#!/bin/bash 
# ======================================================================
#
# Object: set env. variables to use RPC commands everywhere.
# usage : Linux sh or bash : . RPC_config.bash
# Update variables if you change data directories.
#
# Window: nothing to do
# Linux:
# file $HOME/.bashrc file must contains the location of the RPC directory as:
# rpc_pack=/data/Robert_HOME/Copy_TOSH_EXT/Appli_bibi/RPC/RPC_V5p2_Linux_x86_64
# export RPC_DIR=$rpc_pack/RPC_V5p2
#  . $RPC_DIR/RPC_config.bash
#
# Patrick ROBERT, CNRS/LPP-ScientiDev, Jan 2021. 
#
# ======================================================================


# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# These options must be  defined by the user
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

# Visualization option
R_VISU_PDF=yes
R_VISU_PNG=yes_300_256 ; # could be yes_300_16m
R_VISU_SPLASH=yes

# PATH OF  CLUSTER DATA (CEF) :
R_CEF_data_CLU=$rpc_pack/CEF_database_CLUSTER

# PATH OF  CLUSTER DATA (RFF) :
R_RFF_data_CLU=$rpc_pack/RFF_database_CLUSTER

# PATH OF GEOS DATA (RFF) :
R_RFF_data_GEO=$rpc_pack/RFF_database_GEOS

# PATH OF GEOSOL DATA (RFF) :
R_RFF_data_GEOGRD=$rpc_pack/RFF_database_GEOS_GRD

# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
# do not change following commands
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

export R_VISU_PDF=$R_VISU_PDF
export R_VISU_PNG=$R_VISU_PNG
export R_VISU_SPLASH=$R_VISU_SPLASH

export R_CEF_data_CLU=$R_CEF_data_CLU
export R_RFF_data_CLU=$R_RFF_data_CLU
export R_RFF_data_GEO=$R_RFF_data_GEO
export R_RFF_data_GEOGRD=$R_RFF_data_GEOGRD

# Sofware path
# ============

Syst=`uname -o`

if (test $Syst = Msys)
    then
        export RPC_DIR=`echo $rpc_dir | sed -e 's/.//' -e s'/./&:/'`  # pas de /c/... mais c:/
        export R_SOFT_SPLASH=start
    else  
        export R_SOFT_SPLASH=xdg-open ; # acroread
        rpc_dir=$RPC_DIR
fi

# announcement
# ============

echo ===============================================================================
echo "        Welcome $USERNAME in linux terminal to use RPC commands"
echo "        Summary of available RPC commands are given by 'RPC_menu'"
echo
echo 'to know RPC directory path hit: echo $RPC_DIR'
echo 
echo 'to know CLUSTER  database path hit: echo $R_RFF_data_CLU'
echo 'to know GEOS     database path hit: echo $R_RFF_data_GEO'
echo 'to know GEOS_GRD database path hit: echo $R_RFF_data_GEOGRD'
echo "To change data location, edit RPC_config.bash in RPC directory"
echo
echo 'on line information:'
echo '    RPC_menu  => display list of generic commands'
echo '    RPC_doc   => display doc  of  generic commands'
echo 'see also RPC_menu_CLUSTER, RPC_menu_GEOS, RPC_doc_GEOS, RPC_doc_CLUSTER'
echo
echo "In case of any problems : patrick.robert@lpp.polytechnique.fr"
echo ===============================================================================


# Path extension 
# ==============

# This is required to find the RPC commands and personnal scripts

export PATH="$PATH:$rpc_dir/bash\
:$rpc_dir/scripts/scripts_generic\
:$rpc_dir/scripts/scripts_GEOS\
:$rpc_dir/scripts/scripts_CLUSTER\
:$rpc_dir/scripts/scripts_GEOGRD"

# creating RPC.desktop for Ubuntu desk
# ====================================

if (test $Syst != Msys)
    then
    if test -e ./RPC.desktop ; then rm -f  ./RPC.desktop ; fi

    echo "[Desktop Entry]"                       > RPC.desktop
    echo "Type=Application"                     >> RPC.desktop
    echo "Name=RPC_V5p2"                        >> RPC.desktop
    echo "GenericName='RPC software'"           >> RPC.desktop
    echo "Comment='Terminal for RPC commands'"  >> RPC.desktop
    echo "Icon=$RPC_DIR/RPC.ico"                >> RPC.desktop
    echo "Exec=gnome-terminal --show-menubar --working-directory=$RPC_DIR --geometry 136x35+200+200 "  >> RPC.desktop
    echo "Terminal=false"                       >> RPC.desktop
    echo "StartupNotify=false"                  >> RPC.desktop
    echo "Categories=Application"               >> RPC.desktop
    echo " "                                    >> RPC.desktop

    chmod ugo+rx RPC.desktop

#   modif du prompt et des couleurs de 'ls'
#   ======================================

#   PS1="\[\033[31m\]\u@\[\033[31m\]\h\[\033[34m\]/\W: \[\033[39m\]"
#   export PS1
    
    export PS1='\[\033[0;32m\]\h `date +%H:%M` TU \[\033[0;31m\]\w  \[\033[34m\] 
-> '

    LS_COLORS='rs=0:di=01;34:ln=01;36:mh=00:pi=40;33:so=01;35:do=01;35:bd=40;33;01:cd=40;33;01:or=40;\
    31;01:mi=00:su=37;41:sg=30;43:ca=30;41:tw=30;42:ow=34;42:st=37;44:ex=01;31:*.tar=01;31:*.tgz=01;\
    31:*.arc=01;31:*.arj=01;31:*.taz=01;31:*.lha=01;31:*.lz4=01;31:*.lzh=01;31:*.lzma=01;\
    31:*.tlz=01;31:*.txz=01;31:*.tzo=01;31:*.t7z=01;31:*.zip=01;31:*.z=01;31:*.Z=01;31:*.dz=01;31:*.gz=01;\
    31:*.lrz=01;31:*.lz=01;31:*.lzo=01;31:*.xz=01;31:*.bz2=01;31:*.bz=01;31:*.tbz=01;31:*.tbz2=01;\
    31:*.tz=01;31:*.deb=01;31:*.rpm=01;31:*.jar=01;31:*.war=01;31:*.ear=01;31:*.sar=01;31:*.rar=01;\
    31:*.alz=01;31:*.ace=01;31:*.zoo=01;31:*.cpio=01;31:*.7z=01;31:*.rz=01;31:*.cab=01;31:*.jpg=01;\
    35:*.jpeg=01;35:*.gif=01;35:*.bmp=01;35:*.pbm=01;35:*.pgm=01;35:*.ppm=01;35:*.tga=01;35:*.xbm=01;\
    35:*.xpm=01;35:*.tif=01;35:*.tiff=01;35:*.png=01;35:*.svg=01;35:*.svgz=01;35:*.mng=01;35:*.pcx=01;\
    35:*.mov=01;35:*.mpg=01;35:*.mpeg=01;35:*.m2v=01;35:*.mkv=01;35:*.webm=01;35:*.ogm=01;35:*.mp4=01;\
    35:*.m4v=01;35:*.mp4v=01;35:*.vob=01;35:*.qt=01;35:*.nuv=01;35:*.wmv=01;35:*.asf=01;35:*.rm=01;\
    35:*.rmvb=01;35:*.flc=01;35:*.avi=01;35:*.fli=01;35:*.flv=01;35:*.gl=01;35:*.dl=01;35:*.xcf=01;\
    35:*.xwd=01;35:*.yuv=01;35:*.cgm=01;35:*.emf=01;35:*.ogv=01;35:*.ogx=01;35:*.aac=00;36:*.au=00;\
    36:*.flac=00;36:*.m4a=00;36:*.mid=00;36:*.midi=00;36:*.mka=00;36:*.mp3=00;36:*.mpc=00;36:*.ogg=00;\
    36:*.ra=00;36:*.wav=00;36:*.oga=00;36:*.opus=00;36:*.spx=00;36:*.xspf=00;36:';

    else
    LS_COLORS='di=1:fi=0:ln=31:pi=5:so=5:bd=5:cd=5:or=31:mi=0:ex=35:*.rpm=90'
fi

    export LS_COLORS=$LS_COLORS
    alias ls='ls --color=auto'

cd $HOME

#    ===============================================================================
echo
