#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_CLUPOS_2D_plot.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 3 
   then
     echo "this script requires 3 arguments:"
     echo "yymmdd T1 T2 "
     echo "Examples:"
     echo 'do_CLUPOS_2D_plot.sh 20010923  0 0 '
     echo 'do_CLUPOS_2D_plot.sh 20010923  090000 100000 '
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUPOS_4sat"
echo "    RPC_visu_vectime_4sat"

echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_CLUPOS_4sat $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

fnf=" *** file not found, exit $com"

VT1=`sed -n '1p' get_data_CLUPOS_4sat.out` ; if test $? != 0 ; then echo $fnf ;echo "$alarm" >&2 ; exit 1 ;fi
VT2=`sed -n '2p' get_data_CLUPOS_4sat.out` ; if test $? != 0 ; then echo $fnf ;echo "$alarm" >&2 ; exit 1 ;fi
VT3=`sed -n '3p' get_data_CLUPOS_4sat.out` ; if test $? != 0 ; then echo $fnf ;echo "$alarm" >&2 ; exit 1 ;fi
VT4=`sed -n '4p' get_data_CLUPOS_4sat.out` ; if test $? != 0 ; then echo $fnf ;echo "$alarm" >&2 ; exit 1 ;fi

echo
echo "2) visualize 2D positions 4 sat"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_vectime_4sat  $VT1 $VT2 $VT3 $VT4 $datiso1 $datiso2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
