#!/bin/bash

# -----------------------------------------------------------------
# RPC Project :
# Script do_compute_curl_div_CLUFGM.sh 
# Clone from Roproc V4.4
# P. Robert, ScientiDev, Jan 2021
# -----------------------------------------------------------------

appli=`basename $0`
appli36=`echo "$appli                                 " | cut -c1-36`
Narg=7

if( (test $# = 1 ) && (test $1 = -h ) ) ; then hh=1 ; else hh=0 ; fi

if test $# != $Narg || test $hh = 1
   then
   echo "$appli : compute_curl_div from FGM & POS data"
   echo "$appli   require $Narg argument(s), ex:"
   echo "$appli   year month day datiso1 datiso2 FGM_mode"
   echo "    ex: $appli 2001 09 23  2001-09-23T00:00:00.000Z 2001-09-23T23:30:00.000Z SPIN GSM"
   echo ""
   if test $hh = 1 ; then exit 0 ; fi
   echo "$appli36 : *** ERROR ! Command aborted." >&2
   exit 1
fi

datim1=`date +%F'  '%H':'%M':'%S `
julsec1=`date +%s`

year=$1
month=$2
day=$3
datiso1=$4
datiso2=$5
mode=$6
rep=$7

if test $datiso1 = $datiso2 
   then
   datiso1=$year'-'$month'-'$day'T00:00:00.000Z'
   datiso2=$year'-'$month'-'$day'T23:59:59.999Z'
fi

# mode test
# ------------

if ( (test $mode != SPIN) && (test $mode != 5VPS) && (test $mode != FULL) )
   then 
        echo "$appli : mode must be only SPIN or 5VPS or FULL"
        echo "$appli36 : *** ERROR ! Command aborted." >&2
        exit 2
fi


# get 4 S/C positions

RPC_get_data_CLUPOS_4sat $year $month $day

if test $? != 0
   then
   echo "$appli36 : *** ERROR ! Command aborted.">&2
   exit 3
fi

# retrieve POS files name

set `echo $(cat get_data_CLUPOS_4sat.out)`

pos1=$1
pos2=$2
pos3=$3
pos4=$4

pos1r=`basename $pos1 .rff`_r.rff
pos2r=`basename $pos2 .rff`_r.rff
pos3r=`basename $pos3 .rff`_r.rff
pos4r=`basename $pos4 .rff`_r.rff

RPC_reduce_time_vectime $pos1 $pos1r $datiso1 $datiso2
RPC_reduce_time_vectime $pos2 $pos2r $datiso1 $datiso2
RPC_reduce_time_vectime $pos3 $pos3r $datiso1 $datiso2
RPC_reduce_time_vectime $pos4 $pos4r $datiso1 $datiso2

echo "-------------------------------"
echo "POS files name:"
echo $pos1r
echo $pos2r
echo $pos3r
echo $pos4r
echo "-------------------------------"

rm $pos1
rm $pos2
rm $pos3
rm $pos4

# get 4 S/C FGM data

RPC_get_data_CLUFGM_4sat $year $month $day $mode

if test $? != 0
   then
   echo "$appli36 : *** ERROR ! Command aborted.">&2
   exit 4
fi

# retrieve FGM files name

set `echo $(cat get_data_CLUFGM_4sat.out)`

fgm1=$1
fgm2=$2
fgm3=$3
fgm4=$4

fgm1r=`basename $fgm1 .rff`_r.rff
fgm2r=`basename $fgm2 .rff`_r.rff
fgm3r=`basename $fgm3 .rff`_r.rff
fgm4r=`basename $fgm4 .rff`_r.rff

RPC_reduce_time_vectime $fgm1 $fgm1r $datiso1 $datiso2
RPC_reduce_time_vectime $fgm2 $fgm2r $datiso1 $datiso2
RPC_reduce_time_vectime $fgm3 $fgm3r $datiso1 $datiso2
RPC_reduce_time_vectime $fgm4 $fgm4r $datiso1 $datiso2


echo "-------------------------------"
echo "FGM files name:"
echo $fgm1r
echo $fgm2r
echo $fgm3r
echo $fgm4r
echo "-------------------------------"

rm $fgm1
rm $fgm2
rm $fgm3
rm $fgm4

# time alignment of FGM files

RPC_alitime_4_vectime $fgm1r $fgm2r $fgm3r $fgm4r

if test $? != 0
   then
   echo "$appli36 : *** ERROR ! Command aborted.">&2
   exit 5
fi

# remove RPC_ from RPC command
appli=`echo $appli | cut -c5-`

# retrieve FGM time_aligned files name

sed '15,18!d' alitime_4_vectime.out > toto_$$.tmp

set `echo $(cat toto_$$.tmp)`

fgm_ali1=`echo $1 | cut -c10-`
fgm_ali2=`echo $2 | cut -c10-`
fgm_ali3=`echo $3 | cut -c10-`
fgm_ali4=`echo $4 | cut -c10-`

rm toto_$$.tmp

echo "-------------------------------"
echo "FGM time aligned files name:"
echo $fgm_ali1
echo $fgm_ali2
echo $fgm_ali3
echo $fgm_ali4
echo "-------------------------------"


# option GSM

if test $rep = GSM 
   then
   RPC_change_coordinate_system $fgm_ali1 gsm $fgm_ali1'_gsm'
   RPC_change_coordinate_system $fgm_ali2 gsm $fgm_ali2'_gsm'
   RPC_change_coordinate_system $fgm_ali3 gsm $fgm_ali3'_gsm'
   RPC_change_coordinate_system $fgm_ali4 gsm $fgm_ali4'_gsm'

   RPC_change_coordinate_system $pos1r gsm $pos1r'_gsm'
   RPC_change_coordinate_system $pos2r gsm $pos2r'_gsm'
   RPC_change_coordinate_system $pos3r gsm $pos3r'_gsm'
   RPC_change_coordinate_system $pos4r gsm $pos4r'_gsm'

   mv $fgm_ali1'_gsm' $fgm_ali1
   mv $fgm_ali2'_gsm' $fgm_ali2
   mv $fgm_ali3'_gsm' $fgm_ali3
   mv $fgm_ali4'_gsm' $fgm_ali4

   mv $pos1r'_gsm' $pos1r
   mv $pos2r'_gsm' $pos2r
   mv $pos3r'_gsm' $pos3r
   mv $pos4r'_gsm' $pos4r

fi
   
# creating appli.in 

appli=compute_curl_div_4sat


if test -f $appli.in   ; then \mv $appli.in   $appli.in.old   ; fi
if test -f $appli.resu ; then \mv $appli.resu $appli.resu.old ; fi

echo $fgm_ali1  > $appli.in
echo $fgm_ali2 >> $appli.in
echo $fgm_ali3 >> $appli.in
echo $fgm_ali4 >> $appli.in
echo $pos1r    >> $appli.in
echo $pos2r    >> $appli.in
echo $pos3r    >> $appli.in
echo $pos4r    >> $appli.in

echo " "

# run appli.exe 

. run_appli.bash 
err=$?
exit $err   
