#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_Polar_plot_GEOGRD.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 11
   then
     echo "this script requires 11 arguments:"
     echo "yymmdd T1 T2 N_FFT, f1, f2, apod, f1pow, p1,p2, seuil"
     echo "Examples:"
     echo 'do_Polar_plot_GEOGRD.sh  19770706  120000 150000  512  0.  2.0 t  1. -7. -2.2  -4. '
     echo 'do_Polar_plot_GEOGRD.sh  19770802  210000 240000  512  0.  8.0 t  1. -7. -4.5  -5.6'
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
N_FFT=$4
f1=$5
f2=$6
apod=$7
shift 7
f1pow=$1
p1=$2
p2=$3
seuil=$4


datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $N_FFT $f1 $f2 $apod $XY $f1pow $seuil
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOGRD"
echo "    RPC_vectime_to_mfav_GEOGRD"
echo "    RPC_vectime_to_spectro"
echo "    RPC_date_time_to_datiso"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"
echo "    RPC_spectro_to_polar"
echo "    RPC_visu_polar"

echo
echo "1) Get GEOGRD RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOGRD VTL2  $yy $mm $dd 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 1 ; fi
VTL2_GRD=`head -1 get_data_GEOGRD_VTL2.out`


echo
echo "2) transform GEOGRD to MFAV system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_MFA=`basename $VTL2_GRD .rff`_mfav.rff
RPC_vectime_to_mfav_GEOGRD $VTL2_GRD $VT_MFA 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo
echo "3) create SPL2 spectrogram in MFAV"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

SPfilnam=`echo $VT_MFA | sed 's/VT/SP/'`
RPC_vectime_to_spectro $VT_MFA $SPfilnam $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 6 ; fi

echo
echo "4) Visualize MFA spectrogram in Right/Left components"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_spectro  $SPfilnam  $datiso1 $datiso2 $f1 $f2  $p1 $p2 LR $f1 $f2 n
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 7 ; fi

echo
echo "5) Visualize average spectrum in Right/Left components"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_ave_spectrum  $SPfilnam  $datiso1 $datiso2 $f1 $f2  0. 0. LR
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 7 ; fi
echo
echo "6) compute polarisation"
echo "   xxxxxxxxxxxxxxxxxxxx"

polfile=GEOGRD$satnum"_ULF_POLAR_"$yymmdd.resu
RPC_spectro_to_polar $SPfilnam $polfile
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 8 ; fi

echo
echo "7) Visualise polarisation results"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_polar $polfile $datiso1 $datiso2 $seuil $f1 $f2 $p1 $p2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 9 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
