#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_SP_plot_from_VTL2_GEOGRD.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 11 
   then
     echo "this script requires 11 arguments:"
     echo "yymmdd T1 T2  N_FFT, f1, f2, apod, XY, f1pow, y1av, y2av"
     echo "Examples:"
     echo 'do_SP_plot_from_VTL2_GEOGRD.sh 19770706   120000 150000  512  0.  1.5  t XY 1.  -7.2 -2.2 '
     echo 'do_SP_plot_from_VTL2_GEOGRD.sh 19770802   210000 240000  512  0.  8.0  t LR 1.  -7.2 -4.0'
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
N_FFT=$4
f1=$5
f2=$6
apod=$7
XY=$8
shift 8
f1pow=$1
y1av=$2
y2av=$3

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2  $N_FFT $f1 $f2 $apod $XY $f1pow $y1av $y2av
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOGRD"
echo "    RPC_vectime_to_spectro"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"


echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOGRD VTL2  $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

VTfilnam=`head -1 get_data_GEOGRD_VTL2.out`

if test -f $VTfilnam
   then 
   echo "file taken: $VTfilnam "
   else
   echo " $VTfilnam not found"
   echo "$alarm" >&2 ; exit 2
fi

echo
echo "2) create SPL2 spectrogram"
echo "   xxxxxxxxxxxxxxxxxxxxxxx"


SPfilnam=`echo $VTfilnam | sed 's/VTL2/SPL2/'`
SPfilnam=`basename $SPfilnam`
RPC_vectime_to_spectro $VTfilnam $SPfilnam  $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi
echo
echo "3) Visualise SPL2 spectrogram file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_spectro $SPfilnam $datiso1 $datiso2 $f1 $f2 $y1av $y2av $XY $f1pow $f2 n
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 4 ; fi

echo
echo "4) Visualise average spectrum"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_ave_spectrum $SPfilnam $datiso1 $datiso2 $f1 $f2 0. 0. $XY 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
