#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_Polar_plot_GEOULF.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 12 
   then
     echo "this script requires 12 arguments:"
     echo "satnum yymmdd T1 T2 N_FFT, f1, f2, apod, f1pow, p1,p2, seuil"
     echo "Examples:"
     echo 'do_Polar_plot_GEOULF.sh 1  19771206  023000 043000  512  0.5  4.0 t  1. -6. -3  -4. '
     echo
     echo "$alarm" >&2 ; exit 11
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4
N_FFT=$5
f1=$6
f2=$7
apod=$8
shift 8
f1pow=$1
p1=$2
p2=$3
seuil=$4


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $N_FFT $f1 $f2 $apod $XY $f1pow $seuil
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOULF"
echo "    RPC_get_data_GEOMAG"
echo "    RPC_reduce_time_vectime"
echo "    RPC_GEOULF_vectime_to_mfav"
echo "    RPC_vectime_to_spectro"
echo "    RPC_date_time_to_datiso"
echo "    RPC_visu_spectro"
echo "    RPC_spectro_to_polar"
echo "    RPC_visu_polar"

echo
echo "1) Get GEOULF RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOULF VTL2 $satnum $yy $mm $dd 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 1 ; fi
VTL2_STA=`head -1 get_data_GEOULF_VTL2.out`

echo
echo "2) Get GEOMAG RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_get_data_GEOMAG $satnum $yy $mm $dd 
if test $? != 0
       then echo "*** no MAG rff file, proc. aborted" 
            echo "*** $0 exit on error 2" >&2; exit 2 
fi

VTL2_MAG=`head -1 get_data_GEOMAG.out`

echo
echo "3) Reduce time of ULF file"
echo "   xxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

VTL2_STA_red=` basename $VTL2_STA .rff`_red.rff
RPC_reduce_time_vectime $VTL2_STA $VTL2_STA_red $datiso1 $datiso2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi


echo
echo "4) Transform MAG in SRV"
echo "   xxxxxxxxxxxxxxxxxxxx"

VTL2_MAG_srv=` basename $VTL2_MAG .rff`_srv.rff
RPC_vectime_vdh_to_srv_GEOMAG  $VTL2_MAG $VTL2_MAG_srv
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 4 ; fi


echo
echo "5) transform GEOULF to MFA system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_MFA=`basename $VTL2_STA_red .rff`_mfav.rff
RPC_vectime_to_mfav_GEOULF $VTL2_STA_red $VTL2_MAG_srv $VT_MFA 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo
echo "6) create SPL2 spectrogram in MFA"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

SPfilnam=`echo $VT_MFA | sed 's/VT/SP/'`
RPC_vectime_to_spectro $VT_MFA $SPfilnam $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 6 ; fi

echo
echo "7) Visualize MFA spectrogram in Right/Left components"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_spectro  $SPfilnam  $datiso1 $datiso2 $f1 $f2  $p1 $p2 LR $f1 $f2 y
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 7 ; fi

echo
echo "6) compute polarisation"
echo "   xxxxxxxxxxxxxxxxxxxx"

polfile=GEOS$satnum"_ULF_POLAR_"$yymmdd.resu
RPC_spectro_to_polar $SPfilnam $polfile
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 8 ; fi

echo
echo "7) Visualise polarisation results"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_polar $polfile $datiso1 $datiso2 $seuil $f1 $f2 $p1 $p2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 9 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
