#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_SP_plot_GEOMAG.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 12 
   then
     echo "this script requires 12 arguments:"
     echo "yymmdd T1 T2 satnum  N_FFT, f1, f2, apod, XY, f1pow, y1av, y2av"
     echo "Examples:"
     echo 'do_SP_plot_GEOMAG.sh 2 19780810  180000 210000  512  0. 0.02  t XY 0.002  -5. 2.  '
     echo
     echo "$alarm" >&2 ; exit 11
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4
N_FFT=$5
f1=$6
f2=$7
apod=$8
shift 8
XY=$1
f1pow=$2
y1av=$3
y2av=$4

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum  $N_FFT $f1 $f2 $apod $XY $f1pow $y1av $y2av
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOMAG"
echo "    RPC_vectime_to_spectro"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"


echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOMAG $satnum $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

VTfilnam=`head -1 get_data_GEOMAG.out`

if test -f $VTfilnam
   then 
   echo "file taken: $VTfilnam "
   else
   echo " $VTfilnam not found"
   echo "$alarm" >&2 ; exit 2
fi

echo
echo "2) create SPL2 spectrogram"
echo "   xxxxxxxxxxxxxxxxxxxxxxx"


SPfilnam=`echo $VTfilnam | sed 's/VT/SP/'`
SPfilnam=`basename $SPfilnam`
RPC_vectime_to_spectro $VTfilnam $SPfilnam $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi
echo
echo "3) Visualise SPL2 spectrogram file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_spectro $SPfilnam $datiso1 $datiso2 $f1 $f2 $y1av $y2av $XY $f1pow $f2 y
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 4 ; fi

echo
echo "4) Visualise average spectrum"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_ave_spectrum $SPfilnam $datiso1 $datiso2 $f1 $f2 $y1av $y2av $XY 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
