#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_compare_ULF_MAG.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 4 
   then
     echo "this script requires 4 arguments:"
     echo "satnum yymmdd T1 T2 "
     echo "Examples:"
     echo 'do_GEOS_ULF_MAG_plot.sh  1  19770713  120000 123000 '
     echo 'do_GEOS_ULF_MAG_plot.sh  2  19780810  192800 193000 '
     echo
     echo "$alarm" >&2 ; exit 1
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $bitrate $repere 
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOULF"
echo "    RPC_get_data_GEOMAG"
echo "    RPC_add_DxDy_to_BxBy"
echo "    RPC_vectime_vdh_to_srv_GEOMAG"
echo "    RPC_visu_2_vectime"


echo
echo "1) Get ULF RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOULF VTL2 $satnum $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 2
fi

VT_ULF=`head -1 get_data_GEOULF_VTL2.out`

if test -f $VT_ULF
   then 
   echo "file taken: $VT_ULF "
   else
   echo " $VT_ULF not found"
   echo "$alarm" >&2 ; exit 3
fi

echo
echo "2) Get MAG RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_get_data_GEOMAG $satnum $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 4
fi

VT_MAG=`head -1 get_data_GEOMAG.out`

if test -f $VT_MAG
   then 
   echo "file taken: $VT_MAG "
   else
   echo " $VT_MAG not found"
   echo "$alarm" >&2 ; exit 5
fi

echo
echo "3) Transform MAG in SRV system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_MAG_SRV=`basename $VT_MAG .rff`_SRV.rff

RPC_vectime_vdh_to_srv_GEOMAG $VT_MAG $VT_MAG_SRV

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 6
fi

if test -f $VT_MAG_SRV
   then 
   echo "file taken: $VT_MAG_SRV "
   else
   echo " $VT_MAG_SRV not found"
   echo "$alarm" >&2 ; exit 7
fi

echo
echo "4) add DxDy to BxBy in ULF file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_ULF_DXDY=`basename $VT_ULF .rff`_DxDy.rff

RPC_add_DxDy_to_BxBy $VT_ULF $VT_ULF_DXDY

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 6
fi

if test -f $VT_ULF_DXDY
   then 
   echo "file taken: $VT_ULF_DXDY "
   else
   echo " $VT_ULF_DXDY not found"
   echo "$alarm" >&2 ; exit 7
fi

echo
echo "2) Visualise 2 Vectime"
echo "   xxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_2_vectime $VT_ULF_DXDY $VT_MAG_SRV $datiso1 $datiso2 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 8 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
