#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_simulated_data_processing.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

echo "This command use the following RPC generic commands:"
echo "    RPC_create_simulated_data"
echo "    RPC_visu_vectime"
echo "    RPC_visu_vectime_3D"
echo "    RPC_vectime_to_spectro"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"


echo
echo "1) Create ULF, MAG and POS simulated data"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_create_simulated_data ULF
if test $? != 0 ; then echo ; echo "*** $0 exit 1?" >&2; exit 1 ; fi
RPC_create_simulated_data MAG
if test $? != 0 ; then echo ; echo "*** $0 exit 1" >&2; exit 1 ; fi
RPC_create_simulated_data POS
if test $? != 0 ; then echo ; echo "*** $0 exit 1" >&2; exit 1 ; fi

echo
echo "2) Visualize simulated data"
echo "   xxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_vectime VTL2_simulated_ULF_data.rff   2020-02-05T17:33:30.000000Z  2020-02-05T17:34:00.000000Z
if test $? != 0 ; then echo ; echo "*** $0 exit 2" >&2; exit 2 ; fi

RPC_visu_vectime VTL2_simulated_MAG_data.rff  0 0 
if test $? != 0 ; then echo ; echo "*** $0 exit 3" >&2; exit 3 ; fi

RPC_visu_vectime VTL2_simulated_POS_data.rff  0 0 
if test $? != 0 ; then echo ; echo "*** $0 exit 4" >&2; exit 4 ; fi

RPC_visu_vectime_3D  VTL2_simulated_POS_data.rff  0 0 
if test $? != 0 ; then echo ; echo "*** $0 exit 5" >&2; exit 5 ; fi

echo
echo "3) Compute and visualize ULF spectrogram"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_vectime_to_spectro VTL2_simulated_ULF_data.rff SPL2_simulated_ULF_data.rff 512 512 t
if test $? != 0 ; then echo ; echo "*** $0 exit 6" >&2; exit 6 ; fi

RPC_visu_spectro SPL2_simulated_ULF_data.rff 0 0 0. 0. 0. 0. XY 0.5 12. n
if test $? != 0 ; then echo ; echo "*** $0 exit 7" >&2; exit 7 ; fi

RPC_visu_ave_spectrum SPL2_simulated_ULF_data.rff 0 0 0. 12. -6. 1. LR 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 8 ; fi


