#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_simulated_orbit RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`

echo "This command use the following RPC generic commands:"
echo "    RPC_create_simulated_data"
echo "    RPC_visu_vectime_3D"
echo "    RPC_change_coordinate_system"
echo "    RPC_compute_sat_orbit_param"
echo "    RPC_compute_sat_trajectory"
echo "    RPC_visu_2_vectime_3D"

echo
echo "1) Create POS simulated data"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_create_simulated_data POS
if test $? != 0 ; then echo ; echo "*** $0 exit 1" >&2; exit 1 ; fi

echo
echo "2) Visualize POS simulated data"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxx"

file_in_gse=VTL2_simulated_POS_data.rff
file_in_gei=VTL2_simulated_POS_data_gei.rff
file_out_gei=VTL2_simulated_POS_data_gei_recomputed.rff
file_out_gse=VTL2_simulated_POS_data_gse_recomputed.rff

RPC_visu_vectime_3D  $file_in_gse  0 0 
if test $? != 0 ; then echo ; echo "*** $0 exit 2" >&2; exit 2 ; fi

# -----------------------------------------------------------

echo "compute orbital parameters of data files"
echo "----------------------------------------"
echo


RPC_change_coordinate_system $file_in_gse   gei  $file_in_gei 
if test $? != 0 ; then echo ; echo "*** $0 exit 3" >&2; exit 3 ; fi

RPC_compute_sat_orbit_param $file_in_gei 
if test $? != 0 ; then echo ; echo "*** $0 exit 4" >&2; exit 4 ; fi

echo "add some information on compute_sat_trajectory.in"

tail -8 compute_sat_orbit_param.out | head -7 > toto_$$.tmp


#method=MVA (less good)
method=MinMax #(best)

echo
echo "Method=",$method
echo "-------------------------"
cat toto_$$.tmp
echo "-------------------------"

if test $method = MVA
        then sed '1,5!d' toto_$$.tmp > compute_sat_trajectory.in
        dir=1.
        
fi

if test $method = MinMax
        then sed  '4,5d' toto_$$.tmp > compute_sat_trajectory.in
        dir=-1.
fi

echo "compute_sat_trajectory.in :"
cat compute_sat_trajectory.in
echo "-------------------------"

dt=1.
echo "$dt"           >> compute_sat_trajectory.in
echo "$file_out_gei" >> compute_sat_trajectory.in
echo " $dir"         >> compute_sat_trajectory.in

arg=`echo $(cat compute_sat_trajectory.in)`

echo $arg 


# -----------------------------------------------------------

echo "compute theoritical trajectory from orbital parameter"
echo "-----------------------------------------------------"
echo

RPC_compute_sat_trajectory $arg  
if test $? != 0 ; then  echo $alarm  >&2; exit 10 ; fi

RPC_change_coordinate_system $file_out_gei gse $file_out_gse
if test $? != 0 ; then  echo $alarm  >&2; exit 12 ; fi

RPC_visu_vectime_3D $file_out_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 13 ; fi

# -----------------------------------------------------------

echo "compare experiment data with theoritical trajectory"
echo "---------------------------------------------------"
echo


RPC_visu_2_vectime_3D $file_out_gse  $file_in_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 15 ; fi

# -----------------------------------------------------------


