!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program check

!--------------------------------------------------------------------0--
! Laboratoire de Physique des Plasmas
! program to read CLUSTER/EFW RFF WaveForm or VecTime files & check status.
! Patrick ROBERT, LPP, 2011 March 07
!--------------------------------------------------------------------0--

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file, short_file
  integer            :: i,j
  integer            :: n_line
  character(len=32)  :: status_efw_sweep1, status_efw_sweep2
  character(len=255) :: efw_status_log_file
  character(len=4)   :: sat_name
  character(len=255)  :: Fbasename

  print*, '------------------------------------------------------------'
  print*, 'check : read a RFF waveform or vectime file'
  print*, 'and print metadata an data number'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF waveform file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file
  print*, trim(file)

! read  RFF file
! --------------

  call rff_R_file(1,file)

!Trouve le nombre de lignes dans le RFF
  n_line = manda_param%BLOCK_NUMBER

!Crée le fichier de log
  efw_status_log_file="efw_status_log_file.txt"
  open(1, file = efw_status_log_file, position="append")

!Recherche quand le statut EFW sweep change
  do j=1, n_line-1
      status_efw_sweep1 = status(j)(9:9)
      status_efw_sweep2 = status(j+1)(9:9)
      if (status_efw_sweep1 .ne. status_efw_sweep2) then
          short_file = Fbasename(file)
          sat_name = short_file(1:4)
          write(1,*) "Pour ",sat_name,", changement de status EFW trouvé entre:"
          write(1,*) data_index(j)," et ", data_index(j+1)
          write(1,*) "Le status est passé de ",trim(status_efw_sweep1)," à ",trim(status_efw_sweep2),"."
      endif
  end do
  close(1)

  print*, ('-',i=1,72)

  print*, "check_efw_status.exe             : NORMAL TERMINATION"
     stop "check_efw_status.exe             : NORMAL TERMINATION"
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
