!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program search_strong_DC

!----------------------------------------------------------------------!
! Object: Transform a SP.rff in xyz cartesian to Left Right Z components
! Author: P. Robert , LPP, 2015 Feb 07
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  integer :: i,nbspe, nresu,ifc1
  character(len=255) :: file1
  real(kind=4) :: dcx,dcy,dc,dcmax
  

  print*, '------------------------------------------------------------'
  print*, 'search_strong_DC : search in a SP file time periods where '
  print*, '                   perp. DC field is > a given value'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF xyz spectrogram file to read ? (ex: .../data/toto1.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'DC max ? (ex: 1000.)'
  read(*,*) dcmax
  print*, dcmax

  ifc1=1
  
! 1) Reading Metadata
!    ================

  write(*,*)
  write(*,*) 'READING METADATA...'
  write(*,*) '----------------'

! reading manda_param & optio_param only

  call rff_R_metadata(ifc1,file1)
 
  write(*,*) 'Done...'
  
  if (manda_param%data_form /= 'Matrix' ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR search_strong_DC: DATA_FORM of INPUT FILE IS NOT Matrix***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'search_strong_DC.exe            : *** ERROR !! Program aborted !'
     endif  
  
  if (manda_param%file_class /= 'Spectrogram' ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR search_strong_DC: CLASS OF INPUT FILE IS NOT Spectrogram ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'search_strong_DC.exe            : *** ERROR !! Program aborted !'
     endif  
  
  if (manda_param%data_dimension(1) /= 6 ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR search_strong_DC: data dimension OF INPUT FILE IS NOT 6 (3Re & 3Img)***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'search_strong_DC.exe            : *** ERROR !! Program aborted !'
     endif  
     
 
! Retrieve usefull parameter

  nbspe=manda_param%BLOCK_NUMBER

 
  write(*,*)
  write(*,*) 'READING CONSTANT DATA...'
  write(*,*) '------------------------'

  call rff_R_const_data(ifc1)
! call rff_W_const_data(6)

  write(*,*) 'Done...'
 
  write(*,*)
  write(*,*) 'READING INDEXED DATA...'
  write(*,*) '-----------------------'

  call rff_R_indexed_data(ifc1)
  call rff_R_tail(ifc1)

  close(ifc1)

  write(*,*) 'Done...'

  write(*,*) 
  write(*,*) 'DC max=',dcmax
  write(*,*) 
    
 
  write(*,*)
  write(*,*) 'Seach strong DC'
  write(*,*) '---------------'

  open(2,file='search_strong_DC.resu')

  write(2,*) 'Spectra where Perp_DC field is > ',dcmax
  write(2,*)

  nresu=0
  
  do i=1,nbspe

     dcx=R_DATA_MATRIX(1,1,i)
     dcy=R_DATA_MATRIX(3,1,i)
     dc=sqrt(dcx**2 +dcy**2)
     if(dc.gt.dcmax) then
           nresu=nresu +1
           write(2,'(a,3x,f8.2)') data_index(i), dc
     endif
  enddo

  close(2)

  write(*,*) 'spectra number found:',nresu

! *** termine

  print*
  print*, ('-',i=1,72)
  print*, 'Termine'
  print*, ('-',i=1,72)

  print*, 'search_strong_DC.exe            : NORMAL TERMINATION'
     stop 'search_strong_DC.exe            : *** ERROR !! Program aborted !'
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
