!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

    program vectime_L2_to_cef

    !--------------------------------------------------------------------0--
    ! Laboratoire de Physique des Plasmas
    ! Program to read CLUSTER/STAFF-SC RFF cwf file and create a header
    ! of a CWF CAA cef file.
    ! The data field will be filled by the shell 'RFF_vectime_to_cef'
    ! using a sed command, much efficient than a R/W fortran instruction.
    ! Rodrigue Piberne, LPP, 2012 February 22
    ! Rodrigue Piberne, LPP, 2012 November 20 : Change RPC Version
    ! Rodrigue Piberne, LPP, 2013 April 25 : Few modifications
    ! Warning! kernel size and shift size are hard coded for NBR mode
    !--------------------------------------------------------------------0--

!----------------------------------------------------------------------!
! Object: read VTL2 RFF file and create header of CWF.cef file 
! Author: R. Piberne, LPP, 2012 Feb 22  
!----------------------------------------------------------------------!

    ! Variables declaration

    use rff_param_def
    use rff_data_def
    use type_def_cef

    implicit none

    integer             :: ifc, isat, i, cef_output_file_unit
    character(len=255)  :: RFF_file, cef_output_file_name ! Name automatically created by this program
    character(len=field_length_cef) :: dataset_id
    character(len=field_length_cef) :: logicalfileid
    character(len=2)    :: version_number
    character(len=32)   :: down_limit_date ! =00:00:00.000 of the asked day
    character(len=32)   :: up_limit_date   ! =23:59:59.999 of the asked day
    type(CEF_META)      :: dummy_cef_meta
!    type(CEF_PARAMETER) :: dummy_cef_var
    character(len=27)   :: u_present_iso_time ! Gives the present time in ISO format
    character(len=80)   :: rcl_version='RPC V2.2'
    character(len=par_len) :: TED_VERSION
    character(len=par_len) :: TCOR_OPTION
    character(len=12)   :: declination, right_ascension
!    character(len=1)    :: sat_num
    character(len=9)    :: spin_period
    character(len=255)  :: Fbasename
    character(len=12)   :: mass_center_x_str, mass_center_y_str, mass_center_z_str
    real                :: mass_center_x, mass_center_y, mass_center_z
    character(len=12)   :: euler_angle_first, euler_angle_second
    real(kind=4)        :: FREQUENCY_CUT_OFF
    integer             :: CALIB_KERNEL_SIZE
    integer             :: CALIB_SHIFT_SIZE
    character(len=4)    :: FREQUENCY_CUT_OFF_str, CALIB_KERNEL_SIZE_str, CALIB_SHIFT_SIZE_str

    ! Initialisation

    ifc = 3
    cef_output_file_unit = 4
    version_number='01'

    ! file names reading
    ! ------------------

    print*, 'RFF vectime file to read ? (ex: ./toto_VT.rff)'
    read(*,'(a)') RFF_file
    print*, trim(RFF_file)


    ! Read RFF file
    ! -------------

    call rff_R_metadata(ifc,RFF_file)
    call rff_R_const_data(ifc,const_data)

    ! Creating dataset_id
    ! -------------------

    isat=manda_param%OBSERVATORY_NUMBER

    write(*,*) 'Coordinate system: ', manda_param%DATA_COORDINATE_SYSTEM

    !if GSE or ISR2
    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 3) then
        write(dataset_id,'(a1,i1,a12,a3)') 'C',isat,'_CP_STA_CWF_', &
        manda_param%DATA_COORDINATE_SYSTEM
    endif

    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 4) then
        write(dataset_id,'(a1,i1,a12,a4)') 'C',isat,'_CP_STA_CWF_', &
        manda_param%DATA_COORDINATE_SYSTEM
    endif

    ! Current day minimum and maximum allowed time
    down_limit_date = optio_param%TIME_SPAN_FROM
    up_limit_date   = optio_param%TIME_SPAN_TO

    ! Creating LogicalFileID :
    write(logicalfileid,'(a,a2,a4,a2,a2,a2,a2)') dataset_id(1:len_trim(dataset_id)),'__', &
    down_limit_date(1:4), &
    down_limit_date(6:7), &
    down_limit_date(9:10), &
    '_V',version_number

    ! Creating CEF File Name :
    write(cef_output_file_name,'(a,a,a4)') './', &
    logicalfileid(1:len_trim(logicalfileid)),'.cef'

    open(cef_output_file_unit,file = cef_output_file_name)

    cef_output_file_name = Fbasename(cef_output_file_name)

    ! Writing output CEF file header
    ! ========================================================================
    !
    ! Note: All string fields must contain ""
    !
    ! File Metadata:
    ! --------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,64),'File Metadata !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a,a,a)') 'FILE_NAME = "',cef_output_file_name(1:len_trim(cef_output_file_name)),'"'
    write(cef_output_file_unit,'(a)') 'FILE_FORMAT_VERSION = "CEF-2.0"'
    write(cef_output_file_unit,'(a1)') '!'

    ! Global Metadata:
    ! ----------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,60),'Global Metadata   !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'

    ! INCLUDES

    write(cef_output_file_unit,'(a)')        'INCLUDE= CL_CH_MISSION.ceh  ! Mission level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_OBS.ceh      ! Observatory level metadata.'
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a)') 'INCLUDE= CL_CH_STA.ceh      ! Experiment level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_STA_SC.ceh   ! Instrument level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    !if GSE or ISR2
    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 3) then
        write(cef_output_file_unit,'(a,i1,a12,a3,a)') 'INCLUDE= C',isat,'_CH_STA_CWF_', &
        trim(manda_param%DATA_COORDINATE_SYSTEM),&
        '.ceh   ! Dataset level metadata.'
        write(cef_output_file_unit,'(a1)') '!'
    endif

    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 4) then
        write(cef_output_file_unit,'(a,i1,a12,a4,a)') 'INCLUDE= C',isat,'_CH_STA_CWF_', &
        trim(manda_param%DATA_COORDINATE_SYSTEM),&
        '.ceh   ! Dataset level metadata.'
        write(cef_output_file_unit,'(a1)') '!'
    endif

    ! FILE_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TYPE'
    dummy_cef_meta%entry(1)="cef"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! DATASET_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='DATASET_VERSION'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! LOGICAL_FILE_ID
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='LOGICAL_FILE_ID'
    dummy_cef_meta%entry(1)=logicalfileid
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! VERSION_NUMBER
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='VERSION_NUMBER'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_TYPE'
    dummy_cef_meta%entry(1)="CAA"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_VERSION'
    dummy_cef_meta%entry(1)="2.0"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! FILE_TIME_SPAN
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TIME_SPAN'
    dummy_cef_meta%value_type='ISO_TIME_RANGE'
    write(dummy_cef_meta%entry(1),'(a,a1,a)') down_limit_date(1:len_trim(down_limit_date)), &
    '/', &
    up_limit_date(1:len_trim(up_limit_date))
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! GENERATION_DATE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='GENERATION_DATE'
    dummy_cef_meta%value_type='ISO_TIME'
    dummy_cef_meta%entry(1)=u_present_iso_time()
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! FILE_CAVEATS
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_CAVEATS'
    TED_VERSION=const_data%TED_VERSION
    TCOR_OPTION=const_data%TCOR_OPTION
    CALIB_KERNEL_SIZE=const_data%CALIB_KERNEL_SIZE
    CALIB_SHIFT_SIZE=const_data%CALIB_SHIFT_SIZE
    FREQUENCY_CUT_OFF=const_data%FREQUENCY_CUT_OFF
    write(CALIB_KERNEL_SIZE_str,'(i4)') CALIB_KERNEL_SIZE
    write(CALIB_SHIFT_SIZE_str,'(i4)') CALIB_SHIFT_SIZE
    write(FREQUENCY_CUT_OFF_str,'(F4.2)') FREQUENCY_CUT_OFF
    write(dummy_cef_meta%entry(1),'(a,a)') 'Produced from DWF'
    write(dummy_cef_meta%entry(2),'(a,a)') 'TED version ',TED_VERSION(1:len_trim(TED_VERSION))
    write(dummy_cef_meta%entry(3),'(a,a)') 'TCOR option ',TCOR_OPTION(1:len_trim(TED_VERSION))
    write(dummy_cef_meta%entry(4),'(a,a)') 'Produced using software ',rcl_version(1:len_trim(rcl_version))
    write(dummy_cef_meta%entry(5),'(a,a)') 'Calibration tables: feb 2013'
    write(dummy_cef_meta%entry(6),'(a,a,a)') 'Kernel size :',CALIB_KERNEL_SIZE_str, ' for HBR and 1024 for NBR'
    write(dummy_cef_meta%entry(7),'(a,a,a)') 'Shift size :',CALIB_SHIFT_SIZE_str, ' for HBR and 2 for NBR'
    write(dummy_cef_meta%entry(8),'(a,a)') 'Cutoff frequency : ',FREQUENCY_CUT_OFF_str
    ! MEASUREMENT_TIME
    write(dummy_cef_meta%entry(9),'(a,a)') 'Measurement time : ',const_data%CONSTANT_TIME_MEASUREMENT
    ! SPIN AXIS DIRECTION
    write(declination,"(f7.2)") const_data%SPIN_GEI_DECLINATION
    write(right_ascension,"(f7.2)") const_data%SPIN_GEI_RIGHT_ASCENSION
    write(dummy_cef_meta%entry(10),'(a,a)') 'Spin axis direction in GEI : ',"1.0, " &
    //trim(adjustl(declination))//", "//trim(adjustl(right_ascension))
    ! SPIN PERIOD
    write(spin_period,"(f9.7)") const_data%SPIN_PERIOD
    write(dummy_cef_meta%entry(11),'(a,a)') 'Spin period : ', spin_period
    ! MASS CENTER
    ! Warning for cef files mass center is in SC coordinates while in rff files
    ! it is in Body Build coordinates
    write(mass_center_x_str,"(f7.2)") const_data%MASS_CENTER_Z
    write(mass_center_y_str,"(f7.2)") const_data%MASS_CENTER_X
    write(mass_center_z_str,"(f7.2)") const_data%MASS_CENTER_Y

    read(mass_center_x_str,*) mass_center_x
    read(mass_center_y_str,*) mass_center_y
    read(mass_center_z_str,*) mass_center_z

    mass_center_x = mass_center_x*1e-3
    mass_center_y = mass_center_y*1e-3
    mass_center_z = mass_center_z*1e-3

    write(mass_center_x_str,"(f10.4)") mass_center_x
    write(mass_center_y_str,"(f10.4)") mass_center_y
    write(mass_center_z_str,"(f10.4)") mass_center_z
    write(dummy_cef_meta%entry(12),'(a,a)') 'Mass center : ',trim(adjustl(mass_center_x_str))//", "//&
    trim(adjustl(mass_center_y_str))//", "//&
    trim(adjustl(mass_center_z_str))
    ! EULER ANGLE
    write(euler_angle_first,"(f5.2)") const_data%EULER_ANGLE_FIRST
    write(euler_angle_second,"(f5.2)") const_data%EULER_ANGLE_SECOND
    write(dummy_cef_meta%entry(13),'(a,a)') 'Euler angles (degree): ',trim(adjustl(euler_angle_first))//", "//&
    trim(adjustl(euler_angle_second))
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! MEASUREMENT_TIME
    !write(sat_num,"(i1)") manda_param%OBSERVATORY_NUMBER
    !call u_cef_clear_var(dummy_cef_var)

    !dummy_cef_var%parameter_id = "Measurement_time" !usefull to fill the variable name
    !dummy_cef_var%dataset_id = trim(dataset_id)

    !dummy_cef_var%CATDESC = "Time when all the constant data are measured."
    !dummy_cef_var%FIELDNAM = "Measurement time"
    !dummy_cef_var%FILLVAL = "9999-12-31T23:59:59.999999Z"
    !dummy_cef_var%LABLAXIS = "UT"
    !dummy_cef_var%PARAMETER_TYPE = "Support_Data"
    !dummy_cef_var%SI_CONVERSION = '1.0>s'
    !dummy_cef_var%SIGNIFICANT_DIGITS = "20"
    !dummy_cef_var%SIZES = "1"
    !dummy_cef_var%UNITS = 's'
    !dummy_cef_var%VALUE_TYPE = "ISO_TIME"
    !dummy_cef_var%DELTA_MINUS = "0.5"
    !dummy_cef_var%DELTA_PLUS = "0.5"
    !dummy_cef_var%DATA = const_data%CONSTANT_TIME_MEASUREMENT

    !call w_cef_parameter(cef_output_file_unit, dummy_cef_var)


    ! SPIN AXIS DIRECTION
    !write(declination,"(f7.2)") const_data%SPIN_GEI_DECLINATION
    !write(right_ascension,"(f7.2)") const_data%SPIN_GEI_RIGHT_ASCENSION

    !call u_cef_clear_var(dummy_cef_var)

    !dummy_cef_var%parameter_id = "SpinAxis_dir_GEI" !usefull to fill the variable name
    !dummy_cef_var%dataset_id = trim(dataset_id)

    !dummy_cef_var%CATDESC = "Cluster C"//sat_num//", Spin Axis Direction in GEI"
    !dummy_cef_var%COORDINATE_SYSTEM = "GEI"
    !dummy_cef_var%DATA = "1.0, "//trim(adjustl(declination))//", "//trim(adjustl(right_ascension))
    !dummy_cef_var%FIELDNAM = "Module, Declination, Right Ascension"
    !dummy_cef_var%FILLVAL = "-1.E30"
    !dummy_cef_var%FRAME = "GEI>rlp"
    !dummy_cef_var%LABEL_1 = '"N/A", "Dec", "RA"'
    !dummy_cef_var%LABLAXIS = "Spin Direction in GEI"
    !dummy_cef_var%PARAMETER_TYPE = "Support_Data"
    !dummy_cef_var%PARAMETER_CAVEATS = '"Telemetry data without processing"'
    !dummy_cef_var%PROPERTY = "Vector"
    !dummy_cef_var%QUALITY = "0"
    !dummy_cef_var%REPRESENTATION_1 = '"r","l","p"'
    !dummy_cef_var%SI_CONVERSION = '1.0>unitless","1.0>degree","1.0>degree'
    !dummy_cef_var%SIGNIFICANT_DIGITS = "5"
    !dummy_cef_var%SIZES = "3"
    !dummy_cef_var%TENSOR_ORDER = "1"
    !dummy_cef_var%UNITS = 'unitless","degree","degree'
    !dummy_cef_var%VALUE_TYPE = "FLOAT"

    !call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

    ! SPIN PERIOD
    !write(spin_period,"(f9.7)") const_data%SPIN_PERIOD

    !call u_cef_clear_var(dummy_cef_var)

    !dummy_cef_var%parameter_id = "Spin_Period" !usefull to fill the variable name
    !dummy_cef_var%dataset_id = trim(dataset_id)

    !dummy_cef_var%CATDESC = "Cluster C"//sat_num//", Spin Period"
    !dummy_cef_var%DATA = spin_period
    !dummy_cef_var%FIELDNAM = "Cluster C"//sat_num//", Spin Period"
    !dummy_cef_var%FILLVAL = "-1.E30"
    !dummy_cef_var%LABEL_1 = '"Spin Period"'
    !dummy_cef_var%LABLAXIS = "Spin Period"
    !dummy_cef_var%PARAMETER_TYPE = "Support_Data"
    !dummy_cef_var%PARAMETER_CAVEATS = '"Telemetry data without processing"'
    !dummy_cef_var%QUALITY = "0"
    !dummy_cef_var%SI_CONVERSION = '1.0>s'
    !dummy_cef_var%SIGNIFICANT_DIGITS = "8"
    !dummy_cef_var%SIZES = "1"
    !dummy_cef_var%UNITS = 's'
    !dummy_cef_var%VALUE_TYPE = "FLOAT"

    !call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

    ! MASS CENTER
    ! Warning for cef files mass center is in SC coordinates while in rff files
    ! it is in Body Build coordinates
!    write(mass_center_x_str,"(f7.2)") const_data%MASS_CENTER_Z
!    write(mass_center_y_str,"(f7.2)") const_data%MASS_CENTER_X
!    write(mass_center_z_str,"(f7.2)") const_data%MASS_CENTER_Y
!
!    read(mass_center_x_str,*) mass_center_x
!    read(mass_center_y_str,*) mass_center_y
!    read(mass_center_z_str,*) mass_center_z
!
!    mass_center_x = mass_center_x*1e-3
!    mass_center_y = mass_center_y*1e-3
!    mass_center_z = mass_center_z*1e-3
!
!    write(mass_center_x_str,"(f10.4)") mass_center_x
!    write(mass_center_y_str,"(f10.4)") mass_center_y
!    write(mass_center_z_str,"(f10.4)") mass_center_z
!
!    call u_cef_clear_var(dummy_cef_var)
!
!    dummy_cef_var%parameter_id = "Mass_Center" !usefull to fill the variable name
!    dummy_cef_var%dataset_id = trim(dataset_id)
!
!    dummy_cef_var%CATDESC = "Cluster C"//sat_num//", Mass Center"
!    dummy_cef_var%DATA = trim(adjustl(mass_center_x_str))//", "//&
!    trim(adjustl(mass_center_y_str))//", "//&
!    trim(adjustl(mass_center_z_str))
!    dummy_cef_var%FIELDNAM = "Cluster C"//sat_num//", Mass Center"
!    dummy_cef_var%FILLVAL = "-1.E30"
!    dummy_cef_var%LABEL_1 = '"Mass center x", "Mass center y", "Mass center z"'
!    dummy_cef_var%LABLAXIS = "Mass Center"
!    dummy_cef_var%PARAMETER_TYPE = "Support_Data"
!    dummy_cef_var%PARAMETER_CAVEATS = '"Telemetry data without processing"'
!    dummy_cef_var%QUALITY = "0"
!    dummy_cef_var%PROPERTY = "Vector"
!    dummy_cef_var%COORDINATE_SYSTEM = "SC"
!    dummy_cef_var%REPRESENTATION_1 = '"x","y","z"'
!    dummy_cef_var%SI_CONVERSION = '1.0>m'
!    dummy_cef_var%SIGNIFICANT_DIGITS = "5"
!    dummy_cef_var%SIZES = "3"
!    dummy_cef_var%TENSOR_ORDER = "1"
!    dummy_cef_var%UNITS = 'm","m","m'
!    dummy_cef_var%VALUE_TYPE = "FLOAT"
!
!    call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

    ! EULER ANGLE
!    write(euler_angle_first,"(f5.2)") const_data%EULER_ANGLE_FIRST
!    write(euler_angle_second,"(f5.2)") const_data%EULER_ANGLE_SECOND
!
!    call u_cef_clear_var(dummy_cef_var)
!
!    dummy_cef_var%parameter_id = "Euler_angles" !usefull to fill the variable name
!    dummy_cef_var%dataset_id = trim(dataset_id)
!
!    dummy_cef_var%CATDESC = "Cluster C"//sat_num//", Euler angles (cf DDiD I 1.3.2)"
!    dummy_cef_var%DATA = trim(adjustl(euler_angle_first))//", "//&
!    trim(adjustl(euler_angle_second))
!    dummy_cef_var%FIELDNAM = "Cluster C"//sat_num//", Euler angles"
!    dummy_cef_var%FILLVAL = "-1.E30"
!    dummy_cef_var%LABEL_1 = '"First Euler angle", "Second Euler angle"'
!    dummy_cef_var%LABLAXIS = "Euler angles"
!    dummy_cef_var%PARAMETER_TYPE = "Support_Data"
!    dummy_cef_var%PARAMETER_CAVEATS = '"Telemetry data without processing"'
!    dummy_cef_var%QUALITY = "0"
!    dummy_cef_var%SI_CONVERSION = '1>degree'
!    dummy_cef_var%SIGNIFICANT_DIGITS = "3"
!    dummy_cef_var%UNITS = 'degree","degree'
!    dummy_cef_var%VALUE_TYPE = "FLOAT"
!
!    call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

    ! Data start
    ! ----------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,69),'Data     !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'

    close(cef_output_file_unit)
    close(ifc)

    write(*,*) 'CEF header written.'
    write(*,*) 'cef name for calling shell :'
    write(*,'(a)') trim(cef_output_file_name)

    print*, 'vectime_L2_to_cef.exe            : NORMAL TERMINATION'
       stop 'vectime_L2_to_cef.exe            : NORMAL TERMINATION'
end program vectime_L2_to_cef

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
