!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

    program w_cwf_cef_header

!----------------------------------------------------------------------!
! Object: write CWF ceh file
! Author: R. Piberne, LPP, 2011 Apr 05  
!----------------------------------------------------------------------!

    ! Variables declaration

    use rff_param_def
    use rff_data_def
    use type_def_cef

    implicit none

    integer             :: cef_output_file_unit, i
    character(len=4)    :: header_name
    character(len=255)  :: cef_output_file_dir
    character(len=255)  :: cef_output_file_name
    character(len=3)    :: version
    character(1)        :: sat_num
    type(CEF_META)      :: dummy_cef_meta
    type(CEF_PARAMETER) :: dummy_cef_var
    character(len=12)   :: MISALIGNMENT_MATRIX_L1_C1, MISALIGNMENT_MATRIX_L1_C2, &
    MISALIGNMENT_MATRIX_L1_C3, MISALIGNMENT_MATRIX_L2_C1, MISALIGNMENT_MATRIX_L2_C2, &
    MISALIGNMENT_MATRIX_L2_C3, MISALIGNMENT_MATRIX_L3_C1, MISALIGNMENT_MATRIX_L3_C2, &
    MISALIGNMENT_MATRIX_L3_C3
    character(len=10)    :: NBR_resolution, HBR_resolution
    character(len=10)   :: NBR_delta_resolution, HBR_delta_resolution
    character(len=15)   :: NBR_sampling, HBR_sampling
    character(len=4)    :: reference_frame
    character(len=10)   :: NBR_filter_min, HBR_filter_min, NBR_filter_max, HBR_filter_max

    ! Initialisation
    version = 'V01'
    cef_output_file_dir = '/home/piberne/Validate_CEF/'
    reference_frame = 'GSE'
    header_name = reference_frame
    cef_output_file_unit = 1

    ! Writing output CEF file header
    ! ========================================================================
    !
    ! Note: All string fields must contain ""

    do i = 1, 4, 1

        NBR_sampling='25'
        NBR_filter_min = "0.1"
        NBR_filter_max = "12.5"

        HBR_sampling='burst; 450'
        HBR_filter_min ="0.6"
        HBR_filter_max ="225"

        if (i.EQ.1) then
            sat_num = '1'
            NBR_resolution = '3.99990667'
            NBR_delta_resolution = '1.9999533'

            HBR_resolution = '0.22221704'
            HBR_delta_resolution = '0.1111085'
        end if

        if (i.EQ.2) then
            sat_num = '2'
            NBR_resolution = '3.99994222'
            NBR_delta_resolution = '1.9999711'

            HBR_resolution = '0.22221901'
            HBR_delta_resolution = '0.1111095'
        end if

        if (i.EQ.3) then
            sat_num = '3'
            NBR_resolution = '3.99997333'
            NBR_delta_resolution = '1.9999867'

            HBR_resolution = '0.22222074'
            HBR_delta_resolution ='0.1111104'
        end if

        if (i.EQ.4) then
            sat_num = '4'
            NBR_resolution = '3.99997333'
            NBR_delta_resolution = '1.9999867'

            HBR_resolution = '0.22222074'
            HBR_delta_resolution ='0.1111104'
        end if


        !Create and open output ceh file
        cef_output_file_name = trim(cef_output_file_dir)//'C'//sat_num//'_CH_STA_CWF_'//&
        trim(reference_frame)//'.ceh'
        write(*,*) cef_output_file_name
        open(cef_output_file_unit, file = cef_output_file_name)

        write(cef_output_file_unit,'(a)') '! CEH VALIDATION 20 April 2012 by LPP, V01 (RP/PR/NCW/PC)'
        write(cef_output_file_unit,'(a)') '!'

        !DATASET_ID
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='DATASET_ID'
        dummy_cef_meta%entry(1)="C"//sat_num//"_CP_STA_CWF_"//trim(reference_frame)
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !DATA_TYPE
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='DATA_TYPE'
        dummy_cef_meta%entry(1)="CP"
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !DATASET_TITLE
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='DATASET_TITLE'
        dummy_cef_meta%entry(1)="Magnetic Field Waveform - calibrated"
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !CONTACT_COORDINATES
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='CONTACT_COORDINATES'
        dummy_cef_meta%entry(1)="Patrick Canu>PI>patrick.canu@lpp.polytechnique.fr"
        dummy_cef_meta%entry(2)="Nicole Cornilleau-Wehrlin>Deputy-PI>nicole.cornilleau@lpp.polytechnique.fr"
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !DATASET_DESCRIPTION
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='DATASET_DESCRIPTION'
        dummy_cef_meta%entry(1)="This dataset contains measurements"
        dummy_cef_meta%entry(2)="of the magnetic field Calibrated WaveForm (CWF)"
        dummy_cef_meta%entry(3)="from the STAFF-SC instrument in NBR mode (filtered from "//&
        trim(NBR_filter_min)//"Hz to "//trim(NBR_filter_max)//"Hz)"
        dummy_cef_meta%entry(4)="and in HBR mode (filtered from "//&
        trim(HBR_filter_min)//"Hz to "//trim(HBR_filter_max)//"Hz)"
        dummy_cef_meta%entry(5)="and DC magnetic field components in the spin plane Dx, Dy, on the"
        dummy_cef_meta%entry(6)="Cluster C"//sat_num//" spacecraft. This product is given in the "//reference_frame//" frame."
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !PROCESSING_LEVEL
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='PROCESSING_LEVEL'
        dummy_cef_meta%entry(1)="Calibrated"
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !MIN_TIME_RESOLUTION
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='MIN_TIME_RESOLUTION'
        dummy_cef_meta%value_type='FLOAT'
        dummy_cef_meta%entry(1)='@'//trim(NBR_resolution)//'E-02'
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !MAX_TIME_RESOLUTION
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='MAX_TIME_RESOLUTION'
        dummy_cef_meta%value_type='FLOAT'
        dummy_cef_meta%entry(1)='@'//trim(HBR_resolution)//'E-02'
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !DATASET_CAVEATS
        call u_cef_clear_meta(dummy_cef_meta)
        dummy_cef_meta%name='DATASET_CAVEATS'
        dummy_cef_meta%entry(1)="*C"//sat_num//"_CQ_STA_CWF_"//header_name//"_CAVEATS"
        dummy_cef_meta%entry(2)="*C"//sat_num//"_CQ_STA_CALIBRATION_CAVEATS"
        dummy_cef_meta%entry(3)="*C"//sat_num//"_CQ_STA_NOTSRP_CAVEATS"
        dummy_cef_meta%entry(4)="DATASET VERSION HISTORY"
        dummy_cef_meta%entry(5)="Version 01: First version of dataset header"
        call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

        !Start variables label
        write(cef_output_file_unit,'(a)') '!'
        write(cef_output_file_unit,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
        write(cef_output_file_unit,'(a)') '!                                                                   Variables  !'
        write(cef_output_file_unit,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
        write(cef_output_file_unit,'(a)') '!'

        !Time__C1_CP_STA_CWF_*
        call u_cef_clear_var(dummy_cef_var)
        dummy_cef_var%parameter_id = "Time" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

        dummy_cef_var%CATDESC = "Interval centred time tag"
        dummy_cef_var%FIELDNAM = "UT Time"
        dummy_cef_var%FILLVAL = "9999-12-31T23:59:59.999999Z"
        dummy_cef_var%LABLAXIS = "UT"
        dummy_cef_var%PARAMETER_TYPE = "Support_Data"
        dummy_cef_var%SI_CONVERSION = '1.0>s'
        dummy_cef_var%SIGNIFICANT_DIGITS = "27"
        dummy_cef_var%SIZES = "1"
        dummy_cef_var%UNITS = 's'
        dummy_cef_var%VALUE_TYPE = "ISO_TIME"
        dummy_cef_var%DELTA_MINUS = "half_interval__C"//sat_num//"_CP_STA_CWF_"//header_name
        dummy_cef_var%DELTA_PLUS = "half_interval__C"//sat_num//"_CP_STA_CWF_"//header_name
        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !half_interval__C1_CP_STA_CWF_*
        call u_cef_clear_var(dummy_cef_var)
        dummy_cef_var%parameter_id = "half_interval" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

        dummy_cef_var%CATDESC = "Half averaging interval length"
        dummy_cef_var%FIELDNAM = "Half averaging interval length"
        dummy_cef_var%FILLVAL = "9.999999"
        dummy_cef_var%LABLAXIS = "s"
        dummy_cef_var%VALUE_TYPE = 'FLOAT'
        dummy_cef_var%PARAMETER_TYPE = "Support_Data"
        dummy_cef_var%SI_CONVERSION = '1.0>s'
        dummy_cef_var%SIGNIFICANT_DIGITS = "7"
        dummy_cef_var%UNITS = 's'
        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !Status__C1_CP_STA_CWF_*
        call u_cef_clear_var(dummy_cef_var)
        dummy_cef_var%parameter_id = "Status" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

        dummy_cef_var%CATDESC = "STAFF-SC Status"
        dummy_cef_var%DEPEND_0 = "Time"
        dummy_cef_var%FIELDNAM = "STAFF-SC Status"
        dummy_cef_var%FILLVAL = "ZZZZZZZZZZZ"
        dummy_cef_var%LABEL_1 = '"Status"'
        dummy_cef_var%LABLAXIS = "Status"
        dummy_cef_var%PARAMETER_TYPE = "Support_Data"
        dummy_cef_var%SIGNIFICANT_DIGITS = "14"
        dummy_cef_var%SIZES = "1"
        dummy_cef_var%UNITS = 'unitless'
        dummy_cef_var%VALUE_TYPE = 'CHAR'
        dummy_cef_var%QUALITY = '1'
        dummy_cef_var%PARAMETER_CAVEATS = '"We can not certify the 9th character (EFW)"'
        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !Phase_Angle_SC__C1_CP_STA_CWF_*
        call u_cef_clear_var(dummy_cef_var)
        dummy_cef_var%parameter_id = "Phase_Angle" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

        dummy_cef_var%CATDESC = "Phase Angle"
        dummy_cef_var%DEPEND_0 = "Time"
        dummy_cef_var%FIELDNAM = "Phase Angle"
        dummy_cef_var%FILLVAL = "-500.00"
        dummy_cef_var%LABEL_1 = '"Phase Angle"'
        dummy_cef_var%LABLAXIS = "Phase Angle"
        dummy_cef_var%PARAMETER_TYPE = "Support_Data"
        dummy_cef_var%SIGNIFICANT_DIGITS = "6"
        dummy_cef_var%SIZES = "1"
        dummy_cef_var%UNITS = 'degree'
        dummy_cef_var%VALUE_TYPE = 'FLOAT'
        dummy_cef_var%QUALITY = '3'
        dummy_cef_var%PARAMETER_CAVEATS = '"Phase derived from Sun Pulse measurement: can be interpolated, see STATUS"'
        dummy_cef_var%COORDINATE_SYSTEM = "SC"
        dummy_cef_var%SI_CONVERSION = '1>degree'
        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !B_vec_xyz_Instrument__C1_CP_STA_CWF_*
        call u_cef_clear_var(dummy_cef_var)
        dummy_cef_var%parameter_id = "B_vec_xyz_Instrument" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

        dummy_cef_var%CATDESC = "Cluster C1, Calibrated Magnetic Field WaveForm"
        dummy_cef_var%DEPEND_0 = "Time"
        dummy_cef_var%FIELDNAM = "Cluster C1, Calibrated Magnetic Field WaveForm"
        dummy_cef_var%FILLVAL = "1.e30"
        dummy_cef_var%LABEL_1 = '"Bx","By","Bz"'
        dummy_cef_var%LABLAXIS = "Calibrated Magnetic Field Waveform"
        dummy_cef_var%PARAMETER_TYPE = "Data"
        dummy_cef_var%SIGNIFICANT_DIGITS = "7"
        dummy_cef_var%SIZES = "3"
        dummy_cef_var%UNITS = 'nT'
        dummy_cef_var%VALUE_TYPE = 'FLOAT'
        dummy_cef_var%QUALITY = '3' !Good for publication, subject to PI approval
        dummy_cef_var%COORDINATE_SYSTEM = reference_frame
        dummy_cef_var%SI_CONVERSION = "1E9>T"
        dummy_cef_var%ENTITY = "Magnetic_Field"
        dummy_cef_var%FLUCTUATIONS = "Waveform"
        dummy_cef_var%PROPERTY = "Vector"
        dummy_cef_var%REPRESENTATION_1 = '"x","y","z"'
        dummy_cef_var%TENSOR_ORDER = "1"
        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !BDC_vec_xy_Instrument__C1_CP_STA_CWF_* (only for ISR2)
        if (reference_frame == 'ISR2') then
            call u_cef_clear_var(dummy_cef_var)
            dummy_cef_var%parameter_id = "BDC_vec_xy_Instrument" !usefull to fill the variable name
            dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name

            dummy_cef_var%CATDESC = "Cluster C1, DC Magnetic Field in the spin plane"
            dummy_cef_var%DEPEND_0 = "Time"
            dummy_cef_var%FIELDNAM = "Cluster C1, DC Magnetic Field"
            dummy_cef_var%FILLVAL = "1.e30"
            dummy_cef_var%LABEL_1 = '"Dx","Dy"'
            dummy_cef_var%LABLAXIS = "Calibrated Magnetic Field Waveform"
            dummy_cef_var%PARAMETER_TYPE = "Data"
            dummy_cef_var%SIGNIFICANT_DIGITS = "7"
            dummy_cef_var%SIZES = "2"
            dummy_cef_var%UNITS = 'nT'
            dummy_cef_var%VALUE_TYPE = 'FLOAT'
            dummy_cef_var%QUALITY = '3' !Good for publication, subject to PI approval
            dummy_cef_var%COORDINATE_SYSTEM = reference_frame
            dummy_cef_var%SI_CONVERSION = "1E9>T"
            dummy_cef_var%ENTITY = "Magnetic_Field"
            dummy_cef_var%FLUCTUATIONS = "Waveform"
            dummy_cef_var%PROPERTY = "Vector"
            dummy_cef_var%REPRESENTATION_1 = '"x","y"'
            dummy_cef_var%TENSOR_ORDER = "1"
            call w_cef_parameter(cef_output_file_unit, dummy_cef_var)
        endif

        !Misalignment Matrix
        MISALIGNMENT_MATRIX_L1_C1 = '1.0000'
        MISALIGNMENT_MATRIX_L1_C2 = '0.0000'
        MISALIGNMENT_MATRIX_L1_C3 = '0.0000'
        MISALIGNMENT_MATRIX_L2_C1 = '0.0000'
        MISALIGNMENT_MATRIX_L2_C2 = '1.0000'
        MISALIGNMENT_MATRIX_L2_C3 = '0.0000'
        MISALIGNMENT_MATRIX_L3_C1 = '0.0000'
        MISALIGNMENT_MATRIX_L3_C2 = '0.0000'
        MISALIGNMENT_MATRIX_L3_C3 = '1.0000'

        call u_cef_clear_var(dummy_cef_var)

        dummy_cef_var%parameter_id = "Misalignment_Matrix" !usefull to fill the variable name
        dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_CWF_"//header_name
        dummy_cef_var%ENTITY = "Transformation"
        dummy_cef_var%PROPERTY = "Coordinate_rotation"
        dummy_cef_var%CATDESC = "C"//sat_num//" transformation from STAFF real instrument frame "//&
                                "to the theoric orthogonal frame linked to the instrument."        
        dummy_cef_var%DATA = trim(adjustl(MISALIGNMENT_MATRIX_L1_C1))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L1_C2))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L1_C3))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C1))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C2))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C3))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C1))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C2))&
        //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C3))
        dummy_cef_var%FIELDNAM = "Misalignment_Matrix"
        dummy_cef_var%LABEL_1 = '"M1","M2","M3"'
        dummy_cef_var%FILLVAL = "1.E30"
        dummy_cef_var%PARAMETER_TYPE = "Support_Data"
        dummy_cef_var%QUALITY = "0"
        dummy_cef_var%COORDINATE_SYSTEM = "Instrument"
        dummy_cef_var%REPRESENTATION_1 = '"x","y","z"'
        dummy_cef_var%REPRESENTATION_2 = '"x","y","z"'
        dummy_cef_var%SI_CONVERSION = '1>unitless'
        dummy_cef_var%SIGNIFICANT_DIGITS = "5"
        dummy_cef_var%SIZES = "3, 3"
        dummy_cef_var%TENSOR_ORDER = "2"
        dummy_cef_var%FRAME = 'Instrument'
        dummy_cef_var%UNITS = 'unitless'
        dummy_cef_var%VALUE_TYPE = "FLOAT"

        call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

        !Close file
        close(cef_output_file_unit)

    end do


    write(*,*) 'Done'
    
    print*, 'w_cwf_cef_header                : NORMAL TERMINATION'
       stop 'w_cwf_cef_header                : NORMAL TERMINATION'

end program w_cwf_cef_header

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
