!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  
  program add_DxDy_to_BxBy

!--------------------------------------------------------------------0--
! Laboratoire de Physique des Plasmas                                  
!
! add_DxDy_to_Bx_By : Read input RFF file VecTime type with 5 components
!                     create file 3 components with Bx+Dx, By+Dy,Bz 
!                    
! P. Robert, ScientiDev, Dec 2020
!--------------------------------------------------------------------0--

  
! Variables declaration

  use rff_param_def
  use rff_data_def
  
  implicit none
  
  character(len=255) :: in_file_name, ou_file_name,com
  character(len=24)  :: credate
   
  integer            :: nbvec, i,i1,i2,i3

!-----------------------!
! Executable Statements !
!-----------------------!
  
  print*, 'RFF file to read ? (ex: toto.rff)'
  read(*,'(a)') in_file_name
  print*, trim(in_file_name)

  print*, 'RFF file to create ? (ex: toto_DxDy.rff)'
  read(*,'(a)') ou_file_name
  print*, trim(ou_file_name)
  
 
  write(*,*) ('-',i=1,72)
  write(*,*) 'Begin add_DxDy_to_Bx_By'
  write(*,*) ('-',i=1,72)
  write(*,*) 

! 1) Reading Metadata
!    ================

  write(*,*)
  write(*,*) 'READING METADATA...'
  write(*,*) '----------------'

! reading AND writing on std output manda_param & optio_param only

  call rff_R_metadata(1,in_file_name)

  write(*,*) 'Done...'


! 2) Test on Metadata
!    ================

!    a) mission, experiment, obsevatory....

  if (manda_param%DATA_COORDINATE_SYSTEM /= 'ISR2'     .and. &
      manda_param%DATA_COORDINATE_SYSTEM /= 'SRV') then
     write(*,*)
     write(*,*) 'DATA_COORDINATE_SYSTEM =',manda_param%DATA_COORDINATE_SYSTEM
     write(*,'(a)') ' -> ERROR add_DxDy_to_Bx_By: COORDINATE_SYSTEM should be ISR2 or SRV ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     close(1)
     stop 'add_DxDy_to_Bx_By.exe           : *** ERROR !! Program aborted !'
  endif    

!    b) VecTime class only 

  if (manda_param%file_class /= 'VecTime' ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR add_DxDy_to_Bx_By: CLASS OF INPUT FILE IS NOT VECTIME ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     close(1)
     stop 'add_DxDy_to_Bx_By.exe           : *** ERROR !! Program aborted !'
  endif    

!    c) Check that data dimension is 5
  
  if (manda_param%DATA_DIMENSION(1) /= 5) then
     write(*,*)
     write(*,'(a)') ' -> ERROR add_DxDy_to_Bx_By: DATA_DIMENSION shoulb be 5 ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     close(1)
     stop 'add_DxDy_to_Bx_By.exe           : *** ERROR !! Program aborted !'
  endif


! 3) Reading Constant Data
!    =====================

  write(*,*)
  write(*,*) 'READING CONSTANT DATA...'
  write(*,*) '----------------------'

  call rff_R_const_data(1)

  write(*,*) 'Done...'



! 4) Reading indexed Data
!    ====================

  write(*,*)
  write(*,*) 'READING INDEXED DATA...'
  write(*,*) '-----------------------'

  call rff_R_indexed_data(1)

  write(*,*) 'Done...'

! 5) Modify metadata parameters
!    ==========================

  write(*,*)
  write(*,*) 'MODIFY METADATA....'
  write(*,*) '-------------------'

! Update file name
! ----------------

  manda_param%file_name=trim(ou_file_name)


! Change metadata according to data processing
! ---------------

  manda_param%data_dimension(1)= 3
  manda_param%data_label       = 'Bx+Dx ; By+Dy ; Bz '
!  manda_param%data_format      = '(E13.6,1x,E13.6,1x,E13.6)'
  
  com=manda_param%data_units 
  
  i1=index(com,';')
  i2=index(com(i1+1:24),';')
  i3=index(com(i1+1+i2+1:24),';')
  
  manda_param%data_units       = com(1:i3+i2+i1)


! Print all changed mandatory parameters
! --------------------------------------

  write(*,*)
  write(*,*) 'new data_dimension  =', manda_param%data_dimension(1)
  write(*,*) 'new label           =', manda_param%data_label
  write(*,*) 'nex data_units      =', manda_param%data_units
  write(*,*) 'nex data_format     =', manda_param%data_format
  write(*,*)

! change data
! -----------

  nbvec=manda_param%BLOCK_NUMBER
  write(*,*) 'nbvec=',nbvec
  
  do i=1,nbvec
   R_data_vector(1,i)= R_data_vector(1,i) +R_data_vector(4,i)
   R_data_vector(2,i)= R_data_vector(2,i) +R_data_vector(5,i)
  end do
  
  
! 5) create new vectime rff file
! ---------------------------
 
  call gdatiso(credate)
  call rff_update_history(credate,'RPC_add_DxDy_to_Bx_By')

  call rff_W_file(2,trim(ou_file_name))

  close(2)

  print*, ('-',i=1,72)

  print*, 'add_DxDy_to_Bx_By.exe            : NORMAL TERMINATION'
     stop 'add_DxDy_to_Bx_By.exe            : NORMAL TERMINATION'

  end

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX!
