!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program cef_to_rff_dwf_CLUSTA

!----------------------------------------------------------------------!
! Object: convert a DWF cef file to a VTL1 rff file.
! Author: R. Piberne, LPP, 2011 Nov
! revision pour nouveaux CEF et compléments: P. Robert, Fev. 2018
!----------------------------------------------------------------------!

  use type_def_cef
  use rff_param_def
  use rff_data_def

  implicit none

  TYPE(CEF_PARAMETER), dimension(:), allocatable:: cef_param
  type(CEF_META), dimension(:), allocatable:: cef_entry

  character(len=255)  :: cef_file_name,rff_file_name, Fbasename, &
                         cef_file_basename, dummy_char, dummy_char2, dummy_char3, &
                         dummy_char4, dummy_char5, dummy_char6, dummy_char7, &
                         dummy_char8, toto
  integer             :: cef_file_unit,rff_file_unit,err,n_variables,n_metadata, &
                         i, dummy_int, tmp_file_unit,nrec
  character(len=64), dimension(:), allocatable  :: variable_names,metadata_names
  character(len=1)    :: sat_num
  character(len=3)    :: mode
  character(len=64)    :: date
  character(len=10)   :: date_sys,time_sys
  character(len=24)   :: date_temp
  real                :: dummy_float, x,y,z
  real(kind=8)        :: dummy_double
  integer             :: condition_good

  cef_file_unit=1
  rff_file_unit=2
  tmp_file_unit=3

  print*, 'path of cef file ? ex: ../C1_CP_STA_DWF_NBR__20010101_V04.cef'
  read *, cef_file_name
  print*, trim(cef_file_name)
  print*

  cef_file_basename = Fbasename(cef_file_name)

  sat_num=cef_file_basename(2:2)
  mode=cef_file_basename(15:17)
  date=cef_file_basename(20:50)
  
  
  write(*,*) "sat_num=",sat_num
  write(*,*) "mode=",mode
  write(*,*) "date=",date
  
  rff_file_name=trim("CLU"//sat_num//"_STASC_VTL1_"//mode//"_"//date)//".rff"
  
  write(*,*) "rff_file_name=",trim(rff_file_name)

! -----------------------------------
! 1) open cef file
! -----------------------------------

  write(*,*)
  write(*,*) 'Opening file :',TRIM(cef_file_name)

  OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

  if(err /= 0) then
               write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
               write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_dwf_CLUSTA.exe        : *** ERROR !! Program aborted !'
  endif

! -------------------------------------------  
! 2) read metadata, variables and parameters
! -------------------------------------------

  write(*,*)
  write(*,*) 'reading metadata, variables and parameters'

  !find the number of metadata
  n_metadata = 0
  call cef_find_n_metadata(cef_file_unit,n_metadata)
  write(*,*) 'n_metadata=',n_metadata

  !read metadata
  write(*,*)
  write(*,*) 'reading metadata...'
  allocate(metadata_names(n_metadata))
  metadata_names = 'xxx'
  call cef_R_metadata(cef_file_unit,n_metadata, metadata_names)
  do i=1,n_metadata
  write(*,*) metadata_names(i)
  enddo

  !read entry
  allocate(cef_entry(n_metadata))
  call cef_R_entry(cef_file_unit,cef_entry,n_metadata, metadata_names)

  !find the number of variables
  write(*,*)
  write(*,*) 'reading variables...'
  n_variables = 0
  call cef_find_n_variables(cef_file_unit,n_variables)
  write(*,*) 'n_variables=',n_variables

  !read variables
  allocate(variable_names(n_variables))
  variable_names = 'xxx'
  call cef_R_variables(cef_file_unit,n_variables, variable_names)
  do i=1,n_variables
  write(*,*) variable_names(i)
  enddo

  !read parameters
  write(*,*)
  write(*,*) 'reading parameters...'
  allocate(cef_param(n_variables))
  call cef_R_parameter(cef_file_unit,cef_param,n_variables,variable_names)
  do i=1,n_variables
  write(*,*) variable_names(i)
  enddo

! parametres par defaut

  call rff_set_default_init

  manda_param%FILE_CLASS='VecTime'
  manda_param%FILE_FORMAT_VERSION = 'Roproc_Format_File V 2.2'
  manda_param%INDEX_LABEL = 'Time'
  manda_param%INDEX_TYPE  = 'STR'
  manda_param%INDEX_UNITS = 'ISO_TIME'
  manda_param%INDEX_FORM  = 'Scalar'

  call rff_set_default_INDEX_EXTENSION_DESCRIP
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION

  call date_and_time(date_sys,time_sys)

  date_temp = date_sys(1:4)//"-"//date_sys(5:6)//"-"//date_sys(7:8)//&
              "T"//time_sys(1:2)//":"//time_sys(3:4)//":"//time_sys(5:9)//"Z"

  manda_param%FILE_CREATION_DATE = date_temp

  do i=1,n_metadata

    if (metadata_names(i) == 'MISSION') then
      call upper_case(cef_entry(i)%entry(1),len_trim(cef_entry(i)%entry(1)))
      toto=cef_entry(i)%entry(1)
      manda_param%MISSION_NAME = toto(1:64)
      manda_param%MISSION_NAME = manda_param%MISSION_NAME(2:len_trim(manda_param%MISSION_NAME)-1)

    endif

    if (metadata_names(i) == 'OBSERVATORY_DESCRIPTION') then
      toto=cef_entry(i)%entry(1)
      manda_param%OBSERVATORY_NAME =  toto(1:64)
      manda_param%OBSERVATORY_NAME = manda_param%OBSERVATORY_NAME(13:17)

      dummy_char =  cef_entry(i)%entry(1)
      dummy_char  = dummy_char(10:10)
      read(dummy_char, *) dummy_int
      manda_param%OBSERVATORY_NUMBER = dummy_int
    endif

    if (metadata_names(i) == 'INSTRUMENT_NAME') then
      toto=cef_entry(i)%entry(1)
      manda_param%EXPERIMENT_NAME = toto(1:64)
      manda_param%EXPERIMENT_NAME = manda_param%EXPERIMENT_NAME(2:9)
    endif

    if (metadata_names(i) == 'DATASET_ID') then
      toto=cef_entry(i)%entry(1)
      manda_param%EXPERIMENT_MODE = toto(1:64)
      manda_param%EXPERIMENT_MODE = manda_param%EXPERIMENT_mode(16:18)
    endif

    if (metadata_names(i) == 'INSTRUMENT_TYPE') then
      toto=cef_entry(i)%entry(1)
      manda_param%INSTRUMENT_TYPE = toto(1:64)
      dummy_char  = manda_param%INSTRUMENT_TYPE
      dummy_char2 = manda_param%INSTRUMENT_TYPE
      dummy_char  = dummy_char(2:7)
      dummy_char2  = dummy_char2(9:12)
      manda_param%INSTRUMENT_TYPE = trim(dummy_char)//' '//trim(dummy_char2)//'s'
    endif

    if (metadata_names(i) == 'DATASET_TITLE') then
      toto=cef_entry(i)%entry(1)
      manda_param%MEASUREMENT_TYPE = toto(1:64)
      dummy_char  = manda_param%MEASUREMENT_TYPE
      dummy_char2 = manda_param%MEASUREMENT_TYPE
      dummy_char  = dummy_char(11:24)
      call lower_case(dummy_char, len_trim(dummy_char))
      dummy_char2  = dummy_char2(2:10)
      manda_param%MEASUREMENT_TYPE = 'B-AC '//trim(dummy_char2)//' '//trim(dummy_char)
    endif

    if (metadata_names(i) == 'DATASET_DESCRIPTION') then
      toto=cef_entry(i)%entry(5)
      manda_param%DATA_COORDINATE_SYSTEM = toto(1:64)
      manda_param%DATA_COORDINATE_SYSTEM = manda_param%DATA_COORDINATE_SYSTEM(31:36)
    endif

  end do

  condition_good = 0
  do i=1, n_variables

      if (variable_names(i) == 'Time__C'//sat_num//'_CP_STA_DWF_'//mode) then

        toto=cef_param(i)%VALUE_TYPE
        manda_param%INDEX_UNITS= toto(1:64)

        manda_param%INDEX_FORMAT='(a'//trim(cef_param(i)%SIGNIFICANT_DIGITS)//')'



        read(cef_param(i)%SIZES, *) dummy_int
        manda_param%INDEX_DIMENSION= dummy_int

        manda_param%INDEX_PROPERTIES= 'Regularly Spaced'

      endif

      if (variable_names(i) == 'Status__C'//sat_num//'_CP_STA_DWF_'//mode) then

         dummy_char=cef_param(i)%LABLAXIS
         dummy_char=dummy_char(2:7)

         dummy_char3=cef_param(i)%VALUE_TYPE
         if (dummy_char3 == 'CHAR') then
            dummy_char3='STR'
         endif

         dummy_char5=cef_param(i)%UNITS
         if (dummy_char5 == '"unitless"') then
            dummy_char5='None'
         endif

         dummy_char7=cef_param(i)%SIGNIFICANT_DIGITS
         dummy_char7='(a'//trim(dummy_char7)

         condition_good=condition_good+1

      endif

      if (variable_names(i) == 'Phase_Angle__C'//sat_num//'_CP_STA_DWF_'//mode) then

         dummy_char2=cef_param(i)%LABLAXIS
         dummy_char2=dummy_char2(2:12)

         dummy_char4=cef_param(i)%VALUE_TYPE
         if (dummy_char4 == 'FLOAT') then
            dummy_char4 = 'FLT'
         endif

         dummy_char6=cef_param(i)%UNITS
         dummy_char6=dummy_char6(2:7)

         dummy_char8=cef_param(i)%SIGNIFICANT_DIGITS
         read(dummy_char8,*) dummy_int           ! P.R. March 2008
         dummy_int=dummy_int+1                   ! P.R. March 2008
         write(dummy_char8,'(i1)') dummy_int     ! P.R. March 2008
         dummy_char8='f'//trim(dummy_char8)//'.2)'

         condition_good=condition_good+1

      endif

      if (condition_good==2) then
        manda_param%INDEX_EXTENSION_LABEL=trim(dummy_char)//' ; '//trim(dummy_char2)
        manda_param%INDEX_EXTENSION_TYPE=trim(dummy_char3)//' ; '//trim(dummy_char4)
        manda_param%INDEX_EXTENSION_UNITS=trim(dummy_char5)//' ; '//trim(dummy_char6)
!       manda_param%INDEX_EXTENSION_FORMAT=trim(dummy_char7)//',",",'//trim(dummy_char8)
        manda_param%INDEX_EXTENSION_FORMAT='(a14,",",f7.2)'
        manda_param%INDEX_EXTENSION_LENGTH=22 !demander à Patrick comment est obtenu ce chiffre'P.R.: (a14,",",f7.2) 14 +1 +7

        condition_good=0
      endif

      if (variable_names(i) == 'B_vec_xyz_Instrument__C'//sat_num//'_CP_STA_DWF_'//mode) then
         toto=cef_param(i)%LABEL_1
         manda_param%DATA_LABEL= toto(1:64)
         manda_param%DATA_LABEL=manda_param%DATA_LABEL(2:3)//' ; '//manda_param%DATA_LABEL(7:8)&
                                //' ; '//manda_param%DATA_LABEL(12:13)

         toto=cef_param(i)%VALUE_TYPE
         manda_param%DATA_TYPE=toto(1:64)

         toto=cef_param(i)%UNITS
         manda_param%DATA_UNITS=toto(1:64)
         manda_param%DATA_UNITS=manda_param%DATA_UNITS(2:10)//' ; '//manda_param%DATA_UNITS(2:10)&
                                //' ; '//manda_param%DATA_UNITS(2:10)

         dummy_char=cef_param(i)%SIGNIFICANT_DIGITS
         manda_param%DATA_FORMAT='(I'//trim(dummy_char)//',",",I'//trim(dummy_char)//',",",I'//&
                                 trim(dummy_char)//')'

         toto=cef_param(i)%PROPERTY
         manda_param%DATA_FORM=toto(1:64)
         manda_param%DATA_FORM=manda_param%DATA_FORM(2:7)

         read(cef_param(i)%SIZES, *) dummy_int
         manda_param%DATA_DIMENSION(1)=dummy_int

         dummy_char = cef_param(i)%REPRESENTATION_1
         dummy_char = dummy_char(2:2)//dummy_char(6:6)//dummy_char(10:10)//' Cartesian'
         toto=dummy_char
         manda_param%DATA_REPRESENTATION=toto(1:64)
         toto=cef_param(i)%FILLVAL
         manda_param%DATA_FILL_VALUE = toto(1:64)

      endif

  end do


  !OPTIONAL_PARAMETERS
  do i=1,n_metadata

      if (metadata_names(i) == 'TIME_RESOLUTION') then

         read(cef_entry(i)%entry(1), *) dummy_double
         optio_param%TIME_RESOLUTION=dummy_double
         const_data%SAMPLE_RATE=1.D0/dummy_double

      endif

      if (metadata_names(i) == 'FILE_TIME_SPAN') then

         dummy_char=cef_entry(i)%entry(1)
         optio_param%TIME_SPAN_FROM=dummy_char(1:24)
         optio_param%TIME_SPAN_TO  =dummy_char(26:50)

      endif

      if (metadata_names(i) == 'EXPERIMENT_KEY_PERSONNEL') then

         dummy_char=cef_entry(i)%entry(1)
         optio_param%EXPERIMENT_PI_NAME=dummy_char(2:13)

         optio_param%EXPERIMENT_PI_MAIL=dummy_char(25:57)

      endif

  enddo

  write(dummy_char, '(i1)') manda_param%OBSERVATORY_NUMBER
  optio_param%TITLE=trim(manda_param%MISSION_NAME)//' / ' //&
                    trim(manda_param%EXPERIMENT_NAME)//' / '//&
                    trim(manda_param%OBSERVATORY_NAME)// ' (#'//&
                    trim(dummy_char)//')'

  !Hard coding for some parameters

  optio_param%SUB_TITLE='TM data in spinning system'
  optio_param%DISCIPLINE_NAME='Space and Magnetospheric Physics'


  optio_param%MI_DE=8
  optio_param%MISSION_DESCRIPTION(1)='Cluster is a set of 4 spacecrafts, launched in summer 2000. Salsa & Samba'
  optio_param%MISSION_DESCRIPTION(2)='(C2-C3, FM6-FM7 on July 16, Rumba & Tango (C1-C4, FM5-FM8) on August 9.'
  optio_param%MISSION_DESCRIPTION(3)='The aim of the CLuster mission is to study small-scale structures of the'
  optio_param%MISSION_DESCRIPTION(4)='magnetosphere and its environment in three dimensions.'
  optio_param%MISSION_DESCRIPTION(5)='To achieve this, Cluster is constituted of four identical spacecrafts that'
  optio_param%MISSION_DESCRIPTION(6)='will fly in a tetrahedral configuration. The separation distances'
  optio_param%MISSION_DESCRIPTION(7)='between the spacecrafts will vary from ~40 km to 10,000 km,'
  optio_param%MISSION_DESCRIPTION(8)='according to the key scientific regions.'

  optio_param%EX_DE=13
  optio_param%EXPERIMENT_DESCRIPTION(1)='The Spatio Temporal Analysis Field Fluctuation experiment (STAFF) is a'
  optio_param%EXPERIMENT_DESCRIPTION(2)='Tri-axes search coils magnetometer measuring the 3 components of the'
  optio_param%EXPERIMENT_DESCRIPTION(3)='magnetic field up to 4kHz. The STAFF-SC waveform unit produces waveform'
  optio_param%EXPERIMENT_DESCRIPTION(4)='up to either 10 or 180 Hz, according to telemetry rate.'
  optio_param%EXPERIMENT_DESCRIPTION(5)='In Normal Bit Rate (NBR), the sample frequency is about 25.0 Hz, while it is'
  optio_param%EXPERIMENT_DESCRIPTION(6)='450 Hz in High Bit Rate (HBR). Owing to telemetry limitations, a reduction'
  optio_param%EXPERIMENT_DESCRIPTION(7)='of the dynamic data range from 16 to 12 bits is performed inside DWP.'
  optio_param%EXPERIMENT_DESCRIPTION(8)='The principle is to transmit the full 16-bit word at the beginning of'
  optio_param%EXPERIMENT_DESCRIPTION(9)='each telemetry packet, and later the difference between the successive'
  optio_param%EXPERIMENT_DESCRIPTION(10)='samples, coded on 12 bits. The 4th word of telemetry allows determination'
  optio_param%EXPERIMENT_DESCRIPTION(11)='of the maximum error on each component.'
  optio_param%EXPERIMENT_DESCRIPTION(12)='The data are given in the "SSW6RF" coordinates which means " STAFF Sensors'
  optio_param%EXPERIMENT_DESCRIPTION(13)='WEC 6 Reference Frame " where z is close to the spin axis.'

  optio_param%FI_AN=0

  optio_param%BL_HI=3
  optio_param%HISTORY(1)='N1_TO_RFF V.20120801'
  optio_param%HISTORY(2)='RPC_get_data_CLUSTA_WFL1 RPC_V1p4_Linux_x86_64'
  optio_param%HISTORY(3)='RPC_waveform_to_vectime'

  !CONSTANT DATA
  do i=1,n_metadata

     if (metadata_names(i) == 'FILE_CAVEATS') then
         dummy_char = cef_entry(i)%entry(5)
         const_data%TED_VERSION = dummy_char(13:22)

         dummy_char = cef_entry(i)%entry(6)
         const_data%TCOR_OPTION = dummy_char(14:16)

         dummy_char = cef_entry(i)%entry(9)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) dummy_double
         const_data%SPIN_PERIOD = dummy_double
         
         dummy_char = cef_entry(i)%entry(7)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         const_data%CONSTANT_TIME_MEASUREMENT = toto(1:32)
         
         dummy_char = cef_entry(i)%entry(10)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y,z
         const_data%MASS_CENTER_X = x
         const_data%MASS_CENTER_Y = y
         const_data%MASS_CENTER_Z = z
         
         dummy_char = cef_entry(i)%entry(11)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y
         const_data%EULER_ANGLE_FIRST  = x
         const_data%EULER_ANGLE_SECOND = y

         dummy_char = cef_entry(i)%entry(8)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y,z
         const_data%SPIN_GEI_RIGHT_ASCENSION = z
         const_data%SPIN_GEI_DECLINATION = y

    endif


  enddo

  do i=1, n_variables

    if (variable_names(i) == 'Misalignment_Matrix__C'//sat_num//'_CP_STA_DWF_'//mode) then

      dummy_char = cef_param(i)%DATA
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C2 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C3 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C2 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C3 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C2 = dummy_float
      dummy_char2 = dummy_char(1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C3 = dummy_float

    endif

    if (variable_names(i) == 'Minimum_volt_range__C'//sat_num//'_CP_STA_DWF_'//mode) then

       dummy_char = cef_param(i)%DATA
       read(dummy_char, '(f4.2)') dummy_float
       const_data%VOLT_RANGE_MIN = dummy_float

    endif

    if (variable_names(i) == 'Maximum_volt_range__C'//sat_num//'_CP_STA_DWF_'//mode) then

       dummy_char = cef_param(i)%DATA
       read(dummy_char, '(f4.2)') dummy_float
       const_data%VOLT_RANGE_MAX = dummy_float

    endif

    if (variable_names(i) == 'TM_range_min__C'//sat_num//'_CP_STA_DWF_'//mode) then

       dummy_char = cef_param(i)%DATA
       read(dummy_char, '(i1)') dummy_int
       const_data%TM_RANGE_MIN = dummy_int

    endif

    if (variable_names(i) == 'TM_range_max__C'//sat_num//'_CP_STA_DWF_'//mode) then

       dummy_char = cef_param(i)%DATA
       read(dummy_char, '(i5)') dummy_int
       const_data%TM_RANGE_MAX = dummy_int

    endif

  enddo

! lecture du cef pour first and last block index et number of blocks

   OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

  if(err /= 0) then
               write(*,*) '*** unable to open file ', trim(cef_file_name)
               write(*,*) '    in cef_to_rff_dwf_CLUSTA, on unit ',cef_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_dwf_CLUSTA.exe        : *** ERROR !! Program aborted !'
  endif

   toto=' '
   do while ( toto(1:10) /= 'DATA_UNTIL' )           
      read(cef_file_unit,'(a)') toto
   enddo
  
   read(cef_file_unit,'(a)') toto  
   manda_param%block_first_index=  toto(1:index(toto,"Z"))
    
   print*,'write data of ',trim(rff_file_name), ' in a temporary file'
   OPEN(tmp_file_unit,file='data.tmp',status='new',action='write', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in CLUSTA_cef_to_rff_dwf_CLUSTA, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_dwf_CLUSTA.exe        : *** ERROR !! Program aborted !'
  endif
   

   nrec=0
   
   do while ( toto(1:9) /= '!RECORDS=' ) 
      dummy_char=toto   
      write(tmp_file_unit,'(a)') trim(toto)
      nrec=nrec+1
      read(cef_file_unit,'(a)') toto
   enddo
   
   close(tmp_file_unit)
  
   read(toto(10:255),*) dummy_int
   manda_param%BLOCK_NUMBER=nrec
   
   if (nrec/= dummy_int) then
       print*, '*** nb of records read =',nrec
       print*, '    cef param !RECORDS =',dummy_int
   endif
   
   manda_param%block_last_index=  dummy_char(1:index(dummy_char,"Z"))
  

  close(cef_file_unit)

! ---------------
! create rff file
! ---------------

  open(rff_file_unit,file = rff_file_name,action='write')

  print*, 'write header of ',trim(rff_file_name)
  call rff_W_metadata(rff_file_unit,rff_file_name)
  call rff_W_const_data(rff_file_unit)
  write(rff_file_unit,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit,'(a)')   'START INDEXED_DATA'

  close(rff_file_unit)
  
  OPEN(tmp_file_unit,file='data.tmp',status='old',action='read', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in cef_to_rff_dwf_CLUSTA, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_dwf_CLUSTA.exe        : *** ERROR !! Program aborted !'
  endif
  
  close(tmp_file_unit)

  print*, 'cef_to_rff_dwf_CLUSTA.exe        : NORMAL TERMINATION'
     stop 'cef_to_rff_dwf_CLUSTA.exe        : NORMAL TERMINATION'

  end program cef_to_rff_dwf_CLUSTA

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
