
      program compute_curl_div_4sat
!
!     ---------------------------------------------------------------+--
!     Lecture des 4 fichiers FGM time-aligned
!     Lecture des 4 fichiers de position
!
!     calcul du rotationnel et de la divergence
!
!     Le fichier resultat est compute_curl_div_4sat.resu;
!     Ce fichier est visualisable par visu_curl_div_4sat.exe
!
!     P. Robert, CETP, Juin 2001
!     revu et normalise aux fichiers RFF P. Robert Janvier 2021
!     ---------------------------------------------------------------+--
!
!

      use rff_param_def
      use rff_data_def

      real(kind=4),      dimension(:,:),   allocatable :: vectim1
      real(kind=4),      dimension(:,:),   allocatable :: vectim2
      real(kind=4),      dimension(:,:),   allocatable :: vectim3
      real(kind=4),      dimension(:,:),   allocatable :: vectim4

      real(kind=4),      dimension(:,:),   allocatable :: vectim5
      real(kind=4),      dimension(:,:),   allocatable :: vectim6
      real(kind=4),      dimension(:,:),   allocatable :: vectim7
      real(kind=4),      dimension(:,:),   allocatable :: vectim8

      character(len=27), dimension(:),     allocatable :: datiso1
      character(len=27), dimension(:),     allocatable :: datiso2
      character(len=27), dimension(:),     allocatable :: datiso3
      character(len=27), dimension(:),     allocatable :: datiso4

      character(len=27), dimension(:),     allocatable :: datiso5
      character(len=27), dimension(:),     allocatable :: datiso6
      character(len=27), dimension(:),     allocatable :: datiso7
      character(len=27), dimension(:),     allocatable :: datiso8

      character(len=255), dimension(4) :: file_fgm,file_pos
      character(len=4)  :: rep1,rep2,rep3,rep4,rep5,rep6,rep7,rep8,rep
      character(len=120):: projet,experi

!
      real satmag(3,4)
      real satpos(3,4)
      real pxyz(3)

      real*8 dirax(3,3)
      real*8 a,b,c,elong,plana

!     ---------------------------------------------------------------+--
! *** common en sortie de cgeompara
!
      common /distan/     d12 ,    d13 ,    d14 ,    d23 ,  d24,  d34, &
                         dx12 ,   dx13 ,   dx14 ,   dx21 , dx31, dx41, &
                         dy12 ,   dy13 ,   dy14 ,   dy21 , dy31, dy41, &
                         dz12 ,   dz13 ,   dz14 ,   dz21 , dz31, dz41
      common /surfac/    s134 ,   s142 ,   s123 ,   s432
      common /normal/   rx134 ,  rx142 ,  rx123 ,  rx432 , &
                        ry134 ,  ry142 ,  ry123 ,  ry432 , &
                        rz134 ,  rz142 ,  rz123 ,  rz432 , &
                        rn134 ,  rn142 ,  rn123 ,  rn432
      common /volume/    v134 ,   v142 ,   v123 ,   v432
!     ---------------------------------------------------------------+--

      print 100
      print 100, ('X',i=1,53)
      print 100
      print 100, 'compute_curl_div_4sat.exe: compute curl(B) & div(B)'
      print 100, '                             from 4 RFF vectime files'
      print 100, '                             timealigned'
      print 100
      print 100, '                        Patrick Robert, Jan 2021'
      print 100
      print 100, ('X',i=1,53)
      print 100

  100 format(80a)
!
!     ---------------------------------------------------------------+--
      print*, 'lecture du nom des  fichiers '

      read(*,'(a)') file_fgm(1)
      read(*,'(a)') file_fgm(2)
      read(*,'(a)') file_fgm(3)
      read(*,'(a)') file_fgm(4)

      print*, 'file_fgm1=',TRIM(file_fgm(1))
      print*, 'file_fgm2=',TRIM(file_fgm(2))
      print*, 'file_fgm3=',TRIM(file_fgm(3))
      print*, 'file_fgm4=',TRIM(file_fgm(4))


      read(*,'(a)') file_pos(1)
      read(*,'(a)') file_pos(2)
      read(*,'(a)') file_pos(3)
      read(*,'(a)') file_pos(4)

      print*, 'file_pos1=',TRIM(file_pos(1))
      print*, 'file_pos2=',TRIM(file_pos(2))
      print*, 'file_pos3=',TRIM(file_pos(3))
      print*, 'file_pos4=',TRIM(file_pos(4))


!     ---------------------------------------------------------------+--
!     I) Lectute des fichiers FGM alignes en temps
!     ---------------------------------------------------------------+--

      print*
      print*, 'lecture des fichiers FGM'

   DO i=1,4

      call rff_R_file(i,file_fgm(i))

      IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** error, RFF file is not a VecTime Class'
         write(*,*) '    manda_param%FILE_CLASS=', manda_param%FILE_CLASS
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF


      if(i == 1) then
                 datiso1=data_index
                 vectim1=R_data_vector
                 nbloc1=manda_param%BLOCK_NUMBER
                 dt1=real(optio_param%TIME_RESOLUTION)
                 rep1=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 2) then
                 datiso2=data_index
                 vectim2=R_data_vector
                 nbloc2=manda_param%BLOCK_NUMBER
                 dt2=real(optio_param%TIME_RESOLUTION)
                 rep2=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 3) then
                 datiso3=data_index
                 vectim3=R_data_vector
                 nbloc3=manda_param%BLOCK_NUMBER
                 dt3=real(optio_param%TIME_RESOLUTION)
                 rep3=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 4) then
                 datiso4=data_index
                 vectim4=R_data_vector
                 nbloc4=manda_param%BLOCK_NUMBER
                 dt4=real(optio_param%TIME_RESOLUTION)
                 rep4=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      close(i)

   ENDDO

      deallocate(data_index)
      deallocate(R_data_vector)

!     ---------------------------------------------------------------+--
!     II) verification de l'alignement en temps des fichiers FGM
!     ---------------------------------------------------------------+--

      nbloc=nbloc1

      IF((nbloc1 /=  nbloc2)  .or. (nbloc1 /= nbloc3) .or. (nbloc1/= nbloc4))  THEN
         write(*,*) '*** error, nbloc is not the same for the 4 files'
         write(*,*) '    nbloc1,nbloc2,nbloc3,nbloc4=',nbloc1,nbloc2,nbloc3,nbloc4
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF

      rep=rep1

      IF((rep1 /=  rep2)  .or. (rep1 /= rep3) .or. (rep1/= rep4))  THEN
         write(*,*) '*** error, rep is not the same for the 4 files'
         write(*,*) '    rep1,rep2,rep3,rep4=',rep1,rep2,rep3,rep4
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF

      DO i=1,nbloc
      if((datiso1(i) /= datiso2(i)) .or. (datiso1(i) /= datiso3(i)) .or. (datiso1(i) /= datiso4(i))) THEN
         write(*,*) '*** error, datiso is not the same for the 4 files'
         write(*,*) '    datiso1,datiso2,datiso3,datiso4=',datiso1(i),datiso2(i),datiso3(i),datiso4(i)
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF
      ENDDO

      projet=manda_param%MISSION_NAME
      experi=manda_param%EXPERIMENT_NAME

      deallocate(datiso2)
      deallocate(datiso3)
      deallocate(datiso4)



!     ---------------------------------------------------------------+--
!     III) Lecture des fichiers POS
!     ---------------------------------------------------------------+--

      print*
      print*, 'lecture des fichiers POS'

   DO i=1,4

      call rff_R_file(i,file_pos(i))

      IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** error, RFF file is not a VecTime Class'
         write(*,*) '    manda_param%FILE_CLASS=', manda_param%FILE_CLASS
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF


      if(i == 1) then
                 datiso5=data_index
                 vectim5=R_data_vector
                 nbloc5=manda_param%BLOCK_NUMBER
                 dt5=real(optio_param%TIME_RESOLUTION)
                 rep5=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 2) then
                 datiso6=data_index
                 vectim6=R_data_vector
                 nbloc6=manda_param%BLOCK_NUMBER
                 dt6=real(optio_param%TIME_RESOLUTION)
                 rep6=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 3) then
                 datiso7=data_index
                 vectim7=R_data_vector
                 nbloc7=manda_param%BLOCK_NUMBER
                 dt7=real(optio_param%TIME_RESOLUTION)
                 rep7=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      if(i == 4) then
                 datiso8=data_index
                 vectim8=R_data_vector
                 nbloc8=manda_param%BLOCK_NUMBER
                 dt8=real(optio_param%TIME_RESOLUTION)
                 rep8=manda_param%DATA_COORDINATE_SYSTEM(1:4)
      endif

      close(i)

   ENDDO


      deallocate(data_index)
      deallocate(R_data_vector)


!     ---------------------------------------------------------------+--
!     II) verification des fichiers POS
!     ---------------------------------------------------------------+--


      IF((rep5 /=  rep6)  .or. (rep5 /= rep7) .or. (rep5/= rep8))  THEN
         write(*,*) '*** error, rep is not the same for the 4 files'
         write(*,*) '    rep5,rep6,rep7,rep8=',rep5,rep6,rep7,rep8
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF


      IF(rep /= rep5) THEN
         write(*,*) '*** error, rep is not the same between FGM and POS'
         write(*,*) '    rep,rep5=',rep,rep5
         write(*,*) '    program aborted'
         stop 'compute_curl_div_4sat.exe       : *** ERROR !! Program aborted !'
      ENDIF

!     ---------------------------------------------------------------+--

      print*
      print *, ('-',i=1,72)
      print*,'compute_curl_div_4sat: calcul de rotB et div B'
      print*
!
      print*, 'date de debut de periode: ',datiso1(1)
      print*, 'date de fin   de periode: ',datiso1(nbloc)

      call decode_datiso(datiso1,iyear,imon,iday,ih,im,is,ims,imc)
      call cojd00(iyear,imon,iday,jd00)

!
!     --------------------------
!     IV) calcul de curlB et Cie
!     --------------------------
!
! *** ouverture du fichier resultat
!
      close(2)
      open(2,file='compute_curl_div_4sat.resu')
!
! *   ecriture de l'entete

      print*, 'writing header of compute_curl_div_4sat.resu'
!
      write(2,100) 'compute_curl_div_4sat.resu file type'
      write(2,100) 'Data from:'
      write(2,100) TRIM(projet)
      write(2,100) TRIM(experi)
      write(2,100) 'Magnetometer data have been time-aligned'
      write(2,100) 'Orbit data are at any sample rate'
      write(2,100) 'Curl & div are computed from Ampere and Green-Ostrogradski law'
      write(2,100) ' '
      write(2,100) 'Patrick Robert, CETP, Juin 2001 (revised Mar. 2020)'
      write(2,100) '---------------------------------------------------'
      write(2,200) jd00,iyear,imon,iday,' # JulDay 200, iyear,imon,iday'
  200 format(i5.4,1x,i4.4,2(1x,i2.2),a)
      write(2,100) trim(rep),' system'
      write(2,300) nbloc,' # number of records'
  300 format(i8,a)

      write(2,100) '---------------------------------------------------'
      write(2,100) 'data block format:'
      write(2,100) '---------------------------------------------------'
      write(2,100) '# time        : heure decimale du jour'
      write(2,100) '# satmag(*,1) : B1-xyz (nT)'
      write(2,100) '# satmag(*,2) : B2-xyz (nT)'
      write(2,100) '# satmag(*,3) : B3-xyz (nT)'
      write(2,100) '# satmag(*,4) : B4-xyz (nT)'
      write(2,100) '# satpos(*,1) : P1-xyz (km in mass center)'
      write(2,100) '# satpos(*,2) : P2-xyz (km in mass center)'
      write(2,100) '# satpos(*,3) : P3-xyz (km in mass center)'
      write(2,100) '# satpos(*,4) : P4-xyz (km in mass center)'
      write(2,100) '# gjx,gjy,gjz : Current density, A/km2'
      write(2,100) '# cux,cuy,cuz : Curl(B), nT/km'
      write(2,100) '# div         : Div(B), nT/km'
      write(2,100) '# elong,plana : Elongation & Planarity (0-1)'
      write(2,100) '# d12,d13,d14 : d12,d13,d14 (km)'
      write(2,100) '# d23,d24,d34 : d23,d24,d34 (km)'
      write(2,100) '# bmx,bmy,bmz : Baverage (nT)'
      write(2,100) '# rnx,rny,rnz : N= J X Bmoy'
      write(2,100) '# ajb         : (J,B) angle, deg.'
      write(2,100) '# nox,noy,noz : Normal to osculator plane'
      write(2,100) '# rcurv       : Radius of curvature of B (km)'
      write(2,100) '---------------------------------------------------'
!
! *** calcul des positions dans le barycentre,
!     de la geometrie du tetrahedre et de curl et div
!
      print*, 'Start computation, nb block=',nbloc

      do k=1,nbloc
!
! *   calcul de la millisec du jour
!
         call decode_datiso(datiso1(k),iyear,imon,iday,ih,im,is,ims,imc)
         call cojd00(iyear,imon,iday,jd00k)

         hdec=float(jd00k-jd00)*24. +float(ih) +float(im)/60. +float(is)/3600. +float(ims)/3600.e3
!
! *      initialisation pour optimisation de l'interpolation

         j1=1
         j2=1
         j3=1
         j4=1

! *   chargement de satpos et satmag
!
         do i=1,3
!
            satmag(i,1)=vectim1(i,k)
            satmag(i,2)=vectim2(i,k)
            satmag(i,3)=vectim3(i,k)
            satmag(i,4)=vectim4(i,k)
!
            call get_interpol_value(datiso1(k),datiso5,vectim5,nbloc5,j1,pxyz,k1,k2,ierr)
            satpos(i,1)=pxyz(i)
            j1=max(k1-1,1)

            call get_interpol_value(datiso1(k),datiso6,vectim6,nbloc6,j2,pxyz,k1,k2,ierr)
            satpos(i,2)=pxyz(i)
            j2=max(k1-1,1)

            call get_interpol_value(datiso1(k),datiso7,vectim7,nbloc7,j3,pxyz,k1,k2,ierr)
            satpos(i,3)=pxyz(i)
            j3=max(k1-1,1)

            call get_interpol_value(datiso1(k),datiso8,vectim8,nbloc8,j4,pxyz,k1,k2,ierr)
            satpos(i,4)=pxyz(i)
            j4=max(k1-1,1)

         end do

         write(2,320) hdec, ' # Time -----------------',k

         do j=1,4
            write(2,310) (satmag(i,j),i=1,3),' # mag'
         end do

         do j=1,4
            write(2,310) (satpos(i,j),i=1,3), ' # pos'
         end do
!
! *   passage dans le centre de masse
!
         call cbaryclus(satpos,pgx,pgy,pgz)
         call transclus(satpos,pgx,pgy,pgz)

         do j=1,4
            write(2,310) (satpos(i,j),i=1,3), ' # pos Grav'
         end do

!
! *   calcul des densites mesurees par la base barycentrique (A/km2)
!        *** pas utilisé; erreur quelque part, car resultats
!            pas en accord avec la simulation
!        call inipobary(satpos)
!        call inimabary(satmag)
!        call calbabary(qfbary)
!        call estibbary
!        call ccurlbary(cux,cuy,cuz)
!        call cdivbary(div)

!
! *   calcul des courants etc.
!
         call cdistance(satpos)
         call csurfaces
         call cnormales
         call cvolumeto(satpos)

         if(k == 44) print*,d12 ,    d13 ,    d14 ,    d23 ,  d24,  d34
         if(k == 44) print*,s134 ,   s142 ,   s123 ,   s432
         if(k == 44) print*,v134 ,   v142 ,   v123 ,   v432

         call csomdebdl(satpos,satmag)
         call ccurlinco(1,gjx1,gjy1,gjz1)
         call ccurlinco(2,gjx2,gjy2,gjz2)
         call ccurlinco(3,gjx3,gjy3,gjz3)
         call ccurlinco(4,gjx4,gjy4,gjz4)

         gjx=0.25*(gjx1 +gjx2 +gjx3 +gjx4)
         gjy=0.25*(gjy1 +gjy2 +gjy3 +gjy4)
         gjz=0.25*(gjz1 +gjz2 +gjz3 +gjz4)

         call csomdebds(satmag)
         call cdivlinco(1,div1)
         call cdivlinco(2,div2)
         call cdivlinco(3,div3)
         call cdivlinco(4,div4)
         div=(div1+div2+div3+div4)/4.
!
! *   Mo en NT*km/A
!
         pi=acos(-1.)
         rmu0=4.*pi*(1.e-7)*(1.e6)
!
! *   calcul de rotB en nT/km

         cux=gjx*rmu0
         cuy=gjy*rmu0
         cuz=gjz*rmu0

! *   calcul elongation et planarity

         call cellicrit(satpos,a,b,c,dirax,elong,plana)
!
! *   calcul du champ moyen
!
         bmx= (satmag(1,1) +satmag(1,2) +satmag(1,3) +satmag(1,4))/4.
         bmy= (satmag(2,1) +satmag(2,2) +satmag(2,3) +satmag(2,4))/4.
         bmz= (satmag(3,1) +satmag(3,2) +satmag(3,3) +satmag(3,4))/4.
!
! *   calcul de la normale N= J X Bmoy
!
         rnx= gjy*bmz - gjz*bmy
         rny= gjz*bmx - gjx*bmz
         rnz= gjx*bmy - gjy*bmx
!
! *   calcul de l'angle entre J et Bmoy
!
         bmod =sqrt(bmx**2 +bmy**2 + bmz**2)
         gjmod=sqrt(gjx**2 +gjy**2 + gjz**2)

         if(bmod < 1.e-30 .or. gjmod < 1.e-30) then
           ajb=0.
           ratio=0.
                           else
           call cangrat(gjx,gjy,gjz,bmx,bmy,bmz,ajb,ratio)
         endif
!
         ajb= ajb*180./3.1415927
!
! *   calcul de la normale au plan osculateur et du rayon de courbure
!
         call ccurvbary(rnormax,rnormay,rnormaz,rcurv)
!
! *** ecriture des resultats

        elong4=sngl(elong)
        plana4=sngl(plana)

         write(2,310) gjx,gjy,gjz, ' # Gj'
         write(2,310) cux,cuy,cuz, ' # Curl'
         write(2,320) div,         ' # Div'
         write(2,315) elong4,plana4, ' # E,P'
         write(2,310) d12,d13,d14, ' # d1,d2,d3'
         write(2,310) d23,d24,d34, ' # d4,d5,d6'
         write(2,310) bmx,bmy,bmz, ' # Bmoy'
         write(2,310) rnx,rny,rnz, ' # N= J X Bmoy'
         write(2,320) ajb,         ' # (J,Bmoy)'
         write(2,310) rnormax,rnormay,rnormaz, ' # N osculateur'
         write(2,320) rcurv,       ' # R curv'
      end do

  310 format(3(1x,e14.6),a)
  315 format(2(1x,e14.6),a)
  320 format( (1x,e14.6),a,i7)
!
      close(1)
      close(2)

!
      write(*,*) 'compute_curl_div_4sat.exe        : NORMAL TERMINATION'
            stop 'compute_curl_div_4sat.exe        : NORMAL TERMINATION'
      end


