      program current_tube

      use rff_param_def
      use rff_data_def

      character(len=70) :: rff_name(4)
      character(len=27) :: credate

      common /tube/ grtube,gjtube,gjxtu,gjytu,gjztu
      common /repaj/ modj

      character*1 modj

      real satmag(3,4)
      real satpos(3,4,601)

      character*27 datiso1,datiso2

! --------------------------------------------------------------
      nbp=301
      dt=12.

      print*, 'R tube ? (ex: 2000. km)'
      read *, grtube
      print*, grtube

      print*, 'Density in A/km2 ? (ex: 0, 0. 0.25)'
      read *, gjxtu,gjytu,gjztu
      print*, gjxtu,gjytu,gjztu

      gjtube=sqrt(gjxtu**2 +gjytu**2 +gjztu**2)

      print*, 'characteristic lengh fo the tetrahedron . (ex: 1. or 10., or 100.)'
      read *, dcara
      print*, dcara

      print*, 'impact parameter ? (ex: -0.7, in fraction or R tube)'
      read *, para
      print*, para

      print*,'Velocity in X ? (ex: 10 km/s)'
      read *, Vx
      print*, Vx

      par=para*grtube

      modj='u'

      Vy=0.
      Vz=0.

      px1= -20000.
      py1=   par
      pz1=   -200.

      px2= px1 -dcara
      py2= py1 +dcara
      pz2= pz1 -dcara

      px3= px1 +dcara
      py3= py1 -dcara/2.
      pz3= pz1 -dcara/1.5

      px4= px1 -dcara
      py4= py1 -dcara/1.4
      pz4= pz1 -dcara/2.

      datiso1='2020-03-02T00:00:00.000000Z'
      sec=float(nbp-1)*dt
      call addsec_datiso(datiso1,sec,datiso2)

! --------------------------------------------------------------

  call rff_set_default_init
  call gdatiso(credate)

  manda_param%FILE_CLASS                = 'VecTime'
  manda_param%FILE_FORMAT_VERSION       = 'Roproc_Format_File V 2.3'
  manda_param%FILE_CREATION_DATE        = credate
  manda_param%MISSION_NAME              = 'IMAGINE'
  manda_param%OBSERVATORY_NAME          = 'Ima_obs'
  manda_param%OBSERVATORY_NUMBER        = 1
  manda_param%EXPERIMENT_MODE           = 'Normal'
  manda_param%INDEX_LABEL               = 'Time'
  manda_param%INDEX_TYPE                = 'STR'
  manda_param%INDEX_UNITS               = 'ISO_TIME'
  manda_param%INDEX_FORMAT              = '(a27)'
  manda_param%INDEX_FORM                = 'Scalar'
  manda_param%INDEX_DIMENSION           = 1
  manda_param%INDEX_PROPERTIES          = 'Regularly Spaced'
  manda_param%INDEX_EXTENSION_LABEL     = 'No'
  manda_param%INDEX_EXTENSION_TYPE      = 'STR'
  manda_param%INDEX_EXTENSION_UNITS     = 'None'
  manda_param%INDEX_EXTENSION_FORMAT    = 'None'
  manda_param%INDEX_EXTENSION_LENGTH    = 0
  manda_param%DATA_TYPE                 = 'FLT'
  manda_param%DATA_FORMAT               = '(3e15.6)'
  manda_param%DATA_FORM                 = 'Vector'
  manda_param%DATA_DIMENSION            = 3
  manda_param%DATA_REPRESENTATION       = 'xyz Cartesian'
  manda_param%DATA_FILL_VALUE           = '1.e30'

  optio_param%DISCIPLINE_NAME           = 'Space and  Magnetospheric Physics'
  optio_param%EXPERIMENT_PI_NAME        = 'No'
  optio_param%EXPERIMENT_PI_MAIL        = 'patrick.robert@lpp.polytechnique.fr'

  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_INDEX_EXTENSION_DESCRIP

  optio_param%MISSION_DESCRIPTION(1)     = 'Imaginary mission'

  MI_DE = 1

! --------------------------------------------------------------

  manda_param%EXPERIMENT_NAME           = 'SIM_POS'
  manda_param%INSTRUMENT_TYPE           = 'POS measurement'
  manda_param%MEASUREMENT_TYPE          = 'Positions'
  manda_param%DATA_LABEL                = 'Px ; Py ; Pz'
  manda_param%DATA_UNITS                = 'km ; km ; km'
  manda_param%DATA_COORDINATE_SYSTEM    = 'fixed'

  manda_param%BLOCK_NUMBER              = nbp
  manda_param%BLOCK_FIRST_INDEX         = datiso1
  manda_param%BLOCK_LAST_INDEX          = datiso2
  optio_param%TIME_RESOLUTION           = dt
  optio_param%SUB_TITLE                 = 'km in fixed system'
  const_data%SAMPLE_RATE                =  1./dt

  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_INDEX_EXTENSION_DESCRIP

  optio_param%EXPERIMENT_DESCRIPTION(1)  = 'Imaginary POS measurement'
  EX_DE = 1

!---------------------------------------------------------------------

      print*, 'create POS RFF file'

      rff_name(1)='SC1_POS.rff'
      rff_name(2)='SC2_POS.rff'
      rff_name(3)='SC3_POS.rff'
      rff_name(4)='SC4_POS.rff'

      do k=1,4
         manda_param%FILE_NAME = rff_name(k)
         call rff_W_metadata(k,rff_name(k))
         call rff_W_const_data(k)
         write(k,'(a)') 'START INDEXED_DATA'
      end do

      do i=1,nbp

         sec=float(i-1)*dt

         satpos(1,1,i)=px1+Vx*sec
         satpos(2,1,i)=py1+Vy*sec
         satpos(3,1,i)=pz1+Vz*sec

         satpos(1,2,i)=px2+Vx*sec
         satpos(2,2,i)=py2+Vy*sec
         satpos(3,2,i)=pz2+Vz*sec

         satpos(1,3,i)=px3+Vx*sec
         satpos(2,3,i)=py3+Vy*sec
         satpos(3,3,i)=pz3+Vz*sec

         satpos(1,4,i)=px4+Vx*sec
         satpos(2,4,i)=py4+Vy*sec
         satpos(3,4,i)=pz4+Vz*sec


         call addsec_datiso(datiso1,sec,datiso2)

         do k=1,4
            write(k,'(a,3E15.5)') datiso2,satpos(1,k,i),satpos(2,k,i),satpos(3,k,i)
         end do

      end do

      do k=1,4
         write(k,'(a)') 'END INDEXED_DATA'
         call rff_W_tail(k)
      end do

! --------------------------------------------------------------

  manda_param%EXPERIMENT_NAME           = 'SIM_MAG'
  manda_param%INSTRUMENT_TYPE           = 'DC magnetometer'
  manda_param%MEASUREMENT_TYPE          = 'DC magnetic field'
  manda_param%DATA_LABEL                = 'Bx ; By ; Bz'
  manda_param%DATA_UNITS                = 'nT ; nT ; nT'
  manda_param%DATA_COORDINATE_SYSTEM    = 'fixed'

  manda_param%BLOCK_NUMBER              = nbp
  manda_param%BLOCK_FIRST_INDEX         = datiso1
  manda_param%BLOCK_LAST_INDEX          = datiso2
  optio_param%TIME_RESOLUTION           = dt
  optio_param%SUB_TITLE                 = 'nT in fixed system'
  const_data%SAMPLE_RATE                =  1./dt

  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_INDEX_EXTENSION_DESCRIP

  optio_param%EXPERIMENT_DESCRIPTION(1)  = 'Imaginary DC magnetometer'
  EX_DE = 1
!---------------------------------------------------------------------

      print*, 'create MAG RFF file'

      rff_name(1)='SC1_MAG.rff'
      rff_name(2)='SC2_MAG.rff'
      rff_name(3)='SC3_MAG.rff'
      rff_name(4)='SC4_MAG.rff'

      do k=1,4
         manda_param%FILE_NAME = rff_name(k)
         call rff_W_metadata(k,rff_name(k))
         call rff_W_const_data(k)
         write(k,'(a)') 'START INDEXED_DATA'
      end do

      do i=1,nbp

         do k=1,4

            x=satpos(1,k,i)
            y=satpos(2,k,i)
            z=satpos(3,k,i)
            call cal_b_tube(x,y,z,bx,by,bz,bmod)
            satmag(1,k)=bx
            satmag(2,k)=by
            satmag(3,k)=bz

            sec=float(i-1)*dt

            call addsec_datiso(datiso1,sec,datiso2)

            write(k,'(a,3E15.5)') datiso2,satmag(1,k),satmag(2,k),satmag(3,k)
         end do
      end do

      do k=1,4
         write(k,'(a)') 'END INDEXED_DATA'
         call rff_W_tail(k)
      end do

      print*, 'current_tube.exe                 : NORMAL TERMINATION'
         stop 'current_tube.exe                 : NORMAL TERMINATION'
      end

!     ---------------------------------------------------------------+--

      subroutine cal_b_tube(xs,ys,zs,bxs,bys,bzs,bmod)

      common /tube/ grtube,gjtube,gjxtu,gjytu,gjztu
      common /repaj/ modj

      character*1 modj

!     ***********************************************************
!
!     calcul de B dans le repere structure
!     repere structure=repere ou le tube est oblique
!     common /tube/=axe et module de J dans le repere structure
!
!     ***********************************************************

      pi=acos(-1.)
!     valeur de Mu0 en nT*km/A
      rmu=4.*pi*(1.e-7)*(1.e6)
!     c=Mu0*J/2
      c=0.2*pi*gjtube


! *** passage au repere tube incline par rapport au repere structure

      call xybvdh(xs,ys,zs,gjxtu,gjytu,gjztu,x,y,z)

      r2=x*x+y*y
      gr2=grtube*grtube


      if(modj.eq.'u') go to 1
      if(modj.eq.'g') go to 2
      stop 'model de j non defini'

   1  continue

! *** densite uniforme

      if(r2.ge.gr2) then
                    bx=-c*gr2*y/r2
                    by= c*gr2*x/r2
                    bz=0.

                    else
                    bx=-c*y
                    by= c*x
                    bz= 0.
                    endif

      bmax=c*grtube
      go to 10

   2  continue

! *** densite gaussienne

      rsr2=r2/gr2

      bx=-c*(1./rsr2)*(1.-exp(-rsr2))*y
      by= c*(1./rsr2)*(1.-exp(-rsr2))*x
      bz= 0

      um=1.06
      rm=sqrt(um)*grtube

      bmax=c*rm*(1.-exp(-um))/um

   10 continue

      bmod=sqrt(bx*bx+by*by+bz*bz)

! *** passage au repere structure

      call vdhxyb(bx,by,bz,gjxtu,gjytu,gjztu,bxs,bys,bzs)

      return
      end

!     ---------------------------------------------------------------+--

     subroutine vdhxyb(x,y,b,bv,bd,bh,v,d,h)

!     ******************************************************************

!     auteur   :p. robert
!     categorie:astronomie et changement de base
!     objet    :passage du repere ligne de force au repere vdh
!
!     ******************************************************************


!      input=x,y,b avec axe x dans le plan du meridien magnetique
!      output=v,d,h

      call sincosp(bv,bd,bh,st,ct,sp,cp)

      stv=sqrt(1.-cp*cp*st*st)
      if(stv.gt.1.e-30) then
                        spv=-sp/stv
                        cpv=cp*ct/stv

                        else
                        spv=0.
                        cpv=1.
                        endif

      b1=cpv*x-spv*y
      b2=spv*x+cpv*y
      b3=b

      v=cp*ct*b1-sp*b2+cp*st*b3
      d=sp*ct*b1+cp*b2+sp*st*b3
      h=-st*b1+ct*b3

      return
      end

!     ---------------------------------------------------------------+--

      subroutine xybvdh(v,d,h,bv,bd,bh,x,y,b)

!     ******************************************************************
!
!     auteur   :p. robert
!     categorie:astronomie et changement de base
!     objet    :passage du repere vdh au repere ligne de force
!
!     ******************************************************************

!      input=v,d,h
!      output=x,y,b
!             x est dans le plan du meridien magnetique
!

      call sincosp(bv,bd,bh,st,ct,sp,cp)

      b1=ct*cp*v+ct*sp*d-st*h
      b2=-sp*v+cp*d
      b3=st*cp*v+st*sp*d+ct*h

      stv=sqrt(1.-cp*cp*st*st)
      if(stv.gt.1.e-30 ) then
                         spv=-sp/stv
                         cpv=cp*ct/stv

                         else
                         spv=0.
                         cpv=1.
                         endif

      x=cpv*b1+spv*b2
      y=-spv*b1+cpv*b2
      b=b3

      return
      end
!     ---------------------------------------------------------------+--

      subroutine sincosp(x,y,z,st,ct,sp,cp)

!     ******************************************************************
!
!     auteur   :p. robert
!     categorie:astronomie et changement de base
!     objet    :sin et cos des angles polaires d"un vecteur cartesien
!
!     ******************************************************************

      r=sqrt(x*x+y*y+z*z)

      if(r.lt.1e-30) then
                     st=0.
                     ct=1.
                     sp=0.
                     cp=1.
                     return
      endif

      ct=z/r
      if(abs(ct).gt.1.) stop 'erreur sincosp 1'
      st=sqrt(1.-ct*ct)
      if(abs(st).gt.1.) stop 'erreur sincosp 2'

      sp=0.
      cp=1.
      rp=sqrt(x*x+y*y)

      if(rp.lt.1.e-30) return
      sp=y/(rp)
      if(abs(sp).gt.1.) stop 'erreur sincosp 3'
      cp=x/(rp)
      if(abs(cp).gt.1.) stop 'erreur sincosp 4'

      return
      end
!     ---------------------------------------------------------------+--









