!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program diff_rff

!----------------------------------------------------------------------!
! Object: create RFF file containing difference between 2 rff files
! Author: P. Robert , LPP, 2011 Mar
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2
  character(len=120) :: work,credate
  integer            :: i
  integer, dimension(2):: data_dim
  integer :: nbvec, ierr2,mindim

  real (kind=4), dimension(:), allocatable :: moy
  real (kind=4), dimension(:), allocatable :: sig
  real (kind=4), dimension(:), allocatable :: moa
  real (kind=4), dimension(:), allocatable :: vmi
  real (kind=4), dimension(:), allocatable :: vma

  TYPE(Mandatory_param) :: manda_param1,manda_param2
  TYPE(Optional_param)  :: optio_param1,optio_param2
  TYPE(Constant_data)   :: const_data1, const_data2

  print*, '------------------------------------------------------------'
  print*, 'diff_rff : diff on 2 RFF files'
  print*, '------------------------------------------------------------'
  print*

  print*, 'firts  RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'second RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

! read  RFF files
! --------------


  call print_date_time('Reading file 1 Meta-data')

  call rff_R_metadata(1,file1)
  call rff_R_const_data(1)

  manda_param1=manda_param
  optio_param1=optio_param
  const_data1 =const_data

  call rff_set_default_init


  call print_date_time('Reading file 2 Meta-data')

  call rff_R_metadata(2,file2)
  call rff_R_const_data(2)

  manda_param2=manda_param
  optio_param2=optio_param
  const_data2 =const_data

  call diff_meta_data

! lecture des indexed data 2 en premier

  call print_date_time('Reading file 2 Indexed data')
 
  call rff_R_indexed_data(2)
  call rff_R_tail(2)

 ! VecTime file
 ! ------------
 
   data_dim=manda_param2%DATA_DIMENSION
   nbvec=manda_param2%BLOCK_NUMBER

   IF(manda_param2%FILE_CLASS == 'VecTime') THEN
       IF(manda_param2%DATA_TYPE == 'INT') THEN
          allocate(I_data_vector2(data_dim(1),nbvec),stat=ierr2)
          write(*,*) '    I_data_vector2 allocated to ',data_dim(1),nbvec
          I_data_vector2(:,:)=I_data_vector(:,:)
       ENDIF
 
       IF(manda_param2%DATA_TYPE == 'FLT') THEN
          allocate(R_data_vector2(data_dim(1),nbvec),stat=ierr2)
          write(*,*) '    R_data_vector2 allocated to ',data_dim(1),nbvec
          R_data_vector2(:,:)=R_data_vector(:,:)
       ENDIF
                                           ELSE
     print*, ' *** currently, only RFF VecTime can be compared... Sorry'
     stop 'diff_rff.exe                     : *** ERROR !! Program aborted !'
 
   ENDIF

 ! lecture des indexed data 1 

  call print_date_time('Reading file 1 Indexed data')

  call rff_R_indexed_data(1)
  call rff_R_tail(1)

  print*, ('-',i=1,72)

! comparaison des data

  call print_date_time('Indexed data comparison')

  IF(manda_param1%DATA_DIMENSION(1) /= manda_param2%DATA_DIMENSION(1)) THEN
     print*, 'DATA_DIMENSION(1) file1 =', manda_param1%DATA_DIMENSION(1)
     print*, 'DATA_DIMENSION(1) file2 =', manda_param2%DATA_DIMENSION(1)
     mindim=MIN(manda_param1%DATA_DIMENSION(1),manda_param2%DATA_DIMENSION(1))
     print*, '*** comparison will be done ONLY on first ',mindim,' components !'
                                                                       ELSE
      mindim=manda_param1%DATA_DIMENSION(1)
  ENDIF

  IF(manda_param1%DATA_DIMENSION(2) /= manda_param2%DATA_DIMENSION(2)) THEN
     print*, 'DATA_DIMENSION(2) file1 =', manda_param1%DATA_DIMENSION(2)
     print*, 'DATA_DIMENSION(2) file2 =', manda_param2%DATA_DIMENSION(2)
     print*, '*** comparison unpossible !'
     stop 'diff_rff.exe                     : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param1%BLOCK_NUMBER  /= manda_param2%BLOCK_NUMBER) THEN
     print*, 'BLOCK_NUMBER file1 =', manda_param1%BLOCK_NUMBER
     print*, 'BLOCK_NUMBER file2 =', manda_param2%DATA_DIMENSION
     print*, '*** comparison unpossible !'
     stop 'diff_rff.exe                     : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param1%DATA_TYPE  /= manda_param2%DATA_TYPE) THEN
     print*, 'DATA_TYPE file1 =', manda_param1%DATA_TYPE
     print*, 'DATA_TYPE file2 =', manda_param2%DATA_DIMENSION
     stop 'diff_rff.exe                     : *** ERROR !! Program aborted !'
  ENDIF

  print*, ('-',i=1,72)
  print*, 'calcul du RFF contenant la difference entre les deux fichiers'
  print*, 'Number of block=', manda_param%block_number
  print*, 'please wait...'

! les data du file 1 sont dans data_vector
! et on stocke la difference dans ce meme tableau

   manda_param%DATA_DIMENSION(1)=mindim

   allocate(moy(mindim),stat=ierr2)
   allocate(sig(mindim),stat=ierr2)
   allocate(moa(mindim),stat=ierr2)
   allocate(vmi(mindim),stat=ierr2)
   allocate(vma(mindim),stat=ierr2)

   IF(manda_param2%FILE_CLASS == 'VecTime') THEN
       IF(manda_param2%DATA_TYPE == 'INT') THEN
          I_data_vector(1:mindim,:)=I_data_vector(1:mindim,:) -I_data_vector2(1:mindim,:)

          DO i=1,mindim
             moy(i)=SUM(float(I_data_vector(i,:)))/float(manda_param%block_number)
             sig(i)=sqrt(SUM( (float(I_data_vector(i,:))-moy(i))**2)/float(manda_param%block_number) )
             moa(i)=SUM( ABS(float(I_data_vector(i,:))) )/float(manda_param%block_number)
             vmi(i)=float(MINVAL(I_data_vector(i,:)))
             vma(i)=float(MAXVAL(I_data_vector(i,:)))
          ENDDO
       ENDIF
 
       IF(manda_param2%DATA_TYPE == 'FLT') THEN
          R_data_vector(1:mindim,:)=R_data_vector(1:mindim,:) -R_data_vector2(1:mindim,:)

          DO i=1,mindim
             moy(i)=SUM(R_data_vector(i,:))/float(manda_param%block_number)
             sig(i)=sqrt(SUM( (R_data_vector(i,:)-moy(i))**2)/float(manda_param%block_number) )
             moa(i)=SUM( ABS(R_data_vector(i,:)) )/float(manda_param%block_number)
             vmi(i)=MINVAL(R_data_vector(i,:))
             vma(i)=MAXVAL(R_data_vector(i,:))
          ENDDO
       ENDIF
                                           ELSE
     print*, ' *** currently, only RFF VecTime can be compared... Sorry'
     stop 'diff_rff.exe                     : *** ERROR !! Program aborted !'
 
   ENDIF
 
  print*, 'done !'

! modification des formats d'ecriture (des "," au lieu de 1x pour IDL)

  print*
  print*,'Current data formats:'
  print*,'manda_param%INDEX_FORMAT=',TRIM(manda_param%INDEX_FORMAT)
  print*,'manda_param%INDEX_EXTENSION_FORMAT=',TRIM(manda_param%INDEX_EXTENSION_FORMAT)
  print*,'manda_param%DATA_FORMAT=',TRIM(manda_param%DATA_FORMAT)

  work=manda_param%INDEX_FORMAT
  call rff_format_R_to_W(work,manda_param%INDEX_FORMAT)

  work=manda_param%INDEX_EXTENSION_FORMAT
  call rff_format_R_to_W(work,manda_param%INDEX_EXTENSION_FORMAT)

  work=manda_param%DATA_FORMAT
  call rff_format_R_to_W(work,manda_param%DATA_FORMAT)

  print*
  print*,'New formats for writing data:'
  print*,'manda_param%INDEX_FORMAT=',TRIM(manda_param%INDEX_FORMAT)
  print*,'manda_param%INDEX_EXTENSION_FORMAT=',TRIM(manda_param%INDEX_EXTENSION_FORMAT)
  print*,'manda_param%DATA_FORMAT=',TRIM(manda_param%DATA_FORMAT)

! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_diff_rff')

  print*
  print*, 'creation du rff de la difference'
  print*, 'please wait...'

  call print_date_time('Creating diff_rff.rff file')

  call rff_W_file(3,'diff_rff.rff')
 
  print*, 'done !'
  print*
  print*, 'statistics :'
  print*, 'average, sigma, aver.||, min_val,  max_val, for nb. components=',mindim

  DO i=1,mindim
     print*, moy(i) ,sig(i) ,moa(i) ,vmi(i) ,vma(i)
  ENDDO

  call print_date_time('diff_rff.exe : done !')

  print*, 'diff_rff.exe                     : NORMAL TERMINATION'
     stop 'diff_rff.exe                     : NORMAL TERMINATION'

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

contains

  subroutine diff_meta_data

  real(kind=8) diff
  real(kind=4) epsi

  epsi=1.e-30

! Mandatory parameters difference

  print*, ('-',i=1,72)
  print*, 'Mandatory parameters difference:'
  print*

     IF(manda_param1%FILE_NAME               /=  manda_param2%FILE_NAME               ) then
print*,'manda_param1%FILE_NAME                =',TRIM(manda_param1%FILE_NAME)
print*,'manda_param2%FILE_NAME                =',TRIM(manda_param2%FILE_NAME)
     ENDIF

     IF(manda_param1%FILE_CLASS              /=  manda_param2%FILE_CLASS              ) then
print*,'manda_param1%FILE_CLASS               =',TRIM(manda_param1%FILE_CLASS)
print*,'manda_param2%FILE_CLASS               =',TRIM(manda_param2%FILE_CLASS)
     ENDIF

     IF(manda_param1%FILE_FORMAT_VERSION     /=  manda_param2%FILE_FORMAT_VERSION     ) then
print*,'manda_param1%FILE_FORMAT_VERSION      =',TRIM(manda_param1%FILE_FORMAT_VERSION)
print*,'manda_param2%FILE_FORMAT_VERSION      =',TRIM(manda_param2%FILE_FORMAT_VERSION)
     ENDIF

     IF(manda_param1%FILE_CREATION_DATE      /=  manda_param2%FILE_CREATION_DATE      ) then
print*,'manda_param1%FILE_CREATION_DATE       =',TRIM(manda_param1%FILE_CREATION_DATE)
print*,'manda_param2%FILE_CREATION_DATE       =',TRIM(manda_param2%FILE_CREATION_DATE)
     ENDIF


     IF(manda_param1%MISSION_NAME            /=  manda_param2%MISSION_NAME            ) then
print*,'manda_param1%MISSION_NAME             =',TRIM(manda_param1%MISSION_NAME)
print*,'manda_param2%MISSION_NAME             =',TRIM(manda_param2%MISSION_NAME)
     ENDIF

     IF(manda_param1%OBSERVATORY_NAME        /=  manda_param2%OBSERVATORY_NAME        ) then
print*,'manda_param1%OBSERVATORY_NAME         =',TRIM(manda_param1%OBSERVATORY_NAME)
print*,'manda_param2%OBSERVATORY_NAME         =',TRIM(manda_param2%OBSERVATORY_NAME)
     ENDIF

     IF(manda_param1%OBSERVATORY_NUMBER      /=  manda_param2%OBSERVATORY_NUMBER      ) then
print*,'manda_param1%OBSERVATORY_NUMBER       =',manda_param1%OBSERVATORY_NUMBER
print*,'manda_param2%OBSERVATORY_NUMBER       =',manda_param2%OBSERVATORY_NUMBER
     ENDIF

     IF(manda_param1%EXPERIMENT_NAME         /=  manda_param2%EXPERIMENT_NAME         ) then
print*,'manda_param1%EXPERIMENT_NAME          =',TRIM(manda_param1%EXPERIMENT_NAME)
print*,'manda_param2%EXPERIMENT_NAME          =',TRIM(manda_param2%EXPERIMENT_NAME)
     ENDIF

     IF(manda_param1%EXPERIMENT_MODE         /=  manda_param2%EXPERIMENT_MODE         ) then
print*,'manda_param1%EXPERIMENT_MODE          =',TRIM(manda_param1%EXPERIMENT_MODE)
print*,'manda_param2%EXPERIMENT_MODE          =',TRIM(manda_param2%EXPERIMENT_MODE)
     ENDIF

     IF(manda_param1%INSTRUMENT_TYPE         /=  manda_param2%INSTRUMENT_TYPE         ) then
print*,'manda_param1%INSTRUMENT_TYPE          =',TRIM(manda_param1%INSTRUMENT_TYPE)
print*,'manda_param2%INSTRUMENT_TYPE          =',TRIM(manda_param2%INSTRUMENT_TYPE)
     ENDIF

     IF(manda_param1%MEASUREMENT_TYPE        /=  manda_param2%MEASUREMENT_TYPE        ) then
print*,'manda_param1%MEASUREMENT_TYPE         =',TRIM(manda_param1%MEASUREMENT_TYPE)
print*,'manda_param2%MEASUREMENT_TYPE         =',TRIM(manda_param2%MEASUREMENT_TYPE)
     ENDIF


     IF(manda_param1%INDEX_LABEL             /=  manda_param2%INDEX_LABEL             ) then
print*,'manda_param1%INDEX_LABEL              =',TRIM(manda_param1%INDEX_LABEL)
print*,'manda_param2%INDEX_LABEL              =',TRIM(manda_param2%INDEX_LABEL)
     ENDIF

     IF(manda_param1%INDEX_TYPE              /=  manda_param2%INDEX_TYPE              ) then
print*,'manda_param1%INDEX_TYPE               =',TRIM(manda_param1%INDEX_TYPE)
print*,'manda_param2%INDEX_TYPE               =',TRIM(manda_param2%INDEX_TYPE)
     ENDIF

     IF(manda_param1%INDEX_UNITS             /=  manda_param2%INDEX_UNITS             ) then
print*,'manda_param1%INDEX_UNITS              =',TRIM(manda_param1%INDEX_UNITS)
print*,'manda_param2%INDEX_UNITS              =',TRIM(manda_param2%INDEX_UNITS)
     ENDIF

     IF(manda_param1%INDEX_FORMAT            /=  manda_param2%INDEX_FORMAT            ) then
print*,'manda_param1%INDEX_FORMAT             =',TRIM(manda_param1%INDEX_FORMAT)
print*,'manda_param2%INDEX_FORMAT             =',TRIM(manda_param2%INDEX_FORMAT)
     ENDIF

     IF(manda_param1%INDEX_FORM              /=  manda_param2%INDEX_FORM              ) then
print*,'manda_param1%INDEX_FORM               =',TRIM(manda_param1%INDEX_FORM)
print*,'manda_param2%INDEX_FORM               =',TRIM(manda_param2%INDEX_FORM)
     ENDIF

     IF(manda_param1%INDEX_DIMENSION         /=  manda_param2%INDEX_DIMENSION         ) then
print*,'manda_param1%INDEX_DIMENSION          =',    manda_param1%INDEX_DIMENSION
print*,'manda_param2%INDEX_DIMENSION          =',    manda_param2%INDEX_DIMENSION
     ENDIF

     IF(manda_param1%INDEX_PROPERTIES        /=  manda_param2%INDEX_PROPERTIES        ) then
print*,'manda_param1%INDEX_PROPERTIES         =',TRIM(manda_param1%INDEX_PROPERTIES)
print*,'manda_param2%INDEX_PROPERTIES         =',TRIM(manda_param2%INDEX_PROPERTIES)
     ENDIF


     IF(manda_param1%INDEX_EXTENSION_LABEL   /=  manda_param2%INDEX_EXTENSION_LABEL   ) then
print*,'manda_param1%INDEX_EXTENSION_LABEL    =',TRIM(manda_param1%INDEX_EXTENSION_LABEL)
print*,'manda_param2%INDEX_EXTENSION_LABEL    =',TRIM(manda_param2%INDEX_EXTENSION_LABEL)
     ENDIF

     IF(manda_param1%INDEX_EXTENSION_TYPE    /=  manda_param2%INDEX_EXTENSION_TYPE    ) then
print*,'manda_param1%INDEX_EXTENSION_TYPE     =',TRIM(manda_param1%INDEX_EXTENSION_TYPE)
print*,'manda_param2%INDEX_EXTENSION_TYPE     =',TRIM(manda_param2%INDEX_EXTENSION_TYPE)
     ENDIF

     IF(manda_param1%INDEX_EXTENSION_UNITS   /=  manda_param2%INDEX_EXTENSION_UNITS   ) then
print*,'manda_param1%INDEX_EXTENSION_UNITS    =',TRIM(manda_param1%INDEX_EXTENSION_UNITS)
print*,'manda_param2%INDEX_EXTENSION_UNITS    =',TRIM(manda_param2%INDEX_EXTENSION_UNITS)
     ENDIF

     IF(manda_param1%INDEX_EXTENSION_FORMAT  /=  manda_param2%INDEX_EXTENSION_FORMAT  ) then
print*,'manda_param1%INDEX_EXTENSION_FORMAT   =',TRIM(manda_param1%INDEX_EXTENSION_FORMAT)
print*,'manda_param2%INDEX_EXTENSION_FORMAT   =',TRIM(manda_param2%INDEX_EXTENSION_FORMAT)
     ENDIF

     IF(manda_param1%INDEX_EXTENSION_LENGTH  /=  manda_param2%INDEX_EXTENSION_LENGTH  ) then
print*,'manda_param1%INDEX_EXTENSION_LENGTH   =',manda_param1%INDEX_EXTENSION_LENGTH
print*,'manda_param2%INDEX_EXTENSION_LENGTH   =',manda_param2%INDEX_EXTENSION_LENGTH
     ENDIF


     IF(manda_param1%DATA_LABEL              /=  manda_param2%DATA_LABEL              ) then
print*,'manda_param1%DATA_LABEL               =',TRIM(manda_param1%DATA_LABEL)
print*,'manda_param2%DATA_LABEL               =',TRIM(manda_param2%DATA_LABEL)
     ENDIF

     IF(manda_param1%DATA_TYPE               /=  manda_param2%DATA_TYPE               ) then
print*,'manda_param1%DATA_TYPE                =',TRIM(manda_param1%DATA_TYPE)
print*,'manda_param2%DATA_TYPE                =',TRIM(manda_param2%DATA_TYPE)
     ENDIF

     IF(manda_param1%DATA_UNITS              /=  manda_param2%DATA_UNITS              ) then
print*,'manda_param1%DATA_UNITS               =',TRIM(manda_param1%DATA_UNITS)
print*,'manda_param2%DATA_UNITS               =',TRIM(manda_param2%DATA_UNITS)
     ENDIF

     IF(manda_param1%DATA_FORMAT             /=  manda_param2%DATA_FORMAT             ) then
print*,'manda_param1%DATA_FORMAT              =',TRIM(manda_param1%DATA_FORMAT)
print*,'manda_param2%DATA_FORMAT              =',TRIM(manda_param2%DATA_FORMAT)
     ENDIF

     IF(manda_param1%DATA_FORM               /=  manda_param2%DATA_FORM               ) then
print*,'manda_param1%DATA_FORM                =',TRIM(manda_param1%DATA_FORM)
print*,'manda_param2%DATA_FORM                =',TRIM(manda_param2%DATA_FORM)
     ENDIF

     IF(manda_param1%DATA_DIMENSION(1)       /=  manda_param2%DATA_DIMENSION(1)       ) then
print*,'manda_param1%DATA_DIMENSION(1)        =',manda_param1%DATA_DIMENSION(1)
print*,'manda_param2%DATA_DIMENSION(1)        =',manda_param2%DATA_DIMENSION(1)
     ENDIF

     IF(manda_param1%DATA_DIMENSION(2)       /=  manda_param2%DATA_DIMENSION(2)       ) then
print*,'manda_param1%DATA_DIMENSION(2)        =',manda_param1%DATA_DIMENSION(2)
print*,'manda_param2%DATA_DIMENSION(2)        =',manda_param2%DATA_DIMENSION(2)
     ENDIF

     IF(manda_param1%DATA_REPRESENTATION     /=  manda_param2%DATA_REPRESENTATION     ) then
print*,'manda_param1%DATA_REPRESENTATION      =',TRIM(manda_param1%DATA_REPRESENTATION)
print*,'manda_param2%DATA_REPRESENTATION      =',TRIM(manda_param2%DATA_REPRESENTATION)
     ENDIF

     IF(manda_param1%DATA_COORDINATE_SYSTEM  /=  manda_param2%DATA_COORDINATE_SYSTEM  ) then
print*,'manda_param1%DATA_COORDINATE_SYSTEM   =',TRIM(manda_param1%DATA_COORDINATE_SYSTEM)
print*,'manda_param2%DATA_COORDINATE_SYSTEM   =',TRIM(manda_param2%DATA_COORDINATE_SYSTEM)
     ENDIF

     IF(manda_param1%DATA_FILL_VALUE         /=  manda_param2%DATA_FILL_VALUE         ) then
print*,'manda_param1%DATA_FILL_VALUE          =',manda_param1%DATA_FILL_VALUE
print*,'manda_param2%DATA_FILL_VALUE          =',manda_param2%DATA_FILL_VALUE
     ENDIF


     IF(manda_param1%BLOCK_NUMBER            /=  manda_param2%BLOCK_NUMBER            ) then
print*,'manda_param1%BLOCK_NUMBER             =',manda_param1%BLOCK_NUMBER
print*,'manda_param2%BLOCK_NUMBER             =',manda_param2%BLOCK_NUMBER
     ENDIF

     IF(manda_param1%BLOCK_FIRST_INDEX       /=  manda_param2%BLOCK_FIRST_INDEX       ) then
print*,'manda_param1%BLOCK_FIRST_INDEX        =',TRIM(manda_param1%BLOCK_FIRST_INDEX)
print*,'manda_param2%BLOCK_FIRST_INDEX        =',TRIM(manda_param2%BLOCK_FIRST_INDEX)
     ENDIF

     IF(manda_param1%BLOCK_LAST_INDEX        /=  manda_param2%BLOCK_LAST_INDEX        ) then
print*,'manda_param1%BLOCK_LAST_INDEX         =',TRIM(manda_param1%BLOCK_LAST_INDEX)
print*,'manda_param2%BLOCK_LAST_INDEX         =',TRIM(manda_param2%BLOCK_LAST_INDEX)
     ENDIF

! Optional parameters difference

  print*, ('-',i=1,72)
  print*, 'Optional parameters difference:'
  print*

  diff=optio_param1%TIME_RESOLUTION  -optio_param2%TIME_RESOLUTION
     IF(abs(diff) > epsi ) then
print*,'optio_param1%TIME_RESOLUTION       =',optio_param1%TIME_RESOLUTION
print*,'optio_param2%TIME_RESOLUTION       =',optio_param2%TIME_RESOLUTION
     ENDIF

  diff=optio_param1%FREQUENCY_RESOLUTION -optio_param2%FREQUENCY_RESOLUTION
     IF(abs(diff) > epsi ) then
print*,'optio_param1%FREQUENCY_RESOLUTION  =',optio_param1%FREQUENCY_RESOLUTION
print*,'optio_param2%FREQUENCY_RESOLUTION  =',optio_param2%FREQUENCY_RESOLUTION
     ENDIF

     IF(optio_param1%TIME_SPAN_FROM       /=  optio_param2%TIME_SPAN_FROM       ) then
print*,'optio_param1%TIME_SPAN_FROM        =',TRIM(optio_param1%TIME_SPAN_FROM)
print*,'optio_param2%TIME_SPAN_FROM        =',TRIM(optio_param2%TIME_SPAN_FROM)
     ENDIF

     IF(optio_param1%TIME_SPAN_TO         /=  optio_param2%TIME_SPAN_TO         ) then
print*,'optio_param1%TIME_SPAN_TO          =',TRIM(optio_param1%TIME_SPAN_TO)
print*,'optio_param2%TIME_SPAN_TO          =',TRIM(optio_param2%TIME_SPAN_TO)
     ENDIF

     IF(optio_param1%TITLE                /=  optio_param2%TITLE                ) then
print*,'optio_param1%TITLE                 =',TRIM(optio_param1%TITLE)
print*,'optio_param2%TITLE                 =',TRIM(optio_param2%TITLE)
     ENDIF

     IF(optio_param1%SUB_TITLE            /=  optio_param2%SUB_TITLE            ) then
print*,'optio_param1%SUB_TITLE             =',TRIM(optio_param1%SUB_TITLE)
print*,'optio_param2%SUB_TITLE             =',TRIM(optio_param2%SUB_TITLE)
     ENDIF

     IF(optio_param1%DISCIPLINE_NAME      /=  optio_param2%DISCIPLINE_NAME      ) then
print*,'optio_param1%DISCIPLINE_NAME       =',TRIM(optio_param1%DISCIPLINE_NAME)
print*,'optio_param2%DISCIPLINE_NAME       =',TRIM(optio_param2%DISCIPLINE_NAME)
     ENDIF

     IF(optio_param1%EXPERIMENT_PI_NAME   /=  optio_param2%EXPERIMENT_PI_NAME   ) then
print*,'optio_param1%EXPERIMENT_PI_NAME    =',TRIM(optio_param1%EXPERIMENT_PI_NAME)
print*,'optio_param2%EXPERIMENT_PI_NAME    =',TRIM(optio_param2%EXPERIMENT_PI_NAME)
     ENDIF

     IF(optio_param1%EXPERIMENT_PI_MAIL   /=  optio_param2%EXPERIMENT_PI_MAIL   ) then
print*,'optio_param1%EXPERIMENT_PI_MAIL    =',TRIM(optio_param1%EXPERIMENT_PI_MAIL)
print*,'optio_param2%EXPERIMENT_PI_MAIL    =',TRIM(optio_param2%EXPERIMENT_PI_MAIL)
     ENDIF

     IF(optio_param1%MISSION_DESCRIPTION(1)     /=  optio_param2%MISSION_DESCRIPTION(1)     ) then
print*,'optio_param1%MISSION_DESCRIPTION(1)      =',TRIM(optio_param1%MISSION_DESCRIPTION(1))
print*,'optio_param2%MISSION_DESCRIPTION(1)      =',TRIM(optio_param2%MISSION_DESCRIPTION(1))
     ENDIF

     IF(optio_param1%EXPERIMENT_DESCRIPTION(1)  /=  optio_param2%EXPERIMENT_DESCRIPTION(1)  ) then
print*,'optio_param1%EXPERIMENT_DESCRIPTION(1)   =',TRIM(optio_param1%EXPERIMENT_DESCRIPTION(1))
print*,'optio_param2%EXPERIMENT_DESCRIPTION(1)   =',TRIM(optio_param2%EXPERIMENT_DESCRIPTION(1))
     ENDIF

     IF(optio_param1%INDEX_DESCRIPTION(1)       /=  optio_param2%INDEX_DESCRIPTION(1)       ) then
print*,'optio_param1%INDEX_DESCRIPTION(1)        =',TRIM(optio_param1%INDEX_DESCRIPTION(1))
print*,'optio_param2%INDEX_DESCRIPTION(1)        =',TRIM(optio_param2%INDEX_DESCRIPTION(1))
     ENDIF

     IF(optio_param1%INDEX_EXTENSION_DESCRIP(1) /=  optio_param2%INDEX_EXTENSION_DESCRIP(1) ) then
print*,'optio_param1%INDEX_EXTENSION_DESCRIP(1)  =',TRIM(optio_param1%INDEX_EXTENSION_DESCRIP(1))
print*,'optio_param2%INDEX_EXTENSION_DESCRIP(1)  =',TRIM(optio_param2%INDEX_EXTENSION_DESCRIP(1))
     ENDIF

     IF(optio_param1%DATA_DESCRIPTION(1)        /=  optio_param2%DATA_DESCRIPTION(1)        ) then
print*,'optio_param1%DATA_DESCRIPTION(1)         =',TRIM(optio_param1%DATA_DESCRIPTION(1))
print*,'optio_param2%DATA_DESCRIPTION(1)         =',TRIM(optio_param2%DATA_DESCRIPTION(1))
     ENDIF

     IF(optio_param1%BLOCK_DESCRIPTION(1)       /=  optio_param2%BLOCK_DESCRIPTION(1)       ) then
print*,'optio_param1%BLOCK_DESCRIPTION(1)        =',TRIM(optio_param1%BLOCK_DESCRIPTION(1))
print*,'optio_param2%BLOCK_DESCRIPTION(1)        =',TRIM(optio_param2%BLOCK_DESCRIPTION(1))
     ENDIF

     IF(optio_param1%FILE_ANOMALIES(1)          /=  optio_param2%FILE_ANOMALIES(1)          ) then
print*,'optio_param1%FILE_ANOMALIES(1)           =',TRIM(optio_param1%FILE_ANOMALIES(1))
print*,'optio_param2%FILE_ANOMALIES(1)           =',TRIM(optio_param2%FILE_ANOMALIES(1))
     ENDIF

     IF(optio_param1%HISTORY(1)                 /=  optio_param2%HISTORY(1)                 ) then
print*,'optio_param1%HISTORY(1)                  =',TRIM(optio_param1%HISTORY(1))
print*,'optio_param2%HISTORY(1)                  =',TRIM(optio_param2%HISTORY(1))
     ENDIF



! Constant data difference

  print*, ('-',i=1,72)
  print*, 'Constant data difference:'
  print*

     IF(const_data1%TED_VERSION /=  const_data2%TED_VERSION ) then
print*,'const_data1%TED_VERSION  =',TRIM(const_data1%TED_VERSION)
print*,'const_data2%TED_VERSION  =',TRIM(const_data2%TED_VERSION)
     ENDIF

     IF(const_data1%TCOR_OPTION /=  const_data2%TCOR_OPTION ) then
print*,'const_data1%TCOR_OPTION  =',TRIM(const_data1%TCOR_OPTION)
print*,'const_data2%TCOR_OPTION  =',TRIM(const_data2%TCOR_OPTION)
     ENDIF

     diff=const_data1%SAMPLE_RATE -const_data2%SAMPLE_RATE
     IF(abs(diff) > epsi ) then
print*,'const_data1%SAMPLE_RATE     =',const_data1%SAMPLE_RATE
print*,'const_data2%SAMPLE_RATE     =',const_data2%SAMPLE_RATE
     ENDIF

     diff=const_data1%VOLT_RANGE_MIN -const_data2%VOLT_RANGE_MIN
     IF(abs(diff) > epsi ) then
print*,'const_data1%VOLT_RANGE_MIN  =',const_data1%VOLT_RANGE_MIN
print*,'const_data2%VOLT_RANGE_MIN  =',const_data2%VOLT_RANGE_MIN
     ENDIF

     diff=const_data1%VOLT_RANGE_MAX -const_data2%VOLT_RANGE_MAX
     IF(abs(diff) > epsi ) then
print*,'const_data1%VOLT_RANGE_MAX  =',const_data1%VOLT_RANGE_MAX
print*,'const_data2%VOLT_RANGE_MAX  =',const_data2%VOLT_RANGE_MAX
     ENDIF

     IF(const_data1%TM_RANGE_MIN   /=  const_data2%TM_RANGE_MIN   ) then
print*,'const_data1%TM_RANGE_MIN    =',const_data1%TM_RANGE_MIN
print*,'const_data2%TM_RANGE_MIN    =',const_data2%TM_RANGE_MIN
     ENDIF

     IF(const_data1%TM_RANGE_MAX   /=  const_data2%TM_RANGE_MAX   ) then
print*,'const_data1%TM_RANGE_MAX    =',const_data1%TM_RANGE_MAX
print*,'const_data2%TM_RANGE_MAX    =',const_data2%TM_RANGE_MAX
     ENDIF


     diff=const_data1%MISALIGNMENT_MATRIX_L1_C1 -const_data2%MISALIGNMENT_MATRIX_L1_C1 
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L1_C1  =',const_data1%MISALIGNMENT_MATRIX_L1_C1
print*,'const_data2%MISALIGNMENT_MATRIX_L1_C1  =',const_data2%MISALIGNMENT_MATRIX_L1_C1
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L1_C2 -const_data2%MISALIGNMENT_MATRIX_L1_C2 
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L1_C2  =',const_data1%MISALIGNMENT_MATRIX_L1_C2
print*,'const_data2%MISALIGNMENT_MATRIX_L1_C2  =',const_data2%MISALIGNMENT_MATRIX_L1_C2
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L1_C3 -const_data2%MISALIGNMENT_MATRIX_L1_C3 
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L1_C3  =',const_data1%MISALIGNMENT_MATRIX_L1_C3
print*,'const_data2%MISALIGNMENT_MATRIX_L1_C3  =',const_data2%MISALIGNMENT_MATRIX_L1_C3
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L2_C1 -const_data2%MISALIGNMENT_MATRIX_L2_C1
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L2_C1  =',const_data1%MISALIGNMENT_MATRIX_L2_C1
print*,'const_data2%MISALIGNMENT_MATRIX_L2_C1  =',const_data2%MISALIGNMENT_MATRIX_L2_C1
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L2_C2 -const_data2%MISALIGNMENT_MATRIX_L2_C2
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L2_C2  =',const_data1%MISALIGNMENT_MATRIX_L2_C2
print*,'const_data2%MISALIGNMENT_MATRIX_L2_C2  =',const_data2%MISALIGNMENT_MATRIX_L2_C2
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L2_C3 -const_data2%MISALIGNMENT_MATRIX_L2_C3
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L2_C3  =',const_data1%MISALIGNMENT_MATRIX_L2_C3
print*,'const_data2%MISALIGNMENT_MATRIX_L2_C3  =',const_data2%MISALIGNMENT_MATRIX_L2_C3
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L3_C1 -const_data2%MISALIGNMENT_MATRIX_L3_C1
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L3_C1  =',const_data1%MISALIGNMENT_MATRIX_L3_C1
print*,'const_data2%MISALIGNMENT_MATRIX_L3_C1  =',const_data2%MISALIGNMENT_MATRIX_L3_C1
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L3_C2 -const_data2%MISALIGNMENT_MATRIX_L3_C2 
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L3_C2  =',const_data1%MISALIGNMENT_MATRIX_L3_C2
print*,'const_data2%MISALIGNMENT_MATRIX_L3_C2  =',const_data2%MISALIGNMENT_MATRIX_L3_C2
     ENDIF

     diff=const_data1%MISALIGNMENT_MATRIX_L3_C3 -const_data2%MISALIGNMENT_MATRIX_L3_C3 
     IF(abs(diff) > epsi ) then
print*,'const_data1%MISALIGNMENT_MATRIX_L3_C3  =',const_data1%MISALIGNMENT_MATRIX_L3_C3
print*,'const_data2%MISALIGNMENT_MATRIX_L3_C3  =',const_data2%MISALIGNMENT_MATRIX_L3_C3
     ENDIF

     IF(const_data1%CONSTANT_TIME_MEASUREMENT /= const_data2%CONSTANT_TIME_MEASUREMENT ) then
print*,'const_data1%CONSTANT_TIME_MEASUREMENT  =',TRIM(const_data1%CONSTANT_TIME_MEASUREMENT)
print*,'const_data2%CONSTANT_TIME_MEASUREMENT  =',TRIM(const_data2%CONSTANT_TIME_MEASUREMENT)
     ENDIF

     diff=const_data1%SPIN_PERIOD               -const_data2%SPIN_PERIOD               
     IF(abs(diff) > epsi ) then
print*,'const_data1%SPIN_PERIOD                =',const_data1%SPIN_PERIOD
print*,'const_data2%SPIN_PERIOD                =',const_data2%SPIN_PERIOD
     ENDIF

     diff=const_data1%SPIN_GEI_RIGHT_ASCENSION  -const_data2%SPIN_GEI_RIGHT_ASCENSION  
     IF(abs(diff) > epsi ) then
print*,'const_data1%SPIN_GEI_RIGHT_ASCENSION   =',const_data1%SPIN_GEI_RIGHT_ASCENSION
print*,'const_data2%SPIN_GEI_RIGHT_ASCENSION   =',const_data2%SPIN_GEI_RIGHT_ASCENSION
     ENDIF

     diff=const_data1%SPIN_GEI_DECLINATION      -const_data2%SPIN_GEI_DECLINATION      
     IF(abs(diff) > epsi ) then
print*,'const_data1%SPIN_GEI_DECLINATION       =',const_data1%SPIN_GEI_DECLINATION
print*,'const_data2%SPIN_GEI_DECLINATION       =',const_data2%SPIN_GEI_DECLINATION
     ENDIF

     diff=const_data1%MASS_CENTER_X             -const_data2%MASS_CENTER_X             
     IF(abs(diff) > epsi ) then
print*,'const_data1%MASS_CENTER_X              =',const_data1%MASS_CENTER_X
print*,'const_data2%MASS_CENTER_X              =',const_data2%MASS_CENTER_X
     ENDIF

     diff=const_data1%MASS_CENTER_Y             -const_data2%MASS_CENTER_Y             
     IF(abs(diff) > epsi ) then
print*,'const_data1%MASS_CENTER_Y              =',const_data1%MASS_CENTER_Y
print*,'const_data2%MASS_CENTER_Y              =',const_data2%MASS_CENTER_Y
     ENDIF

     diff=const_data1%MASS_CENTER_Z             -const_data2%MASS_CENTER_Z             
     IF(abs(diff) > epsi ) then
print*,'const_data1%MASS_CENTER_Z              =',const_data1%MASS_CENTER_Z
print*,'const_data2%MASS_CENTER_Z              =',const_data2%MASS_CENTER_Z
     ENDIF

     diff=const_data1%EULER_ANGLE_FIRST         -const_data2%EULER_ANGLE_FIRST         
     IF(abs(diff) > epsi ) then
print*,'const_data1%EULER_ANGLE_FIRST          =',const_data1%EULER_ANGLE_FIRST
print*,'const_data2%EULER_ANGLE_FIRST          =',const_data2%EULER_ANGLE_FIRST
     ENDIF

     diff=const_data1%EULER_ANGLE_SECOND        -const_data2%EULER_ANGLE_SECOND        
     IF(abs(diff) > epsi ) then
print*,'const_data1%EULER_ANGLE_SECOND         =',const_data1%EULER_ANGLE_SECOND
print*,'const_data2%EULER_ANGLE_SECOND         =',const_data2%EULER_ANGLE_SECOND
     ENDIF

     diff=const_data1%FREQUENCY_FILTER_MIN -const_data2%FREQUENCY_FILTER_MIN 
     IF(abs(diff) > epsi ) then
print*,'const_data1%FREQUENCY_FILTER_MIN  =',const_data1%FREQUENCY_FILTER_MIN
print*,'const_data2%FREQUENCY_FILTER_MIN  =',const_data2%FREQUENCY_FILTER_MIN
     ENDIF

     diff=const_data1%FREQUENCY_FILTER_MAX -const_data2%FREQUENCY_FILTER_MAX 
     IF(abs(diff) > epsi ) then
print*,'const_data1%FREQUENCY_FILTER_MAX  =',const_data1%FREQUENCY_FILTER_MAX
print*,'const_data2%FREQUENCY_FILTER_MAX  =',const_data2%FREQUENCY_FILTER_MAX
     ENDIF

     diff=const_data1%FREQUENCY_CUT_OFF    -const_data2%FREQUENCY_CUT_OFF    
     IF(abs(diff) > epsi ) then
print*,'const_data1%FREQUENCY_CUT_OFF     =',const_data1%FREQUENCY_CUT_OFF
print*,'const_data2%FREQUENCY_CUT_OFF     =',const_data2%FREQUENCY_CUT_OFF
     ENDIF

     diff=const_data1%FREQUENCY_DETREND    -const_data2%FREQUENCY_DETREND    
     IF(abs(diff) > epsi ) then
print*,'const_data1%FREQUENCY_DETREND     =',const_data1%FREQUENCY_DETREND
print*,'const_data2%FREQUENCY_DETREND     =',const_data2%FREQUENCY_DETREND
     ENDIF
 
     IF(const_data1%CALIB_KERNEL_SIZE    /=  const_data2%CALIB_KERNEL_SIZE   ) then  
print*,'const_data1%CALIB_KERNEL_SIZE     =',const_data1%CALIB_KERNEL_SIZE
print*,'const_data2%CALIB_KERNEL_SIZE     =',const_data2%CALIB_KERNEL_SIZE
     ENDIF
 
     IF(const_data1%CALIB_SHIFT_SIZE     /=  const_data2%CALIB_SHIFT_SIZE    ) then
print*,'const_data1%CALIB_SHIFT_SIZE      =',const_data1%CALIB_SHIFT_SIZE
print*,'const_data2%CALIB_SHIFT_SIZE      =',const_data2%CALIB_SHIFT_SIZE
     ENDIF
 
     IF(const_data1%SPECTRA_KERNEL_SIZE  /=  const_data2%SPECTRA_KERNEL_SIZE ) then
print*,'const_data1%SPECTRA_KERNEL_SIZE   =',const_data1%SPECTRA_KERNEL_SIZE
print*,'const_data2%SPECTRA_KERNEL_SIZE   =',const_data2%SPECTRA_KERNEL_SIZE
     ENDIF
 
     IF(const_data1%SPECTRA_SHIFT_SIZE   /=  const_data2%SPECTRA_SHIFT_SIZE  ) then
print*,'const_data1%SPECTRA_SHIFT_SIZE    =',const_data1%SPECTRA_SHIFT_SIZE
print*,'const_data2%SPECTRA_SHIFT_SIZE    =',const_data2%SPECTRA_SHIFT_SIZE
     ENDIF
 
     IF(const_data1%SPECTRA_WEIGHTING    /=  const_data2%SPECTRA_WEIGHTING   ) then
print*,'const_data1%SPECTRA_WEIGHTING     =',const_data1%SPECTRA_WEIGHTING
print*,'const_data2%SPECTRA_WEIGHTING     =',const_data2%SPECTRA_WEIGHTING
     ENDIF

  end subroutine diff_meta_data
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  end program diff_rff
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
