  program flat_to_rff

! ***************************************************************0**
! convert a flat file  to RFF
!
! P. Robert, ScientiDev, Feb. 2020
! ***************************************************************0**


  use rff_param_def
  use rff_data_def

  character(len=27)  :: credate, start_date
  character(len=70)  :: flat_name,rff_name
  character(len=100) :: line

!-------------------------------------------------------------------0--
  print*, 'name of data file ? (ex: FGM-2004-06-28.flat)'
  read *, flat_name
  print*, flat_name
!---------------------------------------------------------------------

!
! Header of flat file must be as following:
!#-------------------------------------------------------------------------------
!# Comments ZONE
!# KRTP : Kronocentric Radial-Theta-Phi Spherical Polar Saturn centered coodinates
!# Time: decimal second of the day
!# data: Time, Bx, By, Bz
!#-------------------------------------------------------------------------------
!CASSINI                  ! MISSION_NAME
!Cassini                  ! OBSERVATORY_NAME
!1                        ! OBSERVATORY_NUMBER
!FGM                      ! EXPERIMENT_NAME
!Normal                   ! EXPERIMENT_MODE
!Magnetometer             ! INSTRUMENT_TYPE
!Magnetic field           ! MEASUREMENT_TYPE
!KRTP                     ! DATA_COORDINATE_SYSTEM
!Bx ; By ; Bz             ! DATA_LABEL
!nT ; nT ; nT             ! DATA_UNITS
!3                        ! DATA_DIMENSION
!2749035                  ! BLOCK_NUMBER
!0.0320000                ! TIME_RESOLUTION
!2004-06-28T00:00:01.000Z ! BLOCK_FIRST_INDEX
!#-------------------------------------------------------------------------------
!
! after data looks like:
!
! 1.0000002e-001  1.1600000e-001 -1.5200000e-001  1.6000001e-002
! 1.3100004e-001  1.3900000e-001 -1.2300000e-001  1.8999999e-002
! 1.6199994e-001  1.0700000e-001 -1.8600000e-001  2.0000000e-002
! ...

  call set_common_param

  ifc1=10
  ifc2=11

!---------------------------------------------------------------------
  print*, 'read flat file ', trim(flat_name)
!---------------------------------------------------------------------

  close(ifc1)
  open(ifc1,file=flat_name)

  line(1:1)='#'

  do while (line(1:1) == '#')
     read(ifc1,'(a)') line ; print*, line
  end do

  backspace(ifc1)


  read(ifc1,'(a)') line
  i=index(line,'!')-1
  manda_param%MISSION_NAME=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%OBSERVATORY_NAME=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  read(line(1:i),*) manda_param%OBSERVATORY_NUMBER

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%EXPERIMENT_NAME=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%EXPERIMENT_MODE=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%INSTRUMENT_TYPE=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%MEASUREMENT_TYPE=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%DATA_COORDINATE_SYSTEM=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%DATA_LABEL=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%DATA_UNITS=line(1:i)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  read(line(1:i),*) manda_param%DATA_DIMENSION(1)

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  read(line(1:i),*) manda_param%BLOCK_NUMBER

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  read(line(1:i),*) optio_param%TIME_RESOLUTION

  read(ifc1,'(a)') line ; print*, line
  i=index(line,'!')-1
  manda_param%BLOCK_FIRST_INDEX=line(1:i)

  read(ifc1,'(a)') line ; print*, line

  deltaT=real(optio_param%TIME_RESOLUTION)
  const_data%SAMPLE_RATE=  1./deltaT


  nbp        =manda_param%BLOCK_NUMBER
  nbcomp     =manda_param%DATA_DIMENSION(1)
  start_date =manda_param%BLOCK_FIRST_INDEX(1:27)

  print*, 'nbcomp, nbp=',nbcomp, nbp
  print*, 'start date =',start_date

  if(nbcomp /= 3) then
                  print*, 'nbcomp=',nbcomp
                  print*, 'Must be =3'
                  stop 'flat_to_rff.exe               : *** ABORTED !!!'
  endif


  allocate(R_data_vector(3,nbp))
  allocate(data_index(nbp))

! read  magnetic field

  data_index(1)=start_date

  do i=1,nbp

      read(ifc1,'(a)',iostat=iosta) line
      if(iosta /= 0) then
               print*, '*** read error at new record ',i
               print*, line
               stop 'flat_to_rff.exe               : ABORTED !'
      endif
      itest=index(line,'Z')
      if(itest == 0) then
          read(ifc1,*,iostat=iosta) time,Bx,By,Bz
          if(i > 1) call addsec_datiso(start_date,time,data_index(i))
                     else
          read(line(1:27),'(a27)') data_index(i)
          read(line(28:),*,iostat=iosta) Bx,By,Bz
      endif

      if(iosta /= 0) then
                     print*, '*** read error at record ',i
                     print*, line
                     stop 'flat_to_rff.exe               : ABORTED !'
      endif

     R_data_vector(1,i)=Bx
     R_data_vector(2,i)=By
     R_data_vector(3,i)=Bz

  end do

  close(ifc1)

! ===========================================================
  print*, 'CREATE RFF FILE '
! ===========================================================

  i=index(flat_name,'.')

  rff_name=flat_name(1:i)//'rff'

  manda_param%FILE_NAME                 = rff_name

  optio_param%TITLE                     = trim(manda_param%MISSION_NAME)//' / '//trim(manda_param%EXPERIMENT_NAME)
  optio_param%SUB_TITLE                 = manda_param%DATA_UNITS(1:3)//' in '//trim(manda_param%DATA_COORDINATE_SYSTEM)//' system'
  manda_param%BLOCK_LAST_INDEX          = data_index(nbp)

  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_INDEX_EXTENSION_DESCRIP

  optio_param%EXPERIMENT_DESCRIPTION(1)  = 'No description'
  EX_DE = 1

!---------------------------------------------------------------------

! create rff file
  call rff_W_metadata(ifc2,rff_name)
  call rff_W_const_data(ifc2)
  call rff_W_indexed_data(ifc2)
  call rff_W_tail(ifc2)

! ===========================================================
  print*, 'END'
! ===========================================================

  print*
  print*, 'flat_to_rff.exe               : NORMAL TERMINATION'
     stop 'flat_to_rff.exe               : NORMAL TERMINATION'

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
contains
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine set_common_param

  call rff_set_default_init
  call gdatiso(credate)

  manda_param%FILE_CLASS                = 'VecTime'
  manda_param%FILE_FORMAT_VERSION       = 'Roproc_Format_File V 2.3'
  manda_param%FILE_CREATION_DATE        = credate
  manda_param%INDEX_LABEL               = 'Time'
  manda_param%INDEX_TYPE                = 'STR'
  manda_param%INDEX_UNITS               = 'ISO_TIME'
  manda_param%INDEX_FORMAT              = '(a27)'
  manda_param%INDEX_FORM                = 'Scalar'
  manda_param%INDEX_DIMENSION           = 1
  manda_param%INDEX_PROPERTIES          = 'Regularly Spaced'
  manda_param%INDEX_EXTENSION_LABEL     = 'No'
  manda_param%INDEX_EXTENSION_TYPE      = 'STR'
  manda_param%INDEX_EXTENSION_UNITS     = 'None'
  manda_param%INDEX_EXTENSION_FORMAT    = 'None'
  manda_param%INDEX_EXTENSION_LENGTH    = 0
  manda_param%DATA_TYPE                 = 'FLT'
  manda_param%DATA_FORMAT               = '(3e15.6)'
  manda_param%DATA_FORM                 = 'Vector'
  manda_param%DATA_DIMENSION            = 3
  manda_param%DATA_REPRESENTATION       = 'xyz Cartesian'
  manda_param%DATA_FILL_VALUE           = '1.e30'

  optio_param%DISCIPLINE_NAME           = 'Space and  Magnetospheric Physics'
  optio_param%EXPERIMENT_PI_NAME        = 'No'
  optio_param%EXPERIMENT_PI_MAIL        = 'Unknown'

  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_INDEX_EXTENSION_DESCRIP

  optio_param%MISSION_DESCRIPTION(1)     = 'No description'

  MI_DE = 1

  return

  end subroutine set_common_param

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  end program flat_to_rff

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


