!
      program get_data_CLUGEOM
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
!     Lecture des fichiers d'orbite de CLUSTER;
!     liste propre des donnees sur une journee, passage eventuel en GSE
!     et 
!     Resultat dans fichier ascii get_data_CLUGEOM.resu
!     Ne necessite que JD2000 et ORBIT de la orbitlib.o
!     (programmes publics)
!
!     P. Robert, CETP, Mars 2001
!                  revu Mai 2001
!             revu Decembre 2001
!             revu Aout     2002
!             adaptation aux RPC Mars 2014
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

!----------------------------------------------------------------------!
! Object: calcul la geometrie du tetraedre, cré get_data_CLUGEOM.resu
! Author: P. Robert , LPP, 2001, rev P. R. Scientidev Jan 2021
!----------------------------------------------------------------------!

! *** declaration des variables
!

      use rff_param_def
      use rff_data_def

      real(kind=4),      dimension(:,:),   allocatable :: R_data_vector1
!     real(kind=4),      dimension(:,:),   allocatable :: R_data_vector2
      real(kind=4),      dimension(:,:),   allocatable :: R_data_vector3
      real(kind=4),      dimension(:,:),   allocatable :: R_data_vector4
    
      character(len=27), dimension(:),     allocatable :: data_index1
!     character(len=27), dimension(:),     allocatable :: data_index2
      character(len=27), dimension(:),     allocatable :: data_index3
      character(len=27), dimension(:),     allocatable :: data_index4
      
      character(len=255), dimension(4) :: file
      
      real*8 dirax(3,3),a,b,c,gl,gf
      real   satpos(3,4)
!
      character*120 rep,rep1,rep2,rep3,rep4
!
! *** common en sortie de cgeompara
!
      common /distan/     d12 ,    d13 ,    d14 ,    d23 ,  d24,  d34, &
                         dx12 ,   dx13 ,   dx14 ,   dx21 , dx31, dx41, &
                         dy12 ,   dy13 ,   dy14 ,   dy21 , dy31, dy41, &
                         dz12 ,   dz13 ,   dz14 ,   dz21 , dz31, dz41
      common /surfac/    s134 ,   s142 ,   s123 ,   s432
!
!     ---------------------------------------------------------------+--
!
!
      print 200
      print 200, ('X',i=1,53)
      print 200
      print 200, 'get_data_CLUGEOM.exe: list of CLUSTER geometry param.'
      print 200
      print 200, '                 Patrick Robert, March 2001'
      print 200
      print 200, ('X',i=1,53)
      print 200
!
      kode= 6
!
!     ---------------------------------------------------------------+--
      print*, 'lecture du nom des  fichiers de position'

      read(*,'(a)') file(1)
      read(*,'(a)') file(2)
      read(*,'(a)') file(3)
      read(*,'(a)') file(4)
      
      print*, 'file1=',TRIM(file(1))
      print*, 'file1=',TRIM(file(2))
      print*, 'file1=',TRIM(file(3))
      print*, 'file1=',TRIM(file(4))
      
!     ---------------------------------------------------------------+--      
      print*
      print*, 'lecture des fichiers de positions'
      
   DO i=1,4
      
      call rff_R_file(i,file(i))
        
      IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** error, RFF file is not a VecTime Class'
         write(*,*) '    manda_param%FILE_CLASS=', manda_param%FILE_CLASS
         write(*,*) '    program aborted'
         stop 'get_data_CLUGEOM                 : *** ERROR !! Program aborted !'
      ENDIF
      
              
      IF(manda_param%DATA_COORDINATE_SYSTEM /= 'GSE') THEN
         write(*,*) '*** error, RFF file is not in GSE system'
         write(*,*) '    manda_param%DATA_COORDINATE_SYSTEM=', manda_param%DATA_COORDINATE_SYSTEM
         write(*,*) '    program aborted'
         stop 'get_data_CLUGEOM                 : *** ERROR !! Program aborted !'
      ENDIF
      
      if(i == 1) then
                 data_index1=data_index
                 R_data_vector1=R_data_vector
                 nbloc1=manda_param%BLOCK_NUMBER
                 dt1=real(optio_param%TIME_RESOLUTION)
                 rep1=manda_param%DATA_COORDINATE_SYSTEM
      endif
      
      if(i == 2) then
                 data_index2=data_index
                 R_data_vector2=R_data_vector
                 nbloc2=manda_param%BLOCK_NUMBER
                 dt2=real(optio_param%TIME_RESOLUTION)
                 rep2=manda_param%DATA_COORDINATE_SYSTEM
      endif      
      
      if(i == 3) then
                 data_index3=data_index
                 R_data_vector3=R_data_vector
                 nbloc3=manda_param%BLOCK_NUMBER
                 dt3=real(optio_param%TIME_RESOLUTION)
                 rep3=manda_param%DATA_COORDINATE_SYSTEM
      endif
      
      if(i == 4) then
                 data_index4=data_index
                 R_data_vector4=R_data_vector
                 nbloc4=manda_param%BLOCK_NUMBER
                 dt4=real(optio_param%TIME_RESOLUTION)
                 rep4=manda_param%DATA_COORDINATE_SYSTEM
      endif
      
   ENDDO
!     ---------------------------------------------------------------+--      

      dt=dt1
      nbloc=nbloc1
      rep=rep1
      
      IF((abs(dt2-dt1) > 0.001) .or. (abs(dt3-dt1) > 0.001) .or. (abs(dt4-dt1) > 0.001))  THEN
         write(*,*) '*** error, time resolution is not the same for the 4 files'
         write(*,*) '    dt1,dt2,dt3,dt4=',dt1,dt2,dt3,dt4
         write(*,*) '    program aborted'
         stop 'get_data_CLUGEOM                 : *** ERROR !! Program aborted !'
      ENDIF
      
            
      IF((rep1 /=  rep2)  .or. (rep1 /= rep3) .or. (rep1/= rep4))  THEN
         write(*,*) '*** error, rep is not the same for the 4 files'
         write(*,*) '    rep1,rep2,rep3,rep4=',rep1,rep2,rep3,rep4
         write(*,*) '    program aborted'
         stop 'get_data_CLUGEOM                 : *** ERROR !! Program aborted !'
      ENDIF
                  
      IF((nbloc1 /=  nbloc2)  .or. (nbloc1 /= nbloc3) .or. (nbloc1/= nbloc4))  THEN
         write(*,*) '*** error, nbloc is not the same for the 4 files'
         write(*,*) '    nbloc1,nbloc2,nbloc3,nbloc4=',nbloc1,nbloc2,nbloc3,nbloc4
         write(*,*) '    program aborted'
         stop 'get_data_CLUGEOM                 : *** ERROR !! Program aborted !'
      ENDIF
      
      
!
! *** opening get_data_CLUGEOM.resu
!
      close(7)
      open(7,file='get_data_CLUGEOM.resu')
!
      write(7,200) '#START_HEADER'
      write(7,200) 'File type  : get_data_CLUGEOM.resu'
      write(7,200) 'Creator    : get_data_CLUGEOM.exe'
      write(7,200) 'Version    : April 2001'
      write(7,200) 'Author     : P. Robert, CNRS/CETP'
      write(7,200) 'Coordinates: ',rep
      write(7,100) 'Nbloc      : ',nbloc/10
      write(7,200) 'Content    : see following line'
      write(7,200) 'JD    YY  MM DD hh mm ss s/c  X (km)    Y    Z   '
      write(7,200) '                         s/c  X (km)    Y    Z in centre of mass'
      write(7,200) '                         Dij, 6 values'
      write(7,200) '                         Si , 4 values'
      write(7,200) '                         a,b,c'
      write(7,200) '                         Elong, tetE,phiE'
      write(7,200) '                         Plana, tetP,phiP'
      write(7,200) ('-',i=1,89)
      write(7,200) '#END_HEADER'
!

!
      print*
      print*, 'Time loop...'
      
   DO it=1,nbloc,10   
!
!
! *   boucle sur les composantes pour le chargement de satpos
!
      do ix=1,3
         satpos(ix,1)= R_data_vector1(ix,it)
         satpos(ix,2)= R_data_vector2(ix,it)
         satpos(ix,3)= R_data_vector3(ix,it)
         satpos(ix,4)= R_data_vector4(ix,it)
      enddo

! *   ecriture des resultats de la forme longue

      call decode_datiso(data_index(it),iyear,imon,iday,ih,im,is,ims,imc)
      call cjd2000(iyear,imon,iday,jd00)

      write(7,120) jd00,iyear,imon,iday,ih,im,is, &
                   1,satpos(1,1),satpos(2,1),satpos(3,1)
      write(7,110) 2,satpos(1,2),satpos(2,2),satpos(3,2)
      write(7,110) 3,satpos(1,3),satpos(2,3),satpos(3,3)
      write(7,110) 4,satpos(1,4),satpos(2,4),satpos(3,4)
      
! *   calcul des positions dans le centre de gravite
!
      call cbaryclus(satpos,gx,gy,gz)
      call transclus(satpos,gx,gy,gz)    
!
! *   calcul des parametres du tetraedre
!
      call cgeompara(satpos)
      call cellicrit(satpos,a,b,c,dirax,gl,gf)
!
      elong= real(gl)
      plana= real(gf)
!
      call tcarsph(real(dirax(1,1)),real(dirax(2,1)),real(dirax(3,1)), &
      ra,teta,phia)
      call tcarsph(real(dirax(1,2)),real(dirax(2,2)),real(dirax(3,2)), &
      rb,tetb,phib)
      call tcarsph(real(dirax(1,3)),real(dirax(2,3)),real(dirax(3,3)), &
      rc,tetc,phic)
!
      teta=teta*180./3.1415927
      tetc=tetc*180./3.1415927
      phia=phia*180./3.1415927
      phic=phic*180./3.1415927
!
      write(7,300) d12, d13, d14, d23 ,  d24,  d34
      write(7,310) s134 ,s142,s123,s432
      write(7,300) a,b,c
      write(7,400) elong,teta,phia, plana,tetc,phic

   ENDDO
!
! *** fermeture des fichiers

      close(7)
!
      print*
!
!      ---------------------

  100 format(a,i7)
  110 format(24x                            ,1x,i1,3(1x,f10.2), &
            3(1x,f6.2),1x,f8.2,1x,i1.0)
  120 format(i4,i5,2i3.2,1x,2(i2.2,' '),i2.2,1x,i1,3(1x,f10.2), &
            3(1x,f6.2),1x,f8.2,1x,i1.0)
  200 format(100a)
  300 format(23x,6(1x,f10.2))
  310 format(24x,4(1x,e14.6))
  400 format(26x,f8.5,2f8.2)
!
      print*, 'get_data_CLUGEOM                 : NORMAL TERMINATION'
         stop 'get_data_CLUGEOM                 : NORMAL TERMINATION'
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
