!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
          
      subroutine alitime_data_4sat(datiso1,datiso2,datiso3,datiso4, &
                                   vectim1,vectim2,vectim3,vectim4, &
                                   nbp1,nbp2,nbp3,nbp4, dt1,dt2,dt3,dt4,iref,nbpint,fill_val)

!----------------------------------------------------------------------!
! *   Object : aligne en temps les 4 tableaux de donnees vectim par interpolation lineaire
! *   Author : P. Robert, Scientidev, Janvier 2021 - inspiré des Ropocs
!----------------------------------------------------------------------!
!     -------------------------------------------------------------------
!
!     aligne en temps les 4 tableaux de donnees vectim par interpolation lineaire   

!     input: datiso1,datiso2,datiso3,datiso4,vectim1,vectim2,vectim3,vectim4
!            nbp1,nbp2,nbp3,nbp4, dt1,dt2,dt3,dt4
!     output: vectim1,vectim2,vectim3,vectim4, iref,nbpint
!             iref: satellite de reference
!             nbpint: nb de points interpolles
!     -------------------------------------------------------------------
                               

                                   
      character(len=27) datiso1(nbp1),datiso2(nbp2),datiso3(nbp3),datiso4(nbp4)
      
      real(kind=4)      vectim1(3,nbp1),vectim2(3,nbp2),vectim3(3,nbp3),vectim4(3,nbp4)        
      
      integer,      dimension(:),  allocatable :: mil1,mil2,mil3,mil4, milr  
      real(kind=4), dimension(:),  allocatable :: xini,yini,zini,  xali,yali,zali                   
                                   
!
      print*, 'Time alignment od 4sat data'
      print*, '---------------------------'
      print*
      
      print*,'S/C 1:'
      print*, 'date de debut de periode: ',datiso1(1)
      print*, 'date de fin   de periode: ',datiso1(nbp1)
      print*
      
      print*,'S/C 2:'
      print*, 'date de debut de periode: ',datiso2(1)
      print*, 'date de fin   de periode: ',datiso2(nbp2)
      print*
      
      print*,'S/C 3:'
      print*, 'date de debut de periode: ',datiso3(1)
      print*, 'date de fin   de periode: ',datiso3(nbp3)
      print*
      
      print*,'S/C 4:'
      print*, 'date de debut de periode: ',datiso4(1)
      print*, 'date de fin   de periode: ',datiso4(nbp4)      
      

!     -------------------------------------------------------------------
!     I) calcul de la millisec du jour pour chaque sat
!     -------------------------------------------------------------------

       allocate(mil1(nbp1))
       allocate(mil2(nbp2))
       allocate(mil3(nbp3))
       allocate(mil4(nbp4))

!     -------------------------------------------------------------------

      do i=1,nbp1
         call decode_datiso(datiso1(i),iyear,imon,iday,ih,im,is,ims,imc)
         mil1(i)= ims +1000*is +60000*im +3600000*ih
      enddo
!
      print*,'S/C 1:'
      print*, 'mils deb et fin= ',mil1(1),mil1(nbp1)
      
!     -------------------------------------------------------------------
!
      do i=1,nbp2
         call decode_datiso(datiso2(i),iyear,imon,iday,ih,im,is,ims,imc)
         mil2(i)= ims +1000*is +60000*im +3600000*ih
      enddo
!
      print*,'S/C 2:'
      print*, 'mils deb et fin= ',mil2(1),mil2(nbp2)
      
!     -------------------------------------------------------------------
!
      do i=1,nbp3
         call decode_datiso(datiso3(i),iyear,imon,iday,ih,im,is,ims,imc)
         mil3(i)= ims +1000*is +60000*im +3600000*ih
      enddo
!
      print*,'S/C 3:'
      print*, 'mils deb et fin= ',mil3(1),mil3(nbp3)
      
!     -------------------------------------------------------------------
!
      do i=1,nbp4
         call decode_datiso(datiso4(i),iyear,imon,iday,ih,im,is,ims,imc)
         mil4(i)= ims +1000*is +60000*im +3600000*ih
      enddo
!
      print*,'S/C 4:'
      print*, 'mils deb et fin= ',mil4(1),mil4(nbp4)
                  
!
!     -----------------------------------------------------
!     II) calcul du satellite de reference et du nb de pts
!     -----------------------------------------------------
!
! *** on choisi le satellite qui demarre le plus tard
!     et on repere celui qui finit le plus tot
!
      milmax= max( mil1(1), mil2(1), mil3(1), mil4(1) )
      milmin= min( mil1(nbp1), mil2(nbp2), mil3(nbp3), mil4(nbp4) )
      
      iref=0
      jref=0
!
      if(mil1(1).eq.milmax) iref=1
      if(mil2(1).eq.milmax) iref=2
      if(mil3(1).eq.milmax) iref=3
      if(mil4(1).eq.milmax) iref=4
!
      if(mil1(nbp1).eq.milmin) jref=1
      if(mil2(nbp2).eq.milmin) jref=2
      if(mil3(nbp3).eq.milmin) jref=3
      if(mil4(nbp4).eq.milmin) jref=4
!
      print*
      print*, 'mil_1  =',mil1(1)
      print*, 'mil_2  =',mil2(1)
      print*, 'mil_3  =',mil3(1)
      print*, 'mil_4  =',mil4(1)
      print*
      print*, 'milN1  =',mil1(nbp1)
      print*, 'milN2  =',mil2(nbp2)
      print*, 'milN3  =',mil3(nbp3)
      print*, 'milN4  =',mil4(nbp4)
      print*
      print*, 'milmax=',milmax
      print*, 'milmin=',milmin
      print*
      print*, 'satellite de reference pour le temps: ',iref
      print*, 'satellite se terminant le plus tot  : ',jref
!
! *** on prend comme nombre de points de depart le plus petit des 4 echantillons
!
      nbpmin= min(nbp1,nbp2,nbp3,nbp4)
      nbpint=0
      
      allocate(milr(nbpmin))   

!     -------------------------------------------------------------------
!     III) calcul du temps de reference et calcul du nb de pts a prendre
!     -------------------------------------------------------------------
!
      do i=1,nbpmin
         if(iref.eq.1) then
            milr(i)=mil1(i)
            dt=dt1
         endif
         
         if(iref.eq.2) then
            milr(i)=mil2(i)
            dt=dt2
         endif
         
         if(iref.eq.3) then
            milr(i)=mil3(i)
            dt=dt3
         endif
         
         if(iref.eq.4) then
            milr(i)=mil4(i)
            dt=dt4
         endif
!
         if(milr(i).le.milmin) nbpint=i
      enddo
!
      print*
      print*, 'nb de pts testes pour les dates : ',nbpmin
      print*, 'nbp pris pour l''interpollation : ',nbpint
!
!     ------------------------------------------------------------------
!     IV)  interpollation des vecteurs avec le temps du sat de reference
!     ------------------------------------------------------------------
!
      mdtma=int(1.5*dt*1000.)
!
      print*
      print*, 'interpollation des 4 satellites sur ',nbpint, ' points'
      print*, 'dtmax admis recommande= ',mdtma, ' millisec.'
!
      print*
      print 100, '1: T1,T2=',datiso1(1),datiso1(nbp1),mil1(1),mil1(nbp1)
      print 100, '2: T2,T2=',datiso2(1),datiso2(nbp2),mil2(1),mil2(nbp2)
      print 100, '3: T3,T2=',datiso3(1),datiso3(nbp3),mil3(1),mil3(nbp3)
      print 100, '4: T4,T2=',datiso4(1),datiso4(nbp4),mil4(1),mil4(nbp4)
      
  100 format(a,2a28,2i9)
!
      print*
      print*, 'dt1= ',dt1
      print*, 'dt2= ',dt2
      print*, 'dt3= ',dt3
      print*, 'dt4= ',dt4
      
      nbpmax=MAX(nbp1,nbp2,nbp3,nbp4)
      
      allocate(xini(nbpmax))
      allocate(yini(nbpmax))
      allocate(zini(nbpmax))
      
    
      allocate(xali(nbpmax))
      allocate(yali(nbpmax))
      allocate(zali(nbpmax))
      
!
!     on n'interpole pas le satellite de reference

      if(iref.ne.1) then
      print*
      print*, 'interpollation sat 1'
      print*, '--------------------'
!
      print*, 'nbp1, nbpint=',nbp1, nbpint
      call vec_xyz(vectim1,xini,yini,zini,nbp1)
      call interpo(xini,mil1,nbp1,xali,milr,nbpint,mdtma,ianox1,fill_val)
      call interpo(yini,mil1,nbp1,yali,milr,nbpint,mdtma,ianoy1,fill_val)
      call interpo(zini,mil1,nbp1,zali,milr,nbpint,mdtma,ianoz1,fill_val)
      call xyz_vec(xali,yali,zali,vectim1,nbpint)
!
      print*, '                     ano xyz=',ianox1,ianoy1,ianoz1
      endif
!
      if(iref.ne.2) then
      print*
      print*, 'interpollation sat 2'
      print*, '--------------------'
!
      print*, 'nbp2, nbpint=',nbp2, nbpint
      call vec_xyz(vectim2,xini,yini,zini,nbp2)
      call interpo(xini,mil2,nbp2,xali,milr,nbpint,mdtma,ianox2,fill_val)
      call interpo(yini,mil2,nbp2,yali,milr,nbpint,mdtma,ianoy2,fill_val)
      call interpo(zini,mil2,nbp2,zali,milr,nbpint,mdtma,ianoz2,fill_val)
      call xyz_vec(xali,yali,zali,vectim2,nbpint)
!
      print*, '                     ano xyz=',ianox2,ianoy2,ianoz2
      endif
!
      if(iref.ne.3) then
      print*
      print*, 'interpollation sat 3'
      print*, '--------------------'
!
      print*, 'nbp3, nbpint=',nbp3, nbpint
      call vec_xyz(vectim3,xini,yini,zini,nbp3)
      call interpo(xini,mil3,nbp3,xali,milr,nbpint,mdtma,ianox3,fill_val)
      call interpo(yini,mil3,nbp3,yali,milr,nbpint,mdtma,ianoy3,fill_val)
      call interpo(zini,mil3,nbp3,zali,milr,nbpint,mdtma,ianoz3,fill_val)
      call xyz_vec(xali,yali,zali,vectim3,nbpint)
!
      print*, '                     ano xyz=',ianox3,ianoy3,ianoz3
      endif
      
!
      if(iref.ne.4) then
      print*
      print*, 'interpollation sat 4'
      print*, '--------------------'
!
      print*, 'nbp4, nbpint=',nbp4, nbpint
      call vec_xyz(vectim4,xini,yini,zini,nbp4)
      call interpo(xini,mil4,nbp4,xali,milr,nbpint,mdtma,ianox4,fill_val)
      call interpo(yini,mil4,nbp4,yali,milr,nbpint,mdtma,ianoy4,fill_val)
      call interpo(zini,mil4,nbp4,zali,milr,nbpint,mdtma,ianoz4,fill_val)
      call xyz_vec(xali,yali,zali,vectim4,nbpint)
!
      print*, '                     ano xyz=',ianox4,ianoy4,ianoz4
      endif
      
!     ------------------------------------------------------------------
      
      deallocate(milr)
      deallocate(mil1)
      deallocate(mil2)
      deallocate(mil3)
      deallocate(mil4)
            
      deallocate(xini)
      deallocate(yini)
      deallocate(zini)
    
      deallocate(xali)
      deallocate(yali)
      deallocate(zali)    
        
!     ------------------------------------------------------------------

! *** print des anomalies eventuelles
!
      print*
      print*, 'matrice des anomalies:'
      print*
      print*, 'interpo sat 1: ano xyz=',ianox1,ianoy1,ianoz1
      print*, 'interpo sat 2: ano xyz=',ianox2,ianoy2,ianoz2
      print*, 'interpo sat 3: ano xyz=',ianox3,ianoy3,ianoz3
      print*, 'interpo sat 4: ano xyz=',ianox4,ianoy4,ianoz4
!
! *** on n'ecrit pas les fichiers si anomalies

!      if(ianox1.ne.0.or.ianoy1.ne.0.or.ianoz1.ne.0.or. &
!           ianox2.ne.0.or.ianoy2.ne.0.or.ianoz2.ne.0.or. &
!           ianox3.ne.0.or.ianoy3.ne.0.or.ianoz3.ne.0.or. &
!           ianox4.ne.0.or.ianoy4.ne.0.or.ianoz4.ne.0) then
!         print*, '*** anomalies, pas de creation de fichiers alignes'
!         stop 'alitime_data_4sat:     *** ABORTED ! ANOMALIES IN ALIGNMENT'
!      endif

      return
      end  
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine get_interpol_value(datiso,datiso_arr,vectim_arr,nbloc,j1,val_xyz,k1,k2,ierr)
      
      
      character*(*) datiso, datiso_arr(nbloc)
      real vectim_arr(3,nbloc),val_xyz(3)

!----------------------------------------------------------------------!
! *   Object : donne la valeur interpolee de vectim_arr au temps datiso
! *   Author : P. Robert, ScientiDev, Janvier 2021
!----------------------------------------------------------------------!
      
!     on cherche les deux points dans datiso5 qui encadre la date datiso  
 
      k1=0
      k2=0
      ierr=0

      IF(j1 .lt. 1) THEN
         write(*,*) '*** warning get_interpol_value : j1 =',j1
         write(*,*) '    J1 set to 1'
         J1=1
      ENDIF

      DO j=j1,nbloc-1
            
         call compare_datiso(datiso,datiso_arr(j),  icomp1)
         call compare_datiso(datiso,datiso_arr(j+1),icomp2)   
      
         IF(icomp2 .ge. 0 .and. icomp1 .le. 0) THEN   
           k1=j
           k2=j+1
           EXIT
         ENDIF
      ENDDO
      
      IF(k1 .eq.0  .or. k2.eq.0) THEN
         write(*,*) '*** warning get_interpol_value : k1 or k2=0'
         write(*,*) '    values set to 0.'
         val_xyz(1)=0.
         val_xyz(2)=0.
         val_xyz(3)=0.
         ierr=1
         RETURN
      ENDIF
     
      call decode_datiso(datiso,iyear,imon,iday,ih,im,is,ims,imc)
      call codecsec(0,ih,im,is,ims,imc, decsec0)
     
      call decode_datiso(datiso_arr(k1),iyear,imon,iday,ih,im,is,ims,imc)
      call codecsec(0,ih,im,is,ims,imc, decsec1)
     
      call decode_datiso(datiso_arr(k2),iyear,imon,iday,ih,im,is,ims,imc)
      call codecsec(0,ih,im,is,ims,imc, decsec2)

!     interpolation

      fac=(decsec0-decsec1)/(decsec2-decsec1)
     
      val_xyz(1)= vectim_arr(1,k1) +(vectim_arr(1,k2) -vectim_arr(1,k1))*fac
      val_xyz(2)= vectim_arr(2,k1) +(vectim_arr(2,k2) -vectim_arr(2,k1))*fac
      val_xyz(3)= vectim_arr(3,k1) +(vectim_arr(3,k2) -vectim_arr(3,k1))*fac

     return
     end
      
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine interpo(tab1,mils1,n1,tab2,mils2,n2,mdtmax,iano,fill_val)
!
      real tab1(n1), tab2(n2)
      integer mils1(n1), mils2(n2)

!----------------------------------------------------------------------!
! *   Object : interpollation de tab1, resultat dans tab2
! *   Author : P. Robert, October 2001
!----------------------------------------------------------------------!
!     ---------------------------------------------------------------+--
!     interpollation de tab1, resultat dans tab2
!
!     mils1: temps a interpoler avec les donnees de tab1
!     mils2: temps de reference pour l'interpollation
!
!     on cherche les 2 points dans mils1 qui encadre chaque point
!     de mils2, puis on interpolle la valeur de tab1 au temps de mils2
!     et on met le resultat dans tab2.
!     dtmax: intervalle de temps au dela duquel l'interpollation
!     est impossible.
!
!     input : tab1,mils1,n1,mils2,n2,mdtmax
!     output: tab2, iano
!
!     P. Robert, October 2001
!     ---------------------------------------------------------------+--
!
      iano=0

!
! *** test sur n1 et n2
!
      if(n1.le.1) then
              print*, '***lib_alitime/interpo: interpollation impossible'
              print*, '   n1=',n1
              iano=1
              return
                  endif
!
      if(n2.le.1) then
              print*, '***lib_alitime/interpo: interpollation impossible'
              print*, '   n2=',n2
              iano=2
              return
                  endif
!
! *** mise a zero de tab2
!
      do i=1,n2
      tab2(i)=0.
      enddo
!
! *** grande boucle sur le temps de reference  mils2 du tableau 2
!     mils2 est le temps de reference impose pour le calcul de tab2
!
      do 10 i=1,n2
      mti=mils2(i) 
!
! *** recherche dans le temps de tab1 des 2 points encadrant le temps
!     de tab2
!
      do 20 j=2,n1
      mtj=mils1(j)
      if(mtj.ge.mti) then
                     j2=j
                     j1=j-1
                     go to 30
                     endif
   20 continue
!
      print*, '***lib_alitime/interpo: interpollation impossible'
      print*, '   for i= ',i, ' in tab2, time ',mti,' is out of time ' &
                  //'range of tab1: ',mils1(1),' - ',mils1(n1)
!
      call comildayinv(mti,ihi,imi,isi,imsi)
      call comildayinv(mils1(1), ih1,im1,is1,ims1)
      call comildayinv(mils1(n1),ih2,im2,is2,ims2)
!
      print*, 'time ',ihi,imi,isi,imsi, ' is out of interval :'
      print*, '     ',ih1,im1,is1,ims1,' - ',ih2,im2,is2,ims2
!
      iano=3
      print*, '   anomalie ',iano, ' bornes temps1 mal adaptees au temps2', &
              '   valeur interpollee mise a ',fill_val
      print*
      tab2(i)=fill_val
!
! *** interpolation entre j1 et j2 de tab1 pour le temps mti
!
   30 continue

      mtj1=mils1(j1)
      mtj2=mils1(j2)
!
! *** test si interpollation valide
!
      if((mti.gt.mtj2).or.(mti.lt.mtj1)) then
              print*, '***lib_alitime/interpo: interpollation impossible'
              print 100, '    for i= ',i, ' in tab2, msotd=',mti, &
                      ' is out of time range ', mtj1,' - ',mtj2
!
              call comildayinv(mti,ihi,imi,isi,imsi)
              call comildayinv(mtj1,ih1,im1,is1,ims1)
              call comildayinv(mtj2,ih2,im2,is2,ims2)
!
              print*, 'time ',ihi,imi,isi,imsi, 'is out of interval :'
              print*, '     ',ih1,im1,is1,ims1,' - ',ih2,im2,is2,ims2
!
              iano=4
              print*, '   anomalie ',iano, ' mauvais cadre pour temps1', &
                      '   valeur interpollee mise a ',fill_val
              print*
              tab2(i)=fill_val
                                         endif
!
      mdtj=mtj2-mtj1
      mdti=mti-mtj1
!
      if(mdtj.gt.mdtmax) then
              print*, '***lib_alitime/interpo: interpollation impossible'
              call comildayinv(mti,ihi,imi,isi,imsi)
              print 110, '    for i= ',i, ' in tab2, msotd=',mti, &
                      ' time ',ihi,imi,isi,imsi
              print 120, '    delta T ms=',mdtj,' > ', mdtmax, &
                      ' for n1,n2=',j1,j2
!
              iano=5
              print*, '   anomalie ',iano, ' tolerence trop petite', &
                      '   valeur interpollee mise a ',fill_val
              print*
              tab2(i)=fill_val
                          endif
!
  100 format(a,i7,a,i9,a,i9,a,i9)
  110 format(a,i7,a,i9,a,i2.2,':',i2.2,':',i2.2,'.',i3.3)
  120 format(a,i9,a,i9,a,2i8)
! *** on peu interpoller, on interpolle...
!
      tab2(i)=sngl(dble(tab1(j1)) + (dble(tab1(j2))-dble(tab1(j1)))* &
           dble(mdti)/dble(mdtj))
   10 continue
!
      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX   
!
      subroutine xyz_vec(xini,yini,zini,vecti,nbp)
!
      dimension vecti(3,nbp), xini(nbp),yini(nbp),zini(nbp)
!
      do i=1,nbp
      vecti(1,i)=xini(i)
      vecti(2,i)=yini(i)
      vecti(3,i)=zini(i)
      enddo

      return
      end  
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine vec_xyz(vecti,xini,yini,zini,nbp)
!
      dimension vecti(3,nbp), xini(nbp),yini(nbp),zini(nbp)
!
      do i=1,nbp
      xini(i)=vecti(1,i)
      yini(i)=vecti(2,i)
      zini(i)=vecti(3,i)
      enddo

      return
      end  
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!

!
   
