!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
! |                                                                    |
! |                        Roproc_Wave                                 |
! | Modules pour utiliser la fonction complexe decrivant le gain       |
! | des antennes sous la forme gainant(f,ix,idset,fe) exprimee en V/nT |
! | et dependant de la frequence, de la composante, du satellite et de |
! | la frequence d'echantillonnage.                                    |
! |                                                                    |
! |            P. Robert, CNRS/CETP, Septembre 2000                    |
! |                                                                    |
! |  Modification pour compatibilite avec les donnees sol de la        |
! |  station mobile (conjugaison avec les donnees GEOS)                |
! |                                                                    |
! |      P. Robert, CNRS/CETP, Janvier   2002                          |
! |                         revu   Avril 2002                          |
! |                         revu Janvier 2003 (generalisation)         |
! |                         revu Juillet 2003 (Nbp quelconque)         |
! |                         revu Janvier 2004 (separation nbr/hbr      |
! |                                                                    |
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!
!
      complex function gainant(f,ix,pathfil,fe)
!
!     ------------------------------------------------------------------
! *   Objet  : gain complexe de l'antenne ix de la manip idset
! *   Classe : traitements Roproc_Wave
! *   Auteur : P. Robert, CETP, Sept 2000; mod. Janv. 2002, Janv. 2004
! *   Comment: Le fichier des gains est lu lors du 1er appel
!              Le path du directory est charge par initcal
!     ------------------------------------------------------------------
!
      real*4 freq(3,1000),Preal(3,1000),Pimag(3,1000)
      integer ncal(3)
      character(len=*) :: pathfil
      character(len=255), save :: pathfilp
!
      save icall
      save freq,Preal,Pimag
      save ncal
!
      data icall /0/
      data pathfilp /' '/
!
! *** test redibitoires
!
      if(ix.lt.1.or.ix.gt.3) then
        write(*,*) 'gainant :  *** ABORTED ! BAD IX ***'
        stop 'lib_gainant.o/gainant.exe       : *** ERROR !! Program aborted !'
      endif
!
! *** lecture du fichier de calib
!
      icall=icall +1
      if(icall.eq.1.or.trim(pathfil).ne.trim(pathfilp)) then
                           call r_califile(pathfil, ncal,freq,Preal,Pimag)
                           pathfilp=trim(pathfil)
                           endif
!
! *** seuil minimum et maximum
!
      if(f.lt.freq(ix,1)) then
                          gainant= cmplx(Preal(ix,1),Pimag(ix,1))
                          return
                          endif
!
      if(f.gt.freq(ix,ncal(ix))) then
               gainant= cmplx(Preal(ix,ncal(ix)),Pimag(ix,ncal(ix)))
               return
               endif
!
! *** test de coherence entre fe et la gamme de frequence
!
      if(f.gt.fe/2.) then
        write(*,*) 'gainant : *** ABORTED ! F > FE/2 ***'
        stop 'lib_gainant.o/gainant.exe       : *** ERROR !! Program aborted !'
      endif
!
      fmacal=freq(ix,ncal(ix))
!
! *** interpollation sur la table des frequences
!
      if( fe.gt.2.*fmacal) then
                           print*,'***/ FE=',fe
                           print*,'***/ FMAX IN TABLE =',fmacal
                           print*, '    impossible !'
                           print*, 'premature termination'
        write(*,*) 'gainant : *** ABORTED ! FE > FMAX CAL ***'
        stop 'lib_gainant.o/gainant.exe       : *** ERROR !! Program aborted !'
                           endif
!
! *   recherche de la frequence dans la table juste au dessus de f
!
      do 10 i=1,ncal(ix)
      if(freq(ix,i).gt.f) go to 20
   10 continue
      write(*,*) 'gainant : *** ABORTED ! FREQ. NOT FOUND IN CALIFILE***'
      stop 'lib_gainant.o/gainant.exe       : *** ERROR !! Program aborted !'
   20 continue
!
! *   interpollation avec la valeur precedente
!
      f1=freq(ix,i-1)
      f2=freq(ix,i)
      df= f2-f1
!
! jah, probleme de precision f77/solaris avec ifort/linux et g77/Mingw
! jah, passage en double precision
! jah,      dgr= Preal(ix,i) -Preal(ix,i-1)
! jah,      dgi= Pimag(ix,i) -Pimag(ix,i-1)
      dgr= sngl(dble(Preal(ix,i)) -dble(Preal(ix,i-1)))
      dgi= sngl(dble(Pimag(ix,i)) -dble(Pimag(ix,i-1)))
!
! jah, probleme de precision f77/solaris avec ifort/linux et g77/Mingw
! jah, passage en double precision
! jah,      gr= Preal(ix,i-1) + dgr*(f-f1)/df
! jah,      gi= Pimag(ix,i-1) + dgi*(f-f1)/df
      gr= sngl(dble(Preal(ix,i-1)) + dble(dgr*(f-f1))/dble(df))
      gi= sngl(dble(Pimag(ix,i-1)) + dble(dgi)*(dble(f)-dble(f1))/ &
           dble(df))
!
      gainant= cmplx(gr,gi)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine initcal(ifcod,dirfic)
!
!     ------------------------------------------------------------------
! *   Objet  : initialisation du file code et du directory des f.calib
! *   Classe : traitements Roproc_Wave
! *   Auteur : P. Robert, CETP, Sept 2000
!     ------------------------------------------------------------------
!
      character*(*)  dirfic
      character*255  dircal

      common /pathcal_num/ ifcal
!
!
! *** test sur la longueur du nom du fichier
!
      if(len(dirfic).gt.255) then
                           print*, '***initcal: path too long (max 255)'
      stop 'lib_gainant.o/initcal.exe       : *** ERROR !! Program aborted !'
                           endif
!
! *** chargement du common
!
      ifcal= ifcod
      dircal=dirfic
!
!
      print*, ('-',i=1,72)
      print*, 'initcal:'
      print*, TRIM(dircal)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine r_califile(pathfil,ncal,freq,Preal,Pimag)
!
!     ------------------------------------------------------------------
! *   Objet  : lecture du fichier des gains complexes
! *   Classe : traitements Roproc_Wave
! *   Auteur : P. Robert, CETP, Sept 2000
!     ------------------------------------------------------------------
!
      dimension freq(3,1000),Preal(3,1000),Pimag(3,1000),ncal(3)
!
      character*72 ligne
      character(len=*) :: pathfil
!
      common /pathcal_num/ ifcal
!
      do 5 ic=1,3
!
      do i=1,1000
      freq(ic,i)=0.
      Preal(ic,i)=0.
      Pimag(ic,i)=0.
      enddo
!
   5  continue
!
! *** ouverture du fichier de calibration
!
!
      print*, ('-',i=1,72)
      print*, 'gainant:'
      print*, 'file to open :'
      print*,TRIM(pathfil)
!
      close(ifcal)
      open( ifcal,file=trim(pathfil), status='old',action='read', err=40)
!
! *** saut du header
!
      read(ifcal,100) ligne
      print*
      print*, ligne
!
      do 10 i=1,18
      read(ifcal,100) ligne
   10 continue
!
! *   on est positionne juste avant le premier "# This is the ..."
!
      ic=0
!
! *** lecture des 3 composantes
!
      read(ifcal,100) ligne
      if(ligne(1:10).ne.'# This is ') then
                           print*,'*** r_califile: bad file structure'
                           print*,'***/ THE LINE',ligne
                           print*,'***/ SHOULD BE: ''# This is the...'''
                           close(ifcal)
        stop 'lib_gainant.o/r_califile.exe    : *** ERROR !! Program aborted !'
                            endif
!
   20 continue
!
      print*, ligne
!
      read(ifcal,100,end=50) ligne
      print*, ligne
      read(ifcal,100,end=50) ligne
      print*, ligne
!
      ic= ic+1
      ncal(ic)=0
   30 continue
!
      read(ifcal,100,end=50) ligne
!
      if(ligne(1:3).eq.'END') then
                              print*, ligne
                              print*, 'Nx,Ny,Nz=',(ncal(k),k=1,ic)
                              close(ifcal)
                              return
                              endif
      if(ligne(1:10).ne.'# This is ') then
                 ncal(ic)=ncal(ic)+1
                 i=ncal(ic)
      read(ligne,*,end=50) freq(ic,i),Preal(ic,i),Pimag(ic,i)
                 go to 30
                                      else
                                      go to 20
                                      endif
   50 continue
!
      print*, '*** r_califile: abnormal end of file'
      print*,'***/ LAST LINE SHOULD BE: ''END'''
      print*,'***/ BUT LAST LINE IS: ',ligne
      stop 'lib_gainant.o/r_califile.exe    : *** ERROR !! Program aborted !'
!
   40 continue
!
      print*, '*** gainantlib/r_califile: No calibration file'
      print 100, trim(pathfil)
      print*, '*** job aborted !'
      print*,'***/ THE FOLLOWING PATH MAY BE WRONG:'
      print 100, trim(pathfil)
      stop 'lib_gainant.o/r_califile.exe    : *** ERROR !! Program aborted !'
!
  100 format(2a)
!
      end

!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
