
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine co_plane_wave_xy(a,b,f,dt,n,akdotr,bx,by,bz)

!     ------------------------------------------------------------------
! *   Object : computation of a single plane elliptic-polarized waves
! *   Author : P. Robert, CETP,  May 1998
!     ------------------------------------------------------------------
!     ----------------------------------------------------------------+-
! *   computation of a single plane elliptic-polarized waves
!     in the xy plane (K=z)
!     major axis is in X direction
!     minor axis is in Y direction

!     a,b : nT
!     f   : Hz
!     dt  : sec.

!     P. Robert, CETP, May 1998
!     ----------------------------------------------------------------+-

      real bx(n),by(n),bz(n)


      pi=3.1415927


! *** time loop

      do  i=1,n

         omegat=2.*pi*f*(i-1)*dt

         phi= omegat - akdotr

! ***    computation of the wawe in the K system

         bx(i)= a*cos(phi)
         by(i)= b*sin(phi)
         bz(i)= 0.

      enddo

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine co_plane_wave(akx,aky,akz,a,b,f,dt,n,akdotr,bx,by,bz)

!     ------------------------------------------------------------------
! *   Object : computation of a single plane elliptic-polarized waves
! *   Author : P. Robert, CETP,  May 1998
!     ------------------------------------------------------------------
!     ----------------------------------------------------------------+-
! *   computation of a single plane elliptic-polarized waves
!     in a coordinate system where K vector is defined.

!     K   : m-1
!     a,b : nT
!     f   : Hz
!     dt  : sec.

!     P. Robert, CETP, May 1998
!     ----------------------------------------------------------------+-

      real bx(n),by(n),bz(n)


      pi=3.1415927


! *** time loop

      do i=1,n

         omegat=2.*pi*f*(i-1)*dt

         phi= omegat - akdotr

! ***    computation of the wawe in the K system

         xs= a*cos(phi)
         ys= b*sin(phi)
         zs= 0.

! ***    computation of the wawe in the initial system

         call ret_B0_coord(xs,ys,zs,akx,aky,akz,bx(i),by(i),bz(i))

      enddo

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine co_plane_wave_fv(akx,aky,akz,a,b,f1,f2,dtvf,n,dt,akdr,bx,by,bz)

!     ------------------------------------------------------------------
! *   Object : computation of a single plane elliptic-polarized waves
! *   Author : P. Robert, CETP, May 1998 -Rev.2021
!     ------------------------------------------------------------------
!     ----------------------------------------------------------------+-
! *   computation of a single plane elliptic-polarized waves
!     in a coordinate system where K vector is defined.
!     The frequency is variing between f1 and f2.

!     K     : m-1
!     a,b   : nT
!     f1,f2 : Hz
!     dt    : sec.

!     P. Robert, CETP, May 1998 -Rev.
!     ----------------------------------------------------------------+-

      real bx(n),by(n),bz(n)


      pi=3.1415927
      nvdt=int(dtvf/dt) ! nb pts to go from f1 to f2
      nseq=n/nvdt       ! nb of sequences of nvdt pts

      fmax=0.5/dt

! *** time loop

      do i=1,n

! *      linear frequency variation
! *      0.5 factor is required since f is defined as dphi(t)/dt,
! *      and phi(t) contains (i-1)**2, i.e. t**2
        
         iseq= 2*i/nvdt 
         k= i -iseq*nvdt

         vdf= 0.5*float(k-1)*(f2-f1)/float(nvdt-1)
         f=f1+vdf

! *      freal=f1+2.*vdf car f=1(1/2pi)*domega/dt  

         omegat=2.*pi*f*(i-1)*dt

         phi= omegat - akdr

! ***    computation of the wawe in the K system

         xs= a*cos(phi)
         ys= b*sin(phi)
         zs= 0.

! ***    computation of the wawe in the initial system

         call ret_B0_coord(xs,ys,zs,akx,aky,akz,bx(i),by(i),bz(i))

      enddo

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine co_B0_coord(x,y,z,b0x,b0y,b0z,xs,ys,zs)

!     ------------------------------------------------------------------
! *   Object : compute  x,y,z in Bo coordinate system where Z'=Bo
! *   Author : P. Robert, CETP, May 1998
!     ------------------------------------------------------------------

      b0 = sqrt(b0x**2 + b0y**2 + b0z**2)
      b0p= sqrt(b0x**2 + b0y**2)

! *** angles polaires de b0

      cotet= b0z/b0
      sitet= b0p/b0

      if(abs(b0p).gt.1.e-30) then
                             cophi= b0x/b0p
                             siphi= b0y/b0p
                             else
                             cophi=1.
                             siphi=0.
      endif

! *** rotation autour de Z (xp=Bperp)

      xp=  x*cophi + y*siphi
      yp= -x*siphi + y*cophi
      zp=  z

! *** rotation autour de yp (zs=B0)

      xs= -zp*sitet + xp*cotet
      ys=  yp
      zs=  zp*cotet + xp*sitet

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine ret_B0_coord(xs,ys,zs,b0x,b0y,b0z,x,y,z)

!     ------------------------------------------------------------------
! *   Object : retrieve x,y,z from Bo coordinate system where Z'=Bo
! *   Author : P. Robert, CETP, May 1998
!     ------------------------------------------------------------------

      b0 = sqrt(b0x**2 + b0y**2 + b0z**2)
      b0p= sqrt(b0x**2 + b0y**2)

      cotet= b0z/b0
      sitet= b0p/b0

      if(abs(b0p).gt.1.e-30) then
                             cophi= b0x/b0p
                             siphi= b0y/b0p
                             else
                             cophi=1.
                             siphi=0.
      endif

      xp=  zs*sitet + xs*cotet
      yp=  ys
      zp=  zs*cotet - xs*sitet

      x=  xp*cophi - yp*siphi
      y=  xp*siphi + yp*cophi
      z=  zp

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine rot_xy_B0(x,y,z,b0x,b0y,b0z,xs,ys,zs)

!     ------------------------------------------------------------------
! *   Object : make a rotation in the XY plane of the elliptical wave
! *   Author : P. Robert, CETP, May 1998
!     ------------------------------------------------------------------

! *** make a rotation in the XY plane of the elliptical wave
!     to obtain a particular polarisation when using ret_B0_coord
!     (utility for simkvar program)
!     ----------------------------------------------------------------+-


      b0 = sqrt(b0x**2 + b0y**2 + b0z**2)
      b0p= sqrt(b0x**2 + b0y**2)

! *** angles polaires de b0

      cotet= b0z/b0
      sitet= b0p/b0

      if(abs(b0p).gt.1.e-30) then
                             cophi= b0x/b0p
                             siphi= b0y/b0p
                             else
                             cophi=1.
                             siphi=0.
      endif

! *** rotation autour de Z (xp=Bperp) dans le sens contraire
!     a la premiere rotation de ret_B0_coord

      xs=  x*cophi - y*siphi
      ys=  x*siphi + y*cophi
      zs=  z

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


