!
! |XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX|
! |                                                                    |
! |                      utilitylib                                    |
! |                                                                    |
! |        bibliotheque de modules utilitaires                         |
! |                                                                    |
! |  Bibliotheque constitue de la recuperation de certains modules     |
! |  pratiques extraits de la geoscalclib, developpe pour  les         |
! |  satellite GEOS-1 et GEOS-2, de 1977 a 1984.                       |
! |  Les modules de calendrier sont extraits de la Rocotlib.           |
! |                                                                    |
! |            P. Robert, CNRS/CETP, Septembre 2000                    |
! |                       revu Janvier   2001                          |
! |                       revu Octobre   2002                          |
! |                       revu Fevrier   2002                          |
! |                       revu Fevrier   2007 (+ portable)             |
! |                       revu Mai       2011 (reduction/optimisation) |
! |                                                                    |
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine basename(path,dir,nd,name,nf)
!
!     ------------------------------------------------------------------
! *   Objet  : calcul le nom d'un fichier/directory a partir du path
! *   Classe : depouillement specifique Roproc_Vector
! *   Auteur : P. Robert, CETP, 2002
!     ------------------------------------------------------------------
!
      character*(*) path,dir,name
      character*255 ligne
!
!                    *********************
!
      ligne=path

      np=len_trim(path)

! *** recherche du dernier "/"

      do 10 i=1,np
      ns=index(ligne,"/")
      ligne=ligne(ns+1:np)
   10 continue

! *** calcul du dir et du nom de base du fichier

      name=ligne
      nf=len_trim(name)

      dir=path(1:np-nf-1)
      nd=len_trim(dir)

      IF(np.NE.nd+1+nf) PRINT*, '!!!, np,nd,nf=',np,nd,nf

      RETURN
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cbestfor(x,format)
!
!     ---------------------------------------------------------------+--
! *   Objet  : compute_best_format as '(f3.1)' for x=2.5
! *   Classe : Utilitaires
! *   Auteur : P. Robert, CETP, 1995, 2003
!     ---------------------------------------------------------------+--
!
      character*(*) format
      character*1 ia
      character mot*15

      data epsi /1.e-36/
!
!     calcul du format optimum d'un nombre donne x
!
      ll=len(format)
      if(ll.lt.8) then
                  print*,'***/ VARIABLE FORMAT LENGTH IS:',ll
                  print*,'***/ BUT SHOULD BE 8 OR MORE'
                  print*, '             premature ending'
      write(*,*) 'CBESTFOR : *** ABORTED ! FORMAT < 8 CHARACTERS ***'
      stop 'lib_utility.o / cbestfor           : *** ERROR !! Program aborted !'
!' pour respecter la coloration syntaxique de vi
                  endif

      xx=abs(x)

      if(xx.lt.epsi) then
                     format='(f2.0)'
                     return
                     endif
!
! *** compute mantisse and exponent
!
      ie=int(alog10(xx))+1

      die=10.**ie
      rma=xx/die

      if(rma.lt.0.1) then
                     rma=rma*10.
                     ie=ie-1
                     endif

      if(rma.ge.1.) then
                    rma=rma/10.
                    ie=ie+1
                    endif
!
! *** compute significant digits for a real number
!
      write(mot,100) rma

      do 10 i=1,6
      nosd=7-i
      ii=10-i
      if(mot(ii:ii).ne.'0') go to 20
   10 continue
   20 continue

! *** compute best format
!     format f: fn1.n2 avec chiffre np.n2

      if(xx.lt.1.) then
                   n1=nosd+2+abs(ie)
                   lim=9
                   else
                   n1=max(nosd+1,ie+1)
                   lim=8
                   endif

      if(n1.gt.lim) then
                    ia='e'
                    n2=nosd
                    n1=n2+6
                    else
                    ia='f'
                    if(xx.lt.1.) then
                                 n2=nosd+abs(ie)
                                 else
                                 n2=n1-ie-1
                                 endif
                    endif

      if(x.lt.0.) n1=n1+1

      if(n1.lt.10) then
                   write(format,101) ia,n1,n2
                   else
                   write(format,102) ia,n1,n2
                   endif

  100 format(f9.6)
  101 format('(',a1,i1,'.',i1,')')
  102 format('(',a1,i2,'.',i1,')')

      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cbestfori(ix,format)

!     ---------------------------------------------------------------+--
! *   Objet  : compute_best_format_integer as '(i3)' for ix=124
! *   Classe : Utilitaires
! *   Auteur : P. Robert, CETP, 1995, 2003
!     ---------------------------------------------------------------+--
!
!
      character*(*) format
!
!     calcul du format optimum d'un nombre entier donne ix
!

      ll=len(format)
      if(ll.lt.8) then
                  print*,'***/ VARIABLE FORMAT LENGTH IS:',ll
                  print*,'***/ BUT SHOULD BE 8 OR MORE'
                  print*, '             premature ending'
      write(*,*) 'CBESTFORI : *** ABORTED ! FORMAT < 8 CHARACTERS ***'
      stop 'lib_utility.o / cbestfori          : *** ERROR !! Program aborted !'
!' pour respecter la coloration syntaxique de vi
                   endif

      iax=abs(ix)

      if(iax.eq.0) then
                   format='(i1)'
                   return
                   endif

      n1=int(alog10(float(iax))) +1
      if(ix.lt.0) n1=n1+1

      if(n1.lt.10) then
                   write(format,101) n1
                   else
                   write(format,102) n1
                   endif

  101 format('(i',i1,')')
  102 format('(i',i2,')')
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine crandom01(ranval,size)

!     ------------------------------------------------------------------
! *   Objet  : genere une valeur aleatoire entre 0 et size
! *   Classe : depouillement specifique Roproc_Wave
! *   Auteur : P. Robert, CETP, 1994
!     ------------------------------------------------------------------
!
!     utilise la function RANDIM de  P.W.DALY
!     input : size
!     output: ranval between 0. and size
!
      data ii/0/
      save ii

      if(ii.eq.0) then
                  ii=1
                  idum=-1
                  call randgen71(ran,idum)
                  endif
      idum=1

      call randgen71(ran,idum)

      ranval=ran*size

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine randgen71(ranval,idum)

!
!     ------------------------------------------------------------------
! *   Objet  : utilitaire de crandom01
! *   Classe : depouillement specifique Roproc_Wave
! *   Auteur : P.W.DALY, sept.  1994
!     ------------------------------------------------------------------
!
!     Random Number Generators
!     From Numerical Recipes chapter 7.1
!
!     modified P. robert, september 1994
!
!     RANDIM(idum)  -  portable (i.e. machine independent)
!                      no sequential correlations
!                      virtually infinite period
!                      high and low order done separately
!                      BUT is relatively slow
!
!     Routines return a uniform random deviate between 0.0 and 1.0.
!     Set IDUM to any negative value to initialize or reinitialize the
!     sequence.
!     ------------------------------------------------------------------
!
      dimension r(97)
      parameter (m1=259200,ia1=7141,ic1=54773)
      parameter (m2=134456,ia2=8121,ic2=28411)
      parameter (m3=243000,ia3=4561,ic3=51349)

      data iff/0/
      save iff
      save r

      rm1=1./float(m1)
      rm2=1./float(m2)

      if(idum.lt.0.or.iff.eq.0) then
        iff=1
        ix1=mod(ic1-idum,m1)
        ix1=mod(ia1*ix1+ic1,m1)
        ix2=mod(ix1,m2)
        ix1=mod(ia1*ix1+ic1,m1)
        ix3=mod(ix1,m3)

        do j=1,97
          ix1=mod(ia1*ix1+ic1,m1)
          ix2=mod(ia2*ix2+ic2,m2)
          r(j)=(float(ix1)+float(ix2)*rm2)*rm1
        enddo

        idum=1
      endif

      ix1=mod(ia1*ix1+ic1,m1)
      ix2=mod(ia2*ix2+ic2,m2)
      ix3=mod(ia3*ix3+ic3,m3)
      j=1+(97*ix3)/m3

      if(j.gt.97.or.j.lt.1) then
                            write(*,*) '*** randgen71 : j > 97 or < 1'
                            stop 'lib_utility.o / randgen71          : *** ERROR !! Program aborted !'
      endif

      ranval=r(j)
      r(j)=(float(ix1)+float(ix2)*rm2)*rm1

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine int_to_char(ival,cval,nc)
!
!     ------------------------------------------------------------------
! *   Objet  : converti un entier en character, en le cadrant a gauche)
! *   Classe : Procedures Roproc
! *   Auteur : P. Robert, CETP, 2003
!     ------------------------------------------------------------------
!
      character*(*) cval
      character*8 fmt

      if(ival.le.2147483647) fmt='(i10)'
      if(ival.lt.999999999 ) fmt='(i9 )'
      if(ival.lt.99999999  ) fmt='(i8 )'
      if(ival.lt.9999999   ) fmt='(i7 )'
      if(ival.lt.999999    ) fmt='(i6 )'
      if(ival.lt.99999     ) fmt='(i5 )'
      if(ival.lt.9999      ) fmt='(i4 )'
      if(ival.lt.999       ) fmt='(i3 )'
      if(ival.lt.99        ) fmt='(i2 )'
      if(ival.lt.9         ) fmt='(i1 )'

      if(ival.lt.0          ) fmt='(i2 )'
      if(ival.lt.-9         ) fmt='(i3 )'
      if(ival.lt.-99        ) fmt='(i4 )'
      if(ival.lt.-999       ) fmt='(i5 )'
      if(ival.lt.-9999      ) fmt='(i6 )'
      if(ival.lt.-99999     ) fmt='(i7 )'
      if(ival.lt.-999999    ) fmt='(i8 )'
      if(ival.lt.-9999999   ) fmt='(i9 )'
      if(ival.lt.-99999999  ) fmt='(i10)'
      if(ival.lt.-999999999 ) fmt='(i11)'
! jah, constante hors limite
!     if(ival.le.-2147483648) fmt='(i11)'
!
      write(cval,fmt) ival

      nc=len_trim(cval)

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine real_to_string(rx,sx,nc)
!
!     ------------------------------------------------------------------
! *   Objet  : met un reel en string, avec le meilleurs format
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2003
!     ------------------------------------------------------------------
!
      character*(*) sx
      character*8 format

      call cbestfor(rx,format)

      write(sx,format) rx

      nc=len_trim(sx)

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ringbel
!
!     -----------------------------------------------------------------
! *   Objet  : ring bell by printing  '007' octal character
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2000
!     -----------------------------------------------------------------
!
      print *, char(7)

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine upper_case(string,nc)
!
!     -----------------------------------------------------------------
! *   Objet  : met la string en majuscule si elle ne l'est pas
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2000
!     -----------------------------------------------------------------
!

      character*(*) string
!
      do 10 i=1,nc
      ic=ichar(string(i:i))
      if(ic.ge.97.and.ic.le.122) string(i:i)=char(ic-32)
   10 continue

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine lower_case(string,nc)
!
!     -----------------------------------------------------------------
! *   Objet  : met la string en minuscule si elle ne l'est pas
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2000
!     -----------------------------------------------------------------
!
!
      character*(*) string
!
      do 10 i=1,nc
      ic=ichar(string(i:i))
      if(ic.ge.65.and.ic.le.90) string(i:i)=char(ic+32)
   10 continue

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uencfor(format,ifg,n,nd)
!
!     -----------------------------------------------------------------
! *   Objet  : encode un format a partir de ses caracteristiques
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2000
!     -----------------------------------------------------------------
!
      character*(*) format
      character*1 ifg
!
!
      ll=len(format)
      if(ll.lt.8) &
      write(*,*) 'UENCFOR : *** ABORTED ! FORMAT < 8 CHARACTERS ***'
      stop 'lib_utility.o / uencfor            : *** ERROR !! Program aborted !'
!' pour respecter la coloration syntaxique de vi

      if(ifg.ne.'i') go to 10
      if(n.le.9) write(format,1) n
      if(n.ge.10) write(format,2) n
      return

   10 continue
      if(n.gt.9) go to 20
      write(format,3) ifg,n,nd
      return

   20 continue
      if(nd.gt.9) go to 30
      write(format,4) ifg,n,nd
      return

   30 continue
      write(format,5) ifg,n,nd

    1 format('(i',i1,')',4x)
    2 format('(i',i2,')',3x)
    3 format('(',a1,i1,'.',i1,')',2x)
    4 format('(',a1,i2,'.',i1,')',1x)
    5 format('(',a1,i2,'.',i2,')')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine udecfor(format,ifg,n,nd)
!
!     -----------------------------------------------------------------
! *   Objet  : decode un format en fournissant ses caracteristiques
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 2000
!     -----------------------------------------------------------------
!
      character*(*)format,ifg
      character*1 s(8)
      character*8 for8
!
      for8=format(1:8)

      read(for8,1) s
      ifg=s(2)
      if(ifg.ne.'i') go to 10
      nd=0
      if(s(4).eq.')') read(for8,2) n
      if(s(5).eq.')') read(for8,3) n
      return

   10 continue
      if(s(4).ne.'.') go to 20
      read(for8,4) n,nd
      return

   20 continue
      if(s(7).eq.')') read(for8,5) n,nd
      if(s(8).eq.')') read(for8,6) n,nd

    1 format(8a1)
    2 format(2x,i1,5x)
    3 format(2x,i2,4x)
    4 format(2x,i1,1x,i1,3x)
    5 format(2x,i2,1x,i1,2x)
    6 format(2x,i2,1x,i2,1x)

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
