!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program spectro_xyz_to_lrz

!----------------------------------------------------------------------!
! Object: Transform a SP.rff in xyz cartesian to Left Right Z components
! Author: P. Robert , LPP, 2015 Feb 07
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  integer :: i,j,nbspe,nbfreq, ierr1, ifc1,ifc2
  character(len=255) :: file1,file2,credate
  
  complex (kind=4), dimension(:),allocatable :: sx,sy
  complex (kind=4) :: ci

  print*, '------------------------------------------------------------'
  print*, 'spectro_xyz_to_lrz : Transform a SP.rff in xyz cartesian to '
  print*, '                     Left Right Z component'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF xyz spectrogram file to read ? (ex: .../data/toto1.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'RFF lrz spectrogram file to write? (ex: toto2.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  ifc1=1
  ifc2=2
  
! 1) Reading Metadata
!    ================

  write(*,*)
  write(*,*) 'READING METADATA...'
  write(*,*) '----------------'

! reading manda_param & optio_param only

  call rff_R_metadata(ifc1,file1)
 
  write(*,*) 'Done...'
  
  if (manda_param%data_form /= 'Matrix' ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_xyz_to_lrz: DATA_FORM of INPUT FILE IS NOT Matrix***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'spectro_xyz_to_lrz.exe          : *** ERROR !! Program aborted !'
     endif  
  
  if (manda_param%file_class /= 'Spectrogram' ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_xyz_to_lrz: CLASS OF INPUT FILE IS NOT Spectrogram ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'spectro_xyz_to_lrz.exe          : *** ERROR !! Program aborted !'
     endif  
  
  if (manda_param%data_dimension(1) /= 6 ) then 
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_xyz_to_lrz: data dimension OF INPUT FILE IS NOT 6 (3Re & 3Img)***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     stop 'spectro_xyz_to_lrz.exe          : *** ERROR !! Program aborted !'
     endif  
     
 
! Retrieve usefull parameter

  nbspe=manda_param%BLOCK_NUMBER
  nbfreq= manda_param%data_dimension(2)  

 
  write(*,*)
  write(*,*) 'READING CONSTANT DATA...'
  write(*,*) '------------------------'

  call rff_R_const_data(ifc1)
! call rff_W_const_data(6)

  write(*,*) 'Done...'
 
  write(*,*)
  write(*,*) 'READING INDEXED DATA...'
  write(*,*) '-----------------------'

  call rff_R_indexed_data(ifc1)
  call rff_R_tail(ifc1)

  close(ifc1)

  write(*,*) 'Done...'

  write(*,*) 
  write(*,*) 'R_DATA_MATRIX(1,10,1)    =',R_DATA_MATRIX(1,10,1)
  write(*,*) 'R_DATA_MATRIX(2,10,1)    =',R_DATA_MATRIX(2,10,1)
  write(*,*) 
  write(*,*) 'R_DATA_MATRIX(1,10,nbspe)=',R_DATA_MATRIX(1,10,nbspe)
  write(*,*) 'R_DATA_MATRIX(2,10,nbspe)=',R_DATA_MATRIX(2,10,nbspe)
    
 
  write(*,*)
  write(*,*) 'COMPUTING LRZ spectrogram...'
  write(*,*) '----------------------------'

  allocate(sx(nbfreq),stat=ierr1)
  allocate(sy(nbfreq),stat=ierr1)

  ci=CMPLX(0,1.)
  
  do i=1,nbspe
      do j=1,nbfreq

      sx(j)=cmplx(R_DATA_MATRIX(1,j,i), R_DATA_MATRIX(2,j,i))
      sy(j)=cmplx(R_DATA_MATRIX(3,j,i), R_DATA_MATRIX(4,j,i))

      R_DATA_MATRIX(1,j,i)= REAL(conjg(sx(j)) + ci*conjg(sy(j)))/2.
      R_DATA_MATRIX(2,j,i)=AIMAG(conjg(sx(j)) + ci*conjg(sy(j)))/2.

      R_DATA_MATRIX(3,j,i)= REAL(sx(j) + ci*sy(j))/2.
      R_DATA_MATRIX(4,j,i)=AIMAG(sx(j) + ci*sy(j))/2.
      
      enddo
  enddo

  write(*,*)
  write(*,*) 'changing pamameters...'
  
  manda_param%data_representation='LRZ Circular'
  manda_param%data_label='BLr ; BLi ; BRr ; BRi ; BZr ; BZi'

  write(*,*) 'Done...'

! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_spectro_xyz_to_lrz')

! Write RFF file
! --------------

  write(*,*) ('-',i=1,72)
  write(*,*) 'LRZ rff file will be : ',TRIM(file2)

  call rff_W_file(ifc2,file2)

! *** termine

  print*
  print*, ('-',i=1,72)
  print*, 'Termine'
  print*, ('-',i=1,72)

  print*, 'spectro_xyz_to_lrz.exe           : NORMAL TERMINATION'
     stop 'spectro_xyz_to_lrz.exe           : NORMAL TERMINATION'
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
