!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_gse_to_isr2

!----------------------------------------------------------------------!
! Object: convert vectime from GSE to ISR2 (CLUSTER)
! Author: P. Robert , ScientiDev, January 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2
  character(len=27)  :: credate
  integer            :: iyear,imon,iday,ih,im,is,ims,imc
  integer            :: i,nbvec
  real               :: rasn,dec,rad,rx,ry,rz,xgei,ygei,zgei,x,y,z
                                                                        

  print*, '------------------------------------------------------------'
  print*, 'vectime_gse_to_isr2 : read a RFF vectime file'
  print*, 'and change GSE to ISR2 system'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)
!
! *** lecture de la direction de l'axe de spin dans le GEI
!
  print*, 'Right Ascension and Declination in GEI ? (degrees)'
  read *,  rasn,dec
  print*,  rasn,dec

  print*, 'RFF file to create ? (ex: ./toto_gse.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  rad=57.29578
!
  xgei=cos(rasn/rad)*cos(dec/rad)
  ygei=sin(rasn/rad)*cos(dec/rad)
  zgei=sin(dec/rad)
!
  print*
  print*, 'xgei,ygei,zgei=',xgei,ygei,zgei
  
 
! read  RFF file
! --------------
  
! 1 file to read
! 2 file to create with new system

  call rff_R_file(1,file1)

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
      write(*,*) '*** error, RFF file is not a VecTime Class'
      write(*,*) 'manda_param%FILE_CLASS=', manda_param%FILE_CLASS
      write(*,*) '    program aborted'
      stop 'vectime_gse_to_isr2.exe          : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_COORDINATE_SYSTEM/= 'GSE') THEN
      write(*,*) '*** error, RFF file is not in GSE system'
      write(*,*) 'manda_param%DATA_COORDINATE_SYSTEM=', manda_param%DATA_COORDINATE_SYSTEM
      write(*,*) '    program aborted'
      stop 'vectime_gse_to_isr2.exe          : *** ERROR !! Program aborted !'
  ENDIF
                                                                       
! change data to new coordinate system
! ------------------------------------

  nbvec=manda_param%BLOCK_NUMBER

  DO i=1,nbvec
                            
      call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)  
      if(i.lt.10) then 
                  print*,'iyear,imon,iday,ih,im,is=',iyear,imon,iday,ih,im,is                                    
                  print*, 'xyz gse=',R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i)
      endif
      call cp_time_param(iyear,imon,iday,ih,im,is) 
      call tgeigse(xgei,ygei,zgei,rx,ry,rz)
      call tgsesr2(R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i),rx,ry,rz,x,y,z)
      R_data_vector(1,i)=x
      R_data_vector(2,i)=-y
      R_data_vector(3,i)=-z
                                                                     
  ENDDO

  do i=1,10
    print*, 'xyz isr2=',R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i)
  enddo

! new mandatory parameters
! ------------------------

  manda_param%DATA_COORDINATE_SYSTEM='ISR2'
  write(*,*) 'new coordinate system=',manda_param%DATA_COORDINATE_SYSTEM

! create new vectime rff file
! ---------------------------
 
  call gdatiso(credate)
  call rff_update_history(credate,'vectime_gse_to_isr2')
  call rff_W_file(2,file2)

  close(2)

  print*, ('-',i=1,72)

  print*, "vectime_gse_to_isr2.exe          : NORMAL TERMINATION"
     stop "vectime_gse_to_isr2.exe          : NORMAL TERMINATION"

  end


