!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_to_mfav_GEOGRD

!----------------------------------------------------------------------!
! Object: transform a VecTime VTL2 in NWV system into mfav system
! Author: P. Robert , ScientiDev, Oct. 2020, rev. Nov 2021
!----------------------------------------------------------------------!
  use rff_param_def
  use rff_data_def

  implicit none

  integer            :: i,ifc
  integer            :: iyear,imon,iday,ih,im,is,ims,imc,nbloc,ista

  character(len=255) :: VTL2_ULF, VTL2_mfa,com,fullform
  character(len=120) :: credate,repere
  character(len= 27) :: di1ulf,di2ulf
  character(len=3)   :: suff

  real(kind=4)       :: xmfav,ymfav,zmfav, xn,yn,zn
  real(kind=4)       :: bn,bw,bv
  logical            :: pr_out


  print*, '------------------------------------------------------------'
  print*, 'vectime_to_mfav_GEOGRD : transform a VecTime file in NWV '
  print*, '                  system into MFA system'
  print*, '        MFA : Sun direction in (X,Z) plane, Z=B'
  print*, '        MFAV: Earth output vertical  in (X,Z) plane, Z=B '
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF GEOS/SOL/ULF VTL2 file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') VTL2_ULF
  print*, trim(VTL2_ULF)

  print*, 'RFF GEOS/SOL/ULF VTL2 file to write ? (ex: .../data/toto_mfa.rff)'
  read(*,'(a)') VTL2_MFA
  print*, trim(VTL2_MFA)

  i=len(trim(VTL2_MFA))
  suff=VTL2_MFA(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file to write has not .rff suffix'
     stop 'vectime_to_mfav_GEOMAG.exe      : *** ERROR !! Program aborted !'
  ENDIF


!    ==================
! 1) read  ULF RFF file
!    ==================

  print*
  print*, '=================================='
  print*, '2) read  ULF RFF file '
  print*, '=================================='


  ifc=2
  call rff_R_metadata(ifc,VTL2_ULF)

  call rff_R_const_data(ifc)
  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** Only VecTime FILE_CLASS is allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
         write(*,*) '*** Only FLT DATA_TYPE is allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
         write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
         write(*,*) '*** Only Vector DATA_FORM is allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_REPRESENTATION /= 'xyz Cartesian') THEN
         write(*,*) '*** Only Vector DATA_REPRESENTATION is allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  repere=manda_param%DATA_COORDINATE_SYSTEM

  IF(repere /= 'NWV') THEN
         write(*,*) '*** Only NWV DATA_COORDINATE_SYSTEM are allowed'
         stop 'vectime_to_mfav_GEOGRD.exe      : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  nbloc=manda_param%block_number


  di1ulf=data_index(1)(1:23)//'Z'
  di2ulf=data_index(nbloc)(1:23)//'Z'

  write(*,*)
  write(*,*) 'ULF: number of blocks =',nbloc
  write(*,*) 'ULF: data_index(    1)=',di1ulf
  write(*,*) 'ULF: data_index(nbloc)=',di2ulf


! data transformation
! -------------------
  write(*,*)
  write(*,*) 'Vectime transformation '

! Mag field issued of igrf model https://www.ngdc.noaa.gov/IAGA/vmod/igrf.html

! ******************************************************
! *              IGRF SYNTHESIS PROGRAM                *
! *                                                    *
! * A program for the computation of geomagnetic       *
! * field elements from the International Geomagnetic  *
! * Reference Field (13th generation) as revised in    *
! * December 2019 by the IAGA Working Group V-MOD.     *
! *                                                    *
! * It is valid for dates from 1900.0 to 2025.0,       *
! * values up to 2030.0 will be computed but with      *
! * reduced accuracy. Values for dates before 1945.0   *
! * and after 2015.0 are non-definitive, otherwise the *
! * values are definitive.                             *
! *                                                    *
! * Susan Macmillan, William Brown                     *
! *                          British Geological Survey *
! *                           IAGA Working Group V-MOD *
! ******************************************************
  
! position in GEO
  
! HUSAFELL (64.40 N, 20.80 W),Jul  4,1977-Sep 22,1977.
! KITDALEN (69.21 N, 20.18 E),Jan 29,1980-Mar 21,1980 & Jan 31,1981-Mar 28,1981.
! SKIBOTN  (69.35 N, 20.36 E),Jan 15,1982-Mar 07,1982.

! mag field in NEV system (V input)
!----------------------------------------------------------------------------------
!year-mo-da  R   rlat   rlon   B_North     B_Est   B_Vert.     B0      Btet   Bphi
!----------------------------------------------------------------------------------
!1977-07-04  1.  64.40 -20.80  11478.78  -5006.82  50312.38  51847.52  13.98 -23.57
!1977-09-22  1.  64.40 -20.80  11486.21  -4997.99  50314.46  51850.34  13.98 -23.52
!1980-01-29  1.  69.21  20.18  11241.24    644.50  51162.52  52386.88  12.41   3.28
!1981-03-23  1.  69.21  20.18  11216.25    670.57  51172.75  52391.84  12.38   3.42
!1982-01-15  1.  69.35  20.36  11141.93    710.41  51231.02  52433.43  12.29   3.65
!1982-03-07  1.  69.35  20.36  11138.86    713.57  51232.23  52434.00  12.29   3.67
!----------------------------------------------------------------------------------

!data in NWV (North, West, Vert output)

! N  =  H  =  N
! W  = -D  = -E
! Vo =  Vo = -Vi


  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  
  if(iyear==1977) then
    ista=1
    bn= 11480.
    bw=  5000.
    bv=-50313.
  endif
  
  if(iyear==1980 .or. iyear==1981) then
    ista=2
    bn= 11230.
    bw=  -651.
    bv=-51167.    
  endif
  
  if(iyear==1982) then
    ista=3
    bn= 11140.
    bw=  -712.
    bv=-51232.    
  endif


  
  DO i=1,nbloc
  
     if(i<10 .or. i> nbloc-10) then
       pr_out=.true.
              else
       pr_out=.false.
     endif

!    Rocotlib time dependant matrix computation
     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     
     if(iyear==1977) ista=1
     if(iyear==1980 .or. iyear==1981) ista=2
     if(iyear==1982) ista=3

     if(pr_out) print*
     if(pr_out) print*,data_index(i)
     
     xn=R_data_vector(1,i)
     yn=R_data_vector(2,i)
     zn=R_data_vector(3,i)

     call t_nwv_to_mfav(xn,yn,zn,bn,bw,bv,xmfav,ymfav,zmfav)
     
!    data update in mfa

     R_data_vector(1,i)=xmfav
     R_data_vector(2,i)=ymfav
     R_data_vector(3,i)=zmfav

  ENDDO

  manda_param%DATA_COORDINATE_SYSTEM='MFAV'
  manda_param%DATA_DIMENSION(1)     = 3
  manda_param%DATA_FORMAT           = '(E13.6,",",E13.6,",",E13.6)'
  manda_param%BLOCK_FIRST_INDEX=data_index(1)
  manda_param%BLOCK_LAST_INDEX=data_index(nbloc)

  com='Data in MFAV system'

  optio_param%SUB_TITLE=trim(com)


! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_vectime_to_mfav_GEOGRD')

! Write RFF file
! --------------

  ifc=2
  call rff_W_metadata(ifc,VTL2_mfa)
  call rff_W_const_data(ifc)

! ***  call rff_W_indexed_data(ifc)

  IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
        fullform='(a24,3(1x,E14.6))'
     ELSE
        fullform= '('//TRIM(manda_param%INDEX_FORMAT)//',",",'// &
        TRIM(manda_param%INDEX_EXTENSION_FORMAT)//',",",'// &
        TRIM(manda_param%DATA_FORMAT)//')'
  ENDIF

  write(*,*) ' block data format=',trim(fullform)

  write(ifc,'(80a)')  '#',('-',i=1,79)
  write(ifc,'(a)')  'START INDEXED_DATA'

  write(*,*) 'write indexed data, nbloc=',nbloc

  DO i=1,nbloc
     IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
           write(ifc,fullform) data_index(i),R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
        ELSE
           write(ifc,fullform) data_index(i),status(i), &
           R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
     ENDIF
  ENDDO

  call rff_W_tail(ifc)


! *** termine

  print*
  print*, ('-',i=1,72)
  print*, 'Termine'
  print*, ('-',i=1,72)

  print*, 'vectime_to_mfav_GEOGRD.exe       : NORMAL TERMINATION'
     stop 'vectime_to_mfav_GEOGRD.exe       : NORMAL TERMINATION'
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine t_nwv_to_mfav(xnwv,ynwv,znwv,bx,by,bz,xmfav,ymfav,zmfav)

! ----------------------------------------------------------------------
! *   Object : transforms_nwv_to_mfa: NWV -> MFA  system
! *   Author : P. Robert, ScientiDev, 2020
! *   Comment: local system, non time dependent
!        MFA : Sun direction in (X,Z) plane
!        mfav: Earth output vertical  in (X,Z) plane
!
! *   Input  : xnwv,ynwv,nwvz cartesian NWV coordinates
!              bx,  by,  bz   cartesian NWV coordinates of DC mag field
! *   Output : xm,  ym,  zm   cartesian mfa coordinates
! ----------------------------------------------------------------------
!
! **  first rotation

  bperp= sqrt(bx*bx + by*by)
  b0= sqrt(bx*bx + by*by + bz*bz)

  sinphi=by/bperp
  cosphi=bx/bperp

  xp=  cosphi*xnwv + sinphi*ynwv
  yp= -sinphi*xnwv + cosphi*ynwv
  zp=  znwv

! **  second rotation: repere MAG

  sintet= bperp/b0
  costet= bz/b0

  xmag= costet*xp - sintet*zp
  ymag= yp
  zmag= sintet*xp + costet*zp

! **  third rotation: X''' in (X,Z) plane

  bperp= sqrt(xmag**2 + ymag**2)

  sinphi=ymag/bperp
  cosphi=xmag/bperp

  xp=  cosphi*xmag - sinphi*ymag
  yp=  sinphi*xmag + cosphi*ymag
  zp=  zmag

  xmfav=xp
  ymfav=yp
  zmfav=zp


  xmfav=xmag
  ymfav=ymag
  
  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
