!
  program visu_polar
!
! --------------------------------------------------------------------+--
! Lecture d'un fichier copolar.resu et
! Creation du postscript visu_polar.ps
!
! P. Robert, CETP, Juin 2005, revu P. Robert, ScientiDev, Feb. 2021
! --------------------------------------------------------------------+--
!
! *** Declaration pour la lecture standard du fichier copolar.resu

  real(kind=4),     dimension(:,:), allocatable :: spebx,speby,spebz,spebp,spebq,spebr
  integer,          dimension(:,:), allocatable :: image
  character(len=27),dimension(:)  , allocatable :: datiso
  real(kind=4)     ,dimension(:)  , allocatable :: time

  character(len=8)   :: titgra(24),sid,bitr,forgy
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version,labb,tspea(6),tspeb(6)
  character(len=255) :: DataFile,psfile,signat
  character(len=120) :: dati26,mission,experi,titpan,fultit,fnat,form
  character(len=27)  :: datiso1, datiso2
  character(len=80)  :: line

  real(kind=4) :: dt(6),df(6)
  real(kind=4) :: valgra(24)
  real(kind=8) :: ddt


! Initialisation des variables graphiques
!
  data posfx,posfy/ 3.0,18.8/
  data sizfx,sizfy/15., 3.1/
  data decay /0.3/
  data nbgma,nbpma /24,24/
!
! --------------------------------
! lecture des parametres
! --------------------------------

 print*,'Copolar file ? (ex: copolar.resu)'
 read *,DataFile
 print*,DataFile
 
 print*,'datiso1, datiso2 ?'
 read(*,'(a)') line
 i1=index(line,'Z')
 datiso1=line(1:i1)
 i2=index(line(i1+2:80),'Z')
 datiso2=line(i1+2:i2+i1+2)
!print*,'i1,i2=',i1,i2
 print*,datiso1
 print*,datiso2

 print*,'Seuil ? (ex: -4)'
 read *,seuil_visu
 print*,seuil_visu

 print*,'F1, F2 ? (ex: 1. 10.)'
 read *,f1,f2
 print*,f1,f2

 print*,'Pmin, Pmax for power spectrogramme (ex: -7. 1.)'
 read *,puimin, puimax
 print*,puimin, puimax

 print*, '------------------------------------------------------------------------ '

! --------------------------------
! Lecture du fichier copolar.resu
! --------------------------------

  open(1,file=DataFile)

! lecture de l'entete du fichier
!
  call rheacopolar(idset,fultit,mission,experi,sid,isat,fnat,titpan,jul00,iday,imon,iyear, &
                   ih,im,is,ims,nbp,fc,f1f,f2f,nbseq,bitr,fe,Ts,srasc,sdec)

  nbfre=nbp/2
  print*,trim(fultit)
  print*,trim(titpan)
!
! *** alloc des tableaux

  allocate(spebx(nbseq,nbfre))
  allocate(speby(nbseq,nbfre))
  allocate(spebz(nbseq,nbfre))
  allocate(spebp(nbseq,nbfre))
  allocate(spebq(nbseq,nbfre))
  allocate(spebr(nbseq,nbfre))
  allocate(image(nbseq,nbfre))
  allocate(datiso(nbseq))
  allocate(time(nbseq))

! *** lecture des data du fichier

  call rdatcopolar(tspea,tspeb,dt,df,nbseq,nbfre,datiso,spebx,speby,spebz,spebp,spebq,spebr)
!
! fermeture du fichier copolar.resu
!
  close(1)
! ----------------------------------------
! initialisation des parametres graphiques
! ----------------------------------------

  ttit=0.55
  tcom=0.30
  tlab=0.35
  tpar=0.23
  tgra=0.23
  tgrx=0.35
  tcl=0.4
  tcr=0.35
  
  xlab=0.5
  xpar=1.2

  pfy=posfy
  py=posfy
  sy=sizfy

! --------------------------------------------------------------------+--
! ouverture du fichier graphique et mise en page
! --------------------------------------------------------------------+--

  ip=index(DataFile,'.')
  
  psfile=DataFile(1:ip)//'ps'

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)
  call dcolmap_('spectro256')

  write(titleft,'(2a,i1,2a)') trim(mission),'-',isat,' / ',trim(experi)
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)
  call cdattit_(iyear,imon,iday,titright)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  call ppagcha_(0.9,pagsy-2.9,-1,ttit,ttit,0.,'Waves Polarization')
  call ppagcha_(xlab,pagsy-3.6,-1,tcom,tcom,0.,titpan)
  
  form='("N=",i7,"  dt=",f8.4," s df=",f7.4," Hz  F1=",f6.2," F2=",f8.2)'
  write(labb,form) nbseq,dt(1),df(1),f1,f2
  call ppagcha_(xlab,pagsy-4.1,-1,tpar,tpar,0.,labb)
  call ppagtav_(xlab,pagsy-4.6,-1,tpar,tpar,0.,'Threshold=',seuil_visu,'(f5.1)')

! Trace la mire

  call plotpalpol(11.5,pagsy-3.2,6.5,0.8,puimin,puimax,0.2)

 
! ---------------------------------------------------
! calcul des bornes et graduations en temps et en frequence
! ---------------------------------------------------

  print*,'bornes en temps et en frequence'

  call decode_datiso(datiso1,iy,imo,id,ih,im,is,ims,imc)
  t1=float(ih)+float(im)/60. +float(is)/3600.

  call decode_datiso(datiso2,iy,imo,id,ih,im,is,ims,imc)
  t2=float(ih)+float(im)/60. +float(is)/3600.
  
  print*, 't1,t2 (s.)=',t1,t2
  print*, 'f1,f2 (Hz)=',f1,f2

  print*, 'calcul des graduations horaire'
  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'titgra    =',(titgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt

  print*, 'calcul des graduations en frequence'

  call cfiggra_(f1,f2,f1aron,f2aron,bgy,sgy,forgy)

  print*, 'f1,f2,f1aron,bgy,sgy=',f1,f2,f1aron,bgy,sgy
  
  nbseqs=0
  it1=1
  it2=nbseq

! select period

  do i=1,nbseq
     call compare_datiso(datiso1,datiso(i),icomp1)
     call compare_datiso(datiso2,datiso(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbseqs=nbseqs +1
     if(nbseqs == 1) it1=i
     it2=i
  end do

  print*,'nbseq, it1,it2,nbseqs=',nbseq,it1,it2,nbseqs
  print*

  if(nbseqs.lt.2) then
    print*,'nbseq in asked time period <2, program aborted'
    stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  endif

! calcul du temps

  do i=1,nbseq
       call decode_datiso(datiso(i),iy,imo,id,ih,im,is,ims,imc)
       time(i)=float(ih)+float(im)/60. +float(is)/3600.
  enddo

! ---------------------------------------------------
! calcul des seuils pour les 6 images
! ---------------------------------------------------

! passage en log (deviens -8 si egal zero et -10 si negatif)
! log OK si > 1.e-20

  valzer=-21.
  valneg=-22.

  print*,'calcul des seuils'
  
  call cscalog_(spebx(:,:),nbseq,nbfre,valzer,valneg)

  
  pcmin=10.
  pcmax=1.

  call  cscasli_(spebx(:,:),nbseq,nbfre,smix,smax,pcmin,pcmax)
  
  if(abs(puimax-puimin) > 0.1) then
      smix=puimin
      smax=puimax
  endif
                
  
  smiy=0.
  smay=1.
  
  smiz=0.
  smaz=180.
  
  smip=0.
  smap=360.
  
  smiq=0.
  smaq=180.
  
  smir=0.
  smar=360.
  
  swhi= 20.
  sbla=-20.
!
  print*
  print*, 'Seuils min, max pris en compte:'
  print*,smix,smax
  print*,smiy,smay
  print*,smiz,smaz
  print*,smip,smap
  print*,smiq,smaq
  print*,smir,smar

! calcul des indices pour les frequences 

  fmax=float(nbfre)*df(1)
  if(f1.lt.0.) f1=0.
  if(f2.lt.1.e-10) f2=fmax

  if1=int(f1/df(1) +0.5)
  if2=int(f2/df(1) +0.5)+1

  if(if1.lt.1) if1=1
  if(if2.gt.nbfre) if2=nbfre

  print*, 'f1, f2, if1,if2=',f1, f2, if1,if2
  print*, 'fi1,fi2,ip1,ip2=',fi1,fi2,ip1,ip2

  nbfre2= if2-if1+1
  print*
  
! seuil_visu de puissance pour les parametres de polar
  
  where(spebx(:,:) < seuil_visu)
    speby(:,:)=501.
    spebz(:,:)=501.
    spebp(:,:)=501.
    spebq(:,:)=501.
    spebr(:,:)=501.
  end where

! --------------------------------------------------------------------+--
  print*,'plot spectro 1'
! --------------------------------------------------------------------+--

  swhi= 20.
  sbla=-20.
  
  labb='Total Power'
  call ppagcha_(xlab,posfy+sizfy/2,0,tlab,tlab,90.,labb)
  labb='Frequency(Hz)'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  call dlinwid_(2.5)
  call dfontyp_('h')

  call dgrasiz_(0.0,tgra)
  call dstisiz_(0.25,0.13)
  call dstipos_('oi','oo')
  call dlabseny('h')
  call dfiglim_(t1,t2,f1,f2)
 
  
! on trace chaque colonne de 1 px de large au temps t pour gerer les trous de TM  
  ddt   = dble(1./fe)
  pixsiz=  sizfx*real(ddt/dble(t2-t1))
  print*,'t1,t2,sizfx,ddt,pixsiz=',t1,t2,sizfx,ddt,pixsiz

  do i=it1,it2
     call cscaima_(spebx(i,:),1,nbfre,smix,smax,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*

! --------------------------------------------------------------------+--
  print*,'plot spectro 2'
! --------------------------------------------------------------------+--

  swhi= 500.
  
  labb='Exentricity'
  call ppagcha_(xlab,posfy+sizfy/2,0,tlab,tlab,90.,labb)
  labb='[0-1]'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)
  
  do i=it1,it2
     call cscaima_(speby(i,:),1,nbfre,smiy,smay,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*
  
! --------------------------------------------------------------------+--
  print*,'plot spectro 3'
! --------------------------------------------------------------------+--
  labb='K direction'
  call ppagcha_(xlab,posfy,0,tlab,tlab,90.,labb)
  labb='Theta [0 -180]'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)

  do i=it1,it2
     call cscaima_(spebz(i,:),1,nbfre,smiz,smaz,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*
  
! --------------------------------------------------------------------+--
  print*,'plot spectro 4'
! --------------------------------------------------------------------+--
  labb='Phi [0 -360]'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)
  
  do i=it1,it2
     call cscaima_(spebp(i,:),1,nbfre,smip,smap,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*
  
! --------------------------------------------------------------------+--
  print*,'plot spectro 5'
! --------------------------------------------------------------------+--
  labb='Major axis direction'
  call ppagcha_(xlab,posfy,0,tlab,tlab,90.,labb)
  labb='Theta [0 -180]'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)
  
  do i=it1,it2
     call cscaima_(spebq(i,:),1,nbfre,smiq,smaq,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*
  
! --------------------------------------------------------------------+--
  print*,'plot spectro 6'
! --------------------------------------------------------------------+--
  labb='Phi [0 -360]'
  call ppagcha_(xpar,posfy+sizfy/2,0,tpar,tpar,90.,labb)
  
  do i=it1,it2
     call cscaima_(spebr(i,:),1,nbfre,smir,smar,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call dgrasiz_(tgrx,tgra)
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)

! --------------------------------------------------------------------+--

  call ppagcha_(0.8,posfy-0.8,-1,0.4,0.4,0.,'UT')
!
! *** termine
!
  call dclogra_

  print*, 'visu_polar.exe                   : NORMAL TERMINATION'
     stop 'visu_polar.exe                   : NORMAL TERMINATION'
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine spe_plot_ima(posfx,posfy,sizfx,sizfy,spebx,nbseq,nbfre,smi,sma,image,swhi)

  real(kind=4) :: spebx(nbseq,nbfre)
  integer      :: image(nbseq,nbfre)

  sbla=smi -1.

! print*, 'plot image'

  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dstipos_('oo','oo')
  call cscaima_(spebx,nbseq,nbfre,smi,sma,image,sbla,swhi)
  call ppagima_(posfx,posfy,-1,sizfx,sizfy,0.,image,nbseq,nbfre)

  return
  end

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine spe_plot_grad(valgra,titgra,valdt,nbgma,nbpma,t1,t2,f1,f2,tgra)

  character*(*) titgra(24)
  character*8 forgy
  real valgra(24)

  call pfigfra_

! print*,'plot grad'

  call dfiglimx(t1,t2)
  call dgrasizx(tgra)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

  call cfiggra_(f1,f2,f1aron,f2aron,bgy,sgy,forgy)
  call dfiglimy(f1,f2)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)

  return
  end
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine rheacopolar(idset,fultit,projet,experi,sid,isat,fnat,  &
                     titpan,jul00,ijoud,imoid,iand                 &
                    ,ih,im,is,ims,nbp,fc,f1,f2,                    &
                     nbseq,bitr,fe,Ts,srasc,sdec)
!
! --------------------------------------------------------------------+--
! *   Subject  : read header of copolar.resu file
! *   Class    : processing of copolar.resu files type
! *   Author   : P. Robert, CETP
! --------------------------------------------------------------------+--
!
! declarations
!
  character*(*) fultit,projet,experi,fnat
!
  character*78 cbid,tstart,tend,ttrait
  character*(*) titpan
  character*3 bitr ,dfrom,ddcal
  character*5 sid
!
!
  data cbid,tstart,tend,ttrait /4*' '/
!
  dfrom=' '
  ddcal=' '
!
! *** test de la 1ere ligne du fichier
!
  read(1,1) tstart
!
  if(tstart.NE.'START OF FILE HEADER') then
                      print*,'***/ FIRST LINE OF FILE:'
                      print*,tstart
                      print*, ' *** rheacowave'
                      print*, ' File is not a cowave.resu file'
  stop 'RHEACOWAVE     *** ABORTED ! FILE IS NOT A COWAVE.RESU  ***'
                      endif
!
! *** saut des commentaires
!
  do while (cbid.ne.'END COMMENTS')
  read(1,1) cbid
  enddo
!
! *** lecture du reste de l'entete
!
  read(1,1) ttrait
  read(1,1) cbid
  read(1,*) idset
  read(1,1) cbid
  read(1,1) fultit
  read(1,1) cbid
  read(1,1) projet
  read(1,1) cbid
  read(1,1) experi
  read(1,1) cbid
  read(1,1) sid
  read(1,1) cbid
  read(1,*) isat
  read(1,1) cbid
  read(1,1) fnat
  read(1,1) cbid
  read(1,1) titpan
  read(1,1) cbid
  read(1,*) nbp
  read(1,1) cbid
  read(1,*) fc
  read(1,1) cbid
  read(1,*) f1,f2

  read(1,1) cbid
  read(1,*) nbseq
  read(1,1) cbid
  read(1,1) bitr
  read(1,1) cbid
  read(1,*) fe
  read(1,1) cbid
  read(1,*) Ts
  read(1,1) cbid
  read(1,*) srasc,sdec
  read(1,1) cbid
  read(1,*) jul00,ijoud,imoid,iand
  read(1,1) cbid
  read(1,3) ih,im,is,ims
  read(1,1) tend
!
! *** print des resultats
!
  call cchalen_(fultit,ncfu)
  call cchalen_(projet,ncpr)
  call cchalen_(experi,ncex)
  call cchalen_(fnat,nfna)
  call cchalen_(dfrom,ncfn1)
  call cchalen_(ddcal,nccal)
!
  print *, ttrait
  print *,  tstart
  print *, 'Roproc data set Number : ',idset
  print *, 'Full Title: ',fultit(1:ncfu)
  print *, 'Project   : ',projet(1:ncpr)
  print *, 'Experiment: ',experi(1:ncex)
  print *, 'S/C ID: ',sid
  print *, 'S/C # : ',isat
  print *, 'Field Nat : ',fnat(1:nfna)
  print *, 'Step of calibration of input data:',titpan
  print *, 'nbp  :',nbp
  print *, 'cut-off : ', fc
  print *, 'filter  : ', f1,f2
  print *, 'nbseq   : ',nbseq
  print *, 'Bitrate : ',bitr
  print *, 'Samp. f.: ',fe
  print *, 'Spin  T.: ',Ts
  print *, 'sra,sdec: ',srasc,sdec
  print *, 'asked date :          ',ijoud,imoid,iand,jul00
  print *, 'asked time/duration : ',ih,im,is,ims
  print *, tend
  print *, ttrait
!
    1 format(a)
!    2 format(i3,i3,i2.2,i5)
    3 format(3i3,i4)
!
!
  return
  END

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine rdatcopolar(tspea,tspeb,dt,df,nbseq,nbfre,datiso,spebx,speby,spebz,spebp,spebq,spebr)

! --------------------------------------------------------------------+--
! *   Subject  : read sequency of copolar.resu file
! *   Class    : processing of cowave.resu files type
! *   Author   : P. Robert, CETP, September 2000, revised January 2001
! *   Comments : derived from read_caliulf_lib.f library of GEOS pack
! --------------------------------------------------------------------+--

  real spebx(nbseq,nbfre),speby(nbseq,nbfre),spebz(nbseq,nbfre)
  real spebp(nbseq,nbfre),spebq(nbseq,nbfre),spebr(nbseq,nbfre)
  
  character*(*) datiso(nbseq)

  real dt(6),df(6)
  integer nt(6),nf(6)
!
  character*64 tspea(6),tspeb(6)
!
  character*79 cbid,ttrait
!
! *** contenu des variables et tableaux:
!
! nbseq   : nombre maxi de points .
! tspea: titre principal de chaque spectrogramme.
! tspeb: titre de chaque spectrogramme.
!
! dt: resolution en temps un dt par spectro
! df  : resolution en frequence un dt par spectro
!
! *** data/heure de debut; on teste le champ 'END OF FILE' ou le vrai eo
!
! lecture de speb1

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(1)
  read(1,100) cbid
  read(1,100) tspeb(1)
  read(1,100) cbid
  read(1,*) dt(1),df(1)
  read(1,100) cbid
  read(1,*)   nt(1),nf(1)
  read(1,100) cbid

  print*,trim(tspea(1)),' ',trim(tspeb(1)),' ',dt(1),df(1),nt(1),nf(1)

! --------------------------
!
   do j=1,nt(1)
      read(1,100) datiso(j)
      do k=1,nf(1)
      read(1,*) spebx(j,k)
      enddo
   enddo
!
! lecture de speb2

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(2)
  read(1,100) cbid
  read(1,100) tspeb(2)
  read(1,100) cbid
  read(1,*) dt(2),df(2)
  read(1,100) cbid
  read(1,*)   nt(2),nf(2)
  read(1,100) cbid

  print*,trim(tspea(2)),' ',trim(tspeb(2)),' ',dt(2),df(2),nt(2),nf(2)

! --------------------------
!
   do j=1,nt(2)
      read(1,100) datiso(j)
      do k=1,nf(2)
      read(1,*) speby(j,k)
      enddo
   enddo
!
! lecture de speb3

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(3)
  read(1,100) cbid
  read(1,100) tspeb(3)
  read(1,100) cbid
  read(1,*) dt(3),df(3)
  read(1,100) cbid
  read(1,*)   nt(3),nf(3)
  read(1,100) cbid

  print*,trim(tspea(3)),' ',trim(tspeb(3)),' ',dt(3),df(3),nt(3),nf(3)

! --------------------------
!
   do j=1,nt(3)
      read(1,100) datiso(j)
      do k=1,nf(3)
      read(1,*) spebz(j,k)
      enddo
   enddo
!
! lecture de speb4

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(4)
  read(1,100) cbid
  read(1,100) tspeb(4)
  read(1,100) cbid
  read(1,*) dt(4),df(4)
  read(1,100) cbid
  read(1,*)   nt(4),nf(4)
  read(1,100) cbid

  print*,trim(tspea(4)),' ',trim(tspeb(4)),' ',dt(4),df(4),nt(4),nf(4)

! --------------------------
!
   do j=1,nt(4)
      read(1,100) datiso(j)
      do k=1,nf(4)
      read(1,*) spebp(j,k)
      enddo
   enddo

! lecture de speb5

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(5)
  read(1,100) cbid
  read(1,100) tspeb(5)
  read(1,100) cbid
  read(1,*) dt(5),df(5)
  read(1,100) cbid
  read(1,*)   nt(5),nf(5)
  read(1,100) cbid

  print*,trim(tspea(5)),' ',trim(tspeb(5)),' ',dt(5),df(5),nt(5),nf(5)

! --------------------------
!
   do j=1,nt(5)
      read(1,100) datiso(j)
      do k=1,nf(5)
      read(1,*) spebq(j,k)
      enddo
   enddo
!
! lecture de speb6

  read(1,100,end=30) ttrait
  read(1,100,end=30) cbid
  read(1,100,end=30) tspea(6)
  read(1,100) cbid
  read(1,100) tspeb(6)
  read(1,100) cbid
  read(1,*) dt(6),df(6)
  read(1,100) cbid
  read(1,*)   nt(6),nf(6)
  read(1,100) cbid

  print*,trim(tspea(6)),' ',trim(tspeb(6)),' ',dt(6),df(6),nt(6),nf(6)

! --------------------------
!
   do j=1,nt(6)
      read(1,100) datiso(j)
      do k=1,nf(6)
      read(1,*) spebr(j,k)
      enddo
   enddo


   30 continue

  100 format(a)

  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine plotpalpol(ox,oy,sx,sy,xmin,xmax,tgra)
!
! --------------------------------------------------------------------+--
! plot d'une palette HSB
! --------------------------------------------------------------------+--
!
  character*8 forx
!
! *** palette hsb avec cadre
!
  call  ppagcmah(ox,oy,sx,sy,1)
  call  ppagrec_(ox,oy,sx,sy)
!
! *   definition de la figure
!
  call  dfigori_(ox,oy)
  call  dfigsiz_(sx,sy)
  call  dfiglimx(xmin,xmax)
!
! *   trace des graduations pour la puisance

  call  cfiggra_(xmin,xmax,x1a,x2a,bgx,sgx,forx)
  call  dstipos_(' o','ii')
  call  dstisiz_(sy/5.,sy/10.)
  call  dgrapos_('top','left')
  call  dgrasiz_(tgra,tgra)
  call  pfiggrax(0.,bgx,sgx,forx)
  call  ppagcha_(ox-2.3,oy+sy+0.1,-1,tgra*1.3,tgra*1.3,0.,'Log power')
!
! eccentricity

  call  dstipos_('o ','ii')
  call  dstisiz_(sy/5.,sy/10.)
  call  dgrapos_('bottom','left')
  call  dgrasiz_(tgra,tgra)
  call  dfiglimx(0.,1.)
  call  pfiggrax(0.,0.25,0.05,'(f4.2)')
  call  ppagcha_(ox-2.3,oy-0.4,-1,tgra*1.3,tgra*1.3,0.,'Eccentricity')
!
! Theta

  call  dfigori_(ox,oy-0.6)
  call  dstipos_('o ','ii')
  call  dstisiz_(sy/5.,sy/10.)
  call  dgrapos_('bottom','left')
  call  dgrasiz_(tgra,tgra)
  call  dfiglimx(0.,180.)
  call  pfiggrax(0.,45.,15.,'(f4.0)')
  call  ppagcha_(ox-1.3,oy-1.,-1,tgra*1.3,tgra*1.3,0.,'Theta')
!
! Phi

  call  dfigori_(ox,oy-1.2)
  call  dstipos_('o ','ii')
  call  dstisiz_(sy/5.,sy/10.)
  call  dgrapos_('bottom','left')
  call  dgrasiz_(tgra,tgra)
  call  dfiglimx(0.,360.)
  call  pfiggrax(0.,45.,15.,'(f4.0)')
  call  ppagcha_(ox-1.3,oy-1.6,-1,tgra*1.3,tgra*1.3,0.,'Phi')
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX