!
  program visu_spectro

!----------------------------------------------------------------------
! Object: Visualize a SP.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------

  use rff_param_def
  use rff_data_def

  integer            :: nbspe, i

  character(len=255) :: SP_file,psfile,signat,line,pos_ind,mag_ind
  character(len=3)   :: suff,XY
  character(len=1)   :: B,posmag
  character(len=120) :: dati26,mission,experi,csatnum,units,rep,titpan,br
  character(len=8)   :: laby(3),forgy,titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version,laby1,colmap
  character(len=27)  :: datiso1,datiso2,datpos,datmag
  character(len=128) :: titspe,titpui,titper
  character(len=8)   :: titsol(4)

  real(kind=4)       :: valgra(24),valpopo(3,24)
  real(kind=4),  dimension(:),     allocatable :: time,puix,puiy,puiz,bper,timpos,timmag,Fci,FLH
  real(kind=4),  dimension(:,:),   allocatable :: spebx,speby,spebz,valpos
  real(kind=8)       :: ddt
  integer,       dimension(:,:),   allocatable :: image


! *** declaration pour la partie graphique

  data tclab,tctit,tccom,tcgra /0.35,0.35,0.22, 0.3/
  data titpui /'Int. power'/
  data titper /'DC perp'/
  data titpan/'Log Power Spectral Density'/
  data laby1/'Frequency (Hz)'/
  data nbgma,nbpma /24,24/
  data titsol /'Husafell','Kitdalen','Kitdalen','Skibotn'/

!     ---------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_spectro  : Visualize a spectro.rff'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF SP file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') SP_file
  print*, trim(SP_file)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

! *** lecture des options du plot

  print*, 'f1,f2?  (ex: 1. 12.)'
  read *, f1,f2
  print*, f1,f2

  print*, 'logP1, logP2 ?  (ex: -6. -1., 0.=auto)'
  read *, p1imp,p2imp
  print*, p1imp,p2imp

  print*,'XY ? (ex: XY or LR)'
  read(*,'(a)') XY

  print*, 'fi1,fi2?  (ex: 1. 12.)'
  read *, fi1,fi2
  print*, fi1,fi2

! lecture des option pos/mag

  print*,'posmag ? (y/n)'
  read(*,'(a1)') posmag
  print*, posmag

  if(posmag == 'y') then
        read(*,'(a)') pos_ind
        read(*,'(a)') mag_ind
  endif

  iSP=len(trim(SP_file))
  suff=SP_file(iSP-2:iSP)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro.exe                : *** ERROR !! Program aborted !'
  ENDIF

  print*
  print*, '=================================='
  print*, '1) read  spectro file '
  print*, '=================================='


  call rff_R_file(1,SP_file)

  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) 'R_DATA_MATRIX(1,10,1)    =',R_DATA_MATRIX(1,10,1)
  write(*,*) 'R_DATA_MATRIX(1,10,nbspe)=',R_DATA_MATRIX(1,10,nbspe)

 write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspes=0
  it1=1
  it2=nbspe

! select period

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspes=nbspes +1
     if(nbspes == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspes=',nbspe,it1,it2,nbspes
  print*

  if(nbspes.lt.2) then
    print*,'nbspe in asked time period <2, program aborted'
    stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  endif

! calcul des indices pour les frequences et les puiss integrees

  call  co_ind

  print*, 'f1, f2, if1,if2=',f1, f2, if1,if2
  print*, 'fi1,fi2,ip1,ip2=',fi1,fi2,ip1,ip2

  nbfre2= if2-if1+1

  allocate(spebx(nbspes,nbfre2))
  allocate(speby(nbspes,nbfre2))
  allocate(spebz(nbspes,nbfre2))

  allocate(time(nbspes))
  allocate(puix(nbspes))
  allocate(puiy(nbspes))
  allocate(puiz(nbspes))
  allocate(bper(nbspes))

  allocate(image(1,nbfre2))

  print*
  print*, '=================================='
  print*, '2) Load data '
  print*, '=================================='


  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  if(nbvec /= nbspes) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspes=',nbspes
                      print*, 'nbvec not egal to nbspes'
                      stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  endif

  print*
  print*, '======================================'
  print*, '3) read pos and mag files if requested'
  print*, '======================================'

  npos=0
  nmag=0

  if(posmag == 'y') then

      print*, ' reading ',trim(pos_ind)
      open(11,file=pos_ind,IOSTAT=iostat)
      if(iostat /= 0) then
           ipos=0
         else
           ipos=1
           read(11,*) npos
           allocate(timpos(npos))
           allocate(valpos(3,npos))

           do i=1,npos
              read(11,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datpos
              call decode_datiso(datpos,iy,imo,id,ih,im,is,ims,imc)
              timpos(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) valpos(1,i),valpos(2,i),valpos(3,i)
           end do
      endif
      close(11)

      print*, ' reading ',trim(mag_ind)
      open(12,file=mag_ind,IOSTAT=iostat)
      if(iostat /= 0) then
           imag=0
         else
           imag=1
           read(12,*) nmag
           allocate(timmag(nmag))
           allocate(Fci(nmag))
           allocate(FLH(nmag))

           do i=1,nmag
              read(12,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datmag
              call decode_datiso(datmag,iy,imo,id,ih,im,is,ims,imc)
              timmag(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) Bx,By,Bz
              RB=sqrt(Bx**2 +By**2 +Bz**2)
              Fci(i)=RB*1.525e-2
              FLH(i)=sqrt(1836.)*6.2832*Fci(i)
          !   print*,'fci,fch=',Fci(i),flh(i)
           end do
      endif
      close(12)

   else
        print*, 'Not requested...'
  endif


  print*
  print*, '=================================='
  print*, '4) Plot spectrogrammes '
  print*, '=================================='

! ---------------------------------------------------
! cadre general
! ---------------------------------------------------

  psfile=SP_file(1:iSP-4)//'.ps'

  tclab=0.35
  tctit=0.35
  tccom=0.25

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)
  call dcolmap_('spectro256')

  mission=manda_param%MISSION_NAME
  isatnum=manda_param%OBSERVATORY_NUMBER
  write(csatnum,'(i1)') isatnum
  experi= manda_param%EXPERIMENT_NAME
  br    = manda_param%EXPERIMENT_MODE

  titleft=trim(mission)//"-"//trim(csatnum)//'/'//trim(experi)
  if(TRIM(manda_param%MISSION_NAME)    == 'MOBILE STATION' .and. &
     TRIM(manda_param%EXPERIMENT_NAME) == 'ULF' ) then
     titleft=trim(mission)//"-"//trim(titsol(isatnum))//'/'//trim(experi)
  endif
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*,manda_param%DATA_LABEL
  units  =manda_param%DATA_UNITS(1:2)
  rep    =manda_param%DATA_COORDINATE_SYSTEM

  laby(1)=manda_param%DATA_LABEL(1:2)
  laby(2)=manda_param%DATA_LABEL(13:14)
  laby(3)=manda_param%DATA_LABEL(25:26)
  B      =manda_param%DATA_LABEL(1:1)
  titspe =trim(optio_param%TITLE)//'  -  '//trim(optio_param%SUB_TITLE)

  if(XY == 'LR') then
     laby(1)=B//'L'
     laby(2)=B//'R'
  endif

  print*,'plot des titres  et label specifiques de la page'

  titpan=trim(titpan)//' ('//trim(units)//'^2/Hz )'

  fs    =real(const_data%SPIN_PERIOD)
  srasc=const_data%SPIN_GEI_RIGHT_ASCENSION
  sdec =const_data%SPIN_GEI_DECLINATION
  fc   =const_data%FREQUENCY_CUT_OFF

  call plot_tit_spectro_(nbspes,f1,f2,fc,fs,dt,df,sdec,srasc,titpan,titspe,tctit,tccom)

! ---------------------------------------------------
! calcul des bornes et graduations en temps et en frequence
! ---------------------------------------------------

  print*,'bornes en temps et en frequence'

!!  t1=time(1)
!!  t2=time(nbspes)

  call decode_datiso(datiso1,iy,imo,id,ih,im,is,ims,imc)
  t1=float(ih)+float(im)/60. +float(is)/3600.

  call decode_datiso(datiso2,iy,imo,id,ih,im,is,ims,imc)
  t2=float(ih)+float(im)/60. +float(is)/3600.
  
  print*, 't1,t2 (s.)=',t1,t2
  print*, 'f1,f2 (Hz)=',f1,f2

  print*, 'calcul des graduations horaire'
  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'titgra    =',(titgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt

  print*, 'calcul des graduations en frequence'

  call cfiggra_(f1,f2,f1aron,f2aron,bgy,sgy,forgy)

  print*, 'f1,f2,f1aron,bgy,sgy=',f1,f2,f1aron,bgy,sgy

! ---------------------------------------------------
! calcul des seuils pour les 3 images
! ---------------------------------------------------

! passage en log (deviens -8 si egal zero et -10 si negatif)
! log OK si > 1.e-20

  valzer=-16.
  valneg=-20.

  call cscalog_(spebx,nbspes,nbfre2,valzer,valneg)
  call cscalog_(speby,nbspes,nbfre2,valzer,valneg)
  call cscalog_(spebz,nbspes,nbfre2,valzer,valneg)

  pcmin=10.
  pcmax=1.

  call  cscasli_(spebx,nbspes,nbfre2,sminx,smaxx,pcmin,pcmax)
  call  cscasli_(speby,nbspes,nbfre2,sminy,smaxy,pcmin,pcmax)
  call  cscasli_(spebz,nbspes,nbfre2,sminz,smaxz,pcmin,pcmax)

  if(scamax-scamin.gt.1.e20) then
     smin=min(sminx,sminy,sminz)
     smax=max(smaxx,smaxy,smaxz)
     else
     smin=p1imp
     smax=p2imp
  endif

! pas trop de saturation rouge

  smax=smax+1.

! seuils imposes eventuels

  print*
  print*, 'smin, smax =',smin,smax
  print*, 'p1imp,p2imp=',p1imp,p2imp

  if(p2imp-p1imp.gt.0.001) then
                       smi=p1imp
                       sma=p2imp
                           else
                       smi=smin
                       sma=smax
  endif
!
  print*
  print*, 'Seuils min, max pris en compte   =',smi,sma


! ---------------------------------------------------
! Initialisation des parametres graphiques pour tt les figures
! ---------------------------------------------------


! panel DC-perp only for rep in ISR2,SR2,SRV

  ibpe=0
  if(rep.eq.'ISR2'.or.rep.eq.'SR2'.or.rep.eq.'SRV') ibpe=1
  if(rep.eq.'isr2'.or.rep.eq.'sr2'.or.rep.eq.'srv') ibpe=1

  sizfy=5.4

  if(ibpe.eq.1) sizfy=sizfy*0.855
  if(ipos.eq.1) sizfy=sizfy*0.92

  posfy=22.9 -sizfy
  decay=0.37

  sizfx=15.
  posfx=2.9

  call gcolmap_(colmap,nlevel)
  
  sbla=smi -1.
  swhi=sma +float(nlevel)

  call dfigsiz_(sizfx,sizfy)
  call dlinwid_(2.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)
  call dgrasiz_(0.0,tcgra)
  call dstisiz_(0.25,0.13)
  call dstipos_('oi','oo')
  call dlabseny('h')
  call dfiglim_(t1,t2,f1,f2)

! *** plot du spectrogramme x

  print*
  print*, 'Spectrogramme X ...'
  
  call dfigori_(posfx,posfy)
  call dstipos_('oo','oo')
  
! on trace chaque colonne de 1 px de large au temps t pour gerer les trous de TM  
  ddt   = optio_param%TIME_RESOLUTION/3600.d0
  pixsiz=  sizfx*real(ddt/dble(t2-t1))

  do i=1,nbspes
     call cscaima_(spebx(i,:),1,nbfre2,smi,sma,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call dlincol_('r')
  call ppagcha_(0.4,posfy+sizfy/1.5,-1,0.4,0.4,0.,laby(1))

  if(nmag > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag,FLH,nmag)
               call dlincol_('w')
               call pfigcur_(timmag,Fci,nmag)
               call dlinwid_(wid)
               call dlincol_('n')
  endif

  call dlincol_('n')

! plot du label "frequency" pour la 1ere figure

  call ppagcha_(1.3,posfy,-1,0.28,0.28,90.,laby1)


! *** plot du spectrogramme y

  print*, 'Spectrogramme Y ...'
!
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  call dstipos_('oo','oo')

  do i=1,nbspes
     call cscaima_(speby(i,:),1,nbfre2,smi,sma,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call dlincol_('g')
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(2))
  call dlincol_('n')

  if(nmag > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag,FLH,nmag)
               call dlincol_('w')
               call pfigcur_(timmag,Fci,nmag)
               call dlinwid_(wid)
               call dlincol_('n')
  endif

! *** plot du spectrogramme z

  print*, 'Spectrogramme Z ...'
!
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
!

  do i=1,nbspes
     call cscaima_(spebz(i,:),1,nbfre2,smi,sma,image(1,:),sbla,swhi)
     px=posfx + (sizfx-pixsiz)*(time(i)-t1)/(t2-t1)
! on ne plot pas le continu  
     call ppagima_(px,posfy,-1,pixsiz,sizfy,0.,image(1,2:nbfre2),1,nbfre2-1)
  enddo
  
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call dlincol_('b')
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(3)(1:2))
  call dlincol_('n')

  if(nmag > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag,FLH,nmag)
               call dlincol_('w')
               call pfigcur_(timmag,Fci,nmag)
               call dlinwid_(wid)
               call dlincol_('n')
  endif

! ---------------------------------------------------
!  plot des puissances integrees
! ---------------------------------------------------

  print*, 'Puissances integrees ...'

  if(ibpe == 1 ) then
                 grax=0.
                 else
                 grax=tcgra
  endif

  sizfy=sizfy*0.72-0.2
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(grax,0.25)
  call dstipos_('oi','oo')

  posfy=posfy-sizfy-decay-0.3
  call dfigori_(posfx,posfy)
  print*,'posfx,posfy',posfx,posfy

  titpui=trim(titpui)//' ('//trim(units)//'^2)'
  call plotpuiint(puix,puiy,puiz,time,nbspes,titpui,fi1,fi2,smi,sma)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

! ---------------------------------------------------
!     plot de Bperp (avec graduations en temps taille normale)
! ---------------------------------------------------

  if(ibpe == 1 ) then

     print*, 'Bperp ...'

     sizfy=sizfy*0.8
     posfy=posfy-sizfy-decay
     call dfigori_(posfx,posfy)
     call dfigsiz_(sizfx,sizfy)

     call cminmax_(bper,nbspes,y1min,y1max)
     call cfiggra_(y1min,y1max,ymin,ymax,bgy,sgy,forgy)

     call dfiglimy(ymin,ymax)
     call dgrasiz_(tcgra,0.25)

     call pfigfra_
     call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
     call pfiggray(0.,bgy,sgy,forgy)
     call pfigcur_(time,bper,nbspes)

     titper=trim(titper)//' ('//trim(units)//')'
     call ppagcha_(0.6,posfy+sizfy/2.,0,0.24,0.24,90.,trim(titper))
  endif

! ---------------------------------------------------
! *** plot des positions
! ---------------------------------------------------

 if(npos > 0) then
               print*,'plot of positions'
               if(nbgma > 6) then
                             kgma=2
                             else
                             kgma=1
               endif
               i1=1
               valpopo=0.
 
               do k=1,nbgma,kgma
                  do i=i1,npos-1
                     if(timpos(i) .le. valgra(k) .and. timpos(i+1) .ge. valgra(k)) then
                         valpopo(1:3,k)=valpos(1:3,i)
                         i1=i
                         exit
                     endif
                  end do
               end do

      if(mission == 'CLUSTER') valpopo(1:3,1:nbgma)=valpopo(1:3,1:nbgma)/6378.
      if(mission == 'GEOS'   ) valpopo(3,1:nbgma)=valpopo(3,1:nbgma)/6378.

      do k=1,nbgma-1,kgma
         call cfigpag_(valgra(k),ymin,xx,yy)
         write(line,'(f8.2)') valpopo(1,k)
         call ppagcha_(xx,yy-1.2,0,tcgra,tcgra,0.,line)
         write(line,'(f8.2)') valpopo(2,k)
         call ppagcha_(xx,yy-1.2-1.5*tcgra,0,tcgra,tcgra,0.,line)
         write(line,'(f8.2)') valpopo(3,k)
         call ppagcha_(xx,yy-1.2-3*tcgra,0,tcgra,tcgra,0.,line)
      end do

      call ppagcha_(0.5,posfy-1.7,-1,tctit,tctit,0.,'Pos')

  endif

! ---------------------------------------------------
! *** plot du symbole UT et de la mire
! ---------------------------------------------------

  call ppagcha_(0.5,posfy-0.35-tctit,-1,tctit,tctit,0.,'UT')

  call plotpalhsbx(13.5,pagsy-2.7,4.5,0.5,smi,sma,0.2)

! ---------------------------------------------------
! fermeture du fichier psfile et fin du programme
! ---------------------------------------------------

  print*, 'termine pour ce plot, psfile=',trim(psfile)
  print*

  call dclogra_

  print*, 'visu_spectro.exe                 : NORMAL TERMINATION'
     stop 'visu_spectro.exe                 : NORMAL TERMINATION'

!---------------------------------------------------------------------+--
  contains
!---------------------------------------------------------------------+--
  subroutine co_ind

  print*, 'calcul des indices pour les frequences et les puiss integrees'


! bornes du spectro

  fmax=float(nbfre)*df
  if(f1.lt.0.) f1=0.
  if(f2.lt.1.e-10) f2=fmax

  if1=int(f1/df +0.5)
  if2=int(f2/df +0.5)+1

  if(if1.lt.1) if1=1
  if(if2.gt.nbfre) if2=nbfre

! bornes des pui int

  if(fi1.lt.f1) fi1=f1
  if(fi2.gt.fmax) fi2=fmax

  if(fi1.lt. 1.e-10) fi1=1.e-2
  if(fi2.lt. 1.e-10) fi2=f2

  ip1=int(fi1/df +0.5)
  ip2=int(fi2/df +0.5)

  if(ip1.lt.if1) ip1=if1
  if(ip2.gt.if2) ip2=if2

  if(ip1.lt.3) ip1=3
  if(ip2.gt.nbfre) ip2=nbfre

  end subroutine co_ind

!---------------------------------------------------------------------+--

  subroutine load_data

  complex (kind=4) :: ci,sx,sy

  ci=CMPLX(0,1.)

  read(manda_param%DATA_FILL_VALUE,*) filval

  nbvec=0

  print*
  print*,'load_data: it1,it2,nbspes  =',it1,it2,nbspes
  print*,'load_data: if1,if2,f1, f2  =',if1,if2,f1,f2,'  nbfre2=',nbfre2
  print*,'load_data: ip1,ip2,fi1,fi2 =',ip1,ip2,fi1,fi2


  ip1c=ip1 -if1+1
  ip2c=ip2 -if1+1
  print*
  print*, 'load_data: ip1c,ip2c=',ip1c,ip2c

  do i=it1,it2

     nbvec=nbvec+1
     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     if(i == it1) idoty1=idoty
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     if(XY == 'LR' ) then
       do j=if1,if2

         sx=cmplx(R_DATA_MATRIX(1,j,i), R_DATA_MATRIX(2,j,i))
         sy=cmplx(R_DATA_MATRIX(3,j,i), R_DATA_MATRIX(4,j,i))

         R_DATA_MATRIX(1,j,i)= REAL(conjg(sx) + ci*conjg(sy))/2.
         R_DATA_MATRIX(2,j,i)=AIMAG(conjg(sx) + ci*conjg(sy))/2.

         R_DATA_MATRIX(3,j,i)= REAL(sx + ci*sy)/2.
         R_DATA_MATRIX(4,j,i)=AIMAG(sx + ci*sy)/2.

       end do
     endif

     time(nbvec)=decsec/3600.

     spebx(nbvec,1:nbfre2)=(R_DATA_MATRIX(1,if1:if2,i)**2 +R_DATA_MATRIX(2,if1:if2,i)**2)/df
     speby(nbvec,1:nbfre2)=(R_DATA_MATRIX(3,if1:if2,i)**2 +R_DATA_MATRIX(4,if1:if2,i)**2)/df
     spebz(nbvec,1:nbfre2)=(R_DATA_MATRIX(5,if1:if2,i)**2 +R_DATA_MATRIX(6,if1:if2,i)**2)/df

     puix(nbvec)=sum(spebx(nbvec,ip1c:ip2c))*df
     puiy(nbvec)=sum(speby(nbvec,ip1c:ip2c))*df
     puiz(nbvec)=sum(spebz(nbvec,ip1c:ip2c))*df

     bper(nbvec)=sqrt(R_DATA_MATRIX(1,1,i)**2 +R_DATA_MATRIX(3,1,i)**2)
  end do

  deallocate(data_index)
  deallocate(R_DATA_MATRIX)

  end subroutine load_data

!---------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'Spectrogram') THEN
     write(*,*) '*** Only Spectrogram FILE_CLASS is allowed'
     stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Matrix') THEN
     write(*,*) '*** Only Matrix DATA_FORM is allowed'
     stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!---------------------------------------------------------------------+--

  END program visu_spectro

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plot_tit_spectro_(nbp,f1,f2,fc,fs,dtspe,dfspe,     &
            sdec,srasc,titpan,titspe,tctit,tccom)

!     ---------------------------------------------------------------+--
!     plot des titres et parametres
!     ---------------------------------------------------------------+--

  character*140 work
  character*(*) titpan
  character*(*) titspe

  character*120 form
  character*12 fornbp

  call gpagsiz_(pagsx,pagsy)
  call gfigsiz_(sizfx,sizfy)
  call gfigori_(posfx,posfy)

! *** plot des titres et differents parametres

  print*, 'plot des titres et parametres...'

  call dfontyp_('h')

! *   titre general

  call ppagcha_(4.8,pagsy-2.8,-1,tctit,tctit,0.,trim(titpan))

! *   titre de l'ensemble des pannels

  call ppagcha_(4.,pagsy-3.5,-1,tccom,tccom,0.,trim(titspe))

! *   Nbp, dt, etc.

  call cbesfori(nbp,fornbp)


  if(fc > 1.e10) fc=dfspe
  form='("N=",'//fornbp//',"  dt=",f8.4," s df=",f7.4," Hz  Fc=",f8.4," F1=",f8.2," F2=",f9.2)'
  write(work,form)nbp,dtspe,dfspe,fc,f1,f2
  call cchalen_(work,nw)
  call ppagcha_(4.,pagsy-3.9,-1,tccom,tccom,0.,work(1:nw))
  print*, work(1:nw)

! *   Spin Rasc,dec

  if(abs(sdec) .gt.360. .or. abs(srasc) .gt. 360. .or. abs(fs) .gt. 10.) return
  if(abs(sdec) .gt.0. .and. abs(srasc).gt.0. .and. abs(fs).gt.0.) then

      work='S_dec    S_rasc     S_freq'
      call cchalen_(work,nw)
      call ppagcha_(0.3,pagsy-2.3,-1,tccom,tccom,0,work(1:nw))
      print*, work(1:nw)

      form='(f7.2,"  ",f7.2,"   ",f8.6)'
      write(work,form)sdec,srasc,fs
      call cchalen_(work,nw)
      call ppagcha_(0.2,pagsy-2.7,-1,tccom,tccom,0.,work(1:nw))
      print*, work(1:nw)

  endif

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plotpuiint(puix,puiy,puiz,time,nbspes,titpui,fi1,fi2,smi,sma)

!     ---------------------------------------------------------------+--
!     Plot la puissances integrees
!     ---------------------------------------------------------------+--

  character*8 for1,for2
  character*64 titpui,lab1,lab2,laba
  real puix(nbspes),puiy(nbspes),puiz(nbspes)
  real time(nbspes)


  call gfigsiz_(sizfx,sizfy)
  call gfigori_(posfx,posfy)

  asmi=10.**(int(smi))
  asma=10.**(int(sma)+2)

  print*, 'pui  voulues=',smi,sma
  print*, 'val imposees=',asmi,asma

  ! check zero values

  do i=1,nbspes
     if(puix(i).lt.asmi) puix(i)=asmi
     if(puiy(i).lt.asmi) puiy(i)=asmi
     if(puiz(i).lt.asmi) puiz(i)=asmi
  end do

! *** calcul des graduations y

  call dgrastyy(1)
  call cfiggral(asmi,asma,ymin,ymax)
  call dfiglimy(ymin,ymax)
  call pfiggrly(1)

! *** calcul des labels du pannel des puissances

! *   label

  print*, 'fi1,fi2=',fi1,fi2

  call cbesfor_(fi1,for1)
  call cbesfor_(fi2,for2)

  write(lab1,for1) fi1
  write(lab2,for2) fi2

  call cchalen_(lab1,n1)
  call cchalen_(lab2,n2)

  laba=lab1(1:n1)//' - '//lab2(1:n2)//' Hz'

! *** plot du pannel des puissances

  call pfigfra_

  call ppagcha_(0.6,posfy+sizfy/2.,0,0.24,0.24,90.,titpui)

  call dlincol_('r')
  call pfigcur_(time,puix,nbspes)
  call dlincol_('g')
  call pfigcur_(time,puiy,nbspes)
  call dlincol_('b')
  call pfigcur_(time,puiz,nbspes)
  call ppagcha_(1.2,posfy+sizfy/2.,0,0.24,0.24,90.,laba)

  call dlincol_('n')
  call dgrastyy(0)

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
