!
  program visu_spectro_4Bz

!----------------------------------------------------------------------
! Object: Visualize BZ of 4 SP.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------

  use rff_param_def
  use rff_data_def

  integer            :: nbspe, i

  character(len=255) :: SP1,SP2,SP3,SP4,psfile,signat,work,line,pos_ind,mag_ind(4)
  character(len=3)   :: suff,posmag
  character(len=120) :: dati26,mission,experi,units,rep,titpan,mode
  character(len=8)   :: laby(4),forgy,titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version,laby1
  character(len=27)  :: datiso1,datiso2,datpos,datmag
  character(len=128) :: titspe,titpui,titper

  real(kind=4)       :: valgra(24),valpopo(3,24)
  real(kind=4),      dimension(:),   allocatable :: time,time1,time2,time3,time4
  real(kind=4),      dimension(:),   allocatable :: timpos,timmag1,timmag2,timmag3,timmag4
  real(kind=4),      dimension(:),   allocatable :: Fci1,Fci2,Fci3,Fci4
  real(kind=4),      dimension(:),   allocatable :: FLH1,FLH2,FLH3,FLH4
  real(kind=4),      dimension(:),   allocatable :: puiz,puiz1,puiz2,puiz3,puiz4
  real(kind=4),      dimension(:),   allocatable :: bper,bper1,bper2,bper3,bper4
  real(kind=4),      dimension(:,:), allocatable :: spebz,spebz1,spebz2,spebz3,spebz4,valpos

  integer,           dimension(:,:), allocatable :: image


! *** declaration pour la partie graphique

  data tclab,tctit,tccom,tcgra /0.35,0.35,0.22, 0.3/
  data titpui /'Int. power'/
  data titper /'DC perp'/
  data titpan/'Log Power Spectral Density'/
  data laby1/'Frequency (Hz)'/
  data laby /'C1','C2','C3','C4'/
  data nbgma,nbpma /24,24/

!     ---------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_spectro_4Bz  : Visualize Bz of 4 spectro.rff'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF SP1 file to read ? (ex: toto1_GSE.rff)'
  read(*,'(a)') SP1
  print*, trim(SP1)

  print*, 'RFF SP2 file to read ? (ex: toto1_GSE.rff)'
  read(*,'(a)') SP2
  print*, trim(SP2)

  print*, 'RFF SP3 file to read ? (ex: toto1_GSE.rff)'
  read(*,'(a)') SP3
  print*, trim(SP3)

  print*, 'RFF SP4 file to read ? (ex: toto1_GSE.rff)'
  read(*,'(a)') SP4
  print*, trim(SP4)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)

  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

! *** lecture des options du plot

  print*, 'f1,f2?  (ex: 1. 12.)'
  read *, f1,f2
  print*, f1,f2

  print*, 'logP1, logP2 ?  (ex: -6. -1., 0.=auto)'
  read *, p1imp,p2imp
  print*, p1imp,p2imp

  print*, 'fi1,fi2?  (ex: 1. 12.)'
  read *, fi1,fi2
  print*, fi1,fi2


! lecture des option pos/mag

  print*,'posmag ? (y/n)'
  read(*,'(a1)') posmag
  print*, posmag

  if(posmag == 'y') then
        read(*,'(a)') pos_ind
        read(*,'(a)') mag_ind(1)
        read(*,'(a)') mag_ind(2)
        read(*,'(a)') mag_ind(3)
        read(*,'(a)') mag_ind(4)

  endif

  iSP1=len(trim(SP1))
  suff=SP1(iSP1-2:iSP1)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro_4Bz.exe            : *** ERROR !! Program aborted !'
  ENDIF


  iSP1=len(trim(SP1))
  suff=SP1(iSP1-2:iSP1)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro_4Bz.exe            : *** ERROR !! Program aborted !'
  ENDIF


  iSP2=len(trim(SP2))
  suff=SP2(iSP2-2:iSP2)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro_4Bz.exe            : *** ERROR !! Program aborted !'
  ENDIF


  iSP3=len(trim(SP3))
  suff=SP3(iSP3-2:iSP3)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro_4Bz.exe            : *** ERROR !! Program aborted !'
  ENDIF


  iSP4=len(trim(SP4))
  suff=SP4(iSP4-2:iSP4)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro_4Bz.exe            : *** ERROR !! Program aborted !'
  ENDIF


  print*
  print*, '=================================='
  print*, '1) read  spectro1 file '
  print*, '=================================='


  call rff_R_file(1,SP1)
  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspes=0
  it1=1
  it2=nbspe

! select period

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspes=nbspes +1
     if(nbspes == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspes=',nbspe,it1,it2,nbspes
  print*

  if(nbspes.lt.2) then
    print*,'nbspe in asked time period <2, program aborted'
    stop 'visu_spectro_4Bz.exe             : *** ERROR !! Program aborted !'
  endif

! calcul des indices pour les frequences et les puiss integrees

  call  co_ind

  print*, 'f1, f2, if1,if2=',f1, f2, if1,if2
  print*, 'fi1,fi2,ip1,ip2=',fi1,fi2,ip1,ip2

  nbfre2= if2-if1+1

  allocate(spebz(nbspes,nbfre2))
  allocate(time(nbspes))
  allocate(puiz(nbspes))
  allocate(bper(nbspes))

!  allocate(image(nbspes,nbfre2))

  print*
  print*, '=================================='
  print*, '2) Load data SP1'
  print*, '=================================='


  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright
  write(work,'(I4.4,2i2.2)') iyear,imon,iday

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  if(nbvec /= nbspes) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspes=',nbspes
                      print*, 'nbvec not egal to nbspes'
                      stop 'visu_spectro_4Bz.exe             : *** ERROR !! Program aborted !'
  endif

! save 1st file

  nbvec1=nbvec
  allocate(spebz1(nbvec1,nbfre2))
  allocate(time1(nbvec1))
  allocate(puiz1(nbvec1))
  allocate(bper1(nbvec1))

  spebz1(1:nbvec1,1:nbfre2)=spebz(1:nbvec1,1:nbfre2)
  time1(1:nbvec1)=time(1:nbvec1)
  puiz1(1:nbvec1)=puiz(1:nbvec1)
  bper1(1:nbvec1)=bper(1:nbvec1)


  print*
  print*, '======================================'
  print*, '3) read pos and mag files if requested'
  print*, '======================================'

  if(posmag == 'y') then

      print*, ' reading ',trim(pos_ind)
      open(10,file=pos_ind,IOSTAT=iostat)
      if(iostat /= 0) then
           ipos=0
         else
           ipos=1
           read(10,*) npos
           allocate(timpos(npos))
           allocate(valpos(3,npos))

           do i=1,npos
              read(10,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datpos
              call decode_datiso(datpos,iy,imo,id,ih,im,is,ims,imc)
              timpos(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) valpos(1,i),valpos(2,i),valpos(3,i)
           end do
      endif
      close(10)

      print*, ' reading ',trim(mag_ind(1))
      open(11,file=mag_ind(1),IOSTAT=iostat)
      if(iostat /= 0) then
           imag1=0
         else
           imag=1
           read(11,*) nmag1
           allocate(timmag1(nmag1))
           allocate(Fci1(nmag1))
           allocate(FLH1(nmag1))

           do i=1,nmag1
              read(11,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datmag
              call decode_datiso(datmag,iy,imo,id,ih,im,is,ims,imc)
              timmag1(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) Bx,By,Bz
              RB=sqrt(Bx**2 +By**2 +Bz**2)
              Fci1(i)=RB*1.52e-2
              FLH1(i)=sqrt(1836.)*6.2832*Fci1(i)
           end do
      endif
      close(11)

      print*, ' reading ',trim(mag_ind(2))
      open(12,file=mag_ind(2),IOSTAT=iostat)
      if(iostat /= 0) then
           imag2=0
         else
           imag=2
           read(12,*) nmag2
           allocate(timmag2(nmag2))
           allocate(Fci2(nmag2))
           allocate(FLH2(nmag2))

           do i=1,nmag2
              read(12,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datmag
              call decode_datiso(datmag,iy,imo,id,ih,im,is,ims,imc)
              timmag2(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) Bx,By,Bz
              RB=sqrt(Bx**2 +By**2 +Bz**2)
              Fci2(i)=RB*1.52e-2
              FLH2(i)=sqrt(1836.)*6.2832*Fci2(i)
           end do
      endif
      close(12)

      print*, ' reading ',trim(mag_ind(3))
      open(13,file=mag_ind(3),IOSTAT=iostat)
      if(iostat /= 0) then
           imag3=0
         else
           imag=3
           read(13,*) nmag3
           allocate(timmag3(nmag3))
           allocate(Fci3(nmag3))
           allocate(FLH3(nmag3))

           do i=1,nmag3
              read(13,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datmag
              call decode_datiso(datmag,iy,imo,id,ih,im,is,ims,imc)
              timmag3(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) Bx,By,Bz
              RB=sqrt(Bx**2 +By**2 +Bz**2)
              Fci3(i)=RB*1.52e-2
              FLH3(i)=sqrt(1836.)*6.2832*Fci3(i)
           end do
      endif
      close(13)

      print*, ' reading ',trim(mag_ind(4))
      open(14,file=mag_ind(4),IOSTAT=iostat)
      if(iostat /= 0) then
           imag4=0
         else
           imag=4
           read(14,*) nmag4
           allocate(timmag4(nmag4))
           allocate(Fci4(nmag4))
           allocate(FLH4(nmag4))

           do i=1,nmag4
              read(14,'(a)') line
              k=index(line,'Z')
              read(line(1:k),'(a)') datmag
              call decode_datiso(datmag,iy,imo,id,ih,im,is,ims,imc)
              timmag4(i)=float(ih)+float(im)/60. +float(is)/3600.
              read(line(k+1:),*) Bx,By,Bz
              RB=sqrt(Bx**2 +By**2 +Bz**2)
              Fci4(i)=RB*1.52e-2
              FLH4(i)=sqrt(1836.)*6.2832*Fci4(i)
           end do
      endif
      close(14)
   else
        print*, 'Not requested...'
  endif


! ---------------------------------------------------------
  print*, 'Ouverture du fichier PS'
! ---------------------------------------------------------


  mission=manda_param%MISSION_NAME
  experi= manda_param%EXPERIMENT_NAME
  mode    =manda_param%EXPERIMENT_MODE
  rep(1:3)=manda_param%DATA_COORDINATE_SYSTEM(1:3)

  psfile=mission(1:3)//'_'//experi(1:3)//'_'//mode(1:3)//'_'//rep(1:3)//'_'//work(1:8)//'_4Bz.ps'

  tclab=0.35
  tctit=0.35
  tccom=0.25

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)
  call dcolmap_('spectro256')


  titleft=trim(mission)//' / '//trim(experi)//' / '//mode(1:4)//'/ Bz'
  tcl=0.45
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*,manda_param%DATA_LABEL
  units  =manda_param%DATA_UNITS(1:2)
  rep    =manda_param%DATA_COORDINATE_SYSTEM
  titspe =trim(optio_param%SUB_TITLE)

  print*,'plot des titres  et label specifiques de la page'

  titpan=trim(titpan)//' ('//trim(units)//'^2/Hz )'

  fs    =real(const_data%SPIN_PERIOD)
  srasc=const_data%SPIN_GEI_RIGHT_ASCENSION
  sdec =const_data%SPIN_GEI_DECLINATION
  fc   =const_data%FREQUENCY_CUT_OFF

  call plot_tit_spectro_(nbspes,f1,f2,fc,fs,dt,df,sdec,srasc,titpan,titspe,tctit,tccom)

  print*, '=================================='
  print*, 'read 3 others files'
  print*, '=================================='

! --------------------------------------------------------------------------------------
  print*
  print*,'file 2'

  call rff_R_file(2,SP2)
  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspes=0
  it1=1
  it2=nbspe

! select period

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspes=nbspes +1
     if(nbspes == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspes=',nbspe,it1,it2,nbspes
  print*

  deallocate(spebz)
  deallocate(time)
  deallocate(puiz)
  deallocate(bper)

  allocate(spebz(nbspes,nbfre2))
  allocate(time(nbspes))
  allocate(puiz(nbspes))
  allocate(bper(nbspes))


  call load_data
  call check_meta

  if(nbvec /= nbspes) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspes=',nbspes
                      print*, 'nbvec not egal to nbspes'
                      stop 'visu_spectro_4Bz.exe             : *** ERROR !! Program aborted !'
  endif

! save 2st file

  nbvec2=nbvec
  allocate(spebz2(nbvec2,nbfre2))
  allocate(time2(nbvec2))
  allocate(puiz2(nbvec2))
  allocate(bper2(nbvec2))

  spebz2(1:nbvec2,1:nbfre2)=spebz(1:nbvec2,1:nbfre2)
  time2(1:nbvec2)=time(1:nbvec2)
  puiz2(1:nbvec2)=puiz(1:nbvec2)
  bper2(1:nbvec2)=bper(1:nbvec2)

! --------------------------------------------------------------------------------------
  print*
  print*,'file 3'

  call rff_R_file(3,SP3)
  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspes=0
  it1=1
  it2=nbspe

! select period

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspes=nbspes +1
     if(nbspes == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspes=',nbspe,it1,it2,nbspes
  print*

  deallocate(spebz)
  deallocate(time)
  deallocate(puiz)
  deallocate(bper)

  allocate(spebz(nbspes,nbfre2))
  allocate(time(nbspes))
  allocate(puiz(nbspes))
  allocate(bper(nbspes))


  call load_data
  call check_meta

  if(nbvec /= nbspes) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspes=',nbspes
                      print*, 'nbvec not egal to nbspes'
                      stop 'visu_spectro_4Bz.exe             : *** ERROR !! Program aborted !'
  endif

! save 3st file

  nbvec3=nbvec
  allocate(spebz3(nbvec3,nbfre2))
  allocate(time3(nbvec3))
  allocate(puiz3(nbvec3))
  allocate(bper3(nbvec3))

  spebz3(1:nbvec3,1:nbfre2)=spebz(1:nbvec3,1:nbfre2)
  time3(1:nbvec3)=time(1:nbvec3)
  puiz3(1:nbvec3)=puiz(1:nbvec3)
  bper3(1:nbvec3)=bper(1:nbvec3)

! --------------------------------------------------------------------------------------
  print*
  print*,'file 4'

  call rff_R_file(4,SP4)
  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspes=0
  it1=1
  it2=nbspe

! select period

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspes=nbspes +1
     if(nbspes == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspes=',nbspe,it1,it2,nbspes
  print*

  deallocate(spebz)
  deallocate(time)
  deallocate(puiz)
  deallocate(bper)

  allocate(spebz(nbspes,nbfre2))
  allocate(time(nbspes))
  allocate(puiz(nbspes))
  allocate(bper(nbspes))


  call load_data
  call check_meta

  if(nbvec /= nbspes) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspes=',nbspes
                      print*, 'nbvec not egal to nbspes'
                      stop 'visu_spectro_4Bz.exe             : *** ERROR !! Program aborted !'
  endif

! save 4st file

  nbvec4=nbvec
  allocate(spebz4(nbvec4,nbfre2))
  allocate(time4(nbvec4))
  allocate(puiz4(nbvec4))
  allocate(bper4(nbvec4))

  spebz4(1:nbvec4,1:nbfre2)=spebz(1:nbvec4,1:nbfre2)
  time4(1:nbvec4)=time(1:nbvec4)
  puiz4(1:nbvec4)=puiz(1:nbvec4)
  bper4(1:nbvec4)=bper(1:nbvec4)
! --------------------------------------------------------------------------------------

  print*, '--------------------------'
  print*, 'All spectrograms are read'
  print*, '--------------------------'

  deallocate(spebz)
  deallocate(time)
  deallocate(puiz)
  deallocate(bper)
! --------------------------------------------------------------------------------------

! ---------------------------------------------------
! calcul des bornes et graduations en frequence
! ---------------------------------------------------

  print*, 'calcul des graduations en fréquence'

  call cfiggra_(f1,f2,f1aron,f2aron,bgy,sgy,forgy)

  print*, 'f1,f2,f1aron,bgy,sgy=',f1,f2,f1aron,bgy,sgy
  print*, 'fi1,fi2   =',fi1,fi2

! ---------------------------------------------------
! calcul des bornes et graduations en temps
! ---------------------------------------------------

  print*,'bornes en temps et en frequence'

  t1=min(minval(time1),minval(time2),minval(time3),minval(time4))
  t2=max(maxval(time1),maxval(time2),maxval(time3),maxval(time4))

  print*, 't1,t2 (s.)=',t1,t2
  print*, 'f1,f2 (Hz)=',f1,f2

  print*, 'calcul des graduations horaire'

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)

! ---------------------------------------------------
! calcul des seuils pour les 4 images
! ---------------------------------------------------

! passage en log (deviens -8 si egal zero et -10 si negatif)

  valzer=-8.
  valneg=-10.

  call cscalog_(spebz1,nbvec1,nbfre2,valzer,valneg)
  call cscalog_(spebz2,nbvec2,nbfre2,valzer,valneg)
  call cscalog_(spebz3,nbvec3,nbfre2,valzer,valneg)
  call cscalog_(spebz4,nbvec4,nbfre2,valzer,valneg)

  pcmin=10.
  pcmax=1.
print*,'toto'
  call  cscasli_(spebz1,nbvec1,nbfre2,sminz1,smaxz1,pcmin,pcmax)
  call  cscasli_(spebz2,nbvec2,nbfre2,sminz2,smaxz2,pcmin,pcmax)
  call  cscasli_(spebz3,nbvec3,nbfre2,sminz3,smaxz3,pcmin,pcmax)
  call  cscasli_(spebz4,nbvec4,nbfre2,sminz4,smaxz4,pcmin,pcmax)
print*,'toto'

  smin=min(sminz1,sminz2,sminz3,sminz4)
  smax=max(smaxz1,smaxz2,smaxz3,smaxz4)

! pas trop de saturation rouge

  smax=smax+1.

! seuils imposes eventuels

  print*
  print*, 'smin, smax =',smin,smax
  print*, 'p1imp,p2imp=',p1imp,p2imp

  if(p2imp-p1imp.gt.0.001) then
                       smi=p1imp
                       sma=p2imp
                           else
                       smi=smin
                       sma=smax
  endif
!
  print*
  print*, 'Seuils min, max pris en compte   =',smi,sma

! ---------------------------------------------------
! Initialisation des parametres graphiques pour tt les figures
! ---------------------------------------------------


! panel DC-perp only for rep in ISR2,SR2,SRV

  ibpe=0
  if(rep.eq.'ISR2'.or.rep.eq.'SR2'.or.rep.eq.'SRV') ibpe=1
  if(rep.eq.'isr2'.or.rep.eq.'sr2'.or.rep.eq.'srv') ibpe=1

  sizfy=4.

  if(ibpe.eq.1) sizfy=sizfy*0.825
  if(ipos.eq.1) sizfy=sizfy*0.90

  posfy=22.9 -sizfy
  decay=0.40

  sizfx=15.
  posfx=3.

  sbla=smi -1.
  swhi=sma +10.

  call dfigsiz_(sizfx,sizfy)
  call dlinwid_(2.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)
  call dgrasiz_(0.0,tcgra)
  call dstisiz_(0.25,0.13)
  call dstipos_('oi','oo')
  call dlabseny('h')
  call dfiglim_(t1,t2,f1,f2)

  print*, 'Spectrogramme C1 ...'
!
!  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)

  allocate(image(nbvec1,nbfre2))
  call cscaima_(spebz1,nbvec1,nbfre2,smi,sma,image,sbla,swhi)
  call ppagima_(posfx,posfy,-1,sizfx,sizfy,0.,image,nbvec1,nbfre2)
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(1)(1:2))
  
  if(nmag1 > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag1,FLH1,nmag1)
               call dlincol_('w')
               call pfigcur_(timmag1,Fci1,nmag1)
               call dlinwid_(wid)
  endif
  
  call dlincol_('n')

! plot du label "frequency" pour la 1ere figure

  call ppagcha_(1.6,posfy+sizfy/2.,0,0.28,0.28,90.,laby1)


  print*, 'Spectrogramme C2 ...'
!
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)

  deallocate(image)
  allocate(image(nbvec2,nbfre2))
  call cscaima_(spebz2,nbvec2,nbfre2,smi,sma,image,sbla,swhi)
  call ppagima_(posfx,posfy,-1,sizfx,sizfy,0.,image,nbvec2,nbfre2)
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(2)(1:2))
  
  if(nmag2 > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag2,FLH2,nmag2)
               call dlincol_('w')
               call pfigcur_(timmag2,Fci2,nmag2)
               call dlinwid_(wid)
  endif
  
  call dlincol_('n')


  print*, 'Spectrogramme C3 ...'
!
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)

  deallocate(image)
  allocate(image(nbvec3,nbfre2))
  call cscaima_(spebz3,nbvec3,nbfre2,smi,sma,image,sbla,swhi)
  call ppagima_(posfx,posfy,-1,sizfx,sizfy,0.,image,nbvec3,nbfre2)
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(3)(1:2))
  
  if(nmag3 > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag3,FLH3,nmag3)
               call dlincol_('w')
               call pfigcur_(timmag3,Fci3,nmag3)
               call dlinwid_(wid)
  endif
  
  call dlincol_('n')


  print*, 'Spectrogramme C4 ...'

  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)

  deallocate(image)
  allocate(image(nbvec4,nbfre2))
  call cscaima_(spebz4,nbvec4,nbfre2,smi,sma,image,sbla,swhi)
  call ppagima_(posfx,posfy,-1,sizfx,sizfy,0.,image,nbvec4,nbfre2)
  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(f1aron+bgy,bgy,sgy,forgy)
  call ppagcha_(0.4,posfy+sizfy/2.,-1,0.4,0.4,0.,laby(4)(1:2))
  
  if(nmag4 > 0) then
               call glinwid_(wid)
               call dlinwid_(6.)
               call dlincol_('r')
               call pfigcur_(timmag4,FLH4,nmag4)
               call dlincol_('w')
               call pfigcur_(timmag4,Fci4,nmag4)
               call dlinwid_(wid)
  endif
  
  call dlincol_('n')


! ---------------------------------------------------
!  plot des puissances integrees
! ---------------------------------------------------

  print*, 'Puissances integrees ...'

  if(ibpe == 1 ) then
                 sizfy=2.5
                 grax=0.
                 else
                 sizfy=3.5
                 grax=tcgra
  endif

  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(grax,0.25)
  call dstipos_('oi','oo')

  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  print*,'posfx,posfy',posfx,posfy

  titpui=trim(titpui)//' ('//trim(units)//'^2)'
  call plotpuiint(time1,puiz1,time2,puiz2,time3,puiz3,time4,puiz4,&
                  nbvec1,nbvec2,nbvec3,nbvec4,titpui,fi1,fi2,smin,smax,t1,t2)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

! ---------------------------------------------------
!     plot de Bperp (avec graduations en temps taille normale)
! ---------------------------------------------------

  if(ibpe == 1 ) then

     print*, 'Bperp ...'

     posfy=posfy-sizfy-decay
     call dfigori_(posfx,posfy)

     call cminmax_(bper1,nbvec1,y1min,y1max)
     call cfiggra_(y1min,y1max,ymin,ymax,bgy,sgy,forgy)

     call dfiglimy(ymin,ymax)
     call dgrasiz_(tcgra,0.25)

     call pfigfra_
     call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
     call pfiggray(0.,bgy,sgy,forgy)

     call dlincol_('n')
     call pfigcur_(time1,bper1,nbvec1)
     call dlincol_('r')
     call pfigcur_(time2,bper2,nbvec2)
     call dlincol_('g')
     call pfigcur_(time3,bper3,nbvec3)
     call dlincol_('b')
     call pfigcur_(time4,bper4,nbvec4)

     titper=trim(titper)//' ('//trim(units)//')'
     call ppagcha_(0.6,posfy+sizfy/2.,0,0.24,0.24,90.,trim(titper))
  endif
  
! ---------------------------------------------------
! *** plot des positions
! ---------------------------------------------------

  if(npos > 0) then
               print*,'plot of positions'
               if(nbgma > 6) then
                             kgma=2
                             else
                             kgma=1
               endif              
               i1=1
               valpopo=0.
               do k=1,nbgma,kgma
                  do i=i1,npos-1
                     if(timpos(i) .le. valgra(k) .and. timpos(i+1) .ge. valgra(k)) then
                         valpopo(1:3,k)=valpos(1:3,i)
                         i1=i
                         exit
                     endif
                  end do
               end do
               
      if(mission == 'CLUSTER') valpopo(1:3,1:nbgma)=valpopo(1:3,1:nbgma)/6378.
  
      do k=1,nbgma-1,kgma
         call cfigpag_(valgra(k),ymin,xx,yy)
         write(line,'(f8.2)') valpopo(1,k)
         call ppagcha_(xx,yy-1.2,0,tcgra,tcgra,0.,line)
         write(line,'(f8.2)') valpopo(2,k)
         call ppagcha_(xx,yy-1.2-1.5*tcgra,0,tcgra,tcgra,0.,line)
         write(line,'(f8.2)') valpopo(3,k)
         call ppagcha_(xx,yy-1.2-3*tcgra,0,tcgra,tcgra,0.,line)
      end do
  
      call ppagcha_(0.5,posfy-1.7,-1,tctit,tctit,0.,'Pos C3')
   
  endif

! ---------------------------------------------------
! *** plot du symbole UT et de la mire
! ---------------------------------------------------

  call ppagcha_(0.5,posfy-0.35-tctit,-1,tctit,tctit,0.,'UT')

  call plotpalhsbx(13.5,pagsy-2.7,4.5,0.5,smi,sma,0.2)

! ---------------------------------------------------
! fermeture du fichier psfile et fin du programme
! ---------------------------------------------------

  print*, 'termine pour ce plot, psfile=',trim(psfile)
  print*

  call dclogra_

  print*, 'visu_spectro_4Bz.exe             : NORMAL TERMINATION'
     stop 'visu_spectro_4Bz.exe             : NORMAL TERMINATION'

!---------------------------------------------------------------------+--
  contains
!---------------------------------------------------------------------+--
  subroutine co_ind

  print*, 'calcul des indices pour les frequences et les puiss integrees'


! bornes du spectro

  if(f1.lt.0.) f1=0.
  if(f2.lt.1.e-10) f2=nbfre*df

  if1=int(f1/df +0.5)
  if2=int(f2/df +0.5)

  if(if1.lt.1) if1=1
  if(if2.gt.nbfre) if2=nbfre

! bornes des pui int

  if(fi1.lt.f1) fi1=f1
  if(fi2.gt.f2) fi2=f2

  if(fi1.lt. 1.e-10) fi1=1.e-2
  if(fi2.lt. 1.e-10) fi2=f2

  ip1=int(fi1/df +0.5)
  ip2=int(fi2/df +0.5)

  if(ip1.lt.if1) ip1=if1
  if(ip2.gt.if2) ip2=if2

  if(ip1.lt.3) ip1=3
  if(ip2.gt.nbfre) ip2=nbfre

  end subroutine co_ind

!---------------------------------------------------------------------+--

  subroutine load_data

  read(manda_param%DATA_FILL_VALUE,*) filval

  nbvec=0

  print*
  print*,'load_data: it1,it2,nbspe2  =',it1,it2,nbspe2
  print*,'load_data: if1,if2,f1, f2  =',if1,if2,f1,f2
  print*,'load_data: ip1,ip2,fi1,fi2 =',ip1,ip2,fi1,fi2

  ip1c=ip1 -if1+1
  ip2c=ip2 -if1+1
  print*
  print*, 'load_data: ip1c,ip2c=',ip1c,ip2c

  do i=it1,it2

     nbvec=nbvec+1
     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     time(nbvec)=decsec/3600.

     spebz(nbvec,:)=(R_DATA_MATRIX(5,if1:if2,i)**2 +R_DATA_MATRIX(6,if1:if2,i)**2)/df

     puiz(nbvec)=sum(spebz(nbvec,ip1c:ip2c))*df

     bper(nbvec)=sqrt(R_DATA_MATRIX(1,1,i)**2 +R_DATA_MATRIX(3,1,i)**2)
  end do

  deallocate(data_index)
  deallocate(R_DATA_MATRIX)

  end subroutine load_data

!---------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'Spectrogram') THEN
     write(*,*) '*** Only Spectrogram FILE_CLASS is allowed'
     stop 'visu_spectro_4Bz.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_spectro_4Bz.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_spectro_4Bz.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Matrix') THEN
     write(*,*) '*** Only Matrix DATA_FORM is allowed'
     stop 'visu_spectro_4Bz.exe                 : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!---------------------------------------------------------------------+--

  END program visu_spectro_4Bz

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plot_tit_spectro_(nbp,f1,f2,fc,fs,dtspe,dfspe,     &
            sdec,srasc,titpan,titspe,tctit,tccom)

!     ---------------------------------------------------------------+--
!     plot des titres et parametres
!     ---------------------------------------------------------------+--

  character*140 work
  character*(*) titpan
  character*(*) titspe

  character*120 form
  character*12 fornbp

  call gpagsiz_(pagsx,pagsy)
  call gfigsiz_(sizfx,sizfy)
  call gfigori_(posfx,posfy)

! *** plot des titres et differents parametres

  print*, 'plot des titres et parametres...'

  call dfontyp_('h')

! *   titre general

  call ppagcha_(4.8,pagsy-2.8,-1,tctit,tctit,0.,trim(titpan))

! *   titre de l'ensemble des pannels

  call ppagcha_(4.,pagsy-3.5,-1,tccom,tccom,0.,trim(titspe))

! *   Nbp, dt, etc.

  call cbesfori(nbp,fornbp)

  form='("N=",'//fornbp//',"  dt=",f8.4," s df=",f7.4," Hz  Fc=",f6.4," F1=",f6.2," F2=",f8.2)'
  write(work,form)nbp,dtspe,dfspe,fc,f1,f2
  call cchalen_(work,nw)
  call ppagcha_(4.,pagsy-3.9,-1,tccom,tccom,0.,work(1:nw))
  print*, work(1:nw)

! *   Spin Rasc,dec

  if(abs(sdec) .gt.360. .or. abs(srasc) .gt. 360. .or. abs(fs) .gt. 10.) return
  if(abs(sdec) .gt.0. .and. abs(srasc).gt.0. .and. abs(fs).gt.0.) then

      work='S_dec    S_rasc     S_freq'
      call cchalen_(work,nw)
      call ppagcha_(0.3,pagsy-2.3,-1,tccom,tccom,0,work(1:nw))
      print*, work(1:nw)

      form='(f7.2,"  ",f7.2,"   ",f8.6)'
      write(work,form)sdec,srasc,fs
      call cchalen_(work,nw)
      call ppagcha_(0.2,pagsy-2.7,-1,tccom,tccom,0.,work(1:nw))
      print*, work(1:nw)

  endif

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plotpuiint(time1,puiz1,time2,puiz2,time3,puiz3,time4,puiz4,&
                       nbvec1,nbvec2,nbvec3,nbvec4,titpui,fi1,fi2,smi,sma,t1,t2)

!     ---------------------------------------------------------------+--
!     Plot la puissances integrees
!     ---------------------------------------------------------------+--

  character*8 for1,for2
  character*64 titpui,lab1,lab2,laba
  real time1(nbvec1),time2(nbvec2),time3(nbvec3),time4(nbvec4)
  real puiz1(nbvec1),puiz2(nbvec2),puiz3(nbvec3),puiz4(nbvec4)


  call gfigsiz_(sizfx,sizfy)
  call gfigori_(posfx,posfy)

  asmi=10.**(int(smi))
  asma=10.**(int(sma)+2)

  print*, 'pui  voulues=',smi,sma
  print*, 'val imposees=',asmi,asma

  ! check zero values

  do i=1,nbvec1
     if(puiz1(i).lt.asmi) puiz1(i)=asmi
  end do  

  do i=1,nbvec2
     if(puiz2(i).lt.asmi) puiz2(i)=asmi
  end do

  do i=1,nbvec3
     if(puiz3(i).lt.asmi) puiz3(i)=asmi
  end do

  do i=1,nbvec4
     if(puiz4(i).lt.asmi) puiz4(i)=asmi
  end do

! *** calcul des graduations y

  call dgrastyy(1)
  call cfiggral(asmi,asma,ymin,ymax)
  call dfiglimx(t1,t2)
  call dfiglimy(ymin,ymax)
  call pfiggrly(1)

! *** calcul des labels du pannel des puissances

! *   label

  print*, 'fi1,fi2=',fi1,fi2

  call cbesfor_(fi1,for1)
  call cbesfor_(fi2,for2)

  write(lab1,for1) fi1
  write(lab2,for2) fi2

  call cchalen_(lab1,n1)
  call cchalen_(lab2,n2)

  laba=lab1(1:n1)//' - '//lab2(1:n2)//' Hz'

! *** plot du pannel des puissances

  call pfigfra_
  call ppagcha_(0.6,posfy+sizfy/2.,0,0.24,0.24,90.,titpui)

  call dlincol_('n')
  call pfigcur_(time1,puiz1,nbvec1)
  call dlincol_('r')
  call pfigcur_(time2,puiz2,nbvec2)
  call dlincol_('g')
  call pfigcur_(time3,puiz3,nbvec3)
  call dlincol_('b')
  call pfigcur_(time4,puiz4,nbvec4)
  call dlincol_('n')

  call ppagcha_(1.2,posfy+sizfy/2.,0,0.24,0.24,90.,laba)

  call dgrastyy(0)

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
