#!/bin/bash


if test -d sat_trajectory
   then rm -rf sat_trajectory
fi

mkdir sat_trajectory
cd sat_trajectory

# 124252.735203443d0   # Apogee 
# 26321.1522350593d0   # Perigee
# 
# 2001-02-24T15:17:23.000Z   # Perigee Time
# 
# -0.9493840 0.3011743 0.0892410 # Dir. of semi-major axis
# 0.0820478 -0.0364760 0.9959607 # Dir. of semi-minor axis
# 5.0   # Time resolution, mn


RPC_compute_sat_trajectory 124252.735203443d0 26321.1522350593d0  \
                       "2001-02-24T15:17:23.000000Z"              \
                       -0.9493840   0.3011743   0.0892410     \
                        0.0820478  -0.0364760   0.9959607  5.0 \
                       sat_trajectory.rff 1.

RPC_visu_vectime_3D sat_trajectory.rff 0 0

RPC_change_coordinate_system sat_trajectory.rff gse sat_trajectory_gse.rff

RPC_visu_vectime_3D sat_trajectory_gse.rff 0 0


