#!/bin/bash

# ==============================================================
# Tests of RPC_join_vectime to do spectrogram around midnight
# ==============================================================

appli=`basename $0`
alarm="*** $appli : BAD TERMINATION, ABORTED!"

RPC_get_data_GEOULF VTL2 2 1980 06 06
if test $? != 0 ; then echo $alarm ; exit 1 ; fi

RPC_get_data_GEOULF VTL2 2 1980 06 07
if test $? != 0 ; then echo $alarm ; exit 2 ; fi

RPC_join_vectime GEOS2_ULF_VTL2_19800606.rff GEOS2_ULF_VTL2_19800607.rff GEOS2_ULF_VTL2_198006_06_07.rff
if test $? != 0 ; then echo $alarm ; exit 3 ; fi

RPC_reduce_time_vectime GEOS2_ULF_VTL2_198006_06_07.rff  GEOS2_ULF_VTL2_198006_06_07_red.rff   1980-06-06T22:00:00.000Z 1980-06-07T02:00:00.000Z
if test $? != 0 ; then echo $alarm ; exit 4 ; fi

RPC_vectime_to_spectro GEOS2_ULF_VTL2_198006_06_07_red.rff GEOS2_ULF_SPL2_198006_06_07_red.rff 512 512 t
if test $? != 0 ; then echo $alarm ; exit 5 ; fi

RPC_visu_spectro GEOS2_ULF_SPL2_198006_06_07_red.rff 0 0 0 0 -6. -2. XY 0.5 0. y
if test $? != 0 ; then echo $alarm ; exit 6 ; fi



