#!/bin/bash

# ---------------------------------------------------------------
# compare tous les fichiers de l'arborescence dont la taille
# est donnee en argument (octets)
#
# shell de servitude de la commande RPC_search_duplicates
# 
# ex : compare_size.bash 1040081 blabla
# Patrick ROBERT,  Novembre 2010
# ---------------------------------------------------------------


appli=`basename $0`
appli36=`echo "$appli                                 " | cut -c1-36`
Narg=2

if test $# != $Narg
   then
   echo "$appli : compare all files in the tree having the given size (octets)"
   echo "$appli   require $Narg argument(s), ex:"
   echo "$appli   size word mode"
   echo "    size : size in octets, ex: 1040081"
   echo "    word : any word as comment for output"
   echo ""
   echo "$appli36 : *** ERROR !! Command aborted !!"
   exit 1
fi

Fsize=$1

# liste des fichiers dont la taille est $Fsize en octets

find . -size $Fsize"c" > tata1.tmp

# on traite les noms de fichiers avec des blanc ou des parentheses

cat tata1.tmp | sed -e "/zz_fin.jpg/d" -e "s/ /?/g" -e "s/(/?/" -e "s/)/?/" > tata2.tmp

nbfiles=`cat tata2.tmp | wc -l `
rm tata1.tmp 

#echo "---------------------------------------------"
echo "Compare $nbfiles files of size $Fsize  	$2"

# comparaison des fichiers 2 a 2
# ------------------------------

imax=`expr $nbfiles - 1`

for i in `seq 1 $imax`
do
   j1=`expr $i + 1`
   for j in `seq $j1 $nbfiles`
   do
      file1=`sed "$i!d" tata2.tmp`
      file2=`sed "$j!d" tata2.tmp`
      
      cmp $file1 $file2 > /dev/null
      if test $? = 0
         then echo  
              echo $file1
              echo $file2
              echo "--> *** same"
      fi
   done
done 

rm tata2.tmp 

# ----------------------------------------------------------------------
