#!/bin/bash

# -------------------------------------------------------
# RPC Project :
# Run appli name given in argument for all RPC commandes
# appli.in must have been created
# P. Robert, LPP, 2011-03-21
# -------------------------------------------------------

appli32=`echo "$appli                                 " | cut -c1-32`

# check if input file exist

if test ! -f $appli.in
   then echo "*** $appli.in does not exist "
        echo "RPC_$appli32 : *** ERROR ! Command aborted." >&2
        exit 1
fi

# rename possible existing appli.out file

if test -f $appli.out ; then mv $appli.out $appli.out.old ; fi

# run appli.exe

datim1=`date +%F'  '%H':'%M':'%S `
julsec1=`date +%s`

echo " -------------------------------------------------------------------"
path=$RPC_DIR/bin/$appli.exe
echo " Run of $appli.exe :"
echo "     - arguments are taken from $appli.in text file"
echo "     - execution report will be available in $appli.out text file"
echo " Run of $appli.exe, please wait..."
echo ""

$path < $appli.in > $appli.out

echo "==>  $appli.out text file available"

datim2=`date +%F'  '%H':'%M':'%S `
julsec2=`date +%s`
diff=`expr $julsec2 - $julsec1`

diffm=`echo "scale=2; $diff/60." | bc `

echo ""
echo " Starting time $run_appli : $datim1"
echo " Ending   time $run_appli : $datim2"
echo " Duration      $run_appli : $diff sec.  ($diffm mn.)"

grep ": NORMAL TERMINATION" $appli.out > /dev/null
err=$?
if test $err != 0
   then
   echo " RPC_$appli32 : *** ERROR ! Command aborted." >&2
   exit 9
   else
   echo
   echo " $appli36 : NORMAL TERMINATION - time exe= $diff s." >&2
fi

echo " -------------------------------------------------------------------"
