 #!/bin/bash

# ----------------------------------------------------------------------------
# execute les options d'impression selon les variables
# d'environnement pr-dfinies
# ces executions dpendent du sytme
#
# R_VISU_SPLASH = yes entraine la creation d'un pdf a partir du .ps
#                     et sa visualiosion a l'ecran via $R_SOFT_SPLASH
#                     defini dans le RPC_config (acroread sous linux)
#
# pour la production de plot en serie, il est necessaire de 
# faire R_VISU_SPLASH = no pour eviter l'accumulation de fenetres sur l'ecran
#
# $R_VISU_PNG= yes_300 entraine la creation d'un .png a partir du .ps
#                      a 300 ppp (dpi)
#
# $R_VISU_PDF = yes ou $R_VISU_SPLASH = yes entraine la creation du pdf
#                                       avec visu a l'ecran ou non
#
# P. Robert, 2012/11/27
# ----------------------------------------------------------------------------

nomps=$1

if test -f $nomps
   then echo " $nomps    existing"
   else echo " $nomps*** not existing"
   exit 1
fi
# on evite que le nom generique du PS soit utilise ailleurs

gen=`basename $nomps .ps`
mv $nomps $gen"_"$$.ps
nomps=$gen"_"$$.ps

# fabrication eventuelle du pdf (obligatoire si R_VISUSPLASH=yes)

if ((test $R_VISU_PDF = yes ) || (test $R_VISU_SPLASH = yes )) ; then RPC_ps_to_pdf $nomps ; fi

# fabrication eventuelle du png

vispng=`echo $R_VISU_PNG | cut -d"_" -f1`
respng=`echo $R_VISU_PNG | cut -d"_" -f2`
colpng=`echo $R_VISU_PNG | cut -d"_" -f3`

if (test $vispng = yes ) ; then RPC_ps_to_png $nomps $respng $colpng; fi

# sortie ecran du pdf

nompdf=`basename $nomps .ps`.pdf

if (test $R_VISU_SPLASH = yes) 
    then 
        which $R_SOFT_SPLASH > /dev/null
        if (test $? != 0 )
	    then echo "Command $R_SOFT_SPLASH not installed on your system"
	         echo "Splash visu is not possible"
	         echo "*** error run_options_visu.bash, command aborted !"
                 exit 1
        fi  
        echo " Running $R_SOFT_SPLASH on $nompdf ..."
        $R_SOFT_SPLASH $nompdf  > /dev/null 2>&1 &
fi

# end
# ----------------------------------------------------------------------------
