#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_Polar_plot.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 15 
   then
     echo "this script requires 15 arguments:"
     echo "yymmdd T1 T2 satnum bitrate repere, N_FFT, f1, f2, apod, XY, f1pow, seuil, p1,p2"
     echo "Examples:"
     echo 'do_CLUSTA_Polar_plot.sh 20010923  090000 103000 2 NBR ISR2   512  0.   8.0  t XY  1. -5.  -6. 0.'
     echo 'do_CLUSTA_Polar_plot.sh 20010923  090000 103000 2 NBR GSE    512  0.   8.0  t XY  1. -5.  -6. 0.'
     echo 'do_CLUSTA_Polar_plot.sh 20040130  164700 164800 2 HBR GSE    128 50. 225.   t XY 50. -5.5 -6. 0.'
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
satnum=$4
bitrate=$5
repere=$6
N_FFT=$7
f1=$8
shift 8
f2=$1
apod=$2
XY=$3
f1pow=$4
seuil=$5
p1=$6
p2=$7


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $bitrate $repere $N_FFT $f1 $f2 $apod $XY $f1pow $seuil
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUSTA_VTL2"
echo "    RPC_get_data_CLUFGM"
echo "    RPC_vectime_to_mfa_CLUSTA"
echo "    RPC_vectime_to_spectro"
echo "    RPC_date_time_to_datiso"
echo "    RPC_visu_spectro_add_mag_pos"
echo "    RPC_spectro_to_polar"
echo "    RPC_visu_polar"

echo
echo "1) Get CLUSTA RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_CLUSTA_VTL2 $satnum $yy $mm $dd $bitrate $repere
if test $? != 0 ; then echo ; echo "*** $0 exit on error 1" >&2; exit 1 ; fi
VTL2_STA=`head -1 get_data_CLUSTA_VTL2.out`

echo
echo "2) Get CLUFGM RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_get_data_CLUFGM $satnum $yy $mm $dd SPIN 
if test $? != 0
       then echo "*** no SPIN rff file, proc. aborted" 
            echo "*** $0 exit on error 2" >&2; exit 2 
fi

VTL2_FGM=`head -1 get_data_CLUFGM.out`

echo
echo "3) transform CLUSTA to MFA system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_MFA=`basename $VTL2_STA .rff`_mfa.rff
RPC_vectime_to_mfa_CLUSTA $VTL2_STA $VT_MFA $VTL2_FGM
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi

echo
echo "4) create SPL2 spectrogram in MFA"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

SPfilnam=`echo $VT_MFA | sed 's/VT/SP/'`
RPC_vectime_to_spectro $VT_MFA $SPfilnam $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 4 ; fi

echo
echo "5) Visualize MFA spectrogram in Right/Left components"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

if test $bitrate = HBR
   then 
        p1=-9.
        p2=-3.
   else
        p1=-7.
        p2=-1.
fi
datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`
RPC_visu_spectro  $SPfilnam  $datiso1 $datiso2 $f1 $f2  $p1 $p2 LR $f1 $f2 y
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo
echo "6) compute polarisation"
echo "   xxxxxxxxxxxxxxxxxxxx"

RPC_spectro_to_polar $SPfilnam copolar.resu
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 6 ; fi

echo
echo "7) Visualise polarisation results"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_polar copolar.resu 0 0 $seuil $f1 $f2 $p1 $p2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 7 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
