#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_SP_plot_CLUFGM_4Bz.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 12 
   then
     echo "this script requires 11 arguments:"
     echo "yymmdd T1 T2 mode, N_FFT, f1, f2, apod, pmin,pmax,f1pow,"
     echo "Examples:"
     echo 'do_SP_plot_CLUFGM_4Bz.sh 20010923  090000 103000  FULL   512  0.  8.0  t  -7.  0. 0.02  10.'
     echo 'do_SP_plot_CLUFGM_4Bz.sh 20010923  090000 103000  5VPS   256  0.  2.5  t  -5.  1. 0.02   2.5'
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
mode=$4
N_FFT=$5
f1=$6
f2=$7
apod=$8
shift 8
pmin=$1
pmax=$2
f1pow=$3
f2pow=$4


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $mode $N_FFT $f1 $f2 $apod $XY $f1pow $y1av $y2av
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUFGM"
echo "    RPC_vectime_to_spectro"
echo "    RPC_visu_spectro_4Bz"

echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`


for Satnum in 1 2 3 4
    do
    RPC_get_data_CLUFGM $Satnum $yy $mm $dd $mode 

if test -f get_data_CLUFGM.out
   then VTfilnam=`head -1 get_data_CLUFGM.out`
   else
   echo " *** no data for $Satnum"
   echo "$alarm" >&2 ; exit 1
fi


if test -f $VTfilnam
   then 
   echo "file taken: $VTfilnam "
   else
   echo " $VTfilnam not found"
   echo "$alarm" >&2 ; exit 12
fi

if test $Satnum = 1 ; then VT1=$VTfilnam ; fi
if test $Satnum = 2 ; then VT2=$VTfilnam ; fi
if test $Satnum = 3 ; then VT3=$VTfilnam ; fi
if test $Satnum = 4 ; then VT4=$VTfilnam ; fi

done

echo
echo "2) create SPL2 spectrogram"
echo "   xxxxxxxxxxxxxxxxxxxxxxx"


SP1=`echo $VT1 | sed 's/VT/SP/'` ; SP1=`basename $SP1`
SP2=`echo $VT2 | sed 's/VT/SP/'` ; SP2=`basename $SP2`
SP3=`echo $VT3 | sed 's/VT/SP/'` ; SP3=`basename $SP3`
SP4=`echo $VT4 | sed 's/VT/SP/'` ; SP4=`basename $SP4`

RPC_vectime_to_spectro $VT1 $SP1 $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi
RPC_vectime_to_spectro $VT2 $SP2 $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi
RPC_vectime_to_spectro $VT3 $SP3 $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi
RPC_vectime_to_spectro $VT4 $SP4 $N_FFT $N_FFT $apod
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi

echo
echo "3) Visualise SPL2 4Bz spectrogram file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_spectro_4Bz $SP1 $SP2 $SP3 $SP4 $datiso1 $datiso2 $f1 $f2 $pmin $pmax $f1pow $f2pow y
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 4 ; fi


echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
