#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_SP_plot_CLUSTA_from_VTL1.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 13
   then
     echo "this script requires 13 arguments:"
     echo "yymmdd T1 T2 satnum bitrate  N_FFT f1 f2 apod XY f1pow y1av y2av"
     echo "Examples:"
     echo 'do_SP_plot_CLUSTA_from_VTL1.sh 20010923  090000 103000 2 NBR  512  0.   8.0  t XY 1.  -6.  1. '
     echo 'do_SP_plot_CLUSTA_from_VTL1.sh 20040130  164700 164800 2 HBR  128  0. 225.   t XY 1. -10. -3. '
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
satnum=$4
bitrate=$5
N_FFT=$6
f1=$7
f2=$8
shift 8
apod=$1
XY=$2
f1pow=$3
y1av=$4
y2av=$5

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $bitrate $N_FFT $f1 $f2 $apod $XY $f1pow $y1av $y2av
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUSTA_VTL1"
echo "    RPC_vectime_L1_to_spectro_L2_CLUSTA"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"


echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_CLUSTA_VTL1 $satnum $yy $mm $dd $bitrate 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

VTfilnam=`head -1 get_data_CLUSTA_VTL1.out`

if test -f $VTfilnam
   then 
   echo "file taken: $VTfilnam "
   else
   echo " $VTfilnam not found"
   echo "$alarm" >&2 ; exit 2
fi

echo
echo "2) create SPL2 spectrogram"
echo "   xxxxxxxxxxxxxxxxxxxxxxx"


SPfilnam=`echo $VTfilnam | sed 's/VT/SP/'`
SPfilnam=`basename $SPfilnam`
fdet=0.
fc=0.1
step=5
RPC_vectime_L1_to_spectro_L2_CLUSTA $VTfilnam $SPfilnam  $fdet $fc $f1 $f2 $step $N_FFT $N_FFT $apod

if test $? != 0 
   then echo 
        echo "*** $0 exit on error $?" >&2
        exit 3 
fi
echo
echo "3) Visualise SPL2 spectrogram file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_spectro $SPfilnam $datiso1 $datiso2 $f1 $f2 $y1av $y2av $XY $f1pow $f2 y
if test $? != 0 
   then echo 
        echo "*** $0 exit on error$?" >&2
        exit 4 
fi

echo
echo "4) Visualise average spectrum"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_visu_ave_spectrum $SPfilnam $datiso1 $datiso2 $f1 $f2 $y1av $y2av $XY 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 5 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
