#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_CLUSTA_VT_plot.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 6 
   then
     echo "this script requires 6 arguments:"
     echo "yymmdd T1 T2 satnum bitrate repere"
     echo "Examples:"
     echo 'do_CLUSTA_VT_plot.sh 20010923  092000 093000 2 NBR ISR2 '
     echo 'do_CLUSTA_VT_plot.sh 20010923  092000 093000 2 NBR GSE  '
     echo 'do_CLUSTA_VT_plot.sh 20040130  164710 164730 2 HBR GSE  '
     echo
     echo "$alarm" >&2 ; exit 11
fi

yymmdd=$1
hhmmss1=$2
hhmmss2=$3
satnum=$4
bitrate=$5
repere=$6

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $bitrate $repere 
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUSTA_VTL2"
echo "    RPC_visu_vectime"


echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_CLUSTA_VTL2 $satnum $yy $mm $dd $bitrate $repere

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

VTfilnam=`head -1 get_data_CLUSTA_VTL2.out`

if test -f $VTfilnam
   then 
   echo "file taken: $VTfilnam "
   else
   echo " $VTfilnam not found"
   echo "$alarm" >&2 ; exit 2
fi

echo
echo "2) Visualise Vectime"
echo "   xxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_vectime $VTfilnam $datiso1 $datiso2 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
