#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_compare_STA_FGM_CLUSTER.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 5 
   then
     echo "this script requires 5 arguments:"
     echo "satnum yymmdd T1 T2 mode"
     echo "Examples:"
     echo 'do_compare_STA_FGM.sh  1  20010923  092000 093000 NBR'
     echo 'do_compare_STA_FGM.sh  3  20010110  000000 020000 NBR'
     echo
     echo "$alarm" >&2 ; exit 1
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4
mode=$5


echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 $satnum $bitrate $repere 
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_CLUSTA_VTL2"
echo "    RPC_get_data_CLUFGM"
echo "    RPC_add_DxDy_to_BxBy"
echo "    RPC_vectime_gse_to_isr2"
echo "    RPC_visu_2_vectime"


echo
echo "1) Get CLUSTA RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_CLUSTA_VTL2 $satnum $yy $mm $dd $mode ISR2

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 2
fi

VT_ULF=`head -1 get_data_CLUSTA_VTL2.out`

if test -f $VT_ULF
   then 
   echo "file taken: $VT_ULF "
   else
   echo " $VT_ULF not found"
   echo "$alarm" >&2 ; exit 3
fi

echo
echo "2) Get MAG RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_get_data_CLUFGM $satnum $yy $mm $dd 5VPS

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 4
fi

VT_MAG=`head -1 get_data_CLUFGM.out`

if test -f $VT_MAG
   then 
   echo "file taken: $VT_MAG "
   else
   echo " $VT_MAG not found"
   echo "$alarm" >&2 ; exit 5
fi

echo
echo "3) Transform FGM in ISR2 system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxx"

echo "   extract right asc. and deci. from STA file..."

rasc=`head -200 $VT_ULF | grep SPIN_GEI_RIGHT_ASCENSION`
rasc=`echo $rasc | sed "s/.*://"`

decl=`head -200 $VT_ULF | grep SPIN_GEI_DECLINATION`
decl=`echo $decl | sed "s/.*://"`

echo "rasc=$rasc"
echo "decl=$decl"

VT_MAG_ISR2=`basename $VT_MAG .rff`_ISR2.rff

RPC_vectime_gse_to_isr2 $VT_MAG $rasc $decl $VT_MAG_ISR2

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 6
fi

if test -f $VT_MAG_ISR2
   then 
   echo "file taken: $VT_MAG_ISR2"
   else
   echo " $VT_MAG_SRV not found"
   echo "$alarm" >&2 ; exit 7
fi

echo
echo "4) add DxDy to BxBy in ULF file"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VT_ULF_DXDY=`basename $VT_ULF .rff`_DxDy.rff

RPC_add_DxDy_to_BxBy $VT_ULF $VT_ULF_DXDY

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 6
fi

if test -f $VT_ULF_DXDY
   then 
   echo "file taken: $VT_ULF_DXDY "
   else
   echo " $VT_ULF_DXDY not found"
   echo "$alarm" >&2 ; exit 7
fi

echo
echo "2) Visualise 2 Vectime"
echo "   xxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_2_vectime $VT_ULF_DXDY $VT_MAG_ISR2 $datiso1 $datiso2 
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 8 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
