#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_3D_plot_GEOPOS.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

# test on the number of input arguments

if test $# != 4 
   then
     echo "this script requires 4 arguments:"
     echo "yymmdd T1 T2 "
     echo "Examples:"
     echo 'do_3D_plot_GEOPOS.sh 2 19780810  0 0 '
     echo 'do_3D_plot_GEOPOS.sh 2 19780810  090000 150000'
     echo
     echo "$alarm" >&2 ; exit 11
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4

echo "Commande:"
echo $com  $yymmdd $hhmmss1 $hhmmss2 
echo

echo "This command use the following RPC generic commands:"
echo "    RPC_get_data_GEOPOS"
echo "    RPC_change_coordinate_system"
echo "    RPC_visu_vectime_3D"

echo
echo "1) Get RFF file from RFF database"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

RPC_get_data_GEOPOS $satnum $yy $mm $dd 

if test $? != 0
   then
   echo " *** file not found, exit $com"
   echo "$alarm" >&2 ; exit 1
fi

VTL2=` sed -n '1p' get_data_GEOPOS.out` ; if test $? != 0 ; then echo $fnf ;echo "$alarm" >&2 ; exit 1 ;fi

echo
echo "2) visualize 3D positions"
echo "   xxxxxxxxxxxxxxxxxxxxxx"

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

RPC_visu_vectime_3D  $VTL2  $datiso1 $datiso2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi


echo
echo "2) visualize 3D positions in GSE"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"

VTL2_gse=`basename $VTL2 .rff`_gse.rff
RPC_change_coordinate_system $VTL2 gse $VTL2_gse

RPC_visu_vectime_3D  $VTL2_gse $datiso1 $datiso2
if test $? != 0 ; then echo ; echo "*** $0 exit on error $?" >&2; exit 3 ; fi

echo "$0 done !"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
