#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_simulated_orbit_GEOPOS RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script do_simulated_orbit_GEOPOS aborted"

# test on the number of input arguments

if test $# != 4 
   then
     echo "this script requires 4 arguments:"
     echo "satnum yymmdd T1 T2  "
     echo "Examples:"
     echo
     echo '    do_simulated_orbit_GEOPOS.sh 2 19780810 0 0'
     echo "$alarm" >&2 ; exit 1
fi

satnum=$1
yymmdd=$2
hhmmss1=$3
hhmmss2=$4

yy=`echo $yymmdd | cut -c1-4`
mm=`echo $yymmdd | cut -c5-6`
dd=`echo $yymmdd | cut -c7-8`

datiso1=`RPC_date_time_to_datiso $yymmdd $hhmmss1`
datiso2=`RPC_date_time_to_datiso $yymmdd $hhmmss2`

echo "Commande:"
echo $com $satnum $yymmdd $hhmmss1 $hhmmss2  
echo

echo "This command use the following RPC generic commands:"
echo "    RPCget_data_GEOPOS"
echo "    RPC_change_coordinate_system"
echo "    RPC_compute_sat_orbit_param"
echo "    RPC_visu_vectime"
echo "    RPC_visu_vectime_3D"
echo "    RPC_compute_sat_trajectory"

dt=1.

file_in_geo="GEOS"$satnum"_POS_VTL2_"$yymmdd.rff
file_in_gei="GEOS"$satnum"_POS_VTL2_"$yymmdd"_gei".rff
file_in_gse="GEOS"$satnum"_POS_VTL2_"$yymmdd"_gse".rff
file_in_geo_red="GEOS"$satnum"_POS_VTL2_"$yymmdd"_red".rff

file_out_gei="GEOS"$satnum"_POS_VTL2_"$yymmdd"_simulated_gei".rff
file_out_gse="GEOS"$satnum"_POS_VTL2_"$yymmdd"_simulated_gse".rff

# -----------------------------------------------------------

echo "plot of data files"
echo "------------------"
echo

RPC_get_data_GEOPOS $satnum $yy $mm $dd
if test $? != 0 ; then  echo $alarm >&2; exit 2 ; fi

RPC_visu_vectime    $file_in_geo $datiso1 $datiso2
if test $? != 0 ; then  echo $alarm  >&2; exit 3 ; fi

RPC_reduce_time_vectime $file_in_geo $file_in_geo_red $datiso1 $datiso2
if test $? != 0 ; then  echo $alarm  >&2; exit 4 ; fi

RPC_change_coordinate_system $file_in_geo_red gei $file_in_gei
if test $? != 0 ; then  echo $alarm  >&2; exit 5 ; fi

RPC_visu_vectime_3D $file_in_gei 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 6 ; fi

RPC_change_coordinate_system $file_in_geo_red gse $file_in_gse
if test $? != 0 ; then  echo $alarm  >&2; exit 7 ; fi

RPC_visu_vectime_3D $file_in_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 8 ; fi

# -----------------------------------------------------------

echo "compute orbital parametres of data files"
echo "----------------------------------------"
echo

RPC_compute_sat_orbit_param $file_in_gei
if test $? != 0 ; then  echo "*** $0 exit on error 3" >&2; exit 9 ; fi

echo "add some information on compute_sat_trajectory.in"

tail -8 compute_sat_orbit_param.out | head -7 > toto_$$.tmp


#method=MVA (less good)
method=MinMax #(best)

echo
echo "Method=",$method
echo "-------------------------"
cat toto_$$.tmp
echo "-------------------------"

if test $method = MVA
        then sed '1,5!d' toto_$$.tmp > compute_sat_trajectory.in
        dir=1.
        
fi

if test $method = MinMax
        then sed  '4,5d' toto_$$.tmp > compute_sat_trajectory.in
        dir=-1.
fi

echo "compute_sat_trajectory.in :"
cat compute_sat_trajectory.in
echo "-------------------------"

echo "$dt"           >> compute_sat_trajectory.in
echo "$file_out_gei" >> compute_sat_trajectory.in
echo " $dir"         >> compute_sat_trajectory.in

arg=`echo $(cat compute_sat_trajectory.in)`

echo $arg 


# -----------------------------------------------------------

echo "compute theoritical trajectory from orbital parameter"
echo "-----------------------------------------------------"
echo

RPC_compute_sat_trajectory $arg  
if test $? != 0 ; then  echo $alarm  >&2; exit 10 ; fi

RPC_visu_vectime_3D $file_out_gei 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 11 ; fi

RPC_change_coordinate_system $file_out_gei gse $file_out_gse
if test $? != 0 ; then  echo $alarm  >&2; exit 12 ; fi

RPC_visu_vectime_3D $file_out_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 13 ; fi

# -----------------------------------------------------------

echo "compare experiment data with theoritical trajectory"
echo "---------------------------------------------------"
echo

RPC_visu_2_vectime $file_in_gse $file_out_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 14 ; fi

RPC_visu_vectime_3D_4sat $file_in_gse $file_out_gse $file_in_gse $file_in_gse 0 0
if test $? != 0 ; then  echo $alarm  >&2; exit 15 ; fi

# -----------------------------------------------------------


