#!/bin/bash

echo
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo "execute do_simulated_data_MVA_plot.sh RPC_script"
echo "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
echo

com=`basename $0`
alarm=" *** last command: abnormal termination - Script $0 aborted"

echo "This command use the following RPC generic commands:"
echo "    RPC_create_simulated_data"
echo "    RPC_vectime_to_mva"
echo "    RPC_vectime_to_spectro"
echo "    RPC_visu_spectro"
echo "    RPC_visu_ave_spectrum"


echo
echo "1) Create ULF simulated data"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxx"

RPC_create_simulated_data ULF
if test $? != 0 ; then echo ; echo "*** $0 exit 1" >&2; exit 1 ; fi

RPC_vectime_to_spectro VTL2_simulated_ULF_data.rff SPL2_simulated_ULF_data.rff 512 512 t
if test $? != 0 ; then echo ; echo "*** $0 exit 3" >&2; exit 3 ; fi

RPC_visu_spectro SPL2_simulated_ULF_data.rff 0 0 0. 12. -6. 0. XY 0.2 12. n
if test $? != 0 ; then echo ; echo "*** $0 exit 4" >&2; exit 4 ; fi

RPC_visu_ave_spectrum SPL2_simulated_ULF_data.rff 0 0 0. 12. -6. 1. LR 
if test $? != 0 ; then echo ; echo "*** $0 exit 5" >&2; exit 5 ; fi

echo
echo "2) Compute ULF data in MVA system"
echo "   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"


RPC_vectime_to_mva VTL2_simulated_ULF_data.rff VTL2_simulated_ULF_data_mva.rff 
if test $? != 0 ; then echo ; echo "*** $0 exit 2" >&2; exit 2 ; fi

RPC_vectime_to_spectro VTL2_simulated_ULF_data_mva.rff SPL2_simulated_ULF_data_mva.rff 512 512 t
if test $? != 0 ; then echo ; echo "*** $0 exit 3" >&2; exit 3 ; fi

RPC_visu_spectro SPL2_simulated_ULF_data_mva.rff 0 0 0. 12. -6. 0. XY 0.2 12. n
if test $? != 0 ; then echo ; echo "*** $0 exit 4" >&2; exit 4 ; fi

RPC_visu_ave_spectrum SPL2_simulated_ULF_data_mva.rff 0 0 0. 12. -6. 1. LR 
if test $? != 0 ; then echo ; echo "*** $0 exit 5" >&2; exit 5 ; fi



