!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

    program spectro_L2_to_cef

    !--------------------------------------------------------------------0--
    ! Laboratoire de Physique des Plasmas
    ! Program to read CLUSTER/STAFF-SC RFF spectro file and create a header
    ! of a CS CAA cef file.
    ! The data field will be filled by the shell 'RFF_spectro_to_cef'
    ! using a sed command, much efficient than a R/W fortran instruction.
    ! Rodrigue Piberne, LPP, 2012 November 21 : First try
    !--------------------------------------------------------------------0--

!----------------------------------------------------------------------!
! Object: read a SP RFF file and create heder of CS.cef file 
! Author: R. Piberne, LPP, 2012 Nov 21  
!----------------------------------------------------------------------!

    ! Variables declaration

    use rff_param_def
    use rff_data_def
    use type_def_cef

    implicit none

    integer             :: ifc, isat, i, cef_output_file_unit
    character(len=255)  :: RFF_file, cef_output_file_name ! Name automatically created by this program
    character(len=field_length_cef) :: dataset_id
    character(len=field_length_cef) :: logicalfileid
    character(len=2)    :: version_number
    character(len=32)   :: down_limit_date ! =00:00:00.000 of the asked day
    character(len=32)   :: up_limit_date   ! =23:59:59.999 of the asked day
    type(CEF_META)      :: dummy_cef_meta
    character(len=27)   :: u_present_iso_time ! Gives the present time in ISO format
    character(len=80)   :: rcl_version='RPC V2.6'
    character(len=par_len) :: TED_VERSION
    character(len=par_len) :: TCOR_OPTION
!   character(len=1)    :: sat_num
    character(len=255)  :: Fbasename
    real(kind=4)        :: FREQUENCY_CUT_OFF
    integer             :: CALIB_KERNEL_SIZE
    integer             :: CALIB_SHIFT_SIZE
    character(len=4)    :: FREQUENCY_CUT_OFF_str, CALIB_KERNEL_SIZE_str, CALIB_SHIFT_SIZE_str

    ! Initialisation

    ifc = 3
    cef_output_file_unit = 4
    version_number='05'

    ! file names reading
    ! ------------------

    print*, 'RFF vectime file to read ? (ex: ./toto_VT.rff)'
    read(*,'(a)') RFF_file
    print*, trim(RFF_file)

    ! Read RFF file
    ! -------------

    call rff_R_metadata(ifc,RFF_file)
    call rff_R_const_data(ifc)

    ! Creating dataset_id
    ! -------------------

    isat=manda_param%OBSERVATORY_NUMBER

    write(*,*) 'Coordinate system: ', manda_param%DATA_COORDINATE_SYSTEM

    !if GSE or ISR2
    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 3) then
        write(dataset_id,'(a1,i1,a11,a3)') 'C',isat,'_CP_STA_CS_', &
        manda_param%EXPERIMENT_MODE
    endif

    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 4) then
        write(dataset_id,'(a1,i1,a11,a3,a1,a4)') 'C',isat,'_CP_STA_CS_', &
        manda_param%EXPERIMENT_MODE, '_', manda_param%DATA_COORDINATE_SYSTEM
    endif

    ! Current day minimum and maximum allowed time
    down_limit_date = optio_param%TIME_SPAN_FROM
    up_limit_date   = optio_param%TIME_SPAN_TO

    ! Creating LogicalFileID :
    write(logicalfileid,'(a,a2,a4,a2,a2,a2,a2)') dataset_id(1:len_trim(dataset_id)),'__', &
    down_limit_date(1:4), &
    down_limit_date(6:7), &
    down_limit_date(9:10), &
    '_V',version_number

    ! Creating CEF File Name :
    write(cef_output_file_name,'(a,a,a4)') './', &
    logicalfileid(1:len_trim(logicalfileid)),'.cef'

    open(cef_output_file_unit,file = cef_output_file_name)

    cef_output_file_name = Fbasename(cef_output_file_name)

    ! Writing output CEF file header
    ! ========================================================================
    !
    ! Note: All string fields must contain ""
    !
    ! File Metadata:
    ! --------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,64),'File Metadata !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a,a,a)') 'FILE_NAME = "',cef_output_file_name(1:len_trim(cef_output_file_name)),'"'
    write(cef_output_file_unit,'(a)') 'FILE_FORMAT_VERSION = "CEF-2.0"'
    write(cef_output_file_unit,'(a)') 'END_OF_RECORD_MARKER = "$"'
    write(cef_output_file_unit,'(a1)') '!'
    
    ! Global Metadata:
    ! ----------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,60),'Global Metadata   !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'

    ! INCLUDES

    write(cef_output_file_unit,'(a)')        'INCLUDE= CL_CH_MISSION.ceh  ! Mission level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_OBS.ceh      ! Observatory level metadata.'
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a)') 'INCLUDE= CL_CH_STA.ceh      ! Experiment level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_STA_SC.ceh   ! Instrument level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    !if GSE or ISR2
    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 3) then
        write(cef_output_file_unit,'(a,i1,a11,a3,a)') 'INCLUDE= C',isat,&
        '_CH_STA_CS_', manda_param%EXPERIMENT_MODE,'.ceh   ! Dataset level metadata.'
        write(cef_output_file_unit,'(a1)') '!'
    endif

    if (len_trim(manda_param%DATA_COORDINATE_SYSTEM) == 4) then
        write(cef_output_file_unit,'(a,i1,a11,a3,a1,a4,a)') 'INCLUDE= C',isat,&
        '_CH_STA_CS_', manda_param%EXPERIMENT_MODE, &
        '_', trim(manda_param%DATA_COORDINATE_SYSTEM),&
        '.ceh   ! Dataset level metadata.'
        write(cef_output_file_unit,'(a1)') '!'
    endif

    ! FILE_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TYPE'
    dummy_cef_meta%entry(1)="cef"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! DATASET_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='DATASET_VERSION'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! LOGICAL_FILE_ID
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='LOGICAL_FILE_ID'
    dummy_cef_meta%entry(1)=logicalfileid
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! VERSION_NUMBER
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='VERSION_NUMBER'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_TYPE'
    dummy_cef_meta%entry(1)="CAA"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_VERSION'
    dummy_cef_meta%entry(1)="2.0"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! FILE_TIME_SPAN
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TIME_SPAN'
    dummy_cef_meta%value_type='ISO_TIME_RANGE'
    write(dummy_cef_meta%entry(1),'(a,a1,a)') down_limit_date(1:len_trim(down_limit_date)), &
    '/', &
    up_limit_date(1:len_trim(up_limit_date))
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! GENERATION_DATE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='GENERATION_DATE'
    dummy_cef_meta%value_type='ISO_TIME'
    dummy_cef_meta%entry(1)=u_present_iso_time()
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! FILE_CAVEATS
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_CAVEATS'
    TED_VERSION=const_data%TED_VERSION
    TCOR_OPTION=const_data%TCOR_OPTION
    CALIB_KERNEL_SIZE=const_data%CALIB_KERNEL_SIZE
    CALIB_SHIFT_SIZE=const_data%CALIB_SHIFT_SIZE
    FREQUENCY_CUT_OFF=const_data%FREQUENCY_CUT_OFF
    write(CALIB_KERNEL_SIZE_str,'(i4)') CALIB_KERNEL_SIZE
    write(CALIB_SHIFT_SIZE_str,'(i4)') CALIB_SHIFT_SIZE
    write(FREQUENCY_CUT_OFF_str,'(F4.2)') FREQUENCY_CUT_OFF
    write(dummy_cef_meta%entry(1),'(a,a)') 'Produced using software ',rcl_version(1:len_trim(rcl_version))
    write(dummy_cef_meta%entry(2),'(a,a)') 'TED version ',TED_VERSION(1:len_trim(TED_VERSION))
    write(dummy_cef_meta%entry(3),'(a,a)') 'TCOR option ',TCOR_OPTION(1:len_trim(TED_VERSION))
    write(dummy_cef_meta%entry(4),'(a,a)') 'Calibration tables: 14 nov 2011'
    write(dummy_cef_meta%entry(5),'(a,a)') 'Kernel size :',CALIB_KERNEL_SIZE_str
    write(dummy_cef_meta%entry(6),'(a,a)') 'Shift size :',CALIB_SHIFT_SIZE_str
    write(dummy_cef_meta%entry(7),'(a,a)') 'Cutoff frequency : ',FREQUENCY_CUT_OFF_str
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! Data start
    ! ----------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,69),'Data     !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'

    close(cef_output_file_unit)
    close(ifc)

    write(*,*) 'CEF header written.'
    write(*,*) 'cef name for calling shell :'
    write(*,'(a)') trim(cef_output_file_name)

    print*, 'spectro_L2_to_cef.exe            : NORMAL TERMINATION'
       stop 'spectro_L2_to_cef.exe            : NORMAL TERMINATION'
end program spectro_L2_to_cef

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
