!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

     program w_cal_caveat_header

!----------------------------------------------------------------------!
! Object: create the caveat header file associated to calibration data 
! Author: R. Piberne, LPP, 2012 Jul 22  
!----------------------------------------------------------------------!

    ! Variables declaration

    use rff_param_def
    use rff_data_def
    use type_def_cef

    implicit none

    integer             :: ifc, isat, i, cef_output_file_unit
    character(len=255)  :: RFF_file, cef_output_file_name ! Name automatically created by this program
    character(len=field_length_cef) :: dataset_id
    character(len=field_length_cef) :: logicalfileid
    character(len=2)    :: version_number
    character(len=32)   :: down_limit_date ! =00:00:00.000 of the asked day
    character(len=32)   :: up_limit_date   ! =23:59:59.999 of the asked day
    type(CEF_META)      :: dummy_cef_meta
    character(len=27)   :: u_present_iso_time ! Gives the present time in ISO format
    character(len=255)  :: Fbasename


    ! Initialisation

    ifc = 3
    cef_output_file_unit = 4
    version_number='01'

    ! file names reading
    ! ------------------

    print*, 'RFF vectime file to read ? (ex: ./toto_VT.rff)'
    read(*,'(a)') RFF_file
    print*, trim(RFF_file)


    ! Read RFF file
    ! -------------

    call rff_R_metadata(ifc,RFF_file)
    call rff_R_const_data(ifc,const_data)

    ! Creating dataset_id
    ! -------------------

    isat=manda_param%OBSERVATORY_NUMBER

    write(dataset_id,'(a1,i1,a27)') 'C',isat,'_CQ_STA_CALIBRATION_CAVEATS'

    ! Current day minimum and maximum allowed time
    down_limit_date = optio_param%TIME_SPAN_FROM
    up_limit_date   = optio_param%TIME_SPAN_TO

    ! Creating LogicalFileID :
    write(*,*) 'dataset_id =', dataset_id
    write(logicalfileid,'(a,a2,a4,a2,a2,a2,a2)') dataset_id(1:len_trim(dataset_id)),'__', &
    down_limit_date(1:4), &
    down_limit_date(6:7), &
    down_limit_date(9:10), &
    '_V',version_number

    ! Creating CEF File Name :
    write(cef_output_file_name,'(a,a,a4)') './', &
    logicalfileid(1:len_trim(logicalfileid)),'.cef'

    open(cef_output_file_unit,file = cef_output_file_name)

    cef_output_file_name = Fbasename(cef_output_file_name)

    ! Writing output CEF file header
    ! ========================================================================
    !
    ! Note: All string fields must contain ""
    !
    ! File Metadata:
    ! --------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,64),'File Metadata !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a,a,a)') 'FILE_NAME = "',cef_output_file_name(1:len_trim(cef_output_file_name)),'"'
    write(cef_output_file_unit,'(a)') 'FILE_FORMAT_VERSION = "CEF-2.0"'
    write(cef_output_file_unit,'(a1)') '!'

    ! Global Metadata:
    ! ----------------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,60),'Global Metadata   !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'

    ! INCLUDES

    write(cef_output_file_unit,'(a)')        'INCLUDE= CL_CH_MISSION.ceh                            ! Mission level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_OBS.ceh                         ! Observatory level metadata.'
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a)') 'INCLUDE= CL_CH_STA.ceh                         ! Experiment level metadata.'
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CH_STA_SC.ceh                      ! Instrument level metadata.'
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a,i1.1,a)') 'INCLUDE= C',isat,'_CQ_STA_CALIBRATION_CAVEATS.ceh         ! Data level metadata.'
    write(cef_output_file_unit,'(a1)') '!'

    ! FILE_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TYPE'
    dummy_cef_meta%entry(1)="cef"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! DATASET_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='DATASET_VERSION'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! LOGICAL_FILE_ID
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='LOGICAL_FILE_ID'
    dummy_cef_meta%entry(1)=logicalfileid
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! VERSION_NUMBER
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='VERSION_NUMBER'
    dummy_cef_meta%entry(1)=version_number
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_TYPE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_TYPE'
    dummy_cef_meta%entry(1)="CAA"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! METADATA_VERSION
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='METADATA_VERSION'
    dummy_cef_meta%entry(1)="2.0"
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! FILE_TIME_SPAN
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='FILE_TIME_SPAN'
    dummy_cef_meta%value_type='ISO_TIME_RANGE'
    write(dummy_cef_meta%entry(1),'(a,a1,a)') down_limit_date(1:len_trim(down_limit_date)), &
    '/', &
    up_limit_date(1:len_trim(up_limit_date))
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! GENERATION_DATE
    call u_cef_clear_meta(dummy_cef_meta)
    dummy_cef_meta%name='GENERATION_DATE'
    dummy_cef_meta%value_type='ISO_TIME'
    dummy_cef_meta%entry(1)=u_present_iso_time()
    call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

    ! Data start
    ! ----------

    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(80a)') '!',(' ',i=1,69),'Data     !'
    write(cef_output_file_unit,'(80a)') ('!',i=1,80)
    write(cef_output_file_unit,'(a1)') '!'
    write(cef_output_file_unit,'(a26)') 'DATA_UNTIL = "END_OF_FILE"'

    close(cef_output_file_unit)
    close(ifc)

    write(*,*) 'CEF header written.'
    write(*,*) 'cef name for calling shell :'
    write(*,'(a)') trim(cef_output_file_name)

    print*, 'w_cal_caveat_header            : NORMAL TERMINATION'
       stop 'w_cal_caveat_header            : NORMAL TERMINATION'
end program w_cal_caveat_header

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
