!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program w_vectime_cef_header

!--------------------------------------------------------------------0--
! Laboratoire de Physique des Plasmas
! Program to write DWF ceh file.
! Rodrigue Piberne, LPP, 2011 April 05
!--------------------------------------------------------------------0--

! Variables declaration

  use rff_param_def
  use rff_data_def
  use type_def_cef

  implicit none

  integer             :: header_choice, cef_output_file_unit, i
  character(len=3)    :: header_name
  character(len=255)  :: cef_output_file_dir
  character(len=255)  :: cef_output_file_name
  character(len=3)    :: version
  character(1)        :: sat_num
  type(CEF_META)      :: dummy_cef_meta
  type(CEF_PARAMETER) :: dummy_cef_var
  character(len=12)   :: MISALIGNMENT_MATRIX_L1_C1, MISALIGNMENT_MATRIX_L1_C2, &
  MISALIGNMENT_MATRIX_L1_C3, MISALIGNMENT_MATRIX_L2_C1, MISALIGNMENT_MATRIX_L2_C2, &
  MISALIGNMENT_MATRIX_L2_C3, MISALIGNMENT_MATRIX_L3_C1, MISALIGNMENT_MATRIX_L3_C2, &
  MISALIGNMENT_MATRIX_L3_C3
  character(len=10)    :: resolution
  character(len=10)   :: delta_resolution
  character(len=15)   :: sampling

! Initialisation
  version = 'V04'
  cef_output_file_dir = '/home/piberne/Validate_CEF/NBR_HBR_header_2012_version/'

! Choose header to create (0=NBR, 1=HBR)
! ------------------

  header_choice = 0

! Writing output CEF file header
! ========================================================================
!
! Note: All string fields must contain ""


 do i = 1, 4, 1
    !For NBR, 1 resolution per satellite
    if (header_choice.EQ.0) then

        header_name='NBR'
        sampling='25'

        if (i.EQ.1) then
            sat_num = '1'
            resolution = '3.99990667'
            delta_resolution = '1.9999533'
        end if

        if (i.EQ.2) then
            sat_num = '2'
            resolution = '3.99994222'
            delta_resolution = '1.9999711'
        end if

        if (i.EQ.3) then
            resolution = '3.99997333'
            delta_resolution = '1.9999867'
        end if

        if (i.EQ.4) then
            resolution = '3.99997333'
            delta_resolution = '1.9999867'
        end if

    end if
    !For HBR, 1 resolution per satellite
    if (header_choice.EQ.1) then

        header_name='HBR'
        sampling='burst; 450'

        if (i.EQ.1) then
            sat_num = '1'
            resolution = '0.22221704'
            delta_resolution = '0.1111085'

        end if

        if (i.EQ.2) then
            sat_num = '2'
            resolution = '0.22221901'
            delta_resolution = '0.1111095'

        end if

        if (i.EQ.3) then
            sat_num = '3'
            resolution = '0.22222074'
            delta_resolution ='0.1111104'
        end if

        if (i.EQ.4) then
            resolution = '0.22222074'
            delta_resolution ='0.1111104'
        end if

    end if

      !For these kind of CEH, there is one per satellite
      if (i.EQ.1) then
        sat_num = '1'
      endif
      if (i.EQ.2) then
        sat_num = '2'
      endif
      if (i.EQ.3) then
        sat_num = '3'
      endif
      if (i.EQ.4) then
        sat_num = '4'
      endif

      !Create and open output ceh file
      cef_output_file_name = trim(cef_output_file_dir)//'C'//sat_num//'_CH_STA_DWF_'//header_name//'.ceh'
      open(cef_output_file_unit, file = cef_output_file_name)

      write(cef_output_file_unit,'(a)') '! CEH VALIDATION 1 March 2011 by LPP, V04 (RP/PR/NC)'
      write(cef_output_file_unit,'(a)') '!'

      !DATASET_ID
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='DATASET_ID'
      dummy_cef_meta%entry(1)="C"//sat_num//"_CP_STA_DWF_"//header_name//""
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !DATA_TYPE
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='DATA_TYPE'
      dummy_cef_meta%entry(1)="CP"
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !DATASET_TITLE
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='DATASET_TITLE'
      dummy_cef_meta%entry(1)="Magnetic Field Waveform - uncalibrated ("//trim(sampling)//" Hz sampling)"
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !CONTACT_COORDINATES
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='CONTACT_COORDINATES'
      dummy_cef_meta%entry(1)="Patrick Canu>PI>patrick.canu@lpp.polytechnique.fr"
      dummy_cef_meta%entry(2)="Nicole Cornilleau-Wehrlin>Deputy-PI>Nicole.Cornilleau@lpp.polytechnique.fr"
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !DATASET_DESCRIPTION
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='DATASET_DESCRIPTION'
      dummy_cef_meta%entry(1)="This dataset contains "//trim(resolution)//"E-02s resolution measurements"
      dummy_cef_meta%entry(2)="of the magnetic field Decommutated WaveForm (DWF)"
      dummy_cef_meta%entry(3)="from the STAFF-SC instrument in "//header_name//" mode on the"
      dummy_cef_meta%entry(4)="Cluster C"//sat_num//" spacecraft. This product is given in the STAFF"
      dummy_cef_meta%entry(5)="Sensor WEC6 Reference Frame (SSW6RF)."
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !PROCESSING_LEVEL
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='PROCESSING_LEVEL'
      dummy_cef_meta%entry(1)="Uncalibrated"
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !TIME_RESOLUTION
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='TIME_RESOLUTION'
      dummy_cef_meta%value_type='FLOAT'
      dummy_cef_meta%entry(1)='@'//trim(resolution)//'E-02'!@ to forbid the "" format
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !MIN_TIME_RESOLUTION
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='MIN_TIME_RESOLUTION'
      dummy_cef_meta%value_type='FLOAT'
      dummy_cef_meta%entry(1)='@'//trim(resolution)//'E-02'
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !MAX_TIME_RESOLUTION
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='MAX_TIME_RESOLUTION'
      dummy_cef_meta%value_type='FLOAT'
      dummy_cef_meta%entry(1)='@'//trim(resolution)//'E-02'
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !DATASET_CAVEATS
      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name='DATASET_CAVEATS'
      dummy_cef_meta%entry(1)="*C"//sat_num//"_CQ_STA_DWF_"//header_name//"_CAVEATS"
      dummy_cef_meta%entry(2)="DATASET VERSION HISTORY"
      dummy_cef_meta%entry(3)="Version 03 : All the headers have been updated (laboratory name "
      dummy_cef_meta%entry(4)="and email). Introduction of a new header file (Dataset). "
      dummy_cef_meta%entry(5)="For each data point time inside a one second data block, "
      dummy_cef_meta%entry(6)="each sample has been interpolated to insure a continuous sampling rate."
      dummy_cef_meta%entry(7)="The phase has been re-calculated for each point inside each one second block."
      dummy_cef_meta%entry(8)="All versions:"
      dummy_cef_meta%entry(9)="Use the TED software, provided by the Sheffield DWP group,"
      dummy_cef_meta%entry(10)="with TCOR option used for a maximum UT time precision every second."
      dummy_cef_meta%entry(11)="S/C HK used to calculate the phase are not corrected by TCOR."
      dummy_cef_meta%entry(12)="The maximum error induced is 0.2 degree, including time around the leap second."
      dummy_cef_meta%entry(13)="Version 04 : Add data necessary for CWF data."
      dummy_cef_meta%entry(14)="Correction of the time interpolation and of the backward time problem."
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

      !Start variables label
      write(cef_output_file_unit,'(a)') '!'
      write(cef_output_file_unit,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
      write(cef_output_file_unit,'(a)') '!                                                                   Variables  !'
      write(cef_output_file_unit,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
      write(cef_output_file_unit,'(a)') '!'

      !Time__C1_CP_STA_DWF_*
      call u_cef_clear_var(dummy_cef_var)
      dummy_cef_var%parameter_id = "Time" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name

      dummy_cef_var%CATDESC = "Interval centred time tag"
      dummy_cef_var%FIELDNAM = "UT Time"
      dummy_cef_var%FILLVAL = "9999-12-31T23:59:59.999999Z"
      dummy_cef_var%LABLAXIS = "UT"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%SI_CONVERSION = '1.0>s'
      dummy_cef_var%SIGNIFICANT_DIGITS = "27"
      dummy_cef_var%SIZES = "1"
      dummy_cef_var%UNITS = 's'
      dummy_cef_var%VALUE_TYPE = "ISO_TIME"
      dummy_cef_var%DELTA_MINUS = trim(delta_resolution)//'E-02'
      dummy_cef_var%DELTA_PLUS = trim(delta_resolution)//'E-02'
      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Status__C1_CP_STA_DWF_*
      call u_cef_clear_var(dummy_cef_var)
      dummy_cef_var%parameter_id = "Status" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name

      dummy_cef_var%CATDESC = "STAFF-SC Status"
      dummy_cef_var%DEPEND_0 = "Time"
      dummy_cef_var%FIELDNAM = "STAFF-SC Status"
      dummy_cef_var%FILLVAL = "ZZZZZZZZZZZ"
      dummy_cef_var%LABEL_1 = '"Status"'
      dummy_cef_var%LABLAXIS = "Status"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%SIGNIFICANT_DIGITS = "14"
      dummy_cef_var%SIZES = "1"
      dummy_cef_var%UNITS = 'unitless'
      dummy_cef_var%VALUE_TYPE = 'CHAR'
      dummy_cef_var%QUALITY = '1'
      dummy_cef_var%PARAMETER_CAVEATS = '"We can not certify the 9th character (EFW)"'
      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Phase_Angle_SC__C1_CP_STA_DWF_*
      call u_cef_clear_var(dummy_cef_var)
      dummy_cef_var%parameter_id = "Phase_Angle" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name

      dummy_cef_var%CATDESC = "Phase Angle"
      dummy_cef_var%DEPEND_0 = "Time"
      dummy_cef_var%FIELDNAM = "Phase Angle"
      dummy_cef_var%FILLVAL = "-500.00"
      dummy_cef_var%LABEL_1 = '"Phase Angle"'
      dummy_cef_var%LABLAXIS = "Phase Angle"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%SIGNIFICANT_DIGITS = "6"
      dummy_cef_var%SIZES = "1"
      dummy_cef_var%UNITS = 'degree'
      dummy_cef_var%VALUE_TYPE = 'FLOAT'
      dummy_cef_var%QUALITY = '3'
      dummy_cef_var%PARAMETER_CAVEATS = '"Phase derived from Sun Pulse measurement: can be interpolated, see STATUS"'
      dummy_cef_var%COORDINATE_SYSTEM = "SC"
      dummy_cef_var%SI_CONVERSION = '1>degree'
      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !B_vec_xyz_Instrument__C1_CP_STA_DWF_*
      call u_cef_clear_var(dummy_cef_var)
      dummy_cef_var%parameter_id = "B_vec_xyz_Instrument" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name

      dummy_cef_var%CATDESC = "Cluster C1, "//header_name//" Magnetic Field Decommutated WaveForm"
      dummy_cef_var%DEPEND_0 = "Time"
      dummy_cef_var%FIELDNAM = "Cluster C1, "//header_name//" Magnetic Field Decommutated WaveForm"
      dummy_cef_var%FILLVAL = "-999"
      dummy_cef_var%LABEL_1 = '"Bx","By","Bz"'
      dummy_cef_var%LABLAXIS = "Decommutated Magnetic Field Waveform"
      dummy_cef_var%PARAMETER_TYPE = "Data"
      dummy_cef_var%SIGNIFICANT_DIGITS = "5"
      dummy_cef_var%SIZES = "3"
      dummy_cef_var%UNITS = 'TM counts'
      dummy_cef_var%VALUE_TYPE = 'INT'
      dummy_cef_var%QUALITY = '3'
      dummy_cef_var%COORDINATE_SYSTEM = "Instrument"
      dummy_cef_var%SI_CONVERSION = "1.52590218967E-4>V"
      dummy_cef_var%ENTITY = "Magnetic_Field"
      dummy_cef_var%FLUCTUATIONS = "Waveform"
      dummy_cef_var%PROPERTY = "Vector"
      dummy_cef_var%REPRESENTATION_1 = '"x","y","z"'
      dummy_cef_var%TENSOR_ORDER = "1"
      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Misalignment Matrix
      MISALIGNMENT_MATRIX_L1_C1 = '1.0000'
      MISALIGNMENT_MATRIX_L1_C2 = '0.0000'
      MISALIGNMENT_MATRIX_L1_C3 = '0.0000'
      MISALIGNMENT_MATRIX_L2_C1 = '0.0000'
      MISALIGNMENT_MATRIX_L2_C2 = '1.0000'
      MISALIGNMENT_MATRIX_L2_C3 = '0.0000'
      MISALIGNMENT_MATRIX_L3_C1 = '0.0000'
      MISALIGNMENT_MATRIX_L3_C2 = '0.0000'
      MISALIGNMENT_MATRIX_L3_C3 = '1.0000'

      call u_cef_clear_var(dummy_cef_var)

      dummy_cef_var%parameter_id = "Misalignment_Matrix" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name
      dummy_cef_var%ENTITY = "Transformation"
      dummy_cef_var%PROPERTY = "Coordinate_rotation"
      dummy_cef_var%CATDESC = "C"//sat_num//" transformation from STAFF real instrument frame "//&
                                "to the theoric orthogonal frame linked to the instrument."
      dummy_cef_var%DATA = trim(adjustl(MISALIGNMENT_MATRIX_L1_C1))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L1_C2))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L1_C3))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C1))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C2))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L2_C3))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C1))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C2))&
                   //", "//trim(adjustl(MISALIGNMENT_MATRIX_L3_C3))
      dummy_cef_var%FIELDNAM = "Misalignment_Matrix"
      dummy_cef_var%LABEL_1 = '"L*_C1","L*_C2","L*_C3"'
      dummy_cef_var%FILLVAL = "1.E30"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%QUALITY = "0"
      dummy_cef_var%COORDINATE_SYSTEM = "Instrument"
      dummy_cef_var%REPRESENTATION_1 = '"x","y","z"'
      dummy_cef_var%REPRESENTATION_2 = '"x","y","z"'
      dummy_cef_var%SI_CONVERSION = '1>unitless'
      dummy_cef_var%SIGNIFICANT_DIGITS = "5"
      dummy_cef_var%SIZES = "3, 3"
      dummy_cef_var%TENSOR_ORDER = "2"
      dummy_cef_var%FRAME = 'Instrument'
      dummy_cef_var%UNITS = 'unitless'
      dummy_cef_var%VALUE_TYPE = "FLOAT"

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Minimum Volt range
      call u_cef_clear_var(dummy_cef_var)

      dummy_cef_var%parameter_id = "Minimum_volt_range" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name
      dummy_cef_var%DATA = "-5.00"
      dummy_cef_var%FILLVAL = "-99,99"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%CATDESC = "Minimum Volt range"
      dummy_cef_var%FIELDNAM = "Minimum_volt_range"
      dummy_cef_var%SIGNIFICANT_DIGITS = "3"
      dummy_cef_var%SI_CONVERSION = '1>V'
      dummy_cef_var%UNITS = 'V'
      dummy_cef_var%VALUE_TYPE = "FLOAT"

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Maximum Volt range
      call u_cef_clear_var(dummy_cef_var)

      dummy_cef_var%parameter_id = "Maximum_volt_range" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name
      dummy_cef_var%DATA = "5.00"
      dummy_cef_var%FILLVAL = "-99,99"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%CATDESC = "Maximum Volt range"
      dummy_cef_var%FIELDNAM = "Maximum_volt_range"
      dummy_cef_var%SIGNIFICANT_DIGITS = "3"
      dummy_cef_var%SI_CONVERSION = '1>V'
      dummy_cef_var%UNITS = 'V'
      dummy_cef_var%VALUE_TYPE = "FLOAT"

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Minimum tm range
      call u_cef_clear_var(dummy_cef_var)

      dummy_cef_var%parameter_id = "TM_range_min" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name
      dummy_cef_var%DATA = "0"
      dummy_cef_var%FILLVAL = "-1"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%CATDESC = "Minimum telemetry range in TM counts"
      dummy_cef_var%FIELDNAM = "TM_range_min"
      dummy_cef_var%SIGNIFICANT_DIGITS = "1"
      dummy_cef_var%SI_CONVERSION = '1.52590218967E-4>V'
      dummy_cef_var%UNITS = 'TM counts'
      dummy_cef_var%VALUE_TYPE = "INT"

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Maximum tm range
      call u_cef_clear_var(dummy_cef_var)

      dummy_cef_var%parameter_id = "TM_range_max" !usefull to fill the variable name
      dummy_cef_var%dataset_id = "C"//sat_num//"_CP_STA_DWF_"//header_name
      dummy_cef_var%DATA = "65535"
      dummy_cef_var%FILLVAL = "-99999"
      dummy_cef_var%PARAMETER_TYPE = "Support_Data"
      dummy_cef_var%CATDESC = "Maximum telemetry range in TM counts"
      dummy_cef_var%FIELDNAM = "TM_range_max"
      dummy_cef_var%SIGNIFICANT_DIGITS = "5"
      dummy_cef_var%SI_CONVERSION = '1.52590218967E-4>V'
      dummy_cef_var%UNITS = 'TM counts'
      dummy_cef_var%VALUE_TYPE = "INT"

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

      !Close file
      close(cef_output_file_unit)

    end do


  write(*,*) 'Done'
  print*, "w_vectime_cef_header            : NORMAL TERMINATION"
     stop "w_vectime_cef_header            : NORMAL TERMINATION"

  end program w_vectime_cef_header

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
