!
      program alitime_4_vectime
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
!     aligne en temps 4 fichiers vectime
!     utilise la lib_alitime
!
!     P. Robert, Scientidev, Janvier 2021
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


! *** declaration des variables


      use rff_param_def
      use rff_data_def

      real(kind=4),      dimension(:,:),   allocatable :: vectim1
      real(kind=4),      dimension(:,:),   allocatable :: vectim2
      real(kind=4),      dimension(:,:),   allocatable :: vectim3
      real(kind=4),      dimension(:,:),   allocatable :: vectim4
    
      character(len=27), dimension(:),     allocatable :: datiso1
      character(len=27), dimension(:),     allocatable :: datiso2
      character(len=27), dimension(:),     allocatable :: datiso3
      character(len=27), dimension(:),     allocatable :: datiso4
      character(len=27), dimension(:),     allocatable :: datisoa
      
      character(len=255), dimension(4) :: file_in, file_out
      character(len=4)  :: rep1,rep2,rep3,rep4,rep
      character(len=27) :: credate, bfirst,blast
      
!     ---------------------------------------------------------------+--

      print 200
      print 200, ('X',i=1,53)
      print 200
      print 200, 'alitime_4_vectime.exe: time alignment of 4 RFF vectime files'
      print 200
      print 200, '                        Patrick Robert, Jan 2021'
      print 200
      print 200, ('X',i=1,53)
      print 200

  200 format(80a)
!
!     ---------------------------------------------------------------+--
      print*, 'lecture du nom des  fichiers '

      read(*,'(a)') file_in(1)
      read(*,'(a)') file_in(2)
      read(*,'(a)') file_in(3)
      read(*,'(a)') file_in(4)
      
      print*, 'file_in1=',TRIM(file_in(1))
      print*, 'file_in2=',TRIM(file_in(2))
      print*, 'file_in3=',TRIM(file_in(3))
      print*, 'file_in4=',TRIM(file_in(4))
      
      DO i=1,4
         ii=LEN_TRIM(file_in(i))
         file_out(i)=file_in(i)(1:ii-4)//'_ali.rff'
      ENDDO
        
      print*, 'file_in1=',TRIM(file_out(1))
      print*, 'file_in2=',TRIM(file_out(2))
      print*, 'file_in3=',TRIM(file_out(3))
      print*, 'file_in4=',TRIM(file_out(4))
      
!     ---------------------------------------------------------------+--      
      print*
      print*, 'lecture des fichiers '
      
   DO i=1,4
      
      call rff_R_file(i,file_in(i))
        
      IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** error, RFF file is not a VecTime Class'
         write(*,*) '    manda_param%FILE_CLASS=', manda_param%FILE_CLASS
         write(*,*) '    program aborted'
         stop 'alitime_4_vectime.exe           : *** ERROR !! Program aborted !'
      ENDIF
      
      
      if(i == 1) then
                 datiso1=data_index
                 vectim1=R_data_vector
                 nbloc1=manda_param%BLOCK_NUMBER
                 dt1=real(optio_param%TIME_RESOLUTION)
                 rep1=manda_param%DATA_COORDINATE_SYSTEM(1:4)
                 OPEN(11,file='toto1.tmp',form='FORMATTED')
                 call rff_W_metadata(11,'toto1.tmp')
                 call rff_W_const_data(11)
      endif
      
      if(i == 2) then
                 datiso2=data_index
                 vectim2=R_data_vector
                 nbloc2=manda_param%BLOCK_NUMBER
                 dt2=real(optio_param%TIME_RESOLUTION)
                 rep2=manda_param%DATA_COORDINATE_SYSTEM(1:4)
                 OPEN(12,file='toto2.tmp',form='FORMATTED')
                 call rff_W_metadata(12,'toto2.tmp')
                 call rff_W_const_data(12)
      endif      
      
      if(i == 3) then
                 datiso3=data_index
                 vectim3=R_data_vector
                 nbloc3=manda_param%BLOCK_NUMBER
                 dt3=real(optio_param%TIME_RESOLUTION)
                 rep3=manda_param%DATA_COORDINATE_SYSTEM(1:4)
                 OPEN(13,file='toto3.tmp',form='FORMATTED')
                 call rff_W_metadata(13,'toto3.tmp')
                 call rff_W_const_data(13)
      endif
      
      if(i == 4) then
                 datiso4=data_index
                 vectim4=R_data_vector
                 nbloc4=manda_param%BLOCK_NUMBER
                 dt4=real(optio_param%TIME_RESOLUTION)
                 rep4=manda_param%DATA_COORDINATE_SYSTEM(1:4)
                 OPEN(14,file='toto4.tmp',form='FORMATTED')
                 call rff_W_metadata(14,'toto4.tmp')
                 call rff_W_const_data(14)
      endif
      
      close(i)
      
   ENDDO
   
      print*,'nb blocs of each file:',nbloc1,nbloc2,nbloc3,nbloc4
   
!     ---------------------------------------------------------------+--      

      rep=rep1
            
      IF((rep1 /=  rep2)  .or. (rep1 /= rep3) .or. (rep1/= rep4))  THEN
         write(*,*) '*** error, rep is not the same for the 4 files'
         write(*,*) '    rep1,rep2,rep3,rep4=',rep1,rep2,rep3,rep4
         write(*,*) '    program aborted'
         stop 'alitime_4_vectime               : *** ERROR !! Program aborted !'
      ENDIF

!     ---------------------------------------------------------------+-- 

      print*, 'time alignment of 4 datasets'
  
            
      fill_val=1.e30
  
      call alitime_data_4sat(datiso1,datiso2,datiso3,datiso4, &
                             vectim1,vectim2,vectim3,vectim4, &
                              nbloc1, nbloc2, nbloc3, nbloc4, &
                              dt1,dt2,dt3,dt4,iref,nbpint,fill_val)

!     ---------------------------------------------------------------+-- 

      print*, 'create 4 RFF vectime file time aligned'
      
      if(iref == 1) then
                    dt     =dt1
                    bfirst =datiso1(1)
                    blast  =datiso1(nbpint)
                    datisoa=datiso1
      endif
      
      if(iref == 2) then
                    dt     =dt2
                    bfirst =datiso2(1)
                    blast  =datiso2(nbpint)
                    datisoa=datiso2
      endif
      
      if(iref == 3) then
                    dt     =dt3
                    bfirst =datiso3(1)
                    blast  =datiso3(nbpint)
                    datisoa=datiso3
      endif
      
      if(iref == 4) then
                    dt     =dt4
                    bfirst =datiso4(1)
                    blast  =datiso4(nbpint)
                    datisoa=datiso4
      endif
            

      call gdatiso(credate)
     
      
!     S/C 1
!     -----

      REWIND(11)
      call rff_R_metadata(11,'toto1.tmp')
      CLOSE(11,status='DELETE')
      manda_param%BLOCK_NUMBER      =nbpint  
      optio_param%TIME_RESOLUTION   =dt
      manda_param%BLOCK_FIRST_INDEX =bfirst
      manda_param%BLOCK_LAST_INDEX  =blast
      manda_param%FILE_CREATION_DATE=credate 
      call rff_update_history(credate,'alitime_4_vectime')
      data_index=datisoa
      R_data_vector=vectim1
      call rff_W_file(1,file_out(1))

!     S/C 2
!     -----

      REWIND(12)
      call rff_R_metadata(12,'toto2.tmp')
      CLOSE(12,status='DELETE')
      manda_param%BLOCK_NUMBER      =nbpint  
      optio_param%TIME_RESOLUTION   =dt
      manda_param%BLOCK_FIRST_INDEX =bfirst
      manda_param%BLOCK_LAST_INDEX  =blast  
      manda_param%FILE_CREATION_DATE=credate 
      call rff_update_history(credate,'alitime_4_vectime')
      data_index=datisoa
      R_data_vector=vectim2
      call rff_W_file(2,file_out(2))  

!     S/C 3
!     -----

      REWIND(13)
      call rff_R_metadata(13,'toto3.tmp')
      CLOSE(13,status='DELETE')
      manda_param%BLOCK_NUMBER      =nbpint  
      optio_param%TIME_RESOLUTION   =dt
      manda_param%BLOCK_FIRST_INDEX =bfirst
      manda_param%BLOCK_LAST_INDEX  =blast  
      manda_param%FILE_CREATION_DATE=credate 
      call rff_update_history(credate,'alitime_4_vectime')
      data_index=datisoa
      R_data_vector=vectim3
      call rff_W_file(3,file_out(3))
      
!     S/C 4
!     -----

      REWIND(14)
      call rff_R_metadata(14,'toto4.tmp')
      CLOSE(14,status='DELETE')
      manda_param%BLOCK_NUMBER      =nbpint  
      optio_param%TIME_RESOLUTION   =dt
      manda_param%BLOCK_FIRST_INDEX =bfirst
      manda_param%BLOCK_LAST_INDEX  =blast  
      manda_param%FILE_CREATION_DATE=credate 
      call rff_update_history(credate,'alitime_4_vectime')
      data_index=datisoa
      R_data_vector=vectim4
      call rff_W_file(4,file_out(4))
      
      

      print*, 'alitime_4_vectime.exe            : NORMAL TERMINATION'
         stop 'alitime_4_vectime.exe            : NORMAL TERMINATION'
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
