!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

program fgm_cef_gse_to_sr2

!--------------------------------------------------------------------0--
! Laboratoire de Physique des Plasmas
! Program to convert  a gse fgm.cef file into a sr2 one
! Rodrigue Piberne, LPP, 2012 March 08
!--------------------------------------------------------------------0--

  use type_def_cef

  integer, parameter :: datisoDim=27 ! Dimension des chaines de caracteres pour les dates
  integer             :: n_metadata, cef_file_unit, n_block, err, n_variables, i,&
  n_of_data_in_file, j, n_of_vec_in_file,vec_size, index_z,cef_output_file_unit, length, &
  index_under, index_under2,stop_now
! integer, dimension(2) :: errAlloc ! code d erreur pour l allocation dynamique

  character(len=64), dimension(:), allocatable  :: variable_names,metadata_names,data_names
  character(len=255)  :: fgm_filename, include_dirname, cef_output_file_name, dummy_char, dummy_char2
  character(len=100), dimension(:,:), allocatable:: indexed_data
  character(len=100), dimension(:),   allocatable :: data_index
  character(len=27)   :: block_first_index, block_last_index
  character(len=datisoDim), dimension(:), pointer :: datiso => NULL()

  real(kind=4), dimension(:,:), pointer :: vectim => NULL()
  real(kind=4) :: vx, vy, vz, rx, ry, rz, xgei, ygei, zgei, dec, rasn, rad

  type(CEF_PARAMETER), dimension(:), allocatable:: cef_param
  type(CEF_META), dimension(:), allocatable:: cef_entry
  type(CEF_META)      :: dummy_cef_meta
  type(CEF_PARAMETER) :: dummy_cef_var

  print*, '-------------------------------------------------------------'
  print*, 'fgm_cef_gse_to_sre2: convert a gse fgm.cef file into a sr2 one'
  print*, '-------------------------------------------------------------'
  print*

  print*, 'CEF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') fgm_filename
  print*,  trim(fgm_filename)

  print*, 'Right ascension and declination in GEI system ? (ex: 102.49,  -63.95)'
  read *,  rasn, dec 
  print*,  rasn, dec


  include_dirname = ''

  cef_file_unit=1
  cef_output_file_unit = 2

  !read cef file
  ! -----------------------------------

  !0) concatenate include files

  call concatenate_include_files(cef_file_unit,include_dirname,fgm_filename,&
  n_block,block_first_index,block_last_index)

  write(*,*) 'n_block =', n_block

  !1) open file
  !    ---------

  write(*,*)
  write(*,*) 'Opening file :',TRIM(fgm_filename)

OPEN(cef_file_unit,file=trim(fgm_filename),status='old',action='read', iostat=err)

  if(err /= 0) then
      write(*,*) '*** unable to open file : ',TRIM(fgm_filename)
      write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
      write(*,*) '    err= ',err
      write(*,*) '    program aborted !!!'
      stop 'fgm_cef_gse_to_sr2.exe          : *** ERROR !! Program aborted !'
  endif

  ! 2) read metadata, variables and parameters
  !    -------------

  write(*,*)
  write(*,*) 'reading metadata...'

  !find the number of metadata
  n_metadata = 0
  call cef_find_n_metadata(cef_file_unit,n_metadata)

  write(*,*) 'n_meta=',n_metadata

  !read metadata
  write(*,*)
  write(*,*) 'reading metadata...'
  allocate(metadata_names(n_metadata))
  metadata_names = 'xxx'
  call cef_R_metadata(cef_file_unit,n_metadata, metadata_names)
  write(*,*) metadata_names

  !read entry
  allocate(cef_entry(n_metadata))
  call cef_R_entry(cef_file_unit,cef_entry,n_metadata, metadata_names)

  !find the number of variables
  write(*,*)
  write(*,*) 'reading variables...'
  n_variables = 0
  call cef_find_n_variables(cef_file_unit,n_variables)

  !read variables
  allocate(variable_names(n_variables))
  variable_names = 'xxx'
  call cef_R_variables(cef_file_unit,n_variables, variable_names)
  write(*,*) variable_names

  !read parameters
  write(*,*)
  write(*,*) 'reading parameters...'
  allocate(cef_param(n_variables))
  call cef_R_parameter(cef_file_unit,cef_param,n_variables,variable_names)

  !find the number of non constant data
  n_of_data_in_file = 0
  do i=1, n_variables
      if (cef_param(i)%DATA == '') then
          n_of_data_in_file = n_of_data_in_file + 1
      endif
  enddo

  !associate corresponding name to these data
  allocate(data_names(n_of_data_in_file))
  j=1
  do i=1, n_variables
      if (cef_param(i)%DATA == '') then
          data_names(j) = variable_names(i)
          j = j+1
      endif
  enddo

  !find number of vectors
  n_of_vec_in_file=0
  do i=1, n_variables
      if (cef_param(i)%DATA == '') then
          read(cef_param(i)%SIZES, '(i1)') vec_size
          n_of_vec_in_file = n_of_vec_in_file+vec_size
      endif
  enddo

  !fill index data array
OPEN(cef_file_unit,file=trim(fgm_filename),status='old',action='read', iostat=err)

  allocate(indexed_data(n_of_vec_in_file,n_block))
  call cef_R_indexed_data(cef_file_unit, n_of_vec_in_file, n_block, indexed_data)
  close(cef_file_unit)

  write(*,*) 'Indexed array filled'

  !create iso time array
  allocate(data_index(n_block))
  data_index = indexed_data(1,:)
  index_z = 24
  data_index=data_index(:)(1:index_z-1)//'000Z'
  allocate(datiso(n_block))
  do i=1,n_block
    datiso(i)=data_index(i)(1:27)
  enddo

  !create vectime array
  allocate(vectim(3,n_block))

  rad=57.29578

  xgei=cos(rasn/rad)*cos(dec/rad)
  ygei=sin(rasn/rad)*cos(dec/rad)
  zgei=sin(dec/rad)

  do i=1,n_block
      !bx, by, bz en GSE
      read(indexed_data(3,i), '(f10.6)') vx
      read(indexed_data(4,i), '(f10.6)') vy
      read(indexed_data(5,i), '(f10.6)') vz

      if (i == 1) then

      write(*,*) vx,' ', vy, ' ', vz

      endif

      call decode_datiso(datiso(i),iyear,imon,iday,ih,im,is,ims,imc)
      call ctimpar(iyear,imon,iday,ih,im,is)

      rad=57.29578

      xgei=cos(rasn/rad)*cos(dec/rad)
      ygei=sin(rasn/rad)*cos(dec/rad)
      zgei=sin(dec/rad)

      call tgeigse(xgei,ygei,zgei,rx,ry,rz)
      call tgsesr2(vx,vy,vz,rx,ry,rz,x,y,z)
      vectim(1,i)=x
      vectim(2,i)=y
      vectim(3,i)=z

  enddo

  write(*,*) 'Conversion completed!'

  !save data in a new fgm cef file

  ! Creating CEF File Name :

  cef_output_file_name = fgm_filename

  index_dot = index(cef_output_file_name,'.')

  dummy_char = cef_output_file_name(1:index_dot-1)

  cef_output_file_name = trim(dummy_char)//'_sr2.cef'

  write(*,*) 'New FGM sr2 file = ',cef_output_file_name

  open(cef_output_file_unit,file = cef_output_file_name)

  !cef_output_file_name = Fbasename(cef_output_file_name)

  ! Writing output CEF file header
  ! ========================================================================
  !
  ! Note: All string fields must contain ""
  !
  ! File Metadata:
  ! --------------

  write(cef_output_file_unit,'(80a)') ('!',i=1,80)
  write(cef_output_file_unit,'(80a)') '!',(' ',i=1,64),'File Metadata !'
  write(cef_output_file_unit,'(80a)') ('!',i=1,80)
  write(cef_output_file_unit,'(a1)') '!'
  write(cef_output_file_unit,'(a,a,a)') 'FILE_NAME = "',cef_output_file_name(1:len_trim(cef_output_file_name)),'"'
  write(cef_output_file_unit,'(a)') 'FILE_FORMAT_VERSION = "CEF-2.0"'
  write(cef_output_file_unit,'(a1)') '!'

  !write metadata
  do i=1, n_metadata

      call u_cef_clear_meta(dummy_cef_meta)
      dummy_cef_meta%name=metadata_names(i)
      if (cef_entry(i)%value_type /= '') then
          if (cef_entry(i)%value_type(1:1) == '"') then
              length = len_trim(cef_entry(i)%value_type)
              dummy_char = cef_entry(i)%value_type(2:length-1)
          else
              dummy_char = cef_entry(i)%value_type
          endif
          dummy_cef_meta%value_type=trim(dummy_char)
      endif
      j=1
      do while (cef_entry(i)%entry(j) /= ' ')
          if (cef_entry(i)%entry(j)(1:1) == '"') then
              length = len_trim(cef_entry(i)%entry(j))
              dummy_char = cef_entry(i)%entry(j)(2:length-1)
          else
              dummy_char = cef_entry(i)%entry(j)
          endif
          dummy_cef_meta%entry(j)=dummy_char
          j=j+1
      enddo
      call w_cef_meta(cef_output_file_unit,dummy_cef_meta)

  enddo

  !write variables
  do i=1, n_variables

      dummy_char = variable_names(i)

      if ((dummy_char == 'half_interval__C1_CP_FGM_5VPS').or.(dummy_char == 'B_mag__C1_CP_FGM_5VPS') &
      .or.(dummy_char == 'sc_pos_xyz_gse__C1_CP_FGM_5VPS').or.(dummy_char == 'range__C1_CP_FGM_5VPS') &
      .or.(dummy_char == 'tm__C1_CP_FGM_5VPS')) then
          cycle
      endif


      call u_cef_clear_var(dummy_cef_var)
      dummy_char2 = dummy_char
      stop_now = 0
      index_under2 = 0
      do while (stop_now == 0)

          index_under = index(dummy_char2,'_')
          index_under2 = index_under2 + index_under

          if (dummy_char2(index_under+1:index_under+1) == '_') then
              stop_now = 1
              length = len_trim(dummy_char)
              dummy_cef_var%dataset_id = trim(dummy_char(index_under2+2:length))
              dummy_cef_var%parameter_id = trim(dummy_char(1:index_under2-1))
          endif

          length = len_trim(dummy_char2)
          dummy_char2 = dummy_char2(index_under+1:length)

      enddo

      if (cef_param(i)%parent_dataset_id(1:1) == '"') then
          length = len_trim(cef_param(i)%parent_dataset_id)
          dummy_char = cef_param(i)%parent_dataset_id(2:length-1)
      else
          dummy_char = cef_param(i)%parent_dataset_id
      endif
      dummy_cef_var%parent_dataset_id = trim(dummy_char)

      if (cef_param(i)%parameter_type(1:1) == '"') then
          length = len_trim(cef_param(i)%parameter_type)
          dummy_char = cef_param(i)%parameter_type(2:length-1)
      else
          dummy_char = cef_param(i)%parameter_type
      endif
      dummy_cef_var%parameter_type = trim(dummy_char)

      if (cef_param(i)%catdesc(1:1) == '"') then
          length = len_trim(cef_param(i)%catdesc)
          dummy_char = cef_param(i)%catdesc(2:length-1)
      else
          dummy_char = cef_param(i)%catdesc
      endif
      dummy_cef_var%catdesc = trim(dummy_char)

      if (cef_param(i)%entity(1:1) == '"') then
          length = len_trim(cef_param(i)%entity)
          dummy_char = cef_param(i)%entity(2:length-1)
      else
          dummy_char = cef_param(i)%entity
      endif
      dummy_cef_var%entity = trim(dummy_char)

      if (cef_param(i)%property(1:1) == '"') then
          length = len_trim(cef_param(i)%property)
          dummy_char = cef_param(i)%property(2:length-1)
      else
          dummy_char = cef_param(i)%property
      endif
      dummy_cef_var%property = trim(dummy_char)

      if (cef_param(i)%fluctuations(1:1) == '"') then
          length = len_trim(cef_param(i)%fluctuations)
          dummy_char = cef_param(i)%fluctuations(2:length-1)
      else
          dummy_char = cef_param(i)%fluctuations
      endif
      dummy_cef_var%fluctuations = trim(dummy_char)

      if (cef_param(i)%error_plus(1:1) == '"') then
          length = len_trim(cef_param(i)%error_plus)
          dummy_char = cef_param(i)%error_plus(2:length-1)
      else
          dummy_char = cef_param(i)%error_plus
      endif
      dummy_cef_var%error_plus = trim(dummy_char)

      if (cef_param(i)%error_minus(1:1) == '"') then
          length = len_trim(cef_param(i)%error_minus)
          dummy_char = cef_param(i)%error_minus(2:length-1)
      else
          dummy_char = cef_param(i)%error_minus
      endif
      dummy_cef_var%error_minus = trim(dummy_char)

      if (cef_param(i)%compound(1:1) == '"') then
          length = len_trim(cef_param(i)%compound)
          dummy_char = cef_param(i)%compound(2:length-1)
      else
          dummy_char = cef_param(i)%compound
      endif
      dummy_cef_var%compound = trim(dummy_char)

      if (cef_param(i)%compound_def(1:1) == '"') then
          length = len_trim(cef_param(i)%compound_def)
          dummy_char = cef_param(i)%compound_def(2:length-1)
      else
          dummy_char = cef_param(i)%compound_def
      endif
      dummy_cef_var%compound_def = trim(dummy_char)

      if (cef_param(i)%units(1:1) == '"') then
          length = len_trim(cef_param(i)%units)
          dummy_char = cef_param(i)%units(2:length-1)
      else
          dummy_char = cef_param(i)%units
      endif
      dummy_cef_var%units = trim(dummy_char)

      if (cef_param(i)%si_conversion(1:1) == '"') then
          length = len_trim(cef_param(i)%si_conversion)
          dummy_char = cef_param(i)%si_conversion(2:length-1)
      else
          dummy_char = cef_param(i)%si_conversion
      endif
      dummy_cef_var%si_conversion = trim(dummy_char)

      if (cef_param(i)%tensor_order(1:1) == '"') then
          length = len_trim(cef_param(i)%tensor_order)
          dummy_char = cef_param(i)%tensor_order(2:length-1)
      else
          dummy_char = cef_param(i)%tensor_order
      endif
      dummy_cef_var%tensor_order = trim(dummy_char)

      if (cef_param(i)%coordinate_system(1:1) == '"') then
          length = len_trim(cef_param(i)%coordinate_system)
          dummy_char = cef_param(i)%coordinate_system(2:length-1)
      else
          dummy_char = cef_param(i)%coordinate_system
      endif
      dummy_cef_var%coordinate_system = trim(dummy_char)

      if (cef_param(i)%frame_origin(1:1) == '"') then
          length = len_trim(cef_param(i)%frame_origin)
          dummy_char = cef_param(i)%frame_origin(2:length-1)
      else
          dummy_char = cef_param(i)%frame_origin
      endif
      dummy_cef_var%frame_origin = trim(dummy_char)

      if (cef_param(i)%frame_velocity(1:1) == '"') then
          length = len_trim(cef_param(i)%frame_velocity)
          dummy_char = cef_param(i)%frame_velocity(2:length-1)
      else
          dummy_char = cef_param(i)%frame_velocity
      endif
      dummy_cef_var%frame_velocity = trim(dummy_char)

      if (cef_param(i)%frame(1:1) == '"') then
          length = len_trim(cef_param(i)%frame)
          dummy_char = cef_param(i)%frame(2:length-1)
      else
          dummy_char = cef_param(i)%frame
      endif
      dummy_cef_var%frame = trim(dummy_char)

      if (cef_param(i)%tensor_frame(1:1) == '"') then
          length = len_trim(cef_param(i)%tensor_frame)
          dummy_char = cef_param(i)%tensor_frame(2:length-1)
      else
          dummy_char = cef_param(i)%tensor_frame
      endif
      dummy_cef_var%tensor_frame = trim(dummy_char)

      dummy_char = cef_param(i)%representation_1
      dummy_cef_var%representation_1 = trim(dummy_char)

      if (cef_param(i)%representation_2(1:1) == '"') then
          length = len_trim(cef_param(i)%representation_2)
          dummy_char = cef_param(i)%representation_2(2:length-1)
      else
          dummy_char = cef_param(i)%representation_2
      endif
      dummy_cef_var%representation_2 = trim(dummy_char)

      if (cef_param(i)%sizes(1:1) == '"') then
          length = len_trim(cef_param(i)%sizes)
          dummy_char = cef_param(i)%sizes(2:length-1)
      else
          dummy_char = cef_param(i)%sizes
      endif
      dummy_cef_var%sizes = trim(dummy_char)

      if (cef_param(i)%depend_0(1:1) == '"') then
          length = len_trim(cef_param(i)%depend_0)
          dummy_char = cef_param(i)%depend_0(2:length-1)
      else
          dummy_char = cef_param(i)%depend_0
      endif
      dummy_cef_var%depend_0 = trim(dummy_char)

      if (cef_param(i)%data(1:1) == '"') then
          length = len_trim(cef_param(i)%data)
          dummy_char = cef_param(i)%data(2:length-1)
      else
          dummy_char = cef_param(i)%data
      endif
      dummy_cef_var%data = trim(dummy_char)

      dummy_char = cef_param(i)%label_1
      dummy_cef_var%label_1 = trim(dummy_char)

      if (cef_param(i)%delta_plus(1:1) == '"') then
          length = len_trim(cef_param(i)%delta_plus)
          dummy_char = cef_param(i)%delta_plus(2:length-1)
      else
          dummy_char = cef_param(i)%delta_plus
      endif
      dummy_cef_var%delta_plus = trim(dummy_char)

      if (cef_param(i)%delta_minus(1:1) == '"') then
          length = len_trim(cef_param(i)%delta_minus)
          dummy_char = cef_param(i)%delta_minus(2:length-1)
      else
          dummy_char = cef_param(i)%delta_minus
      endif
      dummy_cef_var%delta_minus = trim(dummy_char)

      if (cef_param(i)%value_type(1:1) == '"') then
          length = len_trim(cef_param(i)%value_type)
          dummy_char = cef_param(i)%value_type(2:length-1)
      else
          dummy_char = cef_param(i)%value_type
      endif
      dummy_cef_var%value_type = trim(dummy_char)

      dummy_cef_var%significant_digits = '27'

      if (cef_param(i)%fillval(1:1) == '"') then
          length = len_trim(cef_param(i)%fillval)
          dummy_char = cef_param(i)%fillval(2:length-1)
      else
          dummy_char = cef_param(i)%fillval
      endif
      dummy_cef_var%fillval = trim(dummy_char)

      if (cef_param(i)%quality(1:1) == '"') then
          length = len_trim(cef_param(i)%quality)
          dummy_char = cef_param(i)%quality(2:length-1)
      else
          dummy_char = cef_param(i)%quality
      endif
      dummy_cef_var%quality = trim(dummy_char)

      if (cef_param(i)%parameter_caveats(1:1) == '"') then
          length = len_trim(cef_param(i)%parameter_caveats)
          dummy_char = cef_param(i)%parameter_caveats(2:length-1)
      else
          dummy_char = cef_param(i)%parameter_caveats
      endif
      dummy_cef_var%parameter_caveats = trim(dummy_char)

      if (cef_param(i)%fieldnam(1:1) == '"') then
          length = len_trim(cef_param(i)%fieldnam)
          dummy_char = cef_param(i)%fieldnam(2:length-1)
      else
          dummy_char = cef_param(i)%fieldnam
      endif
      dummy_cef_var%fieldnam = trim(dummy_char)

      if (cef_param(i)%lablaxis(1:1) == '"') then
          length = len_trim(cef_param(i)%lablaxis)
          dummy_char = cef_param(i)%lablaxis(2:length-1)
      else
          dummy_char = cef_param(i)%lablaxis
      endif
      dummy_cef_var%lablaxis = trim(dummy_char)

      if (cef_param(i)%scalemin(1:1) == '"') then
          length = len_trim(cef_param(i)%scalemin)
          dummy_char = cef_param(i)%scalemin(2:length-1)
      else
          dummy_char = cef_param(i)%scalemin
      endif
      dummy_cef_var%scalemin = trim(dummy_char)

      if (cef_param(i)%scalemax(1:1) == '"') then
          length = len_trim(cef_param(i)%scalemax)
          dummy_char = cef_param(i)%scalemax(2:length-1)
      else
          dummy_char = cef_param(i)%scalemax
      endif
      dummy_cef_var%scalemax = trim(dummy_char)

      if (cef_param(i)%scaletyp(1:1) == '"') then
          length = len_trim(cef_param(i)%scaletyp)
          dummy_char = cef_param(i)%scaletyp(2:length-1)
      else
          dummy_char = cef_param(i)%scaletyp
      endif
      dummy_cef_var%scaletyp = trim(dummy_char)

      if (cef_param(i)%displaytype(1:1) == '"') then
          length = len_trim(cef_param(i)%displaytype)
          dummy_char = cef_param(i)%displaytype(2:length-1)
      else
          dummy_char = cef_param(i)%displaytype
      endif
      dummy_cef_var%displaytype = trim(dummy_char)

      if (cef_param(i)%target_system(1:1) == '"') then
          length = len_trim(cef_param(i)%target_system)
          dummy_char = cef_param(i)%target_system(2:length-1)
      else
          dummy_char = cef_param(i)%target_system
      endif
      dummy_cef_var%target_system = trim(dummy_char)

      if (variable_names(i) == 'B_vec_xyz_gse__C1_CP_FGM_5VPS') then

          dummy_cef_var%COORDINATE_SYSTEM   = "SR2>Spin Reference 2"

      endif

      call w_cef_parameter(cef_output_file_unit, dummy_cef_var)

  enddo

    !write indexed data

  write(cef_output_file_unit,'(80a)') ('!',i=1,80)
  write(cef_output_file_unit,'(80a)') '!',(' ',i=1,69),'Data     !'
  write(cef_output_file_unit,'(80a)') ('!',i=1,80)
  write(cef_output_file_unit,'(a1)') '!'
  write(cef_output_file_unit,'(80a)') 'DATA_UNTIL = EOF'

  do i = 1, n_block

      write(cef_output_file_unit,'(a27,3(",",E14.6))') trim(adjustl(datiso(i))),vectim(1,i),vectim(2,i),&
      vectim(3,i)

  enddo

  close(cef_output_file_unit)

  !deallocate arrays

  deallocate(vectim)
  deallocate(data_index)
  deallocate(indexed_data)
  deallocate(data_names)
  deallocate(cef_param)
  deallocate(variable_names)
  deallocate(cef_entry)
  deallocate(metadata_names)
  deallocate(datiso)

  print*, 'fgm_cef_gse_to_sr2.exe           : NORMAL TERMINATION'
     stop 'fgm_cef_gse_to_sr2.exe           : NORMAL TERMINATION'

end program fgm_cef_gse_to_sr2

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX 
