!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

    program cef_to_rff_CLUFGM

    !--------------------------------------------------------------------0--
    ! Laboratoire de Physique des Plasmas
    ! Program to convert a fgm cef file to a rff file.
    ! Rodrigue Piberne, LPP, 2012 March 26
    ! revu P. Robert, February 2018 et juin 2020 pour enlever les warnings
    !--------------------------------------------------------------------0--

    use type_def_cef
    use rff_param_def
    use rff_data_def

    implicit none

    TYPE(CEF_PARAMETER), dimension(:), allocatable:: cef_param
    type(CEF_META),      dimension(:), allocatable:: cef_entry

    character(len=255)  :: cef_file_name,rff_file_name, Fbasename, &
                           cef_file_basename, dummy_char,toto
    integer             :: cef_file_unit,rff_file_unit,err,n_variables,n_metadata, &
                           i, dummy_int, j,k,tmp_file_unit,nrec
    character(len=64), dimension(:), allocatable  :: variable_names,metadata_names,&
                                                     data_names
    character(len=1)    :: sat_num
    character(len=8)    :: date
    character(len=10)   :: date_sys,time_sys
    character(len=24)   :: date_temp

    integer             :: condition_good,n_of_data_in_file
    real(kind=8)        :: tt, x, y, z
    character(len=120)  :: extract

  print*, '-------------------------------------------------------------'
  print*, 'cef_to_rff_CLUFGM: convert a fgm.cef file into a fgm_VT.rff file'
  print*, '-------------------------------------------------------------'
  print*

  print*, 'CEF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') cef_file_name 
  print*,  trim(cef_file_name)


  cef_file_unit=1
  rff_file_unit=2
  tmp_file_unit=3

  cef_file_basename = Fbasename(cef_file_name)
  i=len_trim(cef_file_basename)
  cef_file_basename=cef_file_basename(1:i-4)

! rff file name
! ex: CLU2_FGM_VTL2_5VPS_GSE_20010110_000000_20010110_020000.rff

  i=index(cef_file_basename,'__')
  dummy_char=cef_file_basename(2:2)
  rff_file_name = 'CLU'//trim(dummy_char)//cef_file_basename(6:10)//&
                  'VTL2_'//cef_file_basename(11:14)//trim(cef_file_basename(i+1:255))//'.rff'

  print*
  print*, 'RFF file name will be :'
  print*, trim(rff_file_name)

! parametres par defaut

  call rff_set_default_init

  manda_param%FILE_CLASS='VecTime'
  manda_param%FILE_FORMAT_VERSION = 'Roproc_Format_File V 2.2'
  manda_param%INDEX_LABEL = 'Time'
  manda_param%INDEX_TYPE = 'STR'
  manda_param%INDEX_UNITS = 'ISO_TIME'

  call rff_set_default_INDEX_EXTENSION_DESCRIP
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION

  sat_num=cef_file_basename(2:2)
  date=cef_file_basename(16:24)

    !read cef file
    ! -----------------------------------

    !1) open file
    !    ---------

    write(*,*)
    write(*,*) 'Opening file :',TRIM(cef_file_name)

    OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

    if(err /= 0) then
        write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
        write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
        write(*,*) '    err= ',err
        write(*,*) '    program aborted !!!'
        stop 'cef_to_rff_CLUFGM.exe           : *** ERROR !! Program aborted !'
    endif

    ! 2) read metadata, variables and parameters
    !    -------------

    write(*,*)
    write(*,*) 'reading metadata...'

    !find the number of metadata
    n_metadata = 0
    call cef_find_n_metadata(cef_file_unit,n_metadata)

    !read metadata
    write(*,*)
    write(*,*) 'reading metadata...'
    allocate(metadata_names(n_metadata))
    metadata_names = 'xxx'
    call cef_R_metadata(cef_file_unit,n_metadata, metadata_names)
    write(*,'(a)') metadata_names

    !read entry
    allocate(cef_entry(n_metadata))
    call cef_R_entry(cef_file_unit,cef_entry,n_metadata, metadata_names)

    !find the number of variables
    write(*,*)
    write(*,*) 'reading variables...'
    n_variables = 0
    call cef_find_n_variables(cef_file_unit,n_variables)

    !read variables
    allocate(variable_names(n_variables))
    variable_names = 'xxx'
    call cef_R_variables(cef_file_unit,n_variables, variable_names)
    write(*,'(a)') variable_names

    !read parameters
    write(*,*)
    write(*,*) 'reading parameters...'
    allocate(cef_param(n_variables))
    call cef_R_parameter(cef_file_unit,cef_param,n_variables,variable_names)

    !find the number of non constant data
    n_of_data_in_file = 0
    do i=1, n_variables
        if (cef_param(i)%DATA == '') then
            n_of_data_in_file = n_of_data_in_file + 1
        endif
    enddo

    !associate corresponding name to these data
    allocate(data_names(n_of_data_in_file))
    j=1
    do i=1, n_variables
        if (cef_param(i)%DATA == '') then
            data_names(j) = variable_names(i)
            j = j+1
        endif
    enddo

  close(cef_file_unit)

! rff parameters
! ---------------

  call date_and_time(date_sys,time_sys)
  date_temp = date_sys(1:4)//"-"//date_sys(5:6)//"-"//date_sys(7:8)//&
  "T"//time_sys(1:2)//":"//time_sys(3:4)//":"//time_sys(5:9)//"Z"

  manda_param%FILE_CREATION_DATE = date_temp
  optio_param%DISCIPLINE_NAME='Space and Magnetospheric Physics'

! recup des parametres via le cef

    do i=1,n_metadata

        if (metadata_names(i) == 'MISSION') then
            call upper_case(cef_entry(i)%entry(1),len_trim(cef_entry(i)%entry(1)))
            manda_param%MISSION_NAME = extract(cef_entry(i)%entry(1))
            manda_param%MISSION_NAME = manda_param%MISSION_NAME(2:len_trim(manda_param%MISSION_NAME)-1)

        endif

        if (metadata_names(i) == 'OBSERVATORY_DESCRIPTION') then
            manda_param%OBSERVATORY_NAME =  extract(cef_entry(i)%entry(1))
            manda_param%OBSERVATORY_NAME = manda_param%OBSERVATORY_NAME(13:17)

            dummy_char =  cef_entry(i)%entry(1)
            dummy_char  = dummy_char(10:10)
            read(dummy_char, *) dummy_int
            manda_param%OBSERVATORY_NUMBER = dummy_int
        endif

        if (metadata_names(i) == 'INSTRUMENT_NAME') then
            manda_param%EXPERIMENT_NAME = extract(cef_entry(i)%entry(1))
            manda_param%EXPERIMENT_NAME = manda_param%EXPERIMENT_NAME(2:4)
        endif

        if (metadata_names(i) == 'DATASET_ID') then
            manda_param%EXPERIMENT_MODE = extract(cef_entry(i)%entry(1))
            manda_param%EXPERIMENT_MODE = manda_param%EXPERIMENT_mode(12:15)
! begin PR
            if (manda_param%EXPERIMENT_MODE == 'FULL') then
                               optio_param%TIME_RESOLUTION = 0.04459907D0
            endif

            if (manda_param%EXPERIMENT_MODE == '5VPS') then
                               optio_param%TIME_RESOLUTION = 1.D0/5.D0
            endif

            if (manda_param%EXPERIMENT_MODE == 'SPIN') then
                               optio_param%TIME_RESOLUTION = 4.D0
            endif

            const_data%SAMPLE_RATE= 1.D0/optio_param%TIME_RESOLUTION
! end PR

        endif

        if (metadata_names(i) == 'INSTRUMENT_TYPE') then
            dummy_char  = cef_entry(i)%entry(1)
            manda_param%INSTRUMENT_TYPE = dummy_char(2:13)
        endif

        if (metadata_names(i) == 'DATASET_TITLE') then
            dummy_char  = cef_entry(i)%entry(1)
            manda_param%MEASUREMENT_TYPE = 'B '//trim(dummy_char(2:44))
        endif

      if (metadata_names(i) == 'FILE_TIME_SPAN') then
         dummy_char=cef_entry(i)%entry(1)
         optio_param%TIME_SPAN_FROM=dummy_char(1:24)
         optio_param%TIME_SPAN_TO  =dummy_char(26:50)
      endif

      if (metadata_names(i) == 'INVESTIGATOR_COORDINATES') then
         dummy_char=cef_entry(i)%entry(1)
         k=index(dummy_char,'>')
         optio_param%EXPERIMENT_PI_NAME=dummy_char(2:k-1)
         k=index(dummy_char,'>', back=.true.)
         optio_param%EXPERIMENT_PI_MAIL=trim(dummy_char(k+1:255))
         k=index(optio_param%EXPERIMENT_PI_MAIL,'"')
         optio_param%EXPERIMENT_PI_MAIL=optio_param%EXPERIMENT_PI_MAIL(1:k-1)
      endif

    end do

    manda_param%INDEX_EXTENSION_LABEL='None'
    manda_param%INDEX_EXTENSION_TYPE='None'
    manda_param%INDEX_EXTENSION_UNITS='None'
    manda_param%INDEX_EXTENSION_FORMAT='None'
    manda_param%INDEX_EXTENSION_LENGTH= 0

    write(sat_num,'(i1)') manda_param%OBSERVATORY_NUMBER

    optio_param%TITLE=trim(manda_param%MISSION_NAME)//'/'// &
                      trim(manda_param%EXPERIMENT_NAME)//'/'// &
                      trim(manda_param%OBSERVATORY_NAME)//' (#'//trim(sat_num)//')'

    condition_good = 0
    do i=1, n_variables

        if (variable_names(i)(1:20) == 'time_tags__C'//sat_num//'_CP_FGM') then

            manda_param%INDEX_UNITS= cef_param(i)%VALUE_TYPE(1:64)

            manda_param%INDEX_FORMAT='(a'//trim(cef_param(i)%SIGNIFICANT_DIGITS)//')'

            manda_param%INDEX_FORM= 'Scalar'

            read(cef_param(i)%SIZES, *) dummy_int
            manda_param%INDEX_DIMENSION= dummy_int

            manda_param%INDEX_PROPERTIES= 'Regularly Spaced'

        endif

        print*, 'variable_names(i)(1:25)= ',variable_names(i)(1:25)
        if (variable_names(i)(1:25) == 'B_vec_xyz_gse__C'//sat_num//'_CP_FGM_') then
        
            manda_param%DATA_LABEL=cef_param(i)%LABEL_1(1:64)

! PR    manda_param%DATA_TYPE=cef_param(i)%VALUE_TYPE
            manda_param%DATA_TYPE='FLT'

            manda_param%DATA_UNITS=cef_param(i)%UNITS(1:64)

            dummy_char=cef_param(i)%SIGNIFICANT_DIGITS

            manda_param%DATA_FORM=cef_param(i)%PROPERTY(1:120)
            manda_param%DATA_FORM=manda_param%DATA_FORM(2:7)

            read(cef_param(i)%SIZES, *) dummy_int
            manda_param%DATA_DIMENSION(1)=dummy_int

            manda_param%DATA_REPRESENTATION=cef_param(i)%REPRESENTATION_1(1:120)

            manda_param%DATA_FILL_VALUE = cef_param(i)%FILLVAL(1:120)

            manda_param%DATA_COORDINATE_SYSTEM = cef_param(i)%COORDINATE_SYSTEM(1:64)

! begin PR
            manda_param%INDEX_FORMAT='(a24)'
            manda_param%DATA_FORMAT='(3(",",E14.6))'

            if (manda_param%DATA_UNITS== '"nT"') then
                manda_param%DATA_UNITS= 'nT'
            endif

            if (manda_param%DATA_LABEL== '"Bx", "By", "Bz"') then
                manda_param%DATA_LABEL= 'Bx ; By ; Bz'
            endif

            if (manda_param%DATA_REPRESENTATION== '"x", "y", "z"') then
                manda_param%DATA_REPRESENTATION= 'xyz Cartesian'
            endif

            if(manda_param%DATA_COORDINATE_SYSTEM == '"GSE>Geocentric Solar Ecliptic"') then
               manda_param%DATA_COORDINATE_SYSTEM = 'GSE'
            endif
 

        endif

    end do
        
! end PR     


    !OPTIONAL_PARAMETERS

  optio_param%MI_DE=8
  optio_param%MISSION_DESCRIPTION(1)='Cluster is a set of 4 spacecrafts, launched in summer 2000. Salsa & Samba'
  optio_param%MISSION_DESCRIPTION(2)='(C2-C3, FM6-FM7 on July 16, Rumba & Tango (C1-C4, FM5-FM8) on August 9.'
  optio_param%MISSION_DESCRIPTION(3)='The aim of the CLuster mission is to study small-scale structures of the'
  optio_param%MISSION_DESCRIPTION(4)='magnetosphere and its environment in three dimensions.'
  optio_param%MISSION_DESCRIPTION(5)='To achieve this, Cluster is constituted of four identical spacecrafts that'
  optio_param%MISSION_DESCRIPTION(6)='will fly in a tetrahedral configuration. The separation distances'
  optio_param%MISSION_DESCRIPTION(7)='between the spacecrafts will vary from ~40 km to 10,000 km,'
  optio_param%MISSION_DESCRIPTION(8)='according to the key scientific regions.'

  optio_param%SUB_TITLE='Calibrated data (nT) in GSE system' 

  optio_param%EX_DE=13
  optio_param%EXPERIMENT_DESCRIPTION(1)= "Each Cluster spacecraft carries an identical FGM instrument" 
  optio_param%EXPERIMENT_DESCRIPTION(2)= "(Fluxgate Magnetometer) to measure the DC magnetic field"
  optio_param%EXPERIMENT_DESCRIPTION(3)= "vector. Each instrument, in turn, consists of two triaxial" 
  optio_param%EXPERIMENT_DESCRIPTION(4)= "fluxgate magnetometers and an onboard data processing unit." 
  optio_param%EXPERIMENT_DESCRIPTION(5)= "The instrument samples the magnetic field at a cadence of 22 Hz" 
  optio_param%EXPERIMENT_DESCRIPTION(6)= "(67 Hz in Burst mode). In order to minimise the magnetic " 
  optio_param%EXPERIMENT_DESCRIPTION(7)= "background of the spacecraft, one of the magnetometer sensors"
  optio_param%EXPERIMENT_DESCRIPTION(8)= " (the outboard, or OB sensor) is located at the end of one"
  optio_param%EXPERIMENT_DESCRIPTION(9)= " of the two 5 m radial booms of the spacecraft, the other "
  optio_param%EXPERIMENT_DESCRIPTION(10)= "(the inboard, or IB sensor) at 1.5 m inboard from the end "
  optio_param%EXPERIMENT_DESCRIPTION(11)= "of the boom. Since the start of the scientific operations "
  optio_param%EXPERIMENT_DESCRIPTION(12)= "on February 1, 2001, only the outboard sensor on each "
  optio_param%EXPERIMENT_DESCRIPTION(13)= "satellite has been used."

! reading data

    !2) re-open file
    !   ---------

    write(*,*)
    write(*,*) 'Opening file :',TRIM(cef_file_name)

    OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

    if(err /= 0) then
        write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
        write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
        write(*,*) '    err= ',err
        write(*,*) '    program aborted !!!'
        stop 'cef_to_rff_CLUFGM.exe           : *** ERROR !! Program aborted !'
    endif

   toto=' '
   do while ( toto(1:10) /= 'DATA_UNTIL' )           
      read(cef_file_unit,'(a)') toto
   enddo
  
   read(cef_file_unit,'(a)') toto  
   manda_param%block_first_index=  toto(1:index(toto,"Z"))
    
   print*,'write data of ',trim(rff_file_name), ' in a temporary file'

   OPEN(tmp_file_unit,file='data.tmp',status='new',action='write', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in cef_to_rff_CLUFGM, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_CLUFGM.exe            : *** ERROR !! Program aborted !'
  endif
   

   nrec=0
   
   do while ( toto(1:9) /= '!RECORDS=' ) 
      dummy_char=toto   
      write(tmp_file_unit,'(a)') trim(toto)
      nrec=nrec+1
      read(cef_file_unit,'(a)') toto
   enddo
   
   close(tmp_file_unit)
  
   read(toto(10:255),*) dummy_int
   manda_param%BLOCK_NUMBER=nrec
   
   if (nrec/= dummy_int) then
       print*, '*** nb of records read =',nrec
       print*, '    cef param !RECORDS =',dummy_int
   endif
   
   manda_param%block_last_index=  dummy_char(1:index(dummy_char,"Z"))

! ---------------
! create rff file
! ---------------

  open(rff_file_unit,file = rff_file_name,action='write')

  print*, 'write header of ',trim(rff_file_name)
  call rff_W_metadata(rff_file_unit,rff_file_name)
  call rff_W_const_data(rff_file_unit)
  write(rff_file_unit,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit,'(a)')   'START INDEXED_DATA'

  OPEN(tmp_file_unit,file='data.tmp',status='old',action='read', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in cef_to_rff_CLUFGM, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_CLUFGM.exe            : *** ERROR !! Program aborted !'
  endif

   do i=1,nrec 
      read(tmp_file_unit,'(a)') toto
      read(toto,*) date_temp,tt,x,y,z
      write(rff_file_unit,'(a24,3(",",E14.6))') date_temp,x,y,z
   enddo

  call rff_W_tail(rff_file_unit)
  close(rff_file_unit)


    
    print*, 'cef_to_rff_CLUFGM.exe            : NORMAL TERMINATION'
    stop    'cef_to_rff_CLUFGM.exe            : NORMAL TERMINATION'

end program cef_to_rff_CLUFGM

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
! function extraction de caracter pour eviter les warnings dans 
! l'utilisation de cef_entry(i)%entry(1)
! ex: manda_param%OBSERVATORY_NAME = cef_entry(i)%entry(1)(1:120) marche pas
! P. Robert, Juin 2020
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  character*120 function extract(string)
  character*(*) string
  character*120 string2
  string2=string(1:120)
  extract=string2
  return
  end
